/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.framework.toolsDownloading;

import com.intellij.openapi.util.io.NioFiles;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.util.io.PathKt;
import com.jetbrains.rider.test.facades.execution.RiderThroughEelTestExecutionTarget;
import com.jetbrains.rider.test.framework.toolsDownloading.ArtifactToDownload;
import com.jetbrains.rider.test.framework.toolsDownloading.LocalTestToolsDownloader;
import com.jetbrains.rider.test.framework.toolsDownloading.TestToolsDownloader;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/test/framework/toolsDownloading/RemoteTestToolsDownloader;", "Lcom/jetbrains/rider/test/framework/toolsDownloading/TestToolsDownloader;", "testExecutionTarget", "Lcom/jetbrains/rider/test/facades/execution/RiderThroughEelTestExecutionTarget;", "<init>", "(Lcom/jetbrains/rider/test/facades/execution/RiderThroughEelTestExecutionTarget;)V", "getPersistentCacheFolder", "Ljava/io/File;", "downloadAndUnarchive", "", "artifactToDownload", "Lcom/jetbrains/rider/test/framework/toolsDownloading/ArtifactToDownload;", "intellij.rider.test.framework"})
public final class RemoteTestToolsDownloader
extends TestToolsDownloader {
    @NotNull
    private final RiderThroughEelTestExecutionTarget testExecutionTarget;

    public RemoteTestToolsDownloader(@NotNull RiderThroughEelTestExecutionTarget testExecutionTarget) {
        Intrinsics.checkNotNullParameter((Object)((Object)testExecutionTarget), (String)"testExecutionTarget");
        this.testExecutionTarget = testExecutionTarget;
    }

    @NotNull
    public File getPersistentCacheFolder() {
        EelPath userHome = this.testExecutionTarget.getEelApi().getUserInfo().getHome();
        Path companyFolderInUserHome = EelNioBridgeServiceKt.asNioPath((EelPath)userHome.resolve(".local").resolve("share").resolve("JetBrains"));
        PathKt.createDirectories((Path)companyFolderInUserHome);
        File file = companyFolderInUserHome.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    protected void downloadAndUnarchive(@NotNull ArtifactToDownload artifactToDownload) {
        Intrinsics.checkNotNullParameter((Object)artifactToDownload, (String)"artifactToDownload");
        Path sourceDir = LocalTestToolsDownloader.INSTANCE.downloadAndExtractArchiveArtifactIntoPersistentCache(artifactToDownload.getUrl(), null, artifactToDownload.getDestinationFolderChildName(), artifactToDownload.getSubdirectory()).toPath();
        Path targetDir = artifactToDownload.getDestinationFolder().toPath();
        NioFiles.copyRecursively((Path)sourceDir, (Path)targetDir);
    }
}

