/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.scriptingApi;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.debugger.DotNetSuspendContext;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.test.MaskPatternsKt;
import com.jetbrains.rider.test.MaskPatterns_BaseKt;
import com.jetbrains.rider.test.debugger.XDebuggerTestHelper;
import com.jetbrains.rider.test.debugger.XTestValueNode;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.scriptingApi.DebugTestExecutionContextKt;
import com.jetbrains.rider.test.scriptingApi.PresentationWithText;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_DebugKt;
import com.jetbrains.rider.test.scriptingApi.XDebugExtensionsKt;
import java.awt.Color;
import java.io.PrintStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Semaphore;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\t\u0018\u0000 G2\u00020\u0001:\u0002GHB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\"\u0010\u001e\u001a\u00020\u001b*\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001dJ&\u0010\u001e\u001a\u00020\u001b*\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001d0#J\u001f\u0010$\u001a\u00020\u001b2\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001b0&\u00a2\u0006\u0002\b'J\u0006\u0010(\u001a\u00020\u001bJ\u0006\u0010)\u001a\u00020\u001bJ\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020\u001b2\b\b\u0002\u0010-\u001a\u00020+J\u0014\u0010.\u001a\u00020\u001d*\u00020/2\b\b\u0002\u0010-\u001a\u00020+J\u0010\u00100\u001a\u00020\u001b2\b\b\u0002\u0010-\u001a\u00020+J\u0018\u00100\u001a\u00020\u001b2\u0006\u00101\u001a\u0002022\b\b\u0002\u0010-\u001a\u00020+J\u0018\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u0002052\b\b\u0002\u00106\u001a\u00020\rJ\u0018\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u0002092\b\b\u0002\u00106\u001a\u00020\rJ\u0014\u0010:\u001a\b\u0012\u0004\u0012\u0002050;2\u0006\u0010<\u001a\u00020=J\u0018\u0010>\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020=2\b\b\u0002\u00106\u001a\u00020\rJ\f\u0010?\u001a\b\u0012\u0004\u0012\u0002050@J\u0014\u0010?\u001a\b\u0012\u0004\u0012\u0002050@2\u0006\u0010A\u001a\u000202J \u0010B\u001a\u00020\u001b2\b\b\u0002\u00106\u001a\u00020\r2\u000e\b\u0002\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001d0;J(\u0010B\u001a\u00020\u001b2\u0006\u00101\u001a\u0002022\b\b\u0002\u00106\u001a\u00020\r2\u000e\b\u0002\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001d0;J\u0016\u0010D\u001a\u00020\u001b2\u0006\u0010E\u001a\u00020\u001d2\u0006\u0010F\u001a\u00020\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006I"}, d2={"Lcom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContext;", "", "stream", "Ljava/io/PrintStream;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "<init>", "(Ljava/io/PrintStream;Lcom/intellij/xdebugger/XDebugSession;)V", "getStream", "()Ljava/io/PrintStream;", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "currentIndent", "", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "pausedSemaphore", "Ljava/util/concurrent/Semaphore;", "getPausedSemaphore", "()Ljava/util/concurrent/Semaphore;", "dumpProfile", "Lcom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContext$DebugDumpFilesProfile;", "getDumpProfile", "()Lcom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContext$DebugDumpFilesProfile;", "printlnIndented", "", "s", "", "printlnIndentedWithMask", "regex", "Lkotlin/text/Regex;", "mask", "mutableMap", "", "withIndent", "action", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "assertFinish", "assertDetachFinish", "exceptionFrameIsCalculated", "", "dumpExecutionPoint", "withOffsetsInfo", "text", "Lcom/intellij/xdebugger/XSourcePosition;", "dumpFrame", "frame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "dumpValueItem", "valueItem", "Lcom/intellij/xdebugger/frame/XValueContainer;", "childrenLevel", "dumpValueGroup", "group", "Lcom/intellij/xdebugger/frame/XValueGroup;", "dumpChildrenItems", "", "value", "Lcom/intellij/xdebugger/frame/XValue;", "dumpValue", "getLocals", "", "stackFrame", "dumpLocals", "excludeLocals", "markObject", "local", "markedObjectName", "Companion", "DebugDumpFilesProfile", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nDebugTestExecutionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugTestExecutionContext.kt\ncom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,316:1\n1#2:317\n216#3,2:318\n808#4,11:320\n230#4,2:331\n*S KotlinDebug\n*F\n+ 1 DebugTestExecutionContext.kt\ncom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContext\n*L\n135#1:318,2\n279#1:320,11\n279#1:331,2\n*E\n"})
public final class DebugTestExecutionContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrintStream stream;
    @NotNull
    private final XDebugSession session;
    private int currentIndent;
    @NotNull
    private final Semaphore pausedSemaphore;
    @NotNull
    private final DebugDumpFilesProfile dumpProfile;
    public static final int IndentSize = 4;
    @NotNull
    private static final Duration waitForStopTimeout;
    @NotNull
    private static final Duration waitForBackgroundTimeout;
    @NotNull
    private static final List<String> variablesWithTruncatedOutputList;
    @NotNull
    private static final Map<XDebugSession, DebugTestExecutionContext> debugContexts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugTestExecutionContext(@NotNull PrintStream stream, @NotNull XDebugSession session2) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.stream = stream;
        this.session = session2;
        this.pausedSemaphore = new Semaphore(0);
        this.dumpProfile = new DebugDumpFilesProfile();
        Map<XDebugSession, DebugTestExecutionContext> map = debugContexts;
        synchronized (map) {
            boolean bl = false;
            debugContexts.put(this.session, this);
            Unit unit = Unit.INSTANCE;
        }
        this.session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                TestFrameworkBaseKt.getFrameworkLogger().info("Session paused");
                int availablePermits = this.getPausedSemaphore().availablePermits();
                if (availablePermits > 0) {
                    TestFrameworkBaseKt.getFrameworkLogger().warn("Session was stopped twice in a row. This happens sometimes with soft debugger, seems it's a race inside Mono");
                } else {
                    this.getPausedSemaphore().release();
                }
                TestFrameworkBaseKt.getFrameworkLogger().info("Pause semaphore released. Permits=" + availablePermits);
            }

            public void sessionResumed() {
                TestFrameworkBaseKt.getFrameworkLogger().info("Session resumed");
                super.sessionResumed();
            }

            public void beforeSessionResume() {
                TestFrameworkBaseKt.getFrameworkLogger().info("Before session resume");
                super.beforeSessionResume();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sessionStopped() {
                TestFrameworkBaseKt.getFrameworkLogger().info("Session stopped");
                Map map = debugContexts;
                DebugTestExecutionContext debugTestExecutionContext = this;
                Map map2 = map;
                synchronized (map2) {
                    boolean bl = false;
                    DebugTestExecutionContext debugTestExecutionContext2 = (DebugTestExecutionContext)debugContexts.remove(debugTestExecutionContext.getSession());
                }
                super.sessionStopped();
            }
        });
        if (this.session.isPaused()) {
            this.pausedSemaphore.release();
        }
    }

    @NotNull
    public final PrintStream getStream() {
        return this.stream;
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    @NotNull
    public final Project getProject() {
        Project project2 = this.session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        return project2;
    }

    @NotNull
    public final Semaphore getPausedSemaphore() {
        return this.pausedSemaphore;
    }

    @NotNull
    public final DebugDumpFilesProfile getDumpProfile() {
        return this.dumpProfile;
    }

    public final void printlnIndented(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.stream.println(StringsKt.repeat((CharSequence)" ", (int)(this.currentIndent * 4)) + s);
    }

    public final void printlnIndentedWithMask(@NotNull DebugTestExecutionContext $this$printlnIndentedWithMask, @NotNull String s, @NotNull Regex regex, @NotNull String mask) {
        Intrinsics.checkNotNullParameter((Object)$this$printlnIndentedWithMask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter((Object)mask, (String)"mask");
        $this$printlnIndentedWithMask.printlnIndented(regex.replace((CharSequence)s, mask) + "\n");
    }

    public final void printlnIndentedWithMask(@NotNull DebugTestExecutionContext $this$printlnIndentedWithMask, @NotNull String s, @NotNull Map<Regex, String> mutableMap) {
        Intrinsics.checkNotNullParameter((Object)$this$printlnIndentedWithMask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter(mutableMap, (String)"mutableMap");
        Map<Regex, String> $this$forEach$iv = mutableMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Regex, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Regex, String> element$iv;
            Map.Entry<Regex, String> entry = element$iv = iterator.next();
            boolean bl = false;
            CharSequence charSequence = s;
            Regex regex = entry.getKey();
            String string = entry.getValue();
            regex.replace(charSequence, string);
        }
        $this$printlnIndentedWithMask.printlnIndented(s + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void withIndent(@NotNull Function1<? super DebugTestExecutionContext, Unit> action) {
        int n;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            n = this.currentIndent;
            this.currentIndent = n + 1;
            action.invoke((Object)this);
        }
        finally {
            n = this.currentIndent;
            this.currentIndent = n + -1;
        }
    }

    public final void assertFinish() {
        AssertionsKt.assertEquals((Object)0, (Object)this.pausedSemaphore.availablePermits(), (String)"Paused permits must equal to 0");
        AssertionsKt.assertFalse((boolean)this.session.isSuspended(), (String)"Session must not be suspended at the end of test");
    }

    public final void assertDetachFinish() {
        AssertionsKt.assertEquals((Object)0, (Object)this.pausedSemaphore.availablePermits(), (String)"Paused permits must equal to 0");
    }

    public final boolean exceptionFrameIsCalculated() {
        DotNetSuspendContext dotnetSuspendContext = DotnetDebuggerExtKt.getDotnetSuspendContext((XDebugSession)this.session);
        if (dotnetSuspendContext == null) {
            return true;
        }
        return dotnetSuspendContext.getTestOnly_exceptionFrameCalculated();
    }

    public final void dumpExecutionPoint(boolean withOffsetsInfo) {
        Duration duration = Duration.ofSeconds(15L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        ExtensionsKt.pumpMessages((Duration)duration, () -> DebugTestExecutionContext.dumpExecutionPoint$lambda$0(this));
        XSourcePosition position = this.session.getCurrentPosition();
        if (position == null) {
            DebugTestExecutionContextKt.access$getLogger$p().warn("Position is null after wait. Is the top frame native?");
            this.printlnIndented("--> Position is null.");
            return;
        }
        this.printlnIndented("--> " + this.text(position, withOffsetsInfo));
    }

    public static /* synthetic */ void dumpExecutionPoint$default(DebugTestExecutionContext debugTestExecutionContext, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        debugTestExecutionContext.dumpExecutionPoint(bl);
    }

    @NotNull
    public final String text(@NotNull XSourcePosition $this$text, boolean withOffsetsInfo) {
        TextRange textRange;
        Object offsetOrRange;
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"<this>");
        XSourcePosition position = $this$text;
        Document document = (Document)AssertionsKt.assertNotNull((Object)FileDocumentManager.getInstance().getDocument(position.getFile()), (String)"Editor was not opened at execution point");
        int zeroBasedLine = position.getLine();
        ExecutionPointHighlighter.HighlighterProvider highlighterProvider = position instanceof ExecutionPointHighlighter.HighlighterProvider ? (ExecutionPointHighlighter.HighlighterProvider)position : null;
        Object range = highlighterProvider != null ? highlighterProvider.getHighlightRange() : null;
        Object object = range;
        if (object == null || (object = object.toString()) == null) {
            object = offsetOrRange = "$(" + position.getOffset() + ")";
        }
        if ((textRange = range) == null) {
            TextRange textRange2 = TextRange.create((int)document.getLineStartOffset(zeroBasedLine), (int)document.getLineEndOffset(zeroBasedLine));
            textRange = textRange2;
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"create(...)");
        }
        String string = document.getText(textRange);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String currentText = string;
        String maskedText = this.dumpProfile.maskAllAccordingProfile(currentText, this.getProject());
        if (withOffsetsInfo) {
            return position.getFile().getName() + ":" + (zeroBasedLine + 1) + (String)offsetOrRange + " // " + maskedText;
        }
        return position.getFile().getName() + " // " + maskedText;
    }

    public static /* synthetic */ String text$default(DebugTestExecutionContext debugTestExecutionContext, XSourcePosition xSourcePosition, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return debugTestExecutionContext.text(xSourcePosition, bl);
    }

    public final void dumpFrame(boolean withOffsetsInfo) {
        this.dumpFrame((XStackFrame)AssertionsKt.assertNotNull((Object)this.session.getCurrentStackFrame(), (String)"currentStackFrame is null"), withOffsetsInfo);
    }

    public static /* synthetic */ void dumpFrame$default(DebugTestExecutionContext debugTestExecutionContext, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        debugTestExecutionContext.dumpFrame(bl);
    }

    public final void dumpFrame(@NotNull XStackFrame frame, boolean withOffsetsInfo) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Duration duration = Duration.ofSeconds(15L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        ExtensionsKt.pumpMessages((Duration)duration, () -> DebugTestExecutionContext.dumpFrame$lambda$0(this));
        String frameText = XDebugExtensionsKt.text(frame, withOffsetsInfo);
        String maskedText = this.dumpProfile.maskAllAccordingProfile(frameText, this.getProject());
        this.printlnIndented(maskedText);
    }

    public static /* synthetic */ void dumpFrame$default(DebugTestExecutionContext debugTestExecutionContext, XStackFrame xStackFrame, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        debugTestExecutionContext.dumpFrame(xStackFrame, bl);
    }

    public final void dumpValueItem(@NotNull XValueContainer valueItem, int childrenLevel) {
        Intrinsics.checkNotNullParameter((Object)valueItem, (String)"valueItem");
        XValueContainer xValueContainer = valueItem;
        if (xValueContainer instanceof XValue) {
            this.dumpValue((XValue)valueItem, childrenLevel);
        } else if (xValueContainer instanceof XValueGroup) {
            this.dumpValueGroup((XValueGroup)valueItem, childrenLevel);
        }
    }

    public static /* synthetic */ void dumpValueItem$default(DebugTestExecutionContext debugTestExecutionContext, XValueContainer xValueContainer, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        debugTestExecutionContext.dumpValueItem(xValueContainer, n);
    }

    public final void dumpValueGroup(@NotNull XValueGroup group, int childrenLevel) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        TestFrameworkBaseKt.getFrameworkLogger().info("Dumping of group " + group.getName() + " started...");
        this.printlnIndented(DebugTestExecutionContextKt.getPresentation(group));
        TestFrameworkBaseKt.getFrameworkLogger().info("Group " + group.getName() + " dumped");
        if (childrenLevel > 0) {
            this.withIndent((Function1<? super DebugTestExecutionContext, Unit>)((Function1)arg_0 -> DebugTestExecutionContext.dumpValueGroup$lambda$0(group, childrenLevel, arg_0)));
        }
    }

    public static /* synthetic */ void dumpValueGroup$default(DebugTestExecutionContext debugTestExecutionContext, XValueGroup xValueGroup, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        debugTestExecutionContext.dumpValueGroup(xValueGroup, n);
    }

    @NotNull
    public final List<XValueContainer> dumpChildrenItems(@NotNull XValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        List<XValueContainer> list = XDebuggerTestHelper.collectChildrenItems((XValueContainer)value, DebugTestExecutionContext::dumpChildrenItems$lambda$0);
        Intrinsics.checkNotNullExpressionValue(list, (String)"collectChildrenItems(...)");
        return list;
    }

    public final void dumpValue(@NotNull XValue value, int childrenLevel) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        TestFrameworkBaseKt.getFrameworkLogger().info("Dumping of value started...");
        PresentationWithText presentationWithText = DebugTestExecutionContextKt.getPresentationWithText(value);
        XTestValueNode presentation = presentationWithText.component1();
        String text = presentationWithText.component2();
        String normalizedEndingsText = StringsKt.replace$default((String)TestFrameworkBaseKt.normalizeLineEndings((String)text), (String)"\\r\\n", (String)"\\n", (boolean)false, (int)4, null);
        String maskedText = this.dumpProfile.maskAllAccordingProfile(normalizedEndingsText, this.getProject());
        this.printlnIndented(maskedText);
        TestFrameworkBaseKt.getFrameworkLogger().info("Value dumped: " + normalizedEndingsText + " as " + maskedText);
        if (childrenLevel > 0 && presentation.getMyHasChildren()) {
            this.withIndent((Function1<? super DebugTestExecutionContext, Unit>)((Function1)arg_0 -> DebugTestExecutionContext.dumpValue$lambda$0(value, childrenLevel, arg_0)));
        }
    }

    public static /* synthetic */ void dumpValue$default(DebugTestExecutionContext debugTestExecutionContext, XValue xValue, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        debugTestExecutionContext.dumpValue(xValue, n);
    }

    @NotNull
    public final List<XValueContainer> getLocals() {
        return this.getLocals((XStackFrame)AssertionsKt.assertNotNull((Object)this.session.getCurrentStackFrame(), (String)"currentStackFrame is null"));
    }

    @NotNull
    public final List<XValueContainer> getLocals(@NotNull XStackFrame stackFrame) {
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        AssertionsKt.assertNotNull((Object)stackFrame, (String)"currentStackFrame is null");
        return DebugTestExecutionContextKt.getLocals(stackFrame);
    }

    public final void dumpLocals(int childrenLevel, @NotNull List<String> excludeLocals) {
        Intrinsics.checkNotNullParameter(excludeLocals, (String)"excludeLocals");
        this.dumpLocals((XStackFrame)AssertionsKt.assertNotNull((Object)this.session.getCurrentStackFrame(), (String)"currentStackFrame is null"), childrenLevel, excludeLocals);
    }

    public static /* synthetic */ void dumpLocals$default(DebugTestExecutionContext debugTestExecutionContext, int n, List list, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        debugTestExecutionContext.dumpLocals(n, list);
    }

    public final void dumpLocals(@NotNull XStackFrame frame, int childrenLevel, @NotNull List<String> excludeLocals) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter(excludeLocals, (String)"excludeLocals");
        Duration duration = Duration.ofSeconds(15L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        ExtensionsKt.pumpMessages((Duration)duration, () -> DebugTestExecutionContext.dumpLocals$lambda$0(this));
        TestFrameworkBaseKt.getFrameworkLogger().info("Dumping of stack locals started...");
        List<XValueContainer> locals = this.getLocals(frame);
        for (XValueContainer local : locals) {
            if (local instanceof XNamedValue && excludeLocals.contains(((XNamedValue)local).getName())) {
                this.printlnIndented(((XNamedValue)local).getName() + " = <excluded>");
                continue;
            }
            this.dumpValueItem(local, childrenLevel);
        }
        TestFrameworkBaseKt.getFrameworkLogger().info("Stack locals dumped");
    }

    public static /* synthetic */ void dumpLocals$default(DebugTestExecutionContext debugTestExecutionContext, XStackFrame xStackFrame, int n, List list, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        debugTestExecutionContext.dumpLocals(xStackFrame, n, list);
    }

    /*
     * WARNING - void declaration
     */
    public final void markObject(@NotNull String local, @NotNull String markedObjectName) {
        Object element$iv2;
        block2: {
            void $this$first$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)local, (String)"local");
            Intrinsics.checkNotNullParameter((Object)markedObjectName, (String)"markedObjectName");
            Iterable $this$filterIsInstance$iv = this.getLocals();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof XValue)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                XValue it = (XValue)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)DebugTestExecutionContextKt.getPresentation(it).getMyName(), (Object)local)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        XValue person = (XValue)element$iv2;
        XDebugSession xDebugSession = this.session;
        Intrinsics.checkNotNull((Object)xDebugSession, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
        XValueMarkers xValueMarkers = ((XDebugSessionImpl)xDebugSession).valueMarkers();
        Intrinsics.checkNotNull((Object)xValueMarkers);
        Promise promise2 = xValueMarkers.markValue(person, new ValueMarkup(markedObjectName, Color.BLACK, null));
        ExtensionsKt.pumpMessages$default(null, () -> DebugTestExecutionContext.markObject$lambda$1(promise2), (int)1, null);
    }

    private static final boolean dumpExecutionPoint$lambda$0(DebugTestExecutionContext this$0) {
        return this$0.session.getCurrentPosition() != null && this$0.exceptionFrameIsCalculated();
    }

    private static final boolean dumpFrame$lambda$0(DebugTestExecutionContext this$0) {
        return this$0.exceptionFrameIsCalculated();
    }

    private static final Unit dumpValueGroup$lambda$0(XValueGroup $group, int $childrenLevel, DebugTestExecutionContext $this$withIndent) {
        Intrinsics.checkNotNullParameter((Object)$this$withIndent, (String)"$this$withIndent");
        TestFrameworkBaseKt.getFrameworkLogger().info("Dumping group children...");
        List<XValueContainer> children = XDebuggerTestHelper.collectChildrenItems((XValueContainer)$group, DebugTestExecutionContext::dumpValueGroup$lambda$0$0);
        for (XValueContainer child : children) {
            Intrinsics.checkNotNull((Object)child);
            $this$withIndent.dumpValueItem(child, $childrenLevel - 1);
        }
        TestFrameworkBaseKt.getFrameworkLogger().info("Children dumped");
        return Unit.INSTANCE;
    }

    private static final Boolean dumpValueGroup$lambda$0$0(Semaphore semaphore, Duration duration) {
        Intrinsics.checkNotNull((Object)semaphore);
        Intrinsics.checkNotNull((Object)duration);
        return ScriptingAPI_DebugKt.waiter(semaphore, duration, "dumpValueGroup");
    }

    private static final Boolean dumpChildrenItems$lambda$0(Semaphore semaphore, Duration timeout) {
        Intrinsics.checkNotNull((Object)semaphore);
        Intrinsics.checkNotNull((Object)timeout);
        return ScriptingAPI_DebugKt.waiter(semaphore, timeout, "dumpValue");
    }

    private static final Unit dumpValue$lambda$0(XValue $value, int $childrenLevel, DebugTestExecutionContext $this$withIndent) {
        Intrinsics.checkNotNullParameter((Object)$this$withIndent, (String)"$this$withIndent");
        TestFrameworkBaseKt.getFrameworkLogger().info("Dumping children...");
        List<XValueContainer> children = $this$withIndent.dumpChildrenItems($value);
        for (XValueContainer child : children) {
            $this$withIndent.dumpValueItem(child, $childrenLevel - 1);
        }
        TestFrameworkBaseKt.getFrameworkLogger().info("Children dumped");
        return Unit.INSTANCE;
    }

    private static final boolean dumpLocals$lambda$0(DebugTestExecutionContext this$0) {
        return this$0.exceptionFrameIsCalculated();
    }

    private static final boolean markObject$lambda$1(Promise $promise) {
        Intrinsics.checkNotNull((Object)$promise);
        return !Promises.isPending((Promise)$promise);
    }

    static {
        Duration duration = Duration.ofMinutes(3L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        waitForStopTimeout = duration;
        Duration duration2 = Duration.ofSeconds(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        waitForBackgroundTimeout = duration2;
        variablesWithTruncatedOutputList = CollectionsKt.listOf((Object)"$exception");
        debugContexts = new LinkedHashMap();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContext$Companion;", "", "<init>", "()V", "IndentSize", "", "waitForStopTimeout", "Ljava/time/Duration;", "getWaitForStopTimeout", "()Ljava/time/Duration;", "waitForBackgroundTimeout", "getWaitForBackgroundTimeout", "variablesWithTruncatedOutputList", "", "", "getVariablesWithTruncatedOutputList", "()Ljava/util/List;", "debugContexts", "", "Lcom/intellij/xdebugger/XDebugSession;", "Lcom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContext;", "getDebugContext", "session", "intellij.rider.test.framework"})
    @SourceDebugExtension(value={"SMAP\nDebugTestExecutionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugTestExecutionContext.kt\ncom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContext$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,316:1\n1#2:317\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getWaitForStopTimeout() {
            return waitForStopTimeout;
        }

        @NotNull
        public final Duration getWaitForBackgroundTimeout() {
            return waitForBackgroundTimeout;
        }

        @NotNull
        public final List<String> getVariablesWithTruncatedOutputList() {
            return variablesWithTruncatedOutputList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final DebugTestExecutionContext getDebugContext(@NotNull XDebugSession session2) {
            DebugTestExecutionContext debugTestExecutionContext;
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Map map = debugContexts;
            synchronized (map) {
                boolean bl = false;
                debugTestExecutionContext = (DebugTestExecutionContext)debugContexts.get(session2);
            }
            return debugTestExecutionContext;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\n\u0010\u0013\u001a\u00020\u0006*\u00020\u0006J\n\u0010\u0014\u001a\u00020\u0006*\u00020\u0006R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContext$DebugDumpFilesProfile;", "", "<init>", "()V", "customPathsToMask", "", "", "getCustomPathsToMask", "()Ljava/util/Map;", "setCustomPathsToMask", "(Ljava/util/Map;)V", "customRegexToMask", "Lkotlin/text/Regex;", "getCustomRegexToMask", "setCustomRegexToMask", "maskAllAccordingProfile", "stringToMask", "project", "Lcom/intellij/openapi/project/Project;", "maskPathsAccordingProfile", "maskRegexAccordingProfile", "intellij.rider.test.framework"})
    @SourceDebugExtension(value={"SMAP\nDebugTestExecutionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugTestExecutionContext.kt\ncom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContext$DebugDumpFilesProfile\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,316:1\n216#2,2:317\n216#2,2:319\n*S KotlinDebug\n*F\n+ 1 DebugTestExecutionContext.kt\ncom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContext$DebugDumpFilesProfile\n*L\n71#1:317,2\n79#1:319,2\n*E\n"})
    public static final class DebugDumpFilesProfile {
        @NotNull
        private Map<String, String> customPathsToMask = new LinkedHashMap();
        @NotNull
        private Map<String, Regex> customRegexToMask;

        public DebugDumpFilesProfile() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"GUID", (Object)MaskPatterns_BaseKt.getGuidRegex()), TuplesKt.to((Object)"<address>", (Object)MaskPatterns_BaseKt.getAddressRegex())};
            this.customRegexToMask = MapsKt.mutableMapOf((Pair[])pairArray);
        }

        @NotNull
        public final Map<String, String> getCustomPathsToMask() {
            return this.customPathsToMask;
        }

        public final void setCustomPathsToMask(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.customPathsToMask = map;
        }

        @NotNull
        public final Map<String, Regex> getCustomRegexToMask() {
            return this.customRegexToMask;
        }

        public final void setCustomRegexToMask(@NotNull Map<String, Regex> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.customRegexToMask = map;
        }

        @NotNull
        public final String maskAllAccordingProfile(@NotNull String stringToMask, @Nullable Project project2) {
            Intrinsics.checkNotNullParameter((Object)stringToMask, (String)"stringToMask");
            return MaskPatternsKt.maskSolutionPath(this.maskRegexAccordingProfile(this.maskPathsAccordingProfile(stringToMask)), project2);
        }

        @NotNull
        public final String maskPathsAccordingProfile(@NotNull String $this$maskPathsAccordingProfile) {
            Intrinsics.checkNotNullParameter((Object)$this$maskPathsAccordingProfile, (String)"<this>");
            String maskedString = null;
            maskedString = $this$maskPathsAccordingProfile;
            Map<String, String> $this$forEach$iv = this.customPathsToMask;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl = false;
                String masked = entry.getKey();
                String toMask = entry.getValue();
                maskedString = MaskPatternsKt.maskCustomPath$default(maskedString, toMask, masked, false, 4, null);
            }
            return maskedString;
        }

        @NotNull
        public final String maskRegexAccordingProfile(@NotNull String $this$maskRegexAccordingProfile) {
            Intrinsics.checkNotNullParameter((Object)$this$maskRegexAccordingProfile, (String)"<this>");
            String maskedString = null;
            maskedString = $this$maskRegexAccordingProfile;
            Map<String, Regex> $this$forEach$iv = this.customRegexToMask;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Regex>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Regex> element$iv;
                Map.Entry<String, Regex> entry = element$iv = iterator.next();
                boolean bl = false;
                String masked = entry.getKey();
                Regex toMask = entry.getValue();
                maskedString = MaskPatternsKt.maskCustomRegex(maskedString, toMask, masked);
            }
            return maskedString;
        }
    }
}

