/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.scriptingApi;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.util.WaitFor;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.test.asserts.ShouldAssertsKt;
import com.jetbrains.rider.test.enums.EngineVersion;
import com.jetbrains.rider.test.enums.UnityVersion;
import com.jetbrains.rider.test.framework.TeamCityHelper;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_UnityKt;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.test.AssertionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011H\u0002\u001a\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\tH\u0002\u001a\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u000fH\u0002\u001a\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u000f\u001a\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001c*\b\u0012\u0004\u0012\u00020\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0001\u001aF\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001c2\u0006\u0010\u001f\u001a\u00020\t2\b\b\u0002\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020!2\b\b\u0002\u0010#\u001a\u00020!2\b\b\u0002\u0010$\u001a\u00020!2\b\b\u0002\u0010%\u001a\u00020!\u001a$\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00012\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0001\u001a\u000e\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,\u001a>\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\u00012\u0016\b\u0002\u00101\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020!\u0018\u0001022\u0006\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\t\u001a\u001e\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00012\u0006\u00108\u001a\u00020\t2\u0006\u00105\u001a\u00020\t\u001a \u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020'2\u0006\u0010;\u001a\u00020\u00012\b\b\u0002\u0010<\u001a\u00020\u0003\u001a\u0016\u0010=\u001a\u00020\u00072\u0006\u0010>\u001a\u00020\t2\u0006\u0010\u0000\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010-\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010.\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"riderPackageVersion", "", "unityDefaultTimeout", "Ljava/time/Duration;", "getUnityDefaultTimeout", "()Ljava/time/Duration;", "createLibraryFolderIfNotExist", "", "solutionDirectory", "Ljava/io/File;", "allowUnityPathVfsRootAccess", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getEngineExecutableInstallationPath", "engineVersion", "Lcom/jetbrains/rider/test/enums/EngineVersion;", "getUnityDefaultPaths", "", "getTuanjieDefaultPaths", "getExecutablePath", "engineName", "editorDirPath", "getEngineExecutable", "version", "getOsSpecificPath", "Ljava/nio/file/Path;", "path", "withProjectPath", "", "projectPath", "addArgsForUnityProcess", "logPath", "resetEditorPrefs", "", "useRiderTestPath", "batchMode", "generateSolution", "consistencyCheck", "startUnity", "Ljava/lang/ProcessHandle;", "executable", "args", "waitFirstScriptCompilation", "project", "Lcom/intellij/openapi/project/Project;", "packageManifestPath", "riderPackageTag", "putUnityProjectToTempTestDir", "solutionDirectoryName", "filter", "Lkotlin/Function1;", "testWorkDirectory", "solutionSourceRootDirectory", "testDataDirectory", "copyAdditionalFilesToProject", "solutionName", "workDirectory", "waitForSlnGeneratedByUnity", "unityProcessHandle", "slnDirPath", "timeoutMinutes", "setRiderPackageVersion", "sourceDirectory", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nScriptingAPI.Unity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingAPI.Unity.kt\ncom/jetbrains/rider/test/scriptingApi/ScriptingAPI_UnityKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,289:1\n1387#2:290\n1475#2,5:291\n13805#3,2:296\n1#4:298\n*S KotlinDebug\n*F\n+ 1 ScriptingAPI.Unity.kt\ncom/jetbrains/rider/test/scriptingApi/ScriptingAPI_UnityKt\n*L\n104#1:290\n104#1:291,5\n248#1:296,2\n*E\n"})
public final class ScriptingAPI_UnityKt {
    @NotNull
    public static final String riderPackageVersion = "3.0.35";
    @NotNull
    private static final Duration unityDefaultTimeout;
    @NotNull
    public static final String packageManifestPath = "/Packages/manifest.json";
    @NotNull
    public static final String riderPackageTag = "{{VERSION}}";

    @NotNull
    public static final Duration getUnityDefaultTimeout() {
        return unityDefaultTimeout;
    }

    public static final void createLibraryFolderIfNotExist(@NotNull File solutionDirectory) {
        Intrinsics.checkNotNullParameter((Object)solutionDirectory, (String)"solutionDirectory");
        String[] stringArray = new String[]{"Library"};
        Path libraryFolder = Paths.get(solutionDirectory.toString(), stringArray);
        Intrinsics.checkNotNull((Object)libraryFolder);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(libraryFolder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Files.createDirectory(libraryFolder, new FileAttribute[0]);
        }
    }

    public static final void allowUnityPathVfsRootAccess(@NotNull LifetimeDefinition lifetimeDefinition) {
        String string;
        Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"lifetimeDefinition");
        if (SystemInfo.isWindows) {
            string = "C:/Program Files/Unity";
        } else if (SystemInfo.isMac) {
            string = "/Applications/Unity";
        } else {
            throw new Exception("Not implemented");
        }
        String unityPath = string;
        String[] stringArray = new String[]{unityPath};
        VfsRootAccess.allowRootAccess((Disposable)LifetimeDisposableExKt.createNestedDisposable((Lifetime)((Lifetime)lifetimeDefinition), (String)"Unity path disposable"), (String[])stringArray);
    }

    @NotNull
    public static final File getEngineExecutableInstallationPath(@NotNull EngineVersion engineVersion) {
        Intrinsics.checkNotNullParameter((Object)engineVersion, (String)"engineVersion");
        return engineVersion.isTuanjie() ? ScriptingAPI_UnityKt.getEngineExecutable("Tuanjie", engineVersion) : ScriptingAPI_UnityKt.getEngineExecutable("Unity", engineVersion);
    }

    private static final List<String> getUnityDefaultPaths() {
        List list;
        if (SystemInfo.isWindows) {
            list = CollectionsKt.listOf((Object)"C:/Program Files/Unity/Hub/Editor/");
        } else if (SystemInfo.isMac) {
            list = CollectionsKt.listOf((Object)"/Applications/Unity/Hub/Editor/");
        } else if (SystemInfo.isLinux) {
            Object[] objectArray = new String[]{String.valueOf(System.getProperty("user.home")), System.getProperty("user.home") + "/Unity/Hub/Editor", "/opt/Unity/Hub/Editor"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            throw new Exception("Unknown OS while detecting Unity Editor path");
        }
        return list;
    }

    private static final List<String> getTuanjieDefaultPaths() {
        List list;
        if (SystemInfo.isWindows) {
            list = CollectionsKt.listOf((Object)"C:/Program Files/Tuanjie");
        } else if (SystemInfo.isMac) {
            list = CollectionsKt.listOf((Object)"/Applications/Tuanjie");
        } else if (SystemInfo.isLinux) {
            Object[] objectArray = new String[]{String.valueOf(System.getProperty("user.home")), System.getProperty("user.home") + "/Tuanjie", "/opt/Tuanjie"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            throw new Exception("Unknown OS while detecting Tuanjie Editor path");
        }
        return list;
    }

    private static final String getExecutablePath(String engineName, File editorDirPath) {
        String string;
        if (SystemInfo.isWindows) {
            string = editorDirPath.getCanonicalPath() + "/Editor/" + engineName + ".exe";
        } else if (SystemInfo.isMac) {
            string = editorDirPath.getCanonicalPath() + "/" + engineName + ".app";
        } else if (SystemInfo.isLinux) {
            string = editorDirPath.getCanonicalPath() + "/Editor/" + engineName;
        } else {
            throw new Exception("Unknown OS while detecting " + engineName + " Editor path");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final File getEngineExecutable(String engineName, EngineVersion version) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        List<String> defaultEnginePaths = version.isTuanjie() ? ScriptingAPI_UnityKt.getTuanjieDefaultPaths() : ScriptingAPI_UnityKt.getUnityDefaultPaths();
        Iterable iterable = defaultEnginePaths;
        boolean $i$f$flatMapSequence = false;
        void var6_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String path = (String)element$iv$iv;
            boolean bl = false;
            Sequence list$iv$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)new File(path), null, (int)1, null).maxDepth(1)), arg_0 -> ScriptingAPI_UnityKt.getEngineExecutable$lambda$0$0(version, engineName, arg_0));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
        }
        List potentialEditors = (List)destination$iv$iv;
        if (potentialEditors.isEmpty()) {
            TestFrameworkBaseKt.getFrameworkLogger().error("Could not find suitable " + engineName + " Editor in the default paths, please install " + version + " in one of the default locations:\n" + CollectionsKt.joinToString$default((Iterable)defaultEnginePaths, null, null, null, (int)0, null, ScriptingAPI_UnityKt::getEngineExecutable$lambda$1, (int)31, null));
        }
        File editorDirPath = version.isTuanjie() ? (File)CollectionsKt.first((List)potentialEditors) : (File)CollectionsKt.last((List)CollectionsKt.sortedWith((Iterable)potentialEditors, (arg_0, arg_1) -> ScriptingAPI_UnityKt.getEngineExecutable$lambda$3(ScriptingAPI_UnityKt::getEngineExecutable$lambda$2, arg_0, arg_1)));
        String editorExecutablePath = ScriptingAPI_UnityKt.getExecutablePath(engineName, editorDirPath);
        Path path = Paths.get(editorExecutablePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        File editorExecutable = new File(((Object)ScriptingAPI_UnityKt.getOsSpecificPath(path, version)).toString());
        if (!editorExecutable.exists()) {
            TestFrameworkBaseKt.getFrameworkLogger().error("Could not find " + engineName + " Editor in the default paths, please install " + version + " in one of the default locations:\n" + CollectionsKt.joinToString$default((Iterable)defaultEnginePaths, null, null, null, (int)0, null, ScriptingAPI_UnityKt::getEngineExecutable$lambda$4, (int)31, null));
        }
        return editorExecutable;
    }

    @NotNull
    public static final Path getOsSpecificPath(@NotNull Path path, @NotNull EngineVersion version) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (SystemInfo.isMac) {
            if (version.isTuanjie()) {
                Path path2 = path.resolve("Contents/MacOS/Tuanjie");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                return path2;
            }
            Path path3 = path.resolve("Contents/MacOS/Unity");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            return path3;
        }
        return path;
    }

    @NotNull
    public static final List<String> withProjectPath(@NotNull List<String> $this$withProjectPath, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter($this$withProjectPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Object[] objectArray = new String[]{"-projectPath", projectPath};
        $this$withProjectPath.addAll(CollectionsKt.mutableListOf((Object[])objectArray));
        return $this$withProjectPath;
    }

    @NotNull
    public static final List<String> addArgsForUnityProcess(@NotNull File logPath, boolean resetEditorPrefs, boolean useRiderTestPath, boolean batchMode, boolean generateSolution, boolean consistencyCheck) {
        Intrinsics.checkNotNullParameter((Object)logPath, (String)"logPath");
        List args = new ArrayList();
        Collection collection = args;
        Object[] objectArray = new String[6];
        objectArray[0] = "-debugCodeOptimization";
        objectArray[1] = "-logfile";
        Intrinsics.checkNotNullExpressionValue((Object)logPath.toString(), (String)"toString(...)");
        objectArray[3] = "-silent-crashes";
        objectArray[4] = "-riderIntegrationTests";
        objectArray[5] = "--burst-disable-compilation";
        CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
        if (batchMode) {
            args.add("-batchMode");
        }
        if (consistencyCheck) {
            args.add("-quit");
            args.add("-consistencyCheck");
        }
        if (generateSolution) {
            args.add("-quit");
            args.add("-executeMethod Packages.Rider.Editor.RiderScriptEditor.SyncSolution");
        }
        args.add("-executeMethod");
        boolean bl = resetEditorPrefs ? args.add("Editor.IntegrationTestHelper.ResetAndStart") : args.add("Editor.IntegrationTestHelper.Start");
        if (useRiderTestPath) {
            args.add("-riderTestPath");
        }
        if (TeamCityHelper.Companion.isUnderTeamCity()) {
            String login = System.getenv("unity.login");
            String password = System.getenv("unity.password");
            AssertionsKt.assertNotNull((Object)login, (String)"System.getenv(\"unity.login\") is null.");
            AssertionsKt.assertNotNull((Object)password, (String)"System.getenv(\"unity.password\") is null.");
            Object[] objectArray2 = new String[]{"-username", login, "-password", password};
            CollectionsKt.addAll((Collection)args, (Object[])objectArray2);
        }
        return args;
    }

    public static /* synthetic */ List addArgsForUnityProcess$default(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        if ((n & 0x20) != 0) {
            bl5 = false;
        }
        return ScriptingAPI_UnityKt.addArgsForUnityProcess(file, bl, bl2, bl3, bl4, bl5);
    }

    @NotNull
    public static final ProcessHandle startUnity(@NotNull String executable, @NotNull List<String> args, @NotNull String projectPath) {
        ProcessBuilder processBuilder;
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        args.add(0, executable);
        ScriptingAPI_UnityKt.withProjectPath(args, projectPath);
        ProcessBuilder $this$startUnity_u24lambda_u240 = processBuilder = new ProcessBuilder(args);
        boolean bl = false;
        $this$startUnity_u24lambda_u240.environment().remove("RESHARPER_HOST_BIN");
        ProcessBuilder processBuilder2 = processBuilder;
        Logger logger = TestFrameworkBaseKt.getFrameworkLogger();
        List<String> list = processBuilder2.command();
        Intrinsics.checkNotNullExpressionValue(list, (String)"command(...)");
        logger.info("Starting Unity process with command line: " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        Process process = processBuilder2.start();
        ProcessHandle processHandle = ProcessHandle.of(process.pid()).orElse(null);
        AssertionsKt.assertNotNull((Object)processHandle, (String)"Unity process wasn't started");
        TestFrameworkBaseKt.getFrameworkLogger().info("Unity process started [pid: " + processHandle.pid() + "]");
        return processHandle;
    }

    public static final void waitFirstScriptCompilation(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        TestFrameworkBaseKt.getFrameworkLogger().info("Waiting for .start file exist");
        File unityStartFile = FilesKt.resolve((File)SolutionHostExtensionsKt.getSolutionDirectory((Project)project2), (String)".start");
        ExtensionsKt.waitAndPump((Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project2)), () -> ScriptingAPI_UnityKt.waitFirstScriptCompilation$lambda$0(unityStartFile), (Duration)unityDefaultTimeout, ScriptingAPI_UnityKt::waitFirstScriptCompilation$lambda$1);
        TestFrameworkBaseKt.getFrameworkLogger().info("Unity started (.start file exist)");
    }

    @NotNull
    public static final File putUnityProjectToTempTestDir(@NotNull String solutionDirectoryName, @Nullable Function1<? super File, Boolean> filter, @NotNull File testWorkDirectory, @NotNull File solutionSourceRootDirectory, @NotNull File testDataDirectory) {
        Intrinsics.checkNotNullParameter((Object)solutionDirectoryName, (String)"solutionDirectoryName");
        Intrinsics.checkNotNullParameter((Object)testWorkDirectory, (String)"testWorkDirectory");
        Intrinsics.checkNotNullParameter((Object)solutionSourceRootDirectory, (String)"solutionSourceRootDirectory");
        Intrinsics.checkNotNullParameter((Object)testDataDirectory, (String)"testDataDirectory");
        String string = new File(solutionDirectoryName).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String solutionName = string;
        File workDirectory = new File(testWorkDirectory, solutionName);
        File sourceDirectory = new File(solutionSourceRootDirectory, solutionDirectoryName);
        Function1<? super File, Boolean> function1 = filter;
        FileUtil.copyDir((File)sourceDirectory, (File)workDirectory, (FileFilter)(function1 != null ? arg_0 -> ScriptingAPI_UnityKt.putUnityProjectToTempTestDir$lambda$0(function1, arg_0) : null));
        ScriptingAPI_UnityKt.copyAdditionalFilesToProject(solutionName, workDirectory, testDataDirectory);
        ShouldAssertsKt.shouldBeTrue((boolean)workDirectory.isDirectory(), (String)("Expected '" + workDirectory.getAbsolutePath() + "' to be a directory"));
        return workDirectory;
    }

    public static /* synthetic */ File putUnityProjectToTempTestDir$default(String string, Function1 function1, File file, File file2, File file3, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return ScriptingAPI_UnityKt.putUnityProjectToTempTestDir(string, (Function1<? super File, Boolean>)function1, file, file2, file3);
    }

    public static final void copyAdditionalFilesToProject(@NotNull String solutionName, @NotNull File workDirectory, @NotNull File testDataDirectory) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)solutionName, (String)"solutionName");
            Intrinsics.checkNotNullParameter((Object)workDirectory, (String)"workDirectory");
            Intrinsics.checkNotNullParameter((Object)testDataDirectory, (String)"testDataDirectory");
            File helperFileDirectory = FilesKt.resolve((File)FilesKt.resolve((File)testDataDirectory, (String)"additionalFiles"), (String)solutionName);
            File destinationPath = FilesKt.resolve((File)FilesKt.resolve((File)workDirectory, (String)"Assets"), (String)"Editor");
            if (!helperFileDirectory.exists()) {
                helperFileDirectory = FilesKt.resolve((File)FilesKt.resolve((File)testDataDirectory, (String)"additionalFiles"), (String)"integrationTestHelper");
            }
            File[] fileArray = helperFileDirectory.listFiles();
            if (fileArray == null) break block2;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)file);
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                FilesKt.copyTo$default((File)file, (File)FilesKt.resolve((File)destinationPath, (String)string), (boolean)false, (int)0, (int)6, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean waitForSlnGeneratedByUnity(@NotNull ProcessHandle unityProcessHandle, @NotNull String slnDirPath, @NotNull Duration timeoutMinutes) {
        Intrinsics.checkNotNullParameter((Object)unityProcessHandle, (String)"unityProcessHandle");
        Intrinsics.checkNotNullParameter((Object)slnDirPath, (String)"slnDirPath");
        Intrinsics.checkNotNullParameter((Object)timeoutMinutes, (String)"timeoutMinutes");
        try {
            int bl = (int)timeoutMinutes.toMillis();
            WaitFor waitFor2 = new WaitFor(slnDirPath, unityProcessHandle, bl){
                final /* synthetic */ String $slnDirPath;
                final /* synthetic */ ProcessHandle $unityProcessHandle;
                {
                    this.$slnDirPath = $slnDirPath;
                    this.$unityProcessHandle = $unityProcessHandle;
                    super($super_call_param$1, 10000);
                }

                protected boolean condition() {
                    File[] slnFiles = new File(this.$slnDirPath).listFiles(waitForSlnGeneratedByUnity.waitFor.1::condition$lambda$0);
                    return !this.$unityProcessHandle.isAlive() && slnFiles != null && !(slnFiles.length == 0);
                }

                private static final boolean condition$lambda$0(File file, String name) {
                    Intrinsics.checkNotNull((Object)name);
                    return StringsKt.endsWith$default((String)name, (String)".sln", (boolean)false, (int)2, null);
                }
            };
            waitFor2.assertCompleted("Sln/csproj structure has not been created by Unity in the batch mode");
            boolean bl2 = waitFor2.isConditionRealized();
            return bl2;
        }
        finally {
            if (unityProcessHandle.isAlive()) {
                TestFrameworkBaseKt.getFrameworkLogger().info("Killing Unity process which did not generate csproj structure in " + timeoutMinutes.toMinutes() + " minutes");
                unityProcessHandle.destroyForcibly();
            }
        }
    }

    public static /* synthetic */ boolean waitForSlnGeneratedByUnity$default(ProcessHandle processHandle, String string, Duration duration, int n, Object object) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
            duration = duration2;
        }
        return ScriptingAPI_UnityKt.waitForSlnGeneratedByUnity(processHandle, string, duration);
    }

    public static final void setRiderPackageVersion(@NotNull File sourceDirectory, @NotNull String riderPackageVersion) {
        File file;
        Intrinsics.checkNotNullParameter((Object)sourceDirectory, (String)"sourceDirectory");
        Intrinsics.checkNotNullParameter((Object)riderPackageVersion, (String)"riderPackageVersion");
        File it = file = new File(sourceDirectory.getPath() + packageManifestPath);
        boolean bl = false;
        File file2 = it.isFile() ? file : null;
        if (file2 == null) {
            throw new FileNotFoundException("Cannot find /Packages/manifest.json");
        }
        File file3 = file2;
        String content = FilesKt.readText$default((File)file3, null, (int)1, null);
        String updatedContent = StringsKt.replace$default((String)content, (String)riderPackageTag, (String)riderPackageVersion, (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)file3, (String)updatedContent, null, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getEngineExecutable$lambda$0$0(EngineVersion $version, String $engineName, File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if ($version == UnityVersion.V6) {
            if (!file.isDirectory()) return false;
            if (Intrinsics.areEqual((Object)file.getName(), (Object)$version.getVersion())) return true;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)(UnityVersion.V6.getVersion() + ".0"), (boolean)false, (int)2, null)) return false;
            return true;
        }
        if (!file.isDirectory()) return false;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)$version.getVersion(), (boolean)false, (int)2, null)) return true;
        String string2 = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)$engineName, (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final CharSequence getEngineExecutable$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final int getEngineExecutable$lambda$2(File unity, File otherUnity) {
        return VersionComparatorUtil.compare((String)unity.getName(), (String)otherUnity.getName());
    }

    private static final int getEngineExecutable$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final CharSequence getEngineExecutable$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final boolean waitFirstScriptCompilation$lambda$0(File $unityStartFile) {
        return $unityStartFile.exists();
    }

    private static final String waitFirstScriptCompilation$lambda$1() {
        return "Unity was not started.";
    }

    private static final boolean putUnityProjectToTempTestDir$lambda$0(Function1 $tmp0, File p0) {
        return (Boolean)$tmp0.invoke((Object)p0);
    }

    static {
        Duration duration = Duration.ofSeconds(120L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        unityDefaultTimeout = duration;
    }
}

