/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.unreal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.UnrealEngine;
import com.jetbrains.rd.ide.model.UnrealModel_PregeneratedKt;
import com.jetbrains.rd.ide.model.UnrealVersion;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.cpp.fileType.json.unrealEngine.UnrealProjectModelFilesSniffer;
import com.jetbrains.rider.cpp.unreal.actions.templates.NewUnrealActionBase;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.actions.SolutionViewAddActionGroup;
import com.jetbrains.rider.run.devices.ActiveDeviceManager;
import com.jetbrains.rider.test.OpenSolutionParams;
import com.jetbrains.rider.test.annotations.RiderTestTimeout;
import com.jetbrains.rider.test.annotations.Solution;
import com.jetbrains.rider.test.annotations.TestSettings;
import com.jetbrains.rider.test.asserts.ShouldAssertsKt;
import com.jetbrains.rider.test.base.BaseTestWithShell;
import com.jetbrains.rider.test.enums.BuildTool;
import com.jetbrains.rider.test.enums.Mono;
import com.jetbrains.rider.test.enums.sdk.SdkVersion;
import com.jetbrains.rider.test.facades.TestApiScopes;
import com.jetbrains.rider.test.facades.build.BuildApiFacade;
import com.jetbrains.rider.test.facades.build.RiderBuildApiFacade;
import com.jetbrains.rider.test.facades.protocol.ProtocolApiFacade;
import com.jetbrains.rider.test.facades.protocol.RiderProtocolApiFacade;
import com.jetbrains.rider.test.facades.solution.RiderSolutionApiFacade;
import com.jetbrains.rider.test.facades.solution.SolutionApiFacade;
import com.jetbrains.rider.test.facades.unreal.RiderUnrealApiFacade;
import com.jetbrains.rider.test.facades.unreal.UnrealProjectModelApiFacade;
import com.jetbrains.rider.test.framework.GoldFilesHelperKt;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.framework.TestProjectModelDumpFilesProfile;
import com.jetbrains.rider.test.framework.processor.model.IntegrationTestMethod;
import com.jetbrains.rider.test.framework.testData.TestDataStorage;
import com.jetbrains.rider.test.framework.testData.UnrealTestDataStorage;
import com.jetbrains.rider.test.scriptingApi.BackendSettingsEditor;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Editor_BaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_ProjectModelKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_ProjectModel_BaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Settings_BaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_UnrealKt;
import com.jetbrains.rider.test.shared.utils.ProcessCleanupUtils;
import com.jetbrains.rider.test.suplementary.ExternalSolutions;
import com.jetbrains.rider.test.suplementary.RiderTestSolution;
import com.jetbrains.rider.test.unreal.UnrealBase;
import com.jetbrains.rider.test.unreal.UnrealTestingEngineList;
import com.jetbrains.rider.test.unreal.suplementary.UprojectPlugins;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.OnErrorAction;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.DataProvider;

@RiderTestTimeout(timeout=6L, unit=TimeUnit.MINUTES)
@TestSettings(buildTool=BuildTool.UNREAL, mono=Mono.UNIX_ONLY, sdkVersion=SdkVersion.DOT_NET_8, additionalSdkVersions={SdkVersion.DOT_NET_6})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b'\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0004\u0099\u0001\u009a\u0001B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u00105\u001a\u000206H\u0007J\b\u00107\u001a\u000206H\u0007J\b\u00108\u001a\u000206H\u0007J\u001b\u00109\u001a\u0002062\f\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;H\u0016\u00a2\u0006\u0002\u0010=J\b\u0010>\u001a\u000206H\u0016J\u0018\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0002J\u0016\u0010E\u001a\u0002062\u0006\u0010A\u001a\u00020B2\u0006\u0010F\u001a\u00020DJ\u0012\u0010G\u001a\u0004\u0018\u00010.2\b\b\u0002\u0010H\u001a\u00020IJ\b\u0010J\u001a\u000206H\u0004J\b\u0010K\u001a\u000206H\u0004J$\u0010L\u001a\u0002062\b\b\u0002\u0010M\u001a\u00020N2\u0012\u0010O\u001a\u000e\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u0002060PJo\u0010R\u001a\u0002062\b\b\u0002\u0010S\u001a\u00020N2\u000e\b\u0002\u0010T\u001a\b\u0012\u0004\u0012\u00020.0U2\u0006\u0010V\u001a\u00020W2\b\b\u0002\u0010X\u001a\u00020I26\u0010Y\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0004\u0012\u00020N\u0012\n\u0012\b\u0012\u0004\u0012\u0002060[0Z0;\"\u0014\u0012\u0004\u0012\u00020N\u0012\n\u0012\b\u0012\u0004\u0012\u0002060[0Z\u00a2\u0006\u0002\u0010\\J)\u0010]\u001a\u0002062\f\u0010^\u001a\b\u0012\u0004\u0012\u00020N0;2\u000e\u0010_\u001a\n\u0012\u0006\b\u0001\u0012\u00020a0`\u00a2\u0006\u0002\u0010bJ\u0006\u0010c\u001a\u000206J\b\u0010d\u001a\u000206H\u0014J\b\u0010e\u001a\u000206H\u0004J\u0006\u0010f\u001a\u00020.J\b\u0010g\u001a\u000206H\u0016J\u0012\u0010h\u001a\u00020.2\b\b\u0002\u0010i\u001a\u00020.H\u0004J \u0010j\u001a\u0002062\u0006\u0010k\u001a\u00020.2\u0006\u0010l\u001a\u00020.2\u0006\u0010m\u001a\u00020nH\u0004J\b\u0010o\u001a\u00020.H\u0004J\u0014\u0010p\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0014\u0010r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0014\u0010s\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0014\u0010t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0014\u0010u\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0014\u0010v\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0014\u0010w\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0014\u0010x\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0014\u0010y\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0014\u0010z\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0014\u0010{\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0014\u0010|\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0014\u0010}\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0014\u0010~\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0014\u0010\u007f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0015\u0010\u0080\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0015\u0010\u0081\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0015\u0010\u0082\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J\u0015\u0010\u0083\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0qH\u0007J+\u0010\u008d\u0001\u001a\t\u0012\u0005\u0012\u00030\u008a\u00010U*\u00030\u008e\u00012\u0014\u0010\u008f\u0001\u001a\u000f\u0012\u0005\u0012\u00030\u008a\u0001\u0012\u0004\u0012\u00020I0PH\u0002JA\u0010\u0090\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0q2\u000e\u0010\u0091\u0001\u001a\t\u0012\u0005\u0012\u00030\u0092\u00010;2\u0014\u0010\u008f\u0001\u001a\u000f\u0012\u0005\u0012\u00030\u008a\u0001\u0012\u0004\u0012\u00020I0PH\u0016\u00a2\u0006\u0003\u0010\u0093\u0001J+\u0010\u0094\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0q2\u0014\u0010\u008f\u0001\u001a\u000f\u0012\u0005\u0012\u00030\u008a\u0001\u0012\u0004\u0012\u00020I0PH\u0016R\u001b\u0010\b\u001a\u00020\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\r\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u00020\u00198VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\r\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\r\u001a\u0004\b\u001f\u0010 R\u001b\u0010\"\u001a\u00020#8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\r\u001a\u0004\b$\u0010%R\u001a\u0010'\u001a\u00020(X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0018\u0010\u0084\u0001\u001a\u00030\u0085\u0001X\u0084\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0086\u0001\u0010\u0087\u0001R+\u0010\u0088\u0001\u001a\u0016\u0012\u0004\u0012\u00020N\u0012\u0005\u0012\u00030\u008a\u0001\u0012\u0004\u0012\u00020N0\u0089\u0001X\u0096\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u008b\u0001\u0010\u008c\u0001R\u0019\u0010\u0095\u0001\u001a\t\u0012\u0005\u0012\u00030\u0092\u00010;X\u0082\u0004\u00a2\u0006\u0005\n\u0003\u0010\u0096\u0001R\u0019\u0010\u0097\u0001\u001a\t\u0012\u0005\u0012\u00030\u0092\u00010;X\u0082\u0004\u00a2\u0006\u0005\n\u0003\u0010\u0096\u0001R\u0019\u0010\u0098\u0001\u001a\t\u0012\u0005\u0012\u00030\u0092\u00010;X\u0082\u0004\u00a2\u0006\u0005\n\u0003\u0010\u0096\u0001\u00a8\u0006\u009b\u0001"}, d2={"Lcom/jetbrains/rider/test/unreal/UnrealBase;", "Lcom/jetbrains/rider/test/base/BaseTestWithShell;", "Lcom/jetbrains/rider/test/facades/TestApiScopes$Protocol;", "Lcom/jetbrains/rider/test/facades/TestApiScopes$Solution;", "Lcom/jetbrains/rider/test/facades/TestApiScopes$Build;", "Lcom/jetbrains/rider/test/facades/TestApiScopes$ProjectModel;", "<init>", "()V", "testDataStorage", "Lcom/jetbrains/rider/test/framework/testData/TestDataStorage;", "getTestDataStorage", "()Lcom/jetbrains/rider/test/framework/testData/TestDataStorage;", "testDataStorage$delegate", "Lkotlin/Lazy;", "protocolApiFacade", "Lcom/jetbrains/rider/test/facades/protocol/ProtocolApiFacade;", "getProtocolApiFacade", "()Lcom/jetbrains/rider/test/facades/protocol/ProtocolApiFacade;", "protocolApiFacade$delegate", "solutionApiFacade", "Lcom/jetbrains/rider/test/facades/solution/RiderSolutionApiFacade;", "getSolutionApiFacade", "()Lcom/jetbrains/rider/test/facades/solution/RiderSolutionApiFacade;", "solutionApiFacade$delegate", "projectModelApiFacade", "Lcom/jetbrains/rider/test/facades/unreal/UnrealProjectModelApiFacade;", "getProjectModelApiFacade", "()Lcom/jetbrains/rider/test/facades/unreal/UnrealProjectModelApiFacade;", "projectModelApiFacade$delegate", "buildApiFacade", "Lcom/jetbrains/rider/test/facades/build/BuildApiFacade;", "getBuildApiFacade", "()Lcom/jetbrains/rider/test/facades/build/BuildApiFacade;", "buildApiFacade$delegate", "unrealApiFacade", "Lcom/jetbrains/rider/test/facades/unreal/RiderUnrealApiFacade;", "getUnrealApiFacade", "()Lcom/jetbrains/rider/test/facades/unreal/RiderUnrealApiFacade;", "unrealApiFacade$delegate", "unrealExplorerPaths", "Lcom/jetbrains/rider/test/unreal/UnrealBase$UnrealExplorerPaths;", "getUnrealExplorerPaths", "()Lcom/jetbrains/rider/test/unreal/UnrealBase$UnrealExplorerPaths;", "setUnrealExplorerPaths", "(Lcom/jetbrains/rider/test/unreal/UnrealBase$UnrealExplorerPaths;)V", "pathToTestProjectSource", "Ljava/io/File;", "getPathToTestProjectSource", "()Ljava/io/File;", "openSolutionParams", "Lcom/jetbrains/rider/test/OpenSolutionParams;", "getOpenSolutionParams", "()Lcom/jetbrains/rider/test/OpenSolutionParams;", "cleanUpUnrealProcessesBefore", "", "cleanUpUnrealProcessesAfter", "unrealBeforeAllTestsDefaultConfiguration", "readParametersFromDataProvider", "parameters", "", "", "([Ljava/lang/Object;)V", "beforeOpenSolution", "getByEngine", "Lcom/jetbrains/rider/test/suplementary/ExternalSolutions;", "solution", "Lcom/jetbrains/rider/test/annotations/Solution;", "unrealVersion", "Lcom/jetbrains/rd/ide/model/UnrealVersion;", "putUnrealProjectToTempTestDir", "engineVersion", "getCurrentUnrealLogDirectory", "gameMode", "", "collectUnrealLogs", "closeProject", "executeWithUnrealGold", "baseSuffix", "", "action", "Lkotlin/Function1;", "Ljava/io/PrintStream;", "withDumpEachStep", "baxeSuffix", "dumpItems", "", "dumpProfile", "Lcom/jetbrains/rider/test/framework/TestProjectModelDumpFilesProfile;", "dumpInitBlock", "actions", "Lkotlin/Pair;", "Lkotlin/Function0;", "(Ljava/lang/String;Ljava/util/List;Lcom/jetbrains/rider/test/framework/TestProjectModelDumpFilesProfile;Z[Lkotlin/Pair;)V", "waitUnrealActionAvailable", "path", "actionType", "Ljava/lang/Class;", "Lcom/jetbrains/rider/cpp/unreal/actions/templates/NewUnrealActionBase;", "([Ljava/lang/String;Ljava/lang/Class;)V", "waitUnrealFilesSniffer", "configureAndOpenUnrealProject", "unrealProjectCrutch", "ueAppDataPath", "unrealCleanup", "backupProject", "backupFolder", "restoreProject", "projectDir", "backupDir", "profile", "Lcom/jetbrains/rider/test/unreal/UnrealBase$BackupRestoreProfile;", "getProjectFile", "AllEngines_AllPModels", "", "AllEngines_uprojectOnly", "AllEngines_slnOnly", "egsOnly_AllPModels", "egsOnly_SlnOnly", "ue4egsOnly_UprojectOnly", "ue4egsOnly_SlnOnly", "ue4egsOnly_AllPModels", "ue5egsOnly_UprojectOnly", "egsOnly_UprojectOnly", "ue5Egs_AllPModels", "ue54Egs_AllPModels", "ue5Only_slnOnly", "ue5Only_AllPModels", "ue5SourceOnly_AllPModules", "ue5SourceOnly_UprojectOnly", "ue5SourceOnly_SlnOnly", "ue5EgsOnly_slnOnly", "specialTestProvider", "guidRegex", "Lkotlin/text/Regex;", "getGuidRegex", "()Lkotlin/text/Regex;", "uniqueDataString", "Lkotlin/Function2;", "Lcom/jetbrains/rd/ide/model/UnrealEngine;", "getUniqueDataString", "()Lkotlin/jvm/functions/Function2;", "filter", "Lcom/jetbrains/rider/test/unreal/UnrealTestingEngineList;", "predicate", "generateUnrealFullDataProvider", "unrealPmTypes", "Lcom/jetbrains/rider/test/facades/unreal/UnrealProjectModelApiFacade$PMType;", "([Lcom/jetbrains/rider/test/facades/unreal/UnrealProjectModelApiFacade$PMType;Lkotlin/jvm/functions/Function1;)Ljava/util/Iterator;", "generateUnrealEngineDataProvider", "allModels", "[Lcom/jetbrains/rider/test/facades/unreal/UnrealProjectModelApiFacade$PMType;", "onlySln", "onlyUproject", "UnrealExplorerPaths", "BackupRestoreProfile", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nUnrealBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnrealBase.kt\ncom/jetbrains/rider/test/unreal/UnrealBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,750:1\n1761#2,3:751\n1563#2:754\n1634#2,3:755\n774#2:758\n865#2,2:759\n774#2:761\n865#2,2:762\n1869#2:764\n1870#2:767\n774#2:768\n865#2,2:769\n774#2:771\n865#2,2:772\n1869#2,2:774\n1869#2,2:784\n1869#2,2:786\n1869#2,2:788\n13805#3,2:765\n1321#4,2:776\n1321#4,2:778\n216#5,2:780\n216#5,2:782\n37#6,2:790\n*S KotlinDebug\n*F\n+ 1 UnrealBase.kt\ncom/jetbrains/rider/test/unreal/UnrealBase\n*L\n311#1:751,3\n424#1:754\n424#1:755,3\n700#1:758\n700#1:759,2\n708#1:761\n708#1:762,2\n708#1:764\n708#1:767\n715#1:768\n715#1:769,2\n722#1:771\n722#1:772,2\n722#1:774,2\n537#1:784,2\n541#1:786,2\n545#1:788,2\n709#1:765,2\n483#1:776,2\n501#1:778,2\n524#1:780,2\n533#1:782,2\n547#1:790,2\n*E\n"})
public abstract class UnrealBase
extends BaseTestWithShell
implements TestApiScopes.Protocol,
TestApiScopes.Solution,
TestApiScopes.Build,
TestApiScopes.ProjectModel {
    @NotNull
    private final Lazy testDataStorage$delegate = LazyKt.lazy(() -> UnrealBase.testDataStorage_delegate$lambda$0(this));
    @NotNull
    private final Lazy protocolApiFacade$delegate = LazyKt.lazy(() -> UnrealBase.protocolApiFacade_delegate$lambda$0(this));
    @NotNull
    private final Lazy solutionApiFacade$delegate = LazyKt.lazy(UnrealBase::solutionApiFacade_delegate$lambda$0);
    @NotNull
    private final Lazy projectModelApiFacade$delegate = LazyKt.lazy(() -> UnrealBase.projectModelApiFacade_delegate$lambda$0(this));
    @NotNull
    private final Lazy buildApiFacade$delegate = LazyKt.lazy(() -> UnrealBase.buildApiFacade_delegate$lambda$0(this));
    @NotNull
    private final Lazy unrealApiFacade$delegate = LazyKt.lazy(UnrealBase::unrealApiFacade_delegate$lambda$0);
    public UnrealExplorerPaths unrealExplorerPaths;
    @NotNull
    private final OpenSolutionParams openSolutionParams;
    @NotNull
    private final Regex guidRegex;
    @NotNull
    private final Function2<String, UnrealEngine, String> uniqueDataString;
    @NotNull
    private final UnrealProjectModelApiFacade.PMType[] allModels;
    @NotNull
    private final UnrealProjectModelApiFacade.PMType[] onlySln;
    @NotNull
    private final UnrealProjectModelApiFacade.PMType[] onlyUproject;

    /*
     * WARNING - void declaration
     */
    public UnrealBase() {
        void $this$openSolutionParams_u24lambda_u240;
        UnrealProjectModelApiFacade.PMType[] pMTypeArray;
        UnrealProjectModelApiFacade.PMType[] pMTypeArray2 = pMTypeArray = new OpenSolutionParams();
        UnrealBase unrealBase = this;
        boolean bl = false;
        $this$openSolutionParams_u24lambda_u240.setWaitForCaches(true);
        Duration duration = Duration.ofSeconds(150L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        $this$openSolutionParams_u24lambda_u240.setProjectModelReadyTimeout(duration);
        Duration duration2 = Duration.ofSeconds(120L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        $this$openSolutionParams_u24lambda_u240.setInitWithCachesTimeout(duration2);
        unrealBase.openSolutionParams = pMTypeArray;
        this.guidRegex = new Regex("^[{]?[\\da-fA-F]{8}-([\\da-fA-F]{4}-){3}[\\da-fA-F]{12}[}]?$");
        this.uniqueDataString = (arg_0, arg_1) -> UnrealBase.uniqueDataString$lambda$0(this, arg_0, arg_1);
        pMTypeArray = new UnrealProjectModelApiFacade.PMType[]{UnrealProjectModelApiFacade.PMType.Sln, UnrealProjectModelApiFacade.PMType.Uproject};
        this.allModels = pMTypeArray;
        pMTypeArray = new UnrealProjectModelApiFacade.PMType[]{UnrealProjectModelApiFacade.PMType.Sln};
        this.onlySln = pMTypeArray;
        pMTypeArray = new UnrealProjectModelApiFacade.PMType[]{UnrealProjectModelApiFacade.PMType.Uproject};
        this.onlyUproject = pMTypeArray;
    }

    @NotNull
    public TestDataStorage getTestDataStorage() {
        Lazy lazy = this.testDataStorage$delegate;
        return (TestDataStorage)lazy.getValue();
    }

    @NotNull
    public ProtocolApiFacade getProtocolApiFacade() {
        Lazy lazy = this.protocolApiFacade$delegate;
        return (ProtocolApiFacade)lazy.getValue();
    }

    @NotNull
    public RiderSolutionApiFacade getSolutionApiFacade() {
        Lazy lazy = this.solutionApiFacade$delegate;
        return (RiderSolutionApiFacade)((Object)lazy.getValue());
    }

    @NotNull
    public UnrealProjectModelApiFacade getProjectModelApiFacade() {
        Lazy lazy = this.projectModelApiFacade$delegate;
        return (UnrealProjectModelApiFacade)lazy.getValue();
    }

    @NotNull
    public BuildApiFacade getBuildApiFacade() {
        Lazy lazy = this.buildApiFacade$delegate;
        return (BuildApiFacade)lazy.getValue();
    }

    @NotNull
    public final RiderUnrealApiFacade getUnrealApiFacade() {
        Lazy lazy = this.unrealApiFacade$delegate;
        return (RiderUnrealApiFacade)lazy.getValue();
    }

    @NotNull
    public final UnrealExplorerPaths getUnrealExplorerPaths() {
        UnrealExplorerPaths unrealExplorerPaths = this.unrealExplorerPaths;
        if (unrealExplorerPaths != null) {
            return unrealExplorerPaths;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"unrealExplorerPaths");
        return null;
    }

    public final void setUnrealExplorerPaths(@NotNull UnrealExplorerPaths unrealExplorerPaths) {
        Intrinsics.checkNotNullParameter((Object)unrealExplorerPaths, (String)"<set-?>");
        this.unrealExplorerPaths = unrealExplorerPaths;
    }

    @NotNull
    public final File getPathToTestProjectSource() {
        File file = FilesKt.resolve((File)FilesKt.resolve((File)SolutionHostExtensionsKt.getSolutionDirectory((Project)this.getProject()), (String)"Source"), (String)this.getActiveSolution());
        ShouldAssertsKt.shouldBeTrue$default((boolean)file.exists(), null, (int)1, null);
        return file;
    }

    @NotNull
    public final OpenSolutionParams getOpenSolutionParams() {
        return this.openSolutionParams;
    }

    @BeforeSuite
    public final void cleanUpUnrealProcessesBefore() {
        ProcessCleanupUtils.Policy[] policyArray = new ProcessCleanupUtils.Policy[]{ProcessCleanupUtils.DefaultPolicy.Unreal};
        ProcessCleanupUtils.INSTANCE.cleanupSuspiciousProcesses(policyArray);
    }

    @AfterSuite(alwaysRun=true)
    public final void cleanUpUnrealProcessesAfter() {
        ProcessCleanupUtils.Policy[] policyArray = new ProcessCleanupUtils.Policy[]{ProcessCleanupUtils.DefaultPolicy.Unreal};
        ProcessCleanupUtils.INSTANCE.cleanupSuspiciousProcesses(policyArray);
    }

    @BeforeClass(alwaysRun=true)
    public final void unrealBeforeAllTestsDefaultConfiguration() {
        this.getLogger().info("Found installed engines: " + ArraysKt.joinToString$default((Object[])UnrealTestingEngineList.INSTANCE.getInstalledEngineList(), null, null, null, (int)0, null, UnrealBase::unrealBeforeAllTestsDefaultConfiguration$lambda$0, (int)31, null));
        this.getLogger().info("Engines will be used in tests: " + CollectionsKt.joinToString$default((Iterable)UnrealTestingEngineList.INSTANCE.getTestingEngines(), null, null, null, (int)0, null, UnrealBase::unrealBeforeAllTestsDefaultConfiguration$lambda$1, (int)31, null));
        ScriptingAPI_Settings_BaseKt.editBackendSettings$default(null, null, UnrealBase::unrealBeforeAllTestsDefaultConfiguration$lambda$2, (int)3, null);
    }

    public void readParametersFromDataProvider(@NotNull Object[] parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        UnrealBase.readParametersFromDataProvider$validateDataProviderParameters(parameters);
        UnrealProjectModelApiFacade unrealProjectModelApiFacade = this.getProjectModelApiFacade();
        Object object = parameters[1];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.rider.test.facades.unreal.UnrealProjectModelApiFacade.PMType");
        unrealProjectModelApiFacade.setProjectModelType((UnrealProjectModelApiFacade.PMType)((Object)object));
        RiderUnrealApiFacade riderUnrealApiFacade = this.getUnrealApiFacade();
        Object object2 = parameters[2];
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.UnrealEngine");
        riderUnrealApiFacade.setCurrentEngine((UnrealEngine)object2);
        this.getLogger().info("Current engine set as " + this.getUnrealApiFacade().getCurrentEngine() + ", project model as " + this.getProjectModelApiFacade().getProjectModelType() + ".");
    }

    public void beforeOpenSolution() {
        ScriptingAPI_UnrealKt.copyAdditionalAssetsToProject(this, this.getUnrealApiFacade().getCurrentEngine().getVersion());
    }

    private final ExternalSolutions getByEngine(Solution solution, UnrealVersion unrealVersion) {
        if (ScriptingAPI_UnrealKt.basicallyEquals(unrealVersion, new UnrealVersion(5, 5, 0))) {
            return ExternalSolutions.LyraStarterGame55;
        }
        if (ScriptingAPI_UnrealKt.basicallyEquals(unrealVersion, new UnrealVersion(5, 6, 0))) {
            return ExternalSolutions.LyraStarterGame56;
        }
        throw new IllegalArgumentException("There is no specific " + solution.name() + " for version " + unrealVersion);
    }

    public final void putUnrealProjectToTempTestDir(@NotNull Solution solution, @NotNull UnrealVersion engineVersion) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)solution, (String)"solution");
            Intrinsics.checkNotNullParameter((Object)engineVersion, (String)"engineVersion");
            Iterable $this$any$iv = KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(RiderTestSolution.Unreal.EngineDepended.class));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KProperty1 it = (KProperty1)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)solution.name())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean isEngineDependent = bl;
        String solutionName = !isEngineDependent ? solution.name() : solution.name() + engineVersion.getMajor() + engineVersion.getMinor();
        this.getUnrealApiFacade().setUprojectFile(this.getSolutionApiFacade().prepareSolution(solutionName, this.openSolutionParams, this.getTestWorkDirectory(), this.getSolutionSourceRootDirectory()));
    }

    @Nullable
    public final File getCurrentUnrealLogDirectory(boolean gameMode) {
        if (SystemInfo.isWindows) {
            return FilesKt.resolve((File)FilesKt.resolve((File)this.getActiveSolutionDirectory(), (String)"Saved"), (String)"Logs");
        }
        if (SystemInfo.isMac && !gameMode) {
            return FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)new File(System.getProperty("user.home")), (String)"Library"), (String)"Logs"), (String)"Unreal Engine"), (String)(this.getActiveSolution() + "Editor"));
        }
        if (SystemInfo.isMac && gameMode) {
            return FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)new File(System.getProperty("user.home")), (String)"Library"), (String)"Logs"), (String)this.getActiveSolution());
        }
        return null;
    }

    public static /* synthetic */ File getCurrentUnrealLogDirectory$default(UnrealBase unrealBase, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCurrentUnrealLogDirectory");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return unrealBase.getCurrentUnrealLogDirectory(bl);
    }

    protected final void collectUnrealLogs() {
        File unrealLogsDir;
        File file = unrealLogsDir = UnrealBase.getCurrentUnrealLogDirectory$default(this, false, 1, null);
        boolean bl = file != null ? file.exists() : false;
        if (bl) {
            FilesKt.copyRecursively$default((File)unrealLogsDir, (File)FilesKt.resolve((File)((IntegrationTestMethod)this.getTestMethod()).getLogDirectory(), (String)"UnrealInfo"), (boolean)false, UnrealBase::collectUnrealLogs$lambda$0, (int)2, null);
            FilesKt.deleteRecursively((File)unrealLogsDir);
        }
    }

    protected final void closeProject() {
        this.getSolutionApiFacade().closeSolution();
    }

    public final void executeWithUnrealGold(@NotNull String baseSuffix, @NotNull Function1<? super PrintStream, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)baseSuffix, (String)"baseSuffix");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        File goldFile = ((CharSequence)baseSuffix).length() > 0 ? GoldFilesHelperKt.getFileWithNameSuffix((File)this.getTestGoldFile(), (String)baseSuffix) : this.getTestGoldFile();
        UnrealVersion engineVersion = this.getUnrealApiFacade().getCurrentEngine().getVersion();
        Object[] objectArray = new String[]{"_" + this.getProjectModelApiFacade().getProjectModelType().name(), "_" + engineVersion.getMajor() + "_" + engineVersion.getMinor()};
        GoldFilesHelperKt.executeWithGold((File)goldFile, (List)CollectionsKt.listOf((Object[])objectArray), action);
    }

    public static /* synthetic */ void executeWithUnrealGold$default(UnrealBase unrealBase, String string, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeWithUnrealGold");
        }
        if ((n & 1) != 0) {
            string = "";
        }
        unrealBase.executeWithUnrealGold(string, (Function1<? super PrintStream, Unit>)function1);
    }

    public final void withDumpEachStep(@NotNull String baxeSuffix, @NotNull List<? extends File> dumpItems, @NotNull TestProjectModelDumpFilesProfile dumpProfile, boolean dumpInitBlock, Pair<String, ? extends Function0<Unit>> ... actions) {
        Intrinsics.checkNotNullParameter((Object)baxeSuffix, (String)"baxeSuffix");
        Intrinsics.checkNotNullParameter(dumpItems, (String)"dumpItems");
        Intrinsics.checkNotNullParameter((Object)dumpProfile, (String)"dumpProfile");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        this.executeWithUnrealGold(baxeSuffix, (Function1<? super PrintStream, Unit>)((Function1)arg_0 -> UnrealBase.withDumpEachStep$lambda$0(dumpInitBlock, dumpItems, dumpProfile, actions, arg_0)));
    }

    public static /* synthetic */ void withDumpEachStep$default(UnrealBase unrealBase, String string, List list, TestProjectModelDumpFilesProfile testProjectModelDumpFilesProfile, boolean bl, Pair[] pairArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: withDumpEachStep");
        }
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.listOf((Object)unrealBase.getActiveSolutionDirectory());
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        unrealBase.withDumpEachStep(string, list, testProjectModelDumpFilesProfile, bl, pairArray);
    }

    public final void waitUnrealActionAvailable(@NotNull String[] path, @NotNull Class<? extends NewUnrealActionBase> actionType) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(actionType, (String)"actionType");
        this.waitUnrealFilesSniffer();
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"ProjectViewPopup", null, (DataContext)ScriptingAPI_ProjectModelKt.createDataContextFor(this.getProject(), path));
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
        AnActionEvent actionEvent = anActionEvent;
        Ref.ObjectRef addGroupChildren = new Ref.ObjectRef();
        addGroupChildren.element = new AnAction[0];
        Duration duration = Duration.ofSeconds(60L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        ExtensionsKt.waitAndPump((Duration)duration, () -> UnrealBase.waitUnrealActionAvailable$lambda$0(addGroupChildren, actionType, actionEvent), () -> UnrealBase.waitUnrealActionAvailable$lambda$1(actionType, actionEvent));
    }

    public final void waitUnrealFilesSniffer() {
        UnrealProjectModelFilesSniffer sniffer = UnrealProjectModelFilesSniffer.Companion.getInstance(this.getProject());
        Duration duration = Duration.ofSeconds(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        ExtensionsKt.waitAndPump((Duration)duration, () -> UnrealBase.waitUnrealFilesSniffer$lambda$0(sniffer), UnrealBase::waitUnrealFilesSniffer$lambda$1);
    }

    /*
     * WARNING - void declaration
     */
    protected void configureAndOpenUnrealProject() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getUnrealApiFacade().getPluginsToAddInUproject();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new UprojectPlugins((String)it, true, null, null, null, null));
        }
        List plugins = (List)destination$iv$iv;
        ScriptingAPI_UnrealKt.prepareUprojectFile(this.getUnrealApiFacade().getUprojectFile(), this.getUnrealApiFacade().getCurrentEngine(), this.getUnrealApiFacade().getDisableEnginePlugins(), plugins);
        if (this.getProjectModelApiFacade().getProjectModelType() == UnrealProjectModelApiFacade.PMType.Sln) {
            ScriptingAPI_UnrealKt.generateSolutionFromUProject$default(this.getUnrealApiFacade().getUprojectFile(), this.getUnrealApiFacade().getCurrentEngine(), null, 4, null);
        }
        this.openSolution(this.getProjectFile(), this.openSolutionParams);
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)UnrealModel_PregeneratedKt.getUnrealModel((com.jetbrains.rd.ide.model.Solution)SolutionHostExtensionsKt.getSolution((Project)this.getProject())).isUnrealSolution()))) {
            TestFrameworkBaseKt.getFrameworkLogger().error("This project wasn't detect as unreal project!");
        }
        ActiveDeviceManager.Companion.getInstance(this.getProject());
    }

    protected final void unrealProjectCrutch() {
        if (this.getUnrealApiFacade().getCurrentEngine().isInstalledBuild()) {
            Duration duration = Duration.ofSeconds(400L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            this.openSolutionParams.setBackendLoadedTimeout(duration);
        } else {
            Duration duration = Duration.ofSeconds(600L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            this.openSolutionParams.setBackendLoadedTimeout(duration);
        }
        if (this.getProjectModelApiFacade().getProjectModelType() == UnrealProjectModelApiFacade.PMType.Sln) {
            this.openSolutionParams.setMinimalCountProjectsMustBeLoaded(null);
        } else {
            this.openSolutionParams.setMinimalCountProjectsMustBeLoaded(Integer.valueOf(1000));
        }
    }

    @NotNull
    public final File ueAppDataPath() {
        if (SystemInfo.isMac) {
            return FilesKt.resolve((File)FilesKt.resolve((File)new File(System.getProperty("user.home")), (String)"Library"), (String)"Caches");
        }
        if (SystemInfo.isWindows) {
            return new File(System.getenv("LOCALAPPDATA"));
        }
        return new File("");
    }

    public void unrealCleanup() {
        File ueIntermediate = FilesKt.resolve((File)this.ueAppDataPath(), (String)"UnrealEngine/Intermediate");
        if (FilesKt.deleteRecursively((File)ueIntermediate)) {
            TestFrameworkBaseKt.getFrameworkLogger().info("Deleted " + ueIntermediate);
        }
    }

    @NotNull
    protected final File backupProject(@NotNull File backupFolder) {
        Intrinsics.checkNotNullParameter((Object)backupFolder, (String)"backupFolder");
        FilesKt.deleteRecursively((File)backupFolder);
        FilesKt.copyRecursively$default((File)SolutionHostExtensionsKt.getSolutionDirectory((Project)this.getProject()), (File)backupFolder, (boolean)false, null, (int)6, null);
        return backupFolder;
    }

    public static /* synthetic */ File backupProject$default(UnrealBase unrealBase, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: backupProject");
        }
        if ((n & 1) != 0) {
            file = FilesKt.resolve((File)unrealBase.getTestWorkDirectory(), (String)(unrealBase.getActiveSolution() + "_backup"));
        }
        return unrealBase.backupProject(file);
    }

    protected final void restoreProject(@NotNull File projectDir, @NotNull File backupDir, @NotNull BackupRestoreProfile profile) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)backupDir, (String)"backupDir");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        ShouldAssertsKt.shouldBeTrue((boolean)backupDir.exists(), (String)("There is no backup in " + backupDir + ". Use [backupProject] for create backup before test."));
        ScriptingAPI_Editor_BaseKt.waitForDaemonCloseAllOpenEditors((Project)this.getProject());
        ScriptingAPI_ProjectModel_BaseKt.changeFileSystem2$default((Project)this.getProject(), null, (boolean)false, () -> UnrealBase.restoreProject$lambda$11(projectDir, backupDir, this, profile), (int)6, null);
    }

    @NotNull
    protected final File getProjectFile() {
        if (this.getProjectModelApiFacade().getProjectModelType() == UnrealProjectModelApiFacade.PMType.Uproject) {
            return this.getUnrealApiFacade().getUprojectFile();
        }
        return GoldFilesHelperKt.getFileWithExtension((File)this.getUnrealApiFacade().getUprojectFile(), (String)".sln");
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> AllEngines_AllPModels() {
        return this.generateUnrealFullDataProvider(this.allModels, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::AllEngines_AllPModels$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> AllEngines_uprojectOnly() {
        return this.generateUnrealFullDataProvider(this.onlyUproject, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::AllEngines_uprojectOnly$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> AllEngines_slnOnly() {
        return this.generateUnrealFullDataProvider(this.onlySln, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::AllEngines_slnOnly$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> egsOnly_AllPModels() {
        return this.generateUnrealFullDataProvider(this.allModels, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::egsOnly_AllPModels$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> egsOnly_SlnOnly() {
        return this.generateUnrealFullDataProvider(this.onlySln, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::egsOnly_SlnOnly$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> ue4egsOnly_UprojectOnly() {
        return this.generateUnrealFullDataProvider(this.onlyUproject, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::ue4egsOnly_UprojectOnly$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> ue4egsOnly_SlnOnly() {
        return this.generateUnrealFullDataProvider(this.onlySln, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::ue4egsOnly_SlnOnly$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> ue4egsOnly_AllPModels() {
        return this.generateUnrealFullDataProvider(this.allModels, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::ue4egsOnly_AllPModels$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> ue5egsOnly_UprojectOnly() {
        return this.generateUnrealFullDataProvider(this.onlyUproject, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::ue5egsOnly_UprojectOnly$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> egsOnly_UprojectOnly() {
        return this.generateUnrealFullDataProvider(this.onlyUproject, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::egsOnly_UprojectOnly$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> ue5Egs_AllPModels() {
        return this.generateUnrealFullDataProvider(this.allModels, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::ue5Egs_AllPModels$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> ue54Egs_AllPModels() {
        return this.generateUnrealFullDataProvider(this.allModels, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::ue54Egs_AllPModels$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> ue5Only_slnOnly() {
        return this.generateUnrealFullDataProvider(this.onlySln, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::ue5Only_slnOnly$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> ue5Only_AllPModels() {
        return this.generateUnrealFullDataProvider(this.allModels, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::ue5Only_AllPModels$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> ue5SourceOnly_AllPModules() {
        return this.generateUnrealFullDataProvider(this.allModels, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::ue5SourceOnly_AllPModules$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> ue5SourceOnly_UprojectOnly() {
        return this.generateUnrealFullDataProvider(this.onlyUproject, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::ue5SourceOnly_UprojectOnly$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> ue5SourceOnly_SlnOnly() {
        return this.generateUnrealFullDataProvider(this.onlySln, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::ue5SourceOnly_SlnOnly$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> ue5EgsOnly_slnOnly() {
        return this.generateUnrealFullDataProvider(this.onlySln, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::ue5EgsOnly_slnOnly$lambda$0));
    }

    @DataProvider
    @NotNull
    public final Iterator<Object[]> specialTestProvider() {
        return this.generateUnrealFullDataProvider(this.onlySln, (Function1<? super UnrealEngine, Boolean>)((Function1)UnrealBase::specialTestProvider$lambda$0));
    }

    @NotNull
    protected final Regex getGuidRegex() {
        return this.guidRegex;
    }

    @NotNull
    public Function2<String, UnrealEngine, String> getUniqueDataString() {
        return this.uniqueDataString;
    }

    /*
     * WARNING - void declaration
     */
    private final List<UnrealEngine> filter(UnrealTestingEngineList $this$filter, Function1<? super UnrealEngine, Boolean> predicate) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$filter.getTestingEngines();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        if (collection.isEmpty()) {
            boolean bl = false;
            throw new Exception("Failed to filter engines in " + $this$filter.getTestingEngines() + " by " + predicate);
        }
        return (List)collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterator<Object[]> generateUnrealFullDataProvider(@NotNull UnrealProjectModelApiFacade.PMType[] unrealPmTypes, @NotNull Function1<? super UnrealEngine, Boolean> predicate) {
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)unrealPmTypes, (String)"unrealPmTypes");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        ArrayList result2 = null;
        result2 = new ArrayList();
        Iterable $this$filter$iv = UnrealTestingEngineList.INSTANCE.getTestingEngines();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            if (!((Boolean)predicate.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnrealEngine engine = (UnrealEngine)element$iv;
            boolean bl = false;
            UnrealProjectModelApiFacade.PMType[] $this$forEach$iv2 = unrealPmTypes;
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                UnrealProjectModelApiFacade.PMType element$iv2;
                UnrealProjectModelApiFacade.PMType type = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                Object[] objectArray = new Object[]{this.getUniqueDataString().invoke((Object)String.valueOf((Object)type), (Object)engine), type, engine};
                result2.add(objectArray);
            }
        }
        TestFrameworkBaseKt.getFrameworkLogger().debug("Data Provider was generated: " + result2);
        if (!SystemInfo.isWindows) {
            void $this$filterTo$iv$iv2;
            Object element$iv;
            Iterable $this$filter$iv2 = result2;
            boolean $i$f$filter2 = false;
            element$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Object[] it = (Object[])element$iv$iv;
                boolean bl = false;
                if (!(it[1] != UnrealProjectModelApiFacade.PMType.Sln)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            result2 = (ArrayList)((List)destination$iv$iv2);
        }
        Iterator<Object[]> iterator2 = result2.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        return iterator2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterator<Object[]> generateUnrealEngineDataProvider(@NotNull Function1<? super UnrealEngine, Boolean> predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        ArrayList<Object[]> result2 = new ArrayList<Object[]>();
        Iterable $this$filter$iv = UnrealTestingEngineList.INSTANCE.getTestingEngines();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnrealEngine engine = (UnrealEngine)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{this.getUniqueDataString().invoke((Object)"", (Object)engine), engine};
            result2.add(objectArray);
        }
        TestFrameworkBaseKt.getFrameworkLogger().debug("Data Provider was generated: " + result2);
        Iterator<Object[]> iterator = result2.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        return iterator;
    }

    private static final UnrealTestDataStorage testDataStorage_delegate$lambda$0(UnrealBase this$0) {
        return new UnrealTestDataStorage(this$0.getTestProcessor());
    }

    private static final RiderProtocolApiFacade protocolApiFacade_delegate$lambda$0(UnrealBase this$0) {
        return new RiderProtocolApiFacade(this$0.getExecutionTarget(), this$0.getTestProcessor());
    }

    private static final RiderSolutionApiFacade solutionApiFacade_delegate$lambda$0() {
        return new RiderSolutionApiFacade();
    }

    private static final UnrealProjectModelApiFacade projectModelApiFacade_delegate$lambda$0(UnrealBase this$0) {
        return new UnrealProjectModelApiFacade((SolutionApiFacade)this$0.getSolutionApiFacade(), this$0.getUnrealApiFacade(), this$0.getTestDataStorage());
    }

    private static final buildApiFacade.2.1 buildApiFacade_delegate$lambda$0(UnrealBase this$0) {
        RiderSolutionApiFacade riderSolutionApiFacade = this$0.getSolutionApiFacade();
        BuildApiFacade.BuildSettings buildSettings = new BuildApiFacade.BuildSettings(false, false, false, false, 14, null);
        return new RiderBuildApiFacade(riderSolutionApiFacade, buildSettings){
            private final Duration defaultBuildTimeout;
            {
                Duration duration = Duration.ofMinutes(5L);
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
                this.defaultBuildTimeout = duration;
            }

            public Duration getDefaultBuildTimeout() {
                return this.defaultBuildTimeout;
            }
        };
    }

    private static final RiderUnrealApiFacade unrealApiFacade_delegate$lambda$0() {
        return new RiderUnrealApiFacade();
    }

    private static final CharSequence unrealBeforeAllTestsDefaultConfiguration$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it + "\n";
    }

    private static final CharSequence unrealBeforeAllTestsDefaultConfiguration$lambda$1(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it + "\n";
    }

    private static final Unit unrealBeforeAllTestsDefaultConfiguration$lambda$2(BackendSettingsEditor $this$editBackendSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$editBackendSettings, (String)"$this$editBackendSettings");
        $this$editBackendSettings.setIndexEngine(Boolean.valueOf(false));
        $this$editBackendSettings.setIndexThirdPartyCode(Boolean.valueOf(false));
        $this$editBackendSettings.setIndexPlugins(Boolean.valueOf(false));
        return Unit.INSTANCE;
    }

    private static final void readParametersFromDataProvider$validateDataProviderParameters(Object[] parameters) {
        ShouldAssertsKt.shouldBeTrue$default((boolean)(parameters[0] instanceof String), null, (int)1, null);
        ShouldAssertsKt.shouldBeTrue$default((boolean)(parameters[1] instanceof UnrealProjectModelApiFacade.PMType), null, (int)1, null);
        ShouldAssertsKt.shouldBeTrue$default((boolean)(parameters[2] instanceof UnrealEngine), null, (int)1, null);
    }

    private static final OnErrorAction collectUnrealLogs$lambda$0(File file, IOException exception) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        TestFrameworkBaseKt.getFrameworkLogger().warn(file.getName() + "Cannot be copied" + exception);
        return OnErrorAction.TERMINATE;
    }

    private static final Unit withDumpEachStep$lambda$0(boolean $dumpInitBlock, List $dumpItems, TestProjectModelDumpFilesProfile $dumpProfile, Pair[] $actions, PrintStream printStream) {
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        StringBuilder resultDump = new StringBuilder();
        if ($dumpInitBlock) {
            resultDump.append((CharSequence)ScriptingAPI_ProjectModelKt.doActionAndDump("Init", $dumpItems, $dumpProfile, (Function0<Unit>)((Function0)UnrealBase::withDumpEachStep$lambda$0$0)));
        }
        for (Pair action : $actions) {
            resultDump.append((CharSequence)ScriptingAPI_ProjectModelKt.doActionAndDump((String)action.getFirst(), $dumpItems, $dumpProfile, (Function0<Unit>)((Function0)action.getSecond())));
        }
        printStream.append(resultDump);
        return Unit.INSTANCE;
    }

    private static final Unit withDumpEachStep$lambda$0$0() {
        return Unit.INSTANCE;
    }

    private static final boolean waitUnrealActionAvailable$lambda$0(Ref.ObjectRef $addGroupChildren, Class $actionType, AnActionEvent $actionEvent) {
        ApplicationKt.getApplication().runReadAction(() -> UnrealBase.waitUnrealActionAvailable$lambda$0$0($addGroupChildren, $actionEvent));
        return !((Collection)ArraysKt.filterIsInstance((Object[])((Object[])$addGroupChildren.element), (Class)$actionType)).isEmpty();
    }

    private static final void waitUnrealActionAvailable$lambda$0$0(Ref.ObjectRef $addGroupChildren, AnActionEvent $actionEvent) {
        $addGroupChildren.element = new SolutionViewAddActionGroup().getChildren($actionEvent);
    }

    private static final String waitUnrealActionAvailable$lambda$1(Class $actionType, AnActionEvent $actionEvent) {
        return "No " + $actionType + ". Full list: " + ArraysKt.joinToString$default((Object[])new SolutionViewAddActionGroup().getChildren($actionEvent), (CharSequence)",\n", null, null, (int)0, null, null, (int)62, null);
    }

    private static final boolean waitUnrealFilesSniffer$lambda$0(UnrealProjectModelFilesSniffer $sniffer) {
        return !((Collection)$sniffer.getModulesSnapshot()).isEmpty() && !((Collection)$sniffer.getPluginsSnapshot()).isEmpty();
    }

    private static final String waitUnrealFilesSniffer$lambda$1() {
        return "UnrealProjectModelFilesSniffer is not ready";
    }

    private static final Map<String, String> restoreProject$createProjectSnaphost(UnrealBase this$0, BackupRestoreProfile $profile, File folder) {
        Map snapshot = new LinkedHashMap();
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)folder, null, (int)1, null).onEnter(arg_0 -> UnrealBase.restoreProject$createProjectSnaphost$lambda$0($profile, arg_0))), UnrealBase::restoreProject$createProjectSnaphost$lambda$1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String relatedPath = StringsKt.drop((String)string, (int)(folder.getPath().length() + 1));
            String content = FilesKt.readText$default((File)file, null, (int)1, null);
            snapshot.put(relatedPath, content);
        }
        this$0.getLogger().info("Snapshot created: " + CollectionsKt.joinToString$default((Iterable)snapshot.keySet(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        return snapshot;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean restoreProject$createProjectSnaphost$lambda$0(BackupRestoreProfile $profile, File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if ($profile.getIgnoreDirs().contains(dir.getName())) return false;
        String string = dir.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.startsWith$default((String)string, (String)".", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final boolean restoreProject$createProjectSnaphost$lambda$1(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile() && !it.isHidden();
    }

    private static final File[] restoreProject$restoreProjectFromSnapshot(UnrealBase this$0, BackupRestoreProfile $profile, File folder, Map<String, String> snapshot) {
        Object it;
        Object element$iv;
        List deletedFiles = new ArrayList();
        List replacedFiles = new ArrayList();
        List nonProcessedFiles = new ArrayList();
        List restoredFiles = new ArrayList();
        Object $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)folder, null, (int)1, null).onEnter(arg_0 -> UnrealBase.restoreProject$restoreProjectFromSnapshot$lambda$3($profile, arg_0))), UnrealBase::restoreProject$restoreProjectFromSnapshot$lambda$4);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            File file = (File)element$iv;
            boolean bl = false;
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String relatedPath = StringsKt.drop((String)string, (int)(folder.getPath().length() + 1));
            String content = FilesKt.readText$default((File)file, null, (int)1, null);
            this$0.getLogger().info("Processing: " + relatedPath);
            String contentFromSnapshot = snapshot.get(relatedPath);
            if (contentFromSnapshot == null) {
                deletedFiles.add(relatedPath);
                restoredFiles.add(file);
                file.delete();
            } else if (!Intrinsics.areEqual((Object)contentFromSnapshot, (Object)content)) {
                replacedFiles.add(relatedPath);
                restoredFiles.add(file);
                FilesKt.writeText$default((File)file, (String)contentFromSnapshot, null, (int)2, null);
            } else {
                nonProcessedFiles.add(relatedPath);
            }
            snapshot.remove(relatedPath);
        }
        this$0.getLogger().info("Creating missing files");
        $this$forEach$iv = snapshot;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl = false;
            this$0.getLogger().info((String)it.getKey());
            File creatingFile = FilesKt.resolve((File)folder, (String)((String)it.getKey()));
            Files.createDirectories(creatingFile.getParentFile().toPath(), new FileAttribute[0]);
            FilesKt.writeText$default((File)creatingFile, (String)((String)it.getValue()), null, (int)2, null);
            restoredFiles.add(creatingFile);
        }
        this$0.getLogger().info("\n\nMissing files:");
        $this$forEach$iv = snapshot;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl = false;
            this$0.getLogger().info((String)it.getKey());
        }
        this$0.getLogger().info("=================");
        this$0.getLogger().info("Deleted files:");
        $this$forEach$iv = deletedFiles;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
            this$0.getLogger().info((String)it);
        }
        this$0.getLogger().info("=================");
        this$0.getLogger().info("Replaced files:");
        $this$forEach$iv = replacedFiles;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
            this$0.getLogger().info((String)it);
        }
        this$0.getLogger().info("=================");
        this$0.getLogger().info("NonProcessed files:");
        $this$forEach$iv = nonProcessedFiles;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
            this$0.getLogger().info((String)it);
        }
        this$0.getLogger().info("=================");
        Collection $this$toTypedArray$iv = restoredFiles;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new File[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean restoreProject$restoreProjectFromSnapshot$lambda$3(BackupRestoreProfile $profile, File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if ($profile.getIgnoreDirs().contains(dir.getName())) return false;
        String string = dir.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.startsWith$default((String)string, (String)".", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final boolean restoreProject$restoreProjectFromSnapshot$lambda$4(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile() && !it.isHidden();
    }

    private static final File[] restoreProject$lambda$11(File $projectDir, File $backupDir, UnrealBase this$0, BackupRestoreProfile $profile) {
        return UnrealBase.restoreProject$restoreProjectFromSnapshot(this$0, $profile, $projectDir, UnrealBase.restoreProject$createProjectSnaphost(this$0, $profile, $backupDir));
    }

    private static final boolean AllEngines_AllPModels$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean AllEngines_uprojectOnly$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean AllEngines_slnOnly$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean egsOnly_AllPModels$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isInstalledBuild();
    }

    private static final boolean egsOnly_SlnOnly$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isInstalledBuild();
    }

    private static final boolean ue4egsOnly_UprojectOnly$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isInstalledBuild() && it.getVersion().getMajor() == 4;
    }

    private static final boolean ue4egsOnly_SlnOnly$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isInstalledBuild() && it.getVersion().getMajor() == 4;
    }

    private static final boolean ue4egsOnly_AllPModels$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isInstalledBuild() && it.getVersion().getMajor() == 4;
    }

    private static final boolean ue5egsOnly_UprojectOnly$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isInstalledBuild() && it.getVersion().getMajor() == 5;
    }

    private static final boolean egsOnly_UprojectOnly$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isInstalledBuild();
    }

    private static final boolean ue5Egs_AllPModels$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isInstalledBuild() && it.getVersion().getMajor() == 5;
    }

    private static final boolean ue54Egs_AllPModels$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getVersion().getMajor() == 5 && it.getVersion().getMinor() == 4;
    }

    private static final boolean ue5Only_slnOnly$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getVersion().getMajor() == 5;
    }

    private static final boolean ue5Only_AllPModels$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getVersion().getMajor() == 5;
    }

    private static final boolean ue5SourceOnly_AllPModules$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isInstalledBuild() && it.getVersion().getMajor() == 5;
    }

    private static final boolean ue5SourceOnly_UprojectOnly$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isInstalledBuild() && it.getVersion().getMajor() == 5;
    }

    private static final boolean ue5SourceOnly_SlnOnly$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isInstalledBuild() && it.getVersion().getMajor() == 5;
    }

    private static final boolean ue5EgsOnly_slnOnly$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isInstalledBuild() && it.getVersion().getMajor() == 5;
    }

    private static final boolean specialTestProvider$lambda$0(UnrealEngine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isInstalledBuild() && it.getVersion().getMajor() == 5 && it.getVersion().getMinor() == 1;
    }

    private static final String uniqueDataString$lambda$0(UnrealBase this$0, String baseString, UnrealEngine engine) {
        Intrinsics.checkNotNullParameter((Object)baseString, (String)"baseString");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        CharSequence charSequence = engine.getId();
        return this$0.guidRegex.matches(charSequence) ? baseString + engine.getVersion().getMajor() + "_" + engine.getVersion().getMinor() + "fromSource" : baseString + StringsKt.replace$default((String)engine.getId(), (char)'.', (char)'_', (boolean)false, (int)4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/test/unreal/UnrealBase$BackupRestoreProfile;", "", "<init>", "()V", "ignoreDirs", "", "", "getIgnoreDirs", "()Ljava/util/List;", "intellij.rider.test.framework"})
    public static final class BackupRestoreProfile {
        @NotNull
        private final List<String> ignoreDirs = new ArrayList();

        @NotNull
        public final List<String> getIgnoreDirs() {
            return this.ignoreDirs;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0017\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u000e\u0010\u000bR\u0019\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u0010\u0010\u000bR#\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\t0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\t0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/test/unreal/UnrealBase$UnrealExplorerPaths;", "", "projectName", "", "projectModelType", "Lcom/jetbrains/rider/test/facades/unreal/UnrealProjectModelApiFacade$PMType;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/rider/test/facades/unreal/UnrealProjectModelApiFacade$PMType;)V", "root", "", "getRoot", "()[Ljava/lang/String;", "[Ljava/lang/String;", "project", "getProject", "plugins", "getPlugins", "plugin", "Lkotlin/Function1;", "getPlugin", "()Lkotlin/jvm/functions/Function1;", "module", "getModule", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider.test.framework"})
    @SourceDebugExtension(value={"SMAP\nUnrealBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnrealBase.kt\ncom/jetbrains/rider/test/unreal/UnrealBase$UnrealExplorerPaths\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,750:1\n37#2,2:751\n*S KotlinDebug\n*F\n+ 1 UnrealBase.kt\ncom/jetbrains/rider/test/unreal/UnrealBase$UnrealExplorerPaths\n*L\n390#1:751,2\n*E\n"})
    public static final class UnrealExplorerPaths {
        @NotNull
        private final String projectName;
        @NotNull
        private final UnrealProjectModelApiFacade.PMType projectModelType;
        @NotNull
        private final String[] root;
        @NotNull
        private final String[] project;
        @NotNull
        private final String[] plugins;
        @NotNull
        private final Function1<String, String[]> plugin;
        @NotNull
        private final Function1<String, String[]> module;

        /*
         * WARNING - void declaration
         */
        public UnrealExplorerPaths(@NotNull String projectName, @NotNull UnrealProjectModelApiFacade.PMType projectModelType) {
            void $this$root_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            Intrinsics.checkNotNullParameter((Object)((Object)projectModelType), (String)"projectModelType");
            this.projectName = projectName;
            this.projectModelType = projectModelType;
            Object object = new String[]{this.projectName};
            Object object2 = object = CollectionsKt.mutableListOf((Object[])object);
            UnrealExplorerPaths unrealExplorerPaths = this;
            boolean bl = false;
            if (this.projectModelType == UnrealProjectModelApiFacade.PMType.Sln) {
                $this$root_u24lambda_u240.add("Games");
            }
            $this$root_u24lambda_u240.add(this.projectName);
            Collection $this$toTypedArray$iv = (Collection)object;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            unrealExplorerPaths.root = thisCollection$iv.toArray(new String[0]);
            this.project = (String[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])this.root, (Object)"Source"), (Object)this.projectName);
            this.plugins = (String[])ArraysKt.plus((Object[])this.root, (Object)"Plugins");
            this.plugin = arg_0 -> UnrealExplorerPaths.plugin$lambda$0(this, arg_0);
            this.module = arg_0 -> UnrealExplorerPaths.module$lambda$0(this, arg_0);
        }

        @NotNull
        public final String[] getRoot() {
            return this.root;
        }

        @NotNull
        public final String[] getProject() {
            return this.project;
        }

        @NotNull
        public final String[] getPlugins() {
            return this.plugins;
        }

        @NotNull
        public final Function1<String, String[]> getPlugin() {
            return this.plugin;
        }

        @NotNull
        public final Function1<String, String[]> getModule() {
            return this.module;
        }

        private final String component1() {
            return this.projectName;
        }

        private final UnrealProjectModelApiFacade.PMType component2() {
            return this.projectModelType;
        }

        @NotNull
        public final UnrealExplorerPaths copy(@NotNull String projectName, @NotNull UnrealProjectModelApiFacade.PMType projectModelType) {
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            Intrinsics.checkNotNullParameter((Object)((Object)projectModelType), (String)"projectModelType");
            return new UnrealExplorerPaths(projectName, projectModelType);
        }

        public static /* synthetic */ UnrealExplorerPaths copy$default(UnrealExplorerPaths unrealExplorerPaths, String string, UnrealProjectModelApiFacade.PMType pMType, int n, Object object) {
            if ((n & 1) != 0) {
                string = unrealExplorerPaths.projectName;
            }
            if ((n & 2) != 0) {
                pMType = unrealExplorerPaths.projectModelType;
            }
            return unrealExplorerPaths.copy(string, pMType);
        }

        @NotNull
        public String toString() {
            return "UnrealExplorerPaths(projectName=" + this.projectName + ", projectModelType=" + this.projectModelType + ")";
        }

        public int hashCode() {
            int result2 = this.projectName.hashCode();
            result2 = result2 * 31 + this.projectModelType.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UnrealExplorerPaths)) {
                return false;
            }
            UnrealExplorerPaths unrealExplorerPaths = (UnrealExplorerPaths)other;
            if (!Intrinsics.areEqual((Object)this.projectName, (Object)unrealExplorerPaths.projectName)) {
                return false;
            }
            return this.projectModelType == unrealExplorerPaths.projectModelType;
        }

        private static final String[] plugin$lambda$0(UnrealExplorerPaths this$0, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (String[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])this$0.plugins, (Object)it), (Object)"Source"), (Object)it);
        }

        private static final String[] module$lambda$0(UnrealExplorerPaths this$0, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (String[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])this$0.root, (Object)"Source"), (Object)it);
        }
    }
}

