/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.unreal;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rd.ide.model.UnrealEngine;
import com.jetbrains.rd.ide.model.UnrealVersion;
import com.jetbrains.rider.test.facades.unreal.UnrealProjectModelApiFacade;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_UnrealKt;
import com.jetbrains.rider.test.unreal.UnrealTestingEngineList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0012\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\r\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/test/unreal/UnrealConstants;", "", "<init>", "()V", "unrealPreviousMajor", "Lcom/jetbrains/rd/ide/model/UnrealVersion;", "getUnrealPreviousMajor", "()Lcom/jetbrains/rd/ide/model/UnrealVersion;", "unrealPrevious", "getUnrealPrevious", "unrealLatest", "getUnrealLatest", "testingVersions", "", "getTestingVersions", "()[Lcom/jetbrains/rd/ide/model/UnrealVersion;", "testingVersions$delegate", "Lkotlin/Lazy;", "getLastTestingEngineVersion", "getLastTestingEngine", "Lcom/jetbrains/rd/ide/model/UnrealEngine;", "projectModelTypes", "Lcom/jetbrains/rider/test/facades/unreal/UnrealProjectModelApiFacade$PMType;", "getProjectModelTypes", "()[Lcom/jetbrains/rider/test/facades/unreal/UnrealProjectModelApiFacade$PMType;", "[Lcom/jetbrains/rider/test/facades/unreal/UnrealProjectModelApiFacade$PMType;", "UnrealConfigurations", "UnrealPlatform", "intellij.rider.test.framework"})
public final class UnrealConstants {
    @NotNull
    public static final UnrealConstants INSTANCE = new UnrealConstants();
    @NotNull
    private static final UnrealVersion unrealPreviousMajor = new UnrealVersion(4, 27, 2);
    @NotNull
    private static final UnrealVersion unrealPrevious = new UnrealVersion(5, 5, 4);
    @NotNull
    private static final UnrealVersion unrealLatest = new UnrealVersion(5, 6, 1);
    @NotNull
    private static final Lazy testingVersions$delegate = LazyKt.lazy(UnrealConstants::testingVersions_delegate$lambda$0);
    @NotNull
    private static final UnrealProjectModelApiFacade.PMType[] projectModelTypes;

    private UnrealConstants() {
    }

    @NotNull
    public final UnrealVersion getUnrealPreviousMajor() {
        return unrealPreviousMajor;
    }

    @NotNull
    public final UnrealVersion getUnrealPrevious() {
        return unrealPrevious;
    }

    @NotNull
    public final UnrealVersion getUnrealLatest() {
        return unrealLatest;
    }

    @NotNull
    public final UnrealVersion[] getTestingVersions() {
        Lazy lazy = testingVersions$delegate;
        return (UnrealVersion[])lazy.getValue();
    }

    @NotNull
    public final UnrealVersion getLastTestingEngineVersion() {
        Object object = ArraysKt.maxWithOrNull((Object[])this.getTestingVersions(), UnrealConstants::getLastTestingEngineVersion$lambda$0);
        Intrinsics.checkNotNull((Object)object);
        return (UnrealVersion)object;
    }

    @NotNull
    public final UnrealEngine getLastTestingEngine() {
        Object object = CollectionsKt.maxWithOrNull((Iterable)UnrealTestingEngineList.INSTANCE.getTestingEngines(), UnrealConstants::getLastTestingEngine$lambda$0);
        Intrinsics.checkNotNull((Object)object);
        return (UnrealEngine)object;
    }

    @NotNull
    public final UnrealProjectModelApiFacade.PMType[] getProjectModelTypes() {
        return projectModelTypes;
    }

    private static final UnrealVersion[] testingVersions_delegate$lambda$0() {
        if (SystemInfo.isMac) {
            UnrealVersion[] unrealVersionArray = new UnrealVersion[2];
            unrealVersionArray[0] = unrealPrevious;
            unrealVersionArray[1] = unrealLatest;
            return unrealVersionArray;
        }
        UnrealVersion[] unrealVersionArray = new UnrealVersion[3];
        unrealVersionArray[0] = unrealPreviousMajor;
        unrealVersionArray[1] = unrealPrevious;
        unrealVersionArray[2] = unrealLatest;
        return unrealVersionArray;
    }

    private static final int getLastTestingEngineVersion$lambda$0(UnrealVersion a, UnrealVersion b) {
        Intrinsics.checkNotNull((Object)a);
        Intrinsics.checkNotNull((Object)b);
        return ScriptingAPI_UnrealKt.compareTo(a, b);
    }

    private static final int getLastTestingEngine$lambda$0(UnrealEngine a, UnrealEngine b) {
        return ScriptingAPI_UnrealKt.compareTo(a.getVersion(), b.getVersion());
    }

    static {
        UnrealProjectModelApiFacade.PMType[] pMTypeArray = new UnrealProjectModelApiFacade.PMType[]{UnrealProjectModelApiFacade.PMType.Sln, UnrealProjectModelApiFacade.PMType.Uproject};
        projectModelTypes = pMTypeArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/test/unreal/UnrealConstants$UnrealConfigurations;", "", "fullName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getFullName", "()Ljava/lang/String;", "DebugGameEditor", "DevelopmentEditor", "DebugGameGame", "intellij.rider.test.framework"})
    public static final class UnrealConfigurations
    extends Enum<UnrealConfigurations> {
        @NotNull
        private final String fullName;
        public static final /* enum */ UnrealConfigurations DebugGameEditor = new UnrealConfigurations("DebugGame Editor");
        public static final /* enum */ UnrealConfigurations DevelopmentEditor = new UnrealConfigurations("Development Editor");
        public static final /* enum */ UnrealConfigurations DebugGameGame = new UnrealConfigurations("DebugGame Game");
        private static final /* synthetic */ UnrealConfigurations[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private UnrealConfigurations(String fullName) {
            this.fullName = fullName;
        }

        @NotNull
        public final String getFullName() {
            return this.fullName;
        }

        public static UnrealConfigurations[] values() {
            return (UnrealConfigurations[])$VALUES.clone();
        }

        public static UnrealConfigurations valueOf(String value) {
            return Enum.valueOf(UnrealConfigurations.class, value);
        }

        @NotNull
        public static EnumEntries<UnrealConfigurations> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = unrealConfigurationsArray = new UnrealConfigurations[]{UnrealConfigurations.DebugGameEditor, UnrealConfigurations.DevelopmentEditor, UnrealConfigurations.DebugGameGame};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/test/unreal/UnrealConstants$UnrealPlatform;", "", "fullName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getFullName", "()Ljava/lang/String;", "Win64", "Mac", "Linux", "Playstation", "Companion", "intellij.rider.test.framework"})
    public static final class UnrealPlatform
    extends Enum<UnrealPlatform> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String fullName;
        public static final /* enum */ UnrealPlatform Win64;
        public static final /* enum */ UnrealPlatform Mac;
        public static final /* enum */ UnrealPlatform Linux;
        public static final /* enum */ UnrealPlatform Playstation;
        private static final /* synthetic */ UnrealPlatform[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private UnrealPlatform(String fullName) {
            this.fullName = fullName;
        }

        @NotNull
        public final String getFullName() {
            return this.fullName;
        }

        public static UnrealPlatform[] values() {
            return (UnrealPlatform[])$VALUES.clone();
        }

        public static UnrealPlatform valueOf(String value) {
            return Enum.valueOf(UnrealPlatform.class, value);
        }

        @NotNull
        public static EnumEntries<UnrealPlatform> getEntries() {
            return $ENTRIES;
        }

        static {
            Win64 = new UnrealPlatform("Win64");
            Mac = new UnrealPlatform("Mac");
            Linux = new UnrealPlatform("Linux");
            Playstation = new UnrealPlatform("PS");
            $VALUES = unrealPlatformArray = new UnrealPlatform[]{UnrealPlatform.Win64, UnrealPlatform.Mac, UnrealPlatform.Linux, UnrealPlatform.Playstation};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/test/unreal/UnrealConstants$UnrealPlatform$Companion;", "", "<init>", "()V", "currentPlatform", "Lcom/jetbrains/rider/test/unreal/UnrealConstants$UnrealPlatform;", "getCurrentPlatform", "()Lcom/jetbrains/rider/test/unreal/UnrealConstants$UnrealPlatform;", "intellij.rider.test.framework"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final UnrealPlatform getCurrentPlatform() {
                UnrealPlatform unrealPlatform;
                if (SystemInfo.isWindows) {
                    unrealPlatform = Win64;
                } else if (SystemInfo.isMac) {
                    unrealPlatform = Mac;
                } else if (SystemInfo.isLinux) {
                    unrealPlatform = Linux;
                } else {
                    throw new UnsupportedOperationException("Unknown system");
                }
                return unrealPlatform;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

