/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.unreal;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.UnrealEngine;
import com.jetbrains.rd.ide.model.UnrealShellModel;
import com.jetbrains.rd.ide.model.UnrealShellModel_PregeneratedKt;
import com.jetbrains.rd.ide.model.UnrealVersion;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.framework.TestFrameworkSettings;
import com.jetbrains.rider.test.protocol.TestProtocolExtensionsKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_UnrealKt;
import com.jetbrains.rider.test.unreal.UnrealConstants;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000f\u001a\u00020\u0006J\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0011\u001a\u00020\u0006J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\bR!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/test/unreal/UnrealTestingEngineList;", "", "<init>", "()V", "installedEngineList", "", "Lcom/jetbrains/rd/ide/model/UnrealEngine;", "getInstalledEngineList", "()[Lcom/jetbrains/rd/ide/model/UnrealEngine;", "installedEngineList$delegate", "Lkotlin/Lazy;", "testingEngines", "", "getTestingEngines", "()Ljava/util/List;", "getLatestEngine", "getPreviousEngine", "getPreviousMajorEngine", "findEngine", "version", "Lcom/jetbrains/rd/ide/model/UnrealVersion;", "isInstalledBuild", "", "getInstalledEnginesFromBackend", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nUnrealBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnrealBase.kt\ncom/jetbrains/rider/test/unreal/UnrealTestingEngineList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,750:1\n1#2:751\n3260#3,11:752\n3919#3:765\n4434#3:766\n3919#3:767\n4434#3,2:768\n12970#3,2:780\n4435#3:782\n37#4,2:763\n37#4,2:778\n1563#5:770\n1634#5,2:771\n1563#5:773\n1634#5,3:774\n1636#5:777\n774#5:783\n865#5,2:784\n*S KotlinDebug\n*F\n+ 1 UnrealBase.kt\ncom/jetbrains/rider/test/unreal/UnrealTestingEngineList\n*L\n180#1:752,11\n144#1:765\n144#1:766\n147#1:767\n147#1:768,2\n157#1:780,2\n144#1:782\n125#1:763,2\n152#1:778,2\n149#1:770\n149#1:771,2\n150#1:773\n150#1:774,3\n149#1:777\n160#1:783\n160#1:784,2\n*E\n"})
public final class UnrealTestingEngineList {
    @NotNull
    public static final UnrealTestingEngineList INSTANCE;
    @NotNull
    private static final Lazy installedEngineList$delegate;
    @NotNull
    private static final List<UnrealEngine> testingEngines;

    private UnrealTestingEngineList() {
    }

    @NotNull
    public final UnrealEngine[] getInstalledEngineList() {
        Lazy lazy = installedEngineList$delegate;
        return (UnrealEngine[])lazy.getValue();
    }

    @NotNull
    public final List<UnrealEngine> getTestingEngines() {
        return testingEngines;
    }

    @NotNull
    public final UnrealEngine getLatestEngine() {
        Object v0;
        block2: {
            Iterable iterable = testingEngines;
            for (Object t : iterable) {
                UnrealEngine it = (UnrealEngine)t;
                boolean bl = false;
                if (!ScriptingAPI_UnrealKt.basicallyEquals(it.getVersion(), UnrealConstants.INSTANCE.getUnrealLatest())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        UnrealEngine unrealEngine = v0;
        if (unrealEngine == null) {
            throw new Exception("No engine found. Avaliable engines: " + testingEngines);
        }
        return unrealEngine;
    }

    @NotNull
    public final UnrealEngine getPreviousEngine() {
        Object v0;
        block2: {
            Iterable iterable = testingEngines;
            for (Object t : iterable) {
                UnrealEngine it = (UnrealEngine)t;
                boolean bl = false;
                if (!ScriptingAPI_UnrealKt.basicallyEquals(it.getVersion(), UnrealConstants.INSTANCE.getUnrealPrevious())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        UnrealEngine unrealEngine = v0;
        if (unrealEngine == null) {
            throw new Exception("No engine found. Avaliable engines: " + testingEngines);
        }
        return unrealEngine;
    }

    @NotNull
    public final UnrealEngine getPreviousMajorEngine() {
        Object v0;
        block2: {
            Iterable iterable = testingEngines;
            for (Object t : iterable) {
                UnrealEngine it = (UnrealEngine)t;
                boolean bl = false;
                if (!ScriptingAPI_UnrealKt.basicallyEquals(it.getVersion(), UnrealConstants.INSTANCE.getUnrealPreviousMajor())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        UnrealEngine unrealEngine = v0;
        if (unrealEngine == null) {
            throw new Exception("No engine found. Avaliable engines: " + testingEngines);
        }
        return unrealEngine;
    }

    @NotNull
    public final UnrealEngine findEngine(@NotNull UnrealVersion version, boolean isInstalledBuild) {
        UnrealEngine engine;
        block3: {
            UnrealEngine unrealEngine;
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            TestFrameworkBaseKt.getFrameworkLogger().info("Getting engine " + version + " from" + (isInstalledBuild ? "EGS" : "source"));
            UnrealEngine[] $this$singleOrNull$iv = this.getInstalledEngineList();
            boolean $i$f$singleOrNull = false;
            UnrealEngine single$iv = null;
            boolean found$iv = false;
            int n = $this$singleOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                UnrealEngine element$iv;
                UnrealEngine it = element$iv = $this$singleOrNull$iv[i];
                boolean bl = false;
                if (!(ScriptingAPI_UnrealKt.basicallyEquals(it.getVersion(), version) && it.isInstalledBuild() == isInstalledBuild)) continue;
                if (found$iv) {
                    unrealEngine = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            unrealEngine = engine = !found$iv ? null : single$iv;
        }
        if (engine == null) {
            TestFrameworkBaseKt.getFrameworkLogger().error("Engine version " + version + " not found in the list: " + CollectionsKt.joinToString$default((Iterable)testingEngines, null, null, null, (int)0, null, null, (int)63, null));
        }
        UnrealEngine unrealEngine = engine;
        Intrinsics.checkNotNull(unrealEngine);
        return unrealEngine;
    }

    public static /* synthetic */ UnrealEngine findEngine$default(UnrealTestingEngineList unrealTestingEngineList, UnrealVersion unrealVersion, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return unrealTestingEngineList.findEngine(unrealVersion, bl);
    }

    private final UnrealEngine[] getInstalledEnginesFromBackend() {
        return (UnrealEngine[])CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super UnrealEngine[]>, Object>(null){
            int label;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TimeoutKt.withTimeout((long)Duration.ofSeconds(30L).toMillis(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super UnrealEngine[]>, Object>(null){
                            Object L$0;
                            int label;

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        UnrealShellModel model = UnrealShellModel_PregeneratedKt.getUnrealShellModel((IProtocol)TestProtocolExtensionsKt.getTestProtocol((Application)ApplicationKt.getApplication()));
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)model);
                                        this.label = 1;
                                        Object object2 = IRdCall.DefaultImpls.startSuspending$default((IRdCall)((IRdCall)model.getGetListOfEngines()), (Object)Unit.INSTANCE, null, (Continuation)((Continuation)this), (int)2, null);
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        UnrealShellModel model = (UnrealShellModel)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super UnrealEngine[]> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super UnrealEngine[]> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final UnrealEngine[] installedEngineList_delegate$lambda$0() {
        Collection $this$toTypedArray$iv = ScriptingAPI_UnrealKt.getInstalledEnginesFromFrontend();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new UnrealEngine[0]);
    }

    private static final int testingEngines$lambda$0$1(UnrealEngine v1, UnrealEngine v2) {
        return ScriptingAPI_UnrealKt.compareTo(v1.getVersion(), v2.getVersion());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        Object $this$filterTo$iv$iv;
        INSTANCE = new UnrealTestingEngineList();
        installedEngineList$delegate = LazyKt.lazy(UnrealTestingEngineList::installedEngineList_delegate$lambda$0);
        Object $this$filter$iv = INSTANCE.getInstalledEngineList();
        boolean $i$f$filter = false;
        UnrealEngine[] unrealEngineArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            void element$iv$iv;
            block24: {
                UnrealVersion[] versions;
                UnrealVersion[] unrealVersionArray;
                void eng = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl2 = false;
                if (!((Collection)TestFrameworkSettings.Unreal.INSTANCE.getEngineVersionList()).isEmpty()) {
                    if (TestFrameworkSettings.Unreal.INSTANCE.getEngineVersionList().contains("latest")) {
                        void $this$filterTo$iv$iv2;
                        void $this$filter$iv2;
                        UnrealVersion[] unrealVersionArray2 = new UnrealVersion[1];
                        UnrealEngine[] unrealEngineArray2 = INSTANCE.getInstalledEngineList();
                        int n2 = 0;
                        var13_18 = unrealVersionArray2;
                        boolean $i$f$filter2 = false;
                        void var15_22 = $this$filter$iv2;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo2 = false;
                        int n3 = ((void)$this$filterTo$iv$iv2).length;
                        for (int j = 0; j < n3; ++j) {
                            void element$iv$iv2;
                            void it = element$iv$iv2 = $this$filterTo$iv$iv2[j];
                            boolean bl3 = false;
                            if (!it.isInstalledBuild()) continue;
                            destination$iv$iv2.add(element$iv$iv2);
                        }
                        List list = (List)destination$iv$iv2;
                        Object object = CollectionsKt.maxWithOrNull((Iterable)list, UnrealTestingEngineList::testingEngines$lambda$0$1);
                        Intrinsics.checkNotNull((Object)object);
                        var13_18[n2] = ((UnrealEngine)object).getVersion();
                        unrealVersionArray = unrealVersionArray2;
                    } else {
                        void $this$toTypedArray$iv;
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = TestFrameworkSettings.Unreal.INSTANCE.getEngineVersionList();
                        boolean $i$f$map = false;
                        Iterable $i$f$filter2 = $this$map$iv;
                        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void $this$mapTo$iv$iv2;
                            void version;
                            String string = (String)item$iv$iv;
                            var13_18 = destination$iv$iv3;
                            boolean bl4 = false;
                            char[] it = new char[]{'.'};
                            Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)((CharSequence)version), (char[])it, (boolean)false, (int)0, (int)6, null);
                            boolean $i$f$map2 = false;
                            Iterable iterable = $this$map$iv2;
                            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            boolean $i$f$mapTo2 = false;
                            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                                void p0;
                                String string2 = (String)item$iv$iv2;
                                Collection collection = destination$iv$iv4;
                                boolean bl5 = false;
                                collection.add(Integer.parseInt((String)p0));
                            }
                            List list = (List)destination$iv$iv4;
                            int major = ((Number)list.get(0)).intValue();
                            int minor = ((Number)list.get(1)).intValue();
                            var13_18.add(new UnrealVersion(major, minor, 0));
                        }
                        $this$map$iv = (List)destination$iv$iv3;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        unrealVersionArray = thisCollection$iv.toArray(new UnrealVersion[0]);
                    }
                } else {
                    unrealVersionArray = UnrealConstants.INSTANCE.getTestingVersions();
                }
                UnrealVersion[] $this$any$iv = versions = unrealVersionArray;
                boolean $i$f$any = false;
                int n4 = $this$any$iv.length;
                for (int j = 0; j < n4; ++j) {
                    UnrealVersion element$iv;
                    UnrealVersion it = element$iv = $this$any$iv[j];
                    boolean bl6 = false;
                    if (!ScriptingAPI_UnrealKt.basicallyEquals(it, eng.getVersion())) continue;
                    bl = true;
                    break block24;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object element$iv$iv = iterator.next();
            UnrealEngine it = (UnrealEngine)element$iv$iv;
            boolean bl7 = false;
            switch (TestFrameworkSettings.Unreal.INSTANCE.getEngineType()) {
                case "egs": {
                    bl = it.isInstalledBuild();
                    break;
                }
                case "source": {
                    if (!it.isInstalledBuild()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case "all": {
                    bl = true;
                    break;
                }
                default: {
                    bl = it.isInstalledBuild();
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        testingEngines = (List)var3_3;
    }
}

