/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.jba.auth;

import com.intellij.CommonBundle;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.settingsSync.core.communicator.SettingsSyncUserData;
import com.intellij.settingsSync.jba.SettingsSyncJbaBundle;
import com.intellij.settingsSync.jba.auth.JBAAuthService;
import com.intellij.settingsSync.jba.auth.JBAAuthServiceKt;
import com.intellij.ui.JBAccountInfoService;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JProgressBar;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0003H\u0014J\u0017\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00170\u0016H\u0014\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/settingsSync/jba/auth/LogInProgressDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "parent", "Ljavax/swing/JComponent;", "accountInfoService", "Lcom/intellij/ui/JBAccountInfoService;", "loginMetadata", "", "", "continuation", "Lkotlinx/coroutines/CancellableContinuation;", "Lcom/intellij/settingsSync/core/communicator/SettingsSyncUserData;", "<init>", "(Ljavax/swing/JComponent;Lcom/intellij/ui/JBAccountInfoService;Ljava/util/Map;Lkotlinx/coroutines/CancellableContinuation;)V", "loginSession", "Lcom/intellij/ui/JBAccountInfoService$LoginSession;", "startLoginSession", "", "isProgressDialog", "", "createCenterPanel", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "intellij.settingsSync"})
final class LogInProgressDialog
extends DialogWrapper {
    @NotNull
    private final JBAccountInfoService accountInfoService;
    @NotNull
    private final Map<String, String> loginMetadata;
    @NotNull
    private final CancellableContinuation<SettingsSyncUserData> continuation;
    @Nullable
    private JBAccountInfoService.LoginSession loginSession;

    public LogInProgressDialog(@NotNull JComponent parent, @NotNull JBAccountInfoService accountInfoService, @NotNull Map<String, String> loginMetadata, @NotNull CancellableContinuation<? super SettingsSyncUserData> continuation) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)accountInfoService, (String)"accountInfoService");
        Intrinsics.checkNotNullParameter(loginMetadata, (String)"loginMetadata");
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        super((Component)parent, false);
        this.accountInfoService = accountInfoService;
        this.loginMetadata = loginMetadata;
        this.continuation = continuation;
        this.setTitle(SettingsSyncJbaBundle.INSTANCE.message("login.title", new Object[0]));
        this.init();
        this.getRootPane().setWindowDecorationStyle(1);
        this.startLoginSession();
    }

    private final void startLoginSession() {
        try {
            JBAccountInfoService.LoginSession loginSession = this.loginSession = this.accountInfoService.startLoginSession(JBAccountInfoService.LoginMode.AUTO, null, this.loginMetadata);
            Intrinsics.checkNotNull((Object)loginSession);
            ((CompletableFuture)loginSession.onCompleted().exceptionally(arg_0 -> LogInProgressDialog.startLoginSession$lambda$0(this, arg_0))).thenApply(arg_0 -> LogInProgressDialog.startLoginSession$lambda$2(arg_0 -> LogInProgressDialog.startLoginSession$lambda$1(this, arg_0), arg_0));
        }
        catch (Throwable e) {
            JBAAuthServiceKt.access$getLOG$p().error(e);
            ((Continuation)this.continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e)));
            EventQueue.invokeLater(() -> LogInProgressDialog.startLoginSession$lambda$3(this));
        }
    }

    protected boolean isProgressDialog() {
        return true;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel panel = BuilderKt.panel(arg_0 -> LogInProgressDialog.createCenterPanel$lambda$0(this, arg_0));
        return (JComponent)panel;
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[0];
    }

    private static final JBAccountInfoService.LoginResult startLoginSession$lambda$0(LogInProgressDialog this$0, Throwable exc) {
        if (exc.getCause() instanceof CancellationException || exc instanceof CancellationException) {
            JBAAuthServiceKt.access$getLOG$p().warn("Login cancelled");
        } else {
            JBAAuthServiceKt.access$getLOG$p().warn("Login failed", exc);
        }
        ((Continuation)this$0.continuation).resumeWith(Result.constructor-impl(null));
        EventQueue.invokeLater(() -> LogInProgressDialog.startLoginSession$lambda$0$0(this$0));
        return null;
    }

    private static final void startLoginSession$lambda$0$0(LogInProgressDialog this$0) {
        this$0.close(1);
    }

    private static final Unit startLoginSession$lambda$1(LogInProgressDialog this$0, JBAccountInfoService.LoginResult loginResult) {
        SettingsSyncUserData settingsSyncUserData;
        JBAccountInfoService.LoginResult loginResult2 = loginResult;
        if (loginResult2 instanceof JBAccountInfoService.LoginResult.LoginSuccessful) {
            settingsSyncUserData = JBAAuthService.Companion.fromJBAData(((JBAccountInfoService.LoginResult.LoginSuccessful)loginResult).jbaUser());
        } else if (loginResult2 instanceof JBAccountInfoService.LoginResult.LoginFailed) {
            JBAAuthServiceKt.access$getLOG$p().warn("Login failed: " + ((JBAccountInfoService.LoginResult.LoginFailed)loginResult).errorMessage());
            settingsSyncUserData = null;
        } else {
            JBAAuthServiceKt.access$getLOG$p().warn("Unknown login result: " + loginResult);
            settingsSyncUserData = null;
        }
        SettingsSyncUserData result = settingsSyncUserData;
        ((Continuation)this$0.continuation).resumeWith(Result.constructor-impl((Object)result));
        EventQueue.invokeLater(() -> LogInProgressDialog.startLoginSession$lambda$1$0(this$0));
        return Unit.INSTANCE;
    }

    private static final void startLoginSession$lambda$1$0(LogInProgressDialog this$0) {
        this$0.close(0);
    }

    private static final Unit startLoginSession$lambda$2(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final void startLoginSession$lambda$3(LogInProgressDialog this$0) {
        this$0.close(1);
    }

    private static final Unit createCenterPanel$lambda$0(LogInProgressDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LogInProgressDialog.createCenterPanel$lambda$0$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LogInProgressDialog.createCenterPanel$lambda$0$1(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(LogInProgressDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JProgressBar progressBar = new JProgressBar();
        $this$row.cell((JComponent)progressBar).resizableColumn().applyToComponent(LogInProgressDialog::createCenterPanel$lambda$0$0$0).customize(UnscaledGapsKt.UnscaledGaps((int)0, (int)0, (int)0, (int)10));
        progressBar.setPreferredSize(new Dimension(SystemInfoRt.isMac ? 350 : JBUIScale.scale((int)450), 4));
        String string = CommonBundle.getCancelButtonText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCancelButtonText(...)");
        $this$row.button(string, arg_0 -> LogInProgressDialog.createCenterPanel$lambda$0$0$1(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$0(JProgressBar $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setIndeterminate(true);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$1(LogInProgressDialog this$0, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            JBAccountInfoService.LoginSession loginSession = this$0.loginSession;
            if (loginSession == null) break block0;
            loginSession.close();
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(LogInProgressDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)SettingsSyncJbaBundle.INSTANCE.message("login.troubles.message", new Object[0]), (int)0, null, (int)6, null).applyToComponent(arg_0 -> LogInProgressDialog.createCenterPanel$lambda$0$1$0(this$0, arg_0)).align((Align)AlignY.TOP.INSTANCE).customize(UnscaledGapsKt.UnscaledGaps((int)0, (int)0, (int)0, (int)10));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1$0(LogInProgressDialog this$0, JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addHyperlinkListener(arg_0 -> LogInProgressDialog.createCenterPanel$lambda$0$1$0$0(this$0, arg_0));
        if (SystemInfoRt.isMac) {
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)$this$applyToComponent);
        }
        return Unit.INSTANCE;
    }

    private static final void createCenterPanel$lambda$0$1$0$0(LogInProgressDialog this$0, HyperlinkEvent it) {
        block1: {
            if (!Intrinsics.areEqual((Object)it.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) break block1;
            Container container = this$0.getContentPane();
            Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getContentPane(...)");
            JBAAuthService.Companion.showManageLicensesDialog(container);
            JBAccountInfoService.LoginSession loginSession = this$0.loginSession;
            if (loginSession != null) {
                loginSession.close();
            }
        }
    }
}

