/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.colors.impl.AppFontOptions;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.openapi.util.Disposer;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalColumnSpacing;
import org.jetbrains.plugins.terminal.TerminalFontSettings;
import org.jetbrains.plugins.terminal.TerminalFontSettingsListener;
import org.jetbrains.plugins.terminal.TerminalFontSettingsServiceKt;
import org.jetbrains.plugins.terminal.TerminalFontSettingsState;
import org.jetbrains.plugins.terminal.TerminalLineSpacing;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;

@State(name="TerminalFontOptions", storages={@Storage(value="terminal-font.xml")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0001J\u0015\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0017H\u0014J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\b\u0010\u001c\u001a\u00020\rH\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0002J\b\u0010!\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalFontSettingsService;", "Lcom/intellij/openapi/editor/colors/impl/AppFontOptions;", "Lorg/jetbrains/plugins/terminal/TerminalFontSettingsState;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lorg/jetbrains/plugins/terminal/TerminalFontSettingsListener;", "columnSpacing", "Lorg/jetbrains/plugins/terminal/TerminalColumnSpacing;", "addListener", "", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "getSettings", "Lorg/jetbrains/plugins/terminal/TerminalFontSettings;", "setSettings", "settings", "setSettings$intellij_terminal", "getFontPreferences", "Lcom/intellij/openapi/editor/colors/FontPreferences;", "createFontState", "fontPreferences", "loadState", "state", "noStateLoaded", "getConsoleFontPreferences", "resetNonMonospacedFontsOnce", "", "storedState", "fireListeners", "Companion", "intellij.terminal"})
@ApiStatus.Internal
public final class TerminalFontSettingsService
extends AppFontOptions<TerminalFontSettingsState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CopyOnWriteArrayList<TerminalFontSettingsListener> listeners;
    @NotNull
    private TerminalColumnSpacing columnSpacing;
    @NotNull
    public static final String COMPONENT_NAME = "TerminalFontOptions";

    public TerminalFontSettingsService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.listeners = new CopyOnWriteArrayList();
        this.columnSpacing = TerminalFontSettingsServiceKt.getDEFAULT_TERMINAL_COLUMN_SPACING();
    }

    public final void addListener(@NotNull TerminalFontSettingsListener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.listeners.add(listener2);
        Disposer.register((Disposable)disposable, () -> TerminalFontSettingsService.addListener$lambda$0(this, listener2));
    }

    @ApiStatus.Internal
    @JvmName(name="getSettings")
    @NotNull
    public final TerminalFontSettings getSettings() {
        return new TerminalFontSettings(this.getFontPreferences(), this.columnSpacing);
    }

    public final void setSettings$intellij_terminal(@NotNull TerminalFontSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        TerminalFontSettings oldSettings = this.getSettings();
        FontPreferencesImpl newPreferences = new FontPreferencesImpl();
        this.getConsoleFontPreferences().copyTo((FontPreferences)newPreferences);
        settings.copyTo(newPreferences);
        this.columnSpacing = settings.getColumnSpacing();
        this.update((FontPreferences)newPreferences);
        if (!Intrinsics.areEqual((Object)settings, (Object)oldSettings)) {
            this.fireListeners();
        }
    }

    @NotNull
    public FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = super.getFontPreferences();
        Intrinsics.checkNotNullExpressionValue((Object)fontPreferences, (String)"getFontPreferences(...)");
        FontPreferences result = fontPreferences;
        if (result.getEffectiveFontFamilies().size() == 1 && !Intrinsics.areEqual((Object)result.getFontFamily(), (Object)FontPreferences.DEFAULT_FONT_NAME)) {
            ((FontPreferencesImpl)result).register(FontPreferences.DEFAULT_FONT_NAME, ((FontPreferencesImpl)result).getSize2D(((FontPreferencesImpl)result).getFontFamily()));
        }
        return result;
    }

    @NotNull
    protected TerminalFontSettingsState createFontState(@NotNull FontPreferences fontPreferences) {
        TerminalFontSettingsState terminalFontSettingsState;
        Intrinsics.checkNotNullParameter((Object)fontPreferences, (String)"fontPreferences");
        TerminalFontSettingsState it = terminalFontSettingsState = new TerminalFontSettingsState(fontPreferences);
        boolean bl = false;
        it.setCOLUMN_SPACING(this.columnSpacing.getFloatValue());
        return terminalFontSettingsState;
    }

    public void loadState(@NotNull TerminalFontSettingsState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.columnSpacing = TerminalColumnSpacing.Companion.ofFloat(state.getCOLUMN_SPACING());
        if (!this.resetNonMonospacedFontsOnce(state)) {
            super.loadState((AppEditorFontOptions.PersistentFontPreferences)state);
        }
        this.fireListeners();
    }

    public void noStateLoaded() {
        TerminalLineSpacing defaultConsoleLineSpacing;
        FontPreferences consolePreferences = this.getConsoleFontPreferences();
        TerminalFontSettingsState defaultState = new TerminalFontSettingsState(consolePreferences);
        TerminalLineSpacing userSetConsoleLineSpacing = TerminalLineSpacing.Companion.ofFloat(defaultState.LINE_SPACING);
        if (Intrinsics.areEqual((Object)userSetConsoleLineSpacing, (Object)(defaultConsoleLineSpacing = TerminalLineSpacing.Companion.ofFloat(1.2f)))) {
            defaultState.LINE_SPACING = TerminalFontSettingsServiceKt.getDEFAULT_TERMINAL_LINE_SPACING().getFloatValue();
        }
        this.loadState(defaultState);
    }

    private final FontPreferences getConsoleFontPreferences() {
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme editorColorsScheme = colorsManager.getActiveVisibleScheme();
        if (editorColorsScheme == null) {
            EditorColorsScheme editorColorsScheme2 = colorsManager.getDefaultScheme();
            editorColorsScheme = editorColorsScheme2;
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme2, (String)"getDefaultScheme(...)");
        }
        EditorColorsScheme currentScheme = editorColorsScheme;
        FontPreferences fontPreferences = currentScheme.getConsoleFontPreferences();
        Intrinsics.checkNotNullExpressionValue((Object)fontPreferences, (String)"getConsoleFontPreferences(...)");
        return fontPreferences;
    }

    public final boolean resetNonMonospacedFontsOnce(@NotNull TerminalFontSettingsState storedState) {
        Intrinsics.checkNotNullParameter((Object)((Object)storedState), (String)"storedState");
        return RunOnceUtil.runOnceForApp((String)"TerminalFontSettingsService.fixStoredNonMonospacedFonts", () -> TerminalFontSettingsService.resetNonMonospacedFontsOnce$lambda$0(this, storedState));
    }

    private final void fireListeners() {
        Iterator<TerminalFontSettingsListener> iterator = this.listeners.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<TerminalFontSettingsListener> iterator2 = iterator;
        while (iterator2.hasNext()) {
            TerminalFontSettingsListener listener2 = iterator2.next();
            listener2.fontSettingsChanged();
        }
    }

    private static final void addListener$lambda$0(TerminalFontSettingsService this$0, TerminalFontSettingsListener $listener) {
        this$0.listeners.remove($listener);
    }

    private static final void resetNonMonospacedFontsOnce$lambda$0(TerminalFontSettingsService this$0, TerminalFontSettingsState $storedState) {
        TerminalUiUtilsKt.updateFrontendSettingsAndSync(this$0.coroutineScope, (Function0<Unit>)((Function0)() -> TerminalFontSettingsService.resetNonMonospacedFontsOnce$lambda$0$0($storedState, this$0)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit resetNonMonospacedFontsOnce$lambda$0$0(TerminalFontSettingsState $storedState, TerminalFontSettingsService this$0) {
        TerminalFontSettingsState terminalFontSettingsState;
        if (!FontFamilyService.isMonospaced((String)$storedState.FONT_FAMILY)) {
            void var3_2;
            TerminalFontSettingsState newState = new TerminalFontSettingsState(this$0.getConsoleFontPreferences());
            newState.FONT_SIZE_2D = $storedState.FONT_SIZE_2D;
            newState.LINE_SPACING = $storedState.LINE_SPACING;
            terminalFontSettingsState = var3_2;
        } else {
            terminalFontSettingsState = $storedState;
        }
        TerminalFontSettingsState adjustedState = terminalFontSettingsState;
        super.loadState((AppEditorFontOptions.PersistentFontPreferences)adjustedState);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final TerminalFontSettingsService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalFontSettingsService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/plugins/terminal/TerminalFontSettingsService;", "COMPONENT_NAME", "", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalFontSettingsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalFontSettingsService.kt\norg/jetbrains/plugins/terminal/TerminalFontSettingsService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,326:1\n42#2,3:327\n*S KotlinDebug\n*F\n+ 1 TerminalFontSettingsService.kt\norg/jetbrains/plugins/terminal/TerminalFontSettingsService$Companion\n*L\n32#1:327,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TerminalFontSettingsService getInstance() {
            boolean $i$f$service = false;
            Class<TerminalFontSettingsService> serviceClass$iv = TerminalFontSettingsService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (TerminalFontSettingsService)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

