/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.collect.Sets;
import com.intellij.ide.DataManager;
import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.TerminalTitleListener;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.terminal.ui.TerminalWidgetKt;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.swing.JComponent;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.DefaultTerminalRunnerFactory;
import org.jetbrains.plugins.terminal.LocalBlockTerminalRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalEngine;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalStartupMoment;
import org.jetbrains.plugins.terminal.TerminalTabCloseListener;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalToolWindowPanel;
import org.jetbrains.plugins.terminal.action.MoveTerminalToolWindowTabLeftAction;
import org.jetbrains.plugins.terminal.action.MoveTerminalToolWindowTabRightAction;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementState;
import org.jetbrains.plugins.terminal.arrangement.TerminalCommandHistoryManager;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;
import org.jetbrains.plugins.terminal.classic.ClassicTerminalTabCloseListener;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;
import org.jetbrains.plugins.terminal.ui.TerminalContainer;

@Service(value={Service.Level.PROJECT})
public final class TerminalToolWindowManager
implements Disposable {
    private static final Key<TerminalWidget> TERMINAL_WIDGET_KEY = new Key("TerminalWidget");
    private static final Logger LOG = Logger.getInstance(TerminalToolWindowManager.class);
    private static final Key<AbstractTerminalRunner<?>> RUNNER_KEY = Key.create((String)"RUNNER_KEY");
    private ToolWindowEx myToolWindow;
    private final Project myProject;
    private final AbstractTerminalRunner<?> myTerminalRunner;
    private final Map<TerminalWidget, TerminalContainer> myContainerByWidgetMap;
    private final List<Consumer<TerminalWidget>> myTerminalSetupHandlers;

    @NotNull
    public AbstractTerminalRunner<?> getTerminalRunner() {
        AbstractTerminalRunner<?> abstractTerminalRunner = this.myTerminalRunner;
        if (abstractTerminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(0);
        }
        return abstractTerminalRunner;
    }

    public ToolWindow getToolWindow() {
        return this.myToolWindow;
    }

    public TerminalToolWindowManager(@NotNull Project project) {
        if (project == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(1);
        }
        this.myContainerByWidgetMap = new HashMap<TerminalWidget, TerminalContainer>();
        this.myTerminalSetupHandlers = new CopyOnWriteArrayList<Consumer<TerminalWidget>>();
        this.myProject = project;
        this.myTerminalRunner = DefaultTerminalRunnerFactory.getInstance().create(project);
    }

    public void dispose() {
    }

    @Deprecated
    @ApiStatus.Internal
    public @Unmodifiable Set<JBTerminalWidget> getWidgets() {
        return ContainerUtil.map2SetNotNull(this.myContainerByWidgetMap.keySet(), widget -> JBTerminalWidget.asJediTermWidget((TerminalWidget)widget));
    }

    @NotNull
    public Set<TerminalWidget> getTerminalWidgets() {
        Set<TerminalWidget> set = Collections.unmodifiableSet(this.myContainerByWidgetMap.keySet());
        if (set == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(2);
        }
        return set;
    }

    public void addNewTerminalSetupHandler(@NotNull Consumer<TerminalWidget> listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(4);
        }
        this.myTerminalSetupHandlers.add(listener2);
        if (!Disposer.tryRegister((Disposable)parentDisposable, () -> this.myTerminalSetupHandlers.remove(listener2))) {
            this.myTerminalSetupHandlers.remove(listener2);
        }
    }

    public static TerminalToolWindowManager getInstance(@NotNull Project project) {
        if (project == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(5);
        }
        return (TerminalToolWindowManager)project.getService(TerminalToolWindowManager.class);
    }

    void initToolWindow(@NotNull ToolWindowEx toolWindow) {
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(6);
        }
        if (this.myToolWindow != null) {
            LOG.error("Terminal tool window already initialized");
            return;
        }
        this.myToolWindow = toolWindow;
    }

    void restoreTabsLocal(@Nullable TerminalArrangementState arrangementState) {
        ContentManager contentManager = this.myToolWindow.getContentManager();
        if (arrangementState != null) {
            for (TerminalTabState tabState : arrangementState.myTabStates) {
                TerminalEngine engine = TerminalOptionsProvider.getInstance().getTerminalEngine();
                this.createNewSession(null, this.myTerminalRunner, engine, tabState, false, true);
            }
            Content content = contentManager.getContent(arrangementState.mySelectedTabIndex);
            if (content != null) {
                contentManager.setSelectedContent(content);
            }
        }
    }

    @NotNull
    public TerminalWidget createNewSession() {
        return this.createNewSession(null, this.myTerminalRunner, TerminalEngine.CLASSIC, null, true, true);
    }

    public void createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner) {
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(7);
        }
        this.createNewSession(null, terminalRunner, TerminalEngine.CLASSIC, null, true, true);
    }

    public void createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner, @Nullable TerminalTabState tabState) {
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(8);
        }
        this.createNewSession(null, terminalRunner, TerminalEngine.CLASSIC, tabState, true, true);
    }

    @ApiStatus.Experimental
    public void createNewSession(@Nullable AbstractTerminalRunner<?> terminalRunner, @Nullable TerminalTabState tabState, @Nullable ContentManager contentManager) {
        AbstractTerminalRunner<?> runner = terminalRunner != null ? terminalRunner : this.myTerminalRunner;
        this.createNewSession(contentManager, runner, TerminalEngine.CLASSIC, tabState, true, true);
    }

    @NotNull
    public TerminalWidget createShellWidget(@Nullable String workingDirectory, @Nullable @Nls String tabName, boolean requestFocus, boolean deferSessionStartUntilUiShown) {
        TerminalWidget terminalWidget = this.createNewSession(workingDirectory, tabName, null, requestFocus, deferSessionStartUntilUiShown);
        if (terminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(9);
        }
        return terminalWidget;
    }

    @NotNull
    public Content newTab(@NotNull ToolWindow toolWindow, @Nullable TerminalWidget terminalWidget) {
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(10);
        }
        Content content = this.createNewTab(null, terminalWidget, this.myTerminalRunner, TerminalEngine.CLASSIC, null, true, true);
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(11);
        }
        return content;
    }

    public void openTerminalIn(@Nullable VirtualFile fileToOpen) {
        TerminalTabState state = new TerminalTabState();
        if (fileToOpen != null) {
            state.myWorkingDirectory = fileToOpen.getPath();
        }
        this.createNewSession(null, this.myTerminalRunner, TerminalEngine.CLASSIC, state, true, true);
    }

    @ApiStatus.Internal
    @NotNull
    public TerminalWidget createNewSession(@Nullable String workingDirectory, @Nullable @Nls String tabName, @Nullable List<String> shellCommand, boolean requestFocus, boolean deferSessionStartUntilUiShown) {
        TerminalTabState tabState = new TerminalTabState();
        tabState.myTabName = tabName;
        tabState.myWorkingDirectory = workingDirectory;
        tabState.myShellCommand = shellCommand;
        return this.createNewSession(null, this.myTerminalRunner, TerminalEngine.CLASSIC, tabState, requestFocus, deferSessionStartUntilUiShown);
    }

    @ApiStatus.Internal
    @NotNull
    public TerminalWidget createNewTab(@NotNull TerminalEngine preferredEngine, @Nullable TerminalTabState tabState, @Nullable ContentManager contentManager) {
        if (preferredEngine == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(12);
        }
        return this.createNewSession(contentManager, this.myTerminalRunner, preferredEngine, tabState, true, true);
    }

    @NotNull
    private TerminalWidget createNewSession(@Nullable ContentManager contentManager, @NotNull AbstractTerminalRunner<?> terminalRunner, @NotNull TerminalEngine preferredEngine, @Nullable TerminalTabState tabState, boolean requestFocus, boolean deferSessionStartUntilUiShown) {
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(13);
        }
        if (preferredEngine == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(14);
        }
        Content content = this.createNewTab(contentManager, null, terminalRunner, preferredEngine, tabState, requestFocus, deferSessionStartUntilUiShown);
        TerminalWidget terminalWidget = Objects.requireNonNull((TerminalWidget)content.getUserData(TERMINAL_WIDGET_KEY));
        if (terminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(15);
        }
        return terminalWidget;
    }

    @NotNull
    private ToolWindow getOrInitToolWindow() {
        ToolWindowEx toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Terminal");
            ((ToolWindow)Objects.requireNonNull(toolWindow)).getContentManager();
            LOG.assertTrue(toolWindow == this.myToolWindow);
        }
        ToolWindowEx toolWindowEx = toolWindow;
        if (toolWindowEx == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(16);
        }
        return toolWindowEx;
    }

    @ApiStatus.Internal
    @NotNull
    public Content createNewTab(@Nullable ContentManager contentManager, @Nullable TerminalWidget terminalWidget, @NotNull AbstractTerminalRunner<?> terminalRunner, @NotNull TerminalEngine preferredEngine, @Nullable TerminalTabState tabState, boolean requestFocus, boolean deferSessionStartUntilUiShown) {
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(17);
        }
        if (preferredEngine == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(18);
        }
        ToolWindow toolWindow = this.getOrInitToolWindow();
        TerminalStartupMoment startupMoment = requestFocus && deferSessionStartUntilUiShown ? new TerminalStartupMoment() : null;
        Content content = this.createTerminalContent(terminalRunner, preferredEngine, terminalWidget, tabState, deferSessionStartUntilUiShown, startupMoment);
        ContentManager manager = contentManager != null ? contentManager : toolWindow.getContentManager();
        manager.addContent(content);
        Runnable selectRunnable = () -> manager.setSelectedContent(content, requestFocus);
        if (requestFocus && !toolWindow.isActive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Activating " + toolWindow.getId() + " tool window");
            }
            toolWindow.activate(selectRunnable, true, true);
        } else {
            selectRunnable.run();
        }
        int tabsCount = toolWindow.getContentManager().getContentsRecursively().size();
        ReworkedTerminalUsageCollector.logTabOpened(this.myProject, tabsCount);
        Content content2 = content;
        if (content2 == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(19);
        }
        return content2;
    }

    @Nls
    private static String generateUniqueName(@Nls String suggestedName, List<@Nls String> tabs) {
        HashSet names = Sets.newHashSet(tabs);
        return UniqueNameGenerator.generateUniqueName((String)suggestedName, (String)"", (String)"", (String)" (", (String)")", o -> !names.contains(o));
    }

    @ApiStatus.Internal
    @NotNull
    public Content createTerminalContent(@NotNull AbstractTerminalRunner<?> terminalRunner, @NotNull TerminalEngine preferredEngine, @Nullable TerminalWidget terminalWidget, @Nullable TerminalTabState tabState, boolean deferSessionStartUntilUiShown, @Nullable TerminalStartupMoment startupMoment) {
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(20);
        }
        if (preferredEngine == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(21);
        }
        ToolWindow toolWindow = this.getOrInitToolWindow();
        TerminalToolWindowPanel panel = new TerminalToolWindowPanel();
        Content content = ContentFactory.getInstance().createContent((JComponent)((Object)panel), null, false);
        TerminalWidget widget = terminalWidget;
        if (widget == null) {
            String currentWorkingDir = terminalRunner.getCurrentWorkingDir(tabState);
            NullableLazyValue commandHistoryFileLazyValue = NullableLazyValue.atomicLazyNullable(() -> TerminalCommandHistoryManager.getInstance().getOrCreateCommandHistoryFile(tabState != null ? tabState.myCommandHistoryFileName : null, this.myProject));
            ShellStartupOptions startupOptions = new ShellStartupOptions.Builder().workingDirectory(currentWorkingDir).shellCommand(tabState != null ? tabState.myShellCommand : null).commandHistoryFileProvider((Function0<? extends Path>)((Function0)() -> (Path)commandHistoryFileLazyValue.getValue())).startupMoment(startupMoment).build();
            widget = this.startShellTerminalWidget(terminalRunner, startupOptions, preferredEngine, deferSessionStartUntilUiShown, (Disposable)content);
            widget.getTerminalTitle().change(state -> {
                if (state.getDefaultTitle() == null) {
                    state.setDefaultTitle(terminalRunner.getDefaultTabTitle());
                }
                return Unit.INSTANCE;
            });
            TerminalWorkingDirectoryManager.setInitialWorkingDirectory(content, currentWorkingDir);
        } else {
            TerminalWidgetKt.setNewParentDisposable((TerminalWidget)terminalWidget, (Disposable)content);
        }
        if (tabState != null && tabState.myTabName != null) {
            widget.getTerminalTitle().change(state -> {
                if (tabState.myIsUserDefinedTabTitle) {
                    state.setUserDefinedTitle(tabState.myTabName);
                } else {
                    state.setDefaultTitle(tabState.myTabName);
                }
                return null;
            });
        }
        TerminalToolWindowManager.updateTabTitle(widget, toolWindow, content);
        this.setupTerminalWidget(toolWindow, terminalRunner, widget, content);
        content.setCloseable(true);
        content.putUserData(TERMINAL_WIDGET_KEY, (Object)widget);
        content.putUserData(RUNNER_KEY, terminalRunner);
        TerminalContainer container = new TerminalContainer(this.myProject, content, widget, this);
        panel.setContent(container.getWrapperPanel());
        panel.addFocusListener(TerminalToolWindowManager.createFocusListener(toolWindow));
        TerminalWidget finalWidget = widget;
        this.myTerminalSetupHandlers.forEach(consumer2 -> consumer2.accept(finalWidget));
        content.setPreferredFocusedComponent(() -> finalWidget.getPreferredFocusableComponent());
        ClassicTerminalTabCloseListener.install(content, this.myProject, (Disposable)content);
        Content content2 = content;
        if (content2 == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(22);
        }
        return content2;
    }

    private void setupTerminalWidget(final @NotNull ToolWindow toolWindow, @NotNull AbstractTerminalRunner<?> runner, final @NotNull TerminalWidget widget, final @NotNull Content content) {
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(23);
        }
        if (runner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(24);
        }
        if (widget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(25);
        }
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(26);
        }
        final MoveTerminalToolWindowTabLeftAction moveTabLeftAction = new MoveTerminalToolWindowTabLeftAction();
        final MoveTerminalToolWindowTabRightAction moveTabRightAction = new MoveTerminalToolWindowTabRightAction();
        widget.getTerminalTitle().addTitleListener(new TerminalTitleListener(){

            public void onTitleChanged(@NotNull TerminalTitle terminalTitle) {
                if (terminalTitle == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> TerminalToolWindowManager.updateTabTitle(widget, toolWindow, content), TerminalToolWindowManager.this.myProject.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminalTitle", "org/jetbrains/plugins/terminal/TerminalToolWindowManager$1", "onTitleChanged"));
            }
        }, (Disposable)content);
        JBTerminalWidget terminalWidget = JBTerminalWidget.asJediTermWidget((TerminalWidget)widget);
        if (terminalWidget == null) {
            return;
        }
        terminalWidget.setListener(new JBTerminalWidgetListener(){

            public void onNewSession() {
                TerminalToolWindowManager.this.createNewSession(content.getManager(), TerminalToolWindowManager.this.myTerminalRunner, TerminalEngine.CLASSIC, null, true, true);
            }

            public void onTerminalStarted() {
            }

            public void onPreviousTabSelected() {
                ContentManager contentManager = content.getManager();
                if (contentManager != null && contentManager.getContentCount() > 1) {
                    contentManager.selectPreviousContent();
                }
            }

            public void onNextTabSelected() {
                ContentManager contentManager = content.getManager();
                if (contentManager != null && contentManager.getContentCount() > 1) {
                    contentManager.selectNextContent();
                }
            }

            public void onSessionClosed() {
                TerminalContainer container = TerminalToolWindowManager.this.getContainer(widget);
                if (container != null) {
                    container.closeAndHide();
                }
            }

            public void showTabs() {
                this.performAction("ShowContent");
            }

            public void moveTabRight() {
                moveTabRightAction.move(content, TerminalToolWindowManager.this.myProject);
            }

            public void moveTabLeft() {
                moveTabLeftAction.move(content, TerminalToolWindowManager.this.myProject);
            }

            public boolean canMoveTabRight() {
                return moveTabRightAction.isAvailable(content);
            }

            public boolean canMoveTabLeft() {
                return moveTabLeftAction.isAvailable(content);
            }

            public boolean canSplit(boolean vertically) {
                String actionId = vertically ? "TW.SplitRight" : "TW.SplitDown";
                return this.isActionEnabled(actionId);
            }

            public void split(boolean vertically) {
                String actionId = vertically ? "TW.SplitRight" : "TW.SplitDown";
                this.performAction(actionId);
            }

            public boolean isGotoNextSplitTerminalAvailable() {
                return this.isActionEnabled("TW.MoveToNextSplitter");
            }

            public void gotoNextSplitTerminal(boolean forward) {
                String actionId = forward ? "TW.MoveToNextSplitter" : "TW.MoveToPreviousSplitter";
                this.performAction(actionId);
            }

            private boolean isActionEnabled(@NotNull String actionId) {
                AnAction action;
                if (actionId == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((action = ActionManager.getInstance().getAction(actionId)) == null) {
                    return false;
                }
                AnActionEvent event = this.createActionEvent(action);
                AnActionResult result = ActionUtil.updateAction((AnAction)action, (AnActionEvent)event);
                if (!result.isPerformed()) {
                    return false;
                }
                return event.getPresentation().isEnabled();
            }

            private void performAction(@NotNull String actionId) {
                AnAction action;
                if (actionId == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((action = ActionManager.getInstance().getAction(actionId)) == null) {
                    return;
                }
                AnActionEvent event = this.createActionEvent(action);
                ActionUtil.performAction((AnAction)action, (AnActionEvent)event);
            }

            @NotNull
            private AnActionEvent createActionEvent(@NotNull AnAction action) {
                if (action == null) {
                    2.$$$reportNull$$$0(2);
                }
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)widget.getComponent());
                AnActionEvent anActionEvent = AnActionEvent.createEvent((AnAction)action, (DataContext)dataContext, null, (String)"unknown", (ActionUiKind)ActionUiKind.NONE, null);
                if (anActionEvent == null) {
                    2.$$$reportNull$$$0(3);
                }
                return anActionEvent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "actionId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalToolWindowManager$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalToolWindowManager$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createActionEvent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isActionEnabled";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "performAction";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createActionEvent";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        });
    }

    private static void updateTabTitle(@NotNull TerminalWidget widget, @NotNull ToolWindow toolWindow, @NotNull Content content) {
        if (widget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(27);
        }
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(28);
        }
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(29);
        }
        TerminalTitle title = widget.getTerminalTitle();
        String titleString = title.buildTitle();
        List<String> tabs = toolWindow.getContentManager().getContentsRecursively().stream().filter(c -> c != content).map(c -> c.getDisplayName()).toList();
        String generatedName = TerminalToolWindowManager.generateUniqueName(titleString, tabs);
        content.setDisplayName(generatedName);
        title.change(state -> {
            state.setDefaultTitle(generatedName);
            return Unit.INSTANCE;
        });
    }

    public void register(@NotNull TerminalContainer terminalContainer) {
        if (terminalContainer == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(30);
        }
        this.myContainerByWidgetMap.put(terminalContainer.getTerminalWidget(), terminalContainer);
    }

    public void unregister(@NotNull TerminalContainer terminalContainer) {
        if (terminalContainer == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(31);
        }
        this.myContainerByWidgetMap.remove(terminalContainer.getTerminalWidget());
        if (terminalContainer.getContent().getUserData(TERMINAL_WIDGET_KEY) == terminalContainer.getTerminalWidget()) {
            terminalContainer.getContent().putUserData(TERMINAL_WIDGET_KEY, (Object)this.findWidgetForContent(terminalContainer.getContent()));
        }
    }

    @Nullable
    private TerminalWidget findWidgetForContent(@NotNull Content content) {
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(32);
        }
        TerminalWidget any = null;
        for (Map.Entry<TerminalWidget, TerminalContainer> entry : this.myContainerByWidgetMap.entrySet()) {
            TerminalWidget terminalWidget;
            if (entry.getValue().getContent() != content) continue;
            any = terminalWidget = entry.getKey();
            if (!terminalWidget.hasFocus()) continue;
            return terminalWidget;
        }
        return any;
    }

    @Nullable
    public TerminalContainer getContainer(@NotNull TerminalWidget terminalWidget) {
        if (terminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(33);
        }
        return this.myContainerByWidgetMap.get(terminalWidget);
    }

    public void closeTab(@NotNull Content content) {
        ContentManager manager;
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(34);
        }
        if ((manager = content.getManager()) != null) {
            manager.removeContent(content, true, true, true);
        }
    }

    @NotNull
    private static FocusListener createFocusListener(final @NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(35);
        }
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JComponent component2 = TerminalToolWindowManager.getComponentToFocus(toolWindow);
                if (component2 != null) {
                    component2.requestFocusInWindow();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
    }

    @Nullable
    private static JComponent getComponentToFocus(@NotNull ToolWindow toolWindow) {
        Content selectedContent;
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(36);
        }
        if ((selectedContent = toolWindow.getContentManager().getSelectedContent()) != null) {
            return selectedContent.getPreferredFocusableComponent();
        }
        return toolWindow.getComponent();
    }

    @NotNull
    private TerminalWidget startShellTerminalWidget(@NotNull AbstractTerminalRunner<?> terminalRunner, @NotNull ShellStartupOptions startupOptions, @NotNull TerminalEngine preferredEngine, boolean deferSessionStartUntilUiShown, @NotNull Disposable parentDisposable) {
        TerminalWidget widget;
        boolean isAnyRemoteDev;
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(37);
        }
        if (startupOptions == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(38);
        }
        if (preferredEngine == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(39);
        }
        if (parentDisposable == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(40);
        }
        boolean bl = isAnyRemoteDev = PlatformUtils.isJetBrainsClient() || AppMode.isRemoteDevHost();
        if (preferredEngine == TerminalEngine.NEW_TERMINAL && ExperimentalUI.isNewUI() && terminalRunner == this.myTerminalRunner && !isAnyRemoteDev) {
            LocalBlockTerminalRunner runner = new LocalBlockTerminalRunner(this.myProject);
            widget = runner.startShellTerminalWidget(parentDisposable, startupOptions, deferSessionStartUntilUiShown);
        } else {
            widget = terminalRunner.startShellTerminalWidget(parentDisposable, startupOptions, deferSessionStartUntilUiShown);
        }
        TerminalWidget terminalWidget = widget;
        if (terminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(41);
        }
        return terminalWidget;
    }

    @Nullable
    public static JBTerminalWidget getWidgetByContent(@NotNull Content content) {
        TerminalWidget data;
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(42);
        }
        return (data = (TerminalWidget)content.getUserData(TERMINAL_WIDGET_KEY)) != null ? JBTerminalWidget.asJediTermWidget((TerminalWidget)data) : null;
    }

    @Nullable
    public static TerminalWidget findWidgetByContent(@NotNull Content content) {
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(43);
        }
        return (TerminalWidget)content.getUserData(TERMINAL_WIDGET_KEY);
    }

    @Nullable
    public static AbstractTerminalRunner<?> getRunnerByContent(@NotNull Content content) {
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(44);
        }
        return (AbstractTerminalRunner)content.getUserData(RUNNER_KEY);
    }

    public void detachWidgetAndRemoveContent(@NotNull Content content) {
        ContentManager contentManager;
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(45);
        }
        if ((contentManager = content.getManager()) == null) {
            throw new IllegalStateException("Content manager is null for " + String.valueOf(content));
        }
        TerminalTabCloseListener.Companion.executeContentOperationSilently(content, (Function0<Unit>)((Function0)() -> {
            contentManager.removeContent(content, true);
            return Unit.INSTANCE;
        }));
        content.putUserData(TERMINAL_WIDGET_KEY, null);
        if (this.myToolWindow != null && this.myToolWindow.getContentManager().isEmpty()) {
            this.myToolWindow.hide();
        }
    }

    public static boolean isInTerminalToolWindow(@NotNull JBTerminalWidget widget) {
        if (widget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(46);
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)widget.getTerminalPanel());
        ToolWindow toolWindow = (ToolWindow)dataContext.getData(PlatformDataKeys.TOOL_WINDOW);
        return TerminalToolWindowManager.isTerminalToolWindow(toolWindow);
    }

    public static boolean isTerminalToolWindow(@Nullable ToolWindow toolWindow) {
        return toolWindow != null && "Terminal".equals(toolWindow.getId());
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public ShellTerminalWidget createLocalShellWidget(@Nullable String workingDirectory, @Nullable @Nls String tabName) {
        ShellTerminalWidget shellTerminalWidget = ShellTerminalWidget.toShellJediTermWidgetOrThrow(this.createShellWidget(workingDirectory, tabName, true, true));
        if (shellTerminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(47);
        }
        return shellTerminalWidget;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public ShellTerminalWidget createLocalShellWidget(@Nullable String workingDirectory, @Nullable @Nls String tabName, boolean requestFocus) {
        ShellTerminalWidget shellTerminalWidget = ShellTerminalWidget.toShellJediTermWidgetOrThrow(this.createShellWidget(workingDirectory, tabName, requestFocus, true));
        if (shellTerminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(48);
        }
        return shellTerminalWidget;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public ShellTerminalWidget createLocalShellWidget(@Nullable String workingDirectory, @Nullable @Nls String tabName, boolean requestFocus, boolean deferSessionStartUntilUiShown) {
        ShellTerminalWidget shellTerminalWidget = ShellTerminalWidget.toShellJediTermWidgetOrThrow(this.createShellWidget(workingDirectory, tabName, requestFocus, deferSessionStartUntilUiShown));
        if (shellTerminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(49);
        }
        return shellTerminalWidget;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 7, 8, 10, 12, 13, 14, 17, 18, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 42, 43, 44, 45, 46 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalToolWindowManager";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: 
            case 10: 
            case 23: 
            case 28: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 17: 
            case 20: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalRunner";
                break;
            }
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredEngine";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 25: 
            case 27: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 26: 
            case 29: 
            case 32: 
            case 34: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalContainer";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalWidget";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startupOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalRunner";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalToolWindowManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalWidgets";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createShellWidget";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "newTab";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewSession";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrInitToolWindow";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTab";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createTerminalContent";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "startShellTerminalWidget";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalShellWidget";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addNewTerminalSetupHandler";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initToolWindow";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createNewSession";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newTab";
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createNewTab";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalContent";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setupTerminalWidget";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updateTabTitle";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findWidgetForContent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getContainer";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "closeTab";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createFocusListener";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getComponentToFocus";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "startShellTerminalWidget";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetByContent";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findWidgetByContent";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerByContent";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "detachWidgetAndRemoveContent";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isInTerminalToolWindow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 7, 8, 10, 12, 13, 14, 17, 18, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 42, 43, 44, 45, 46 -> new IllegalArgumentException(string);
        };
    }
}

