/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.arrangement;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.TimeoutUtil;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.arrangement.ProcessInfoUtil;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementManager;

public final class TerminalWorkingDirectoryManager {
    private static final Logger LOG = Logger.getInstance(TerminalWorkingDirectoryManager.class);
    private static final int MERGE_WAIT_MILLIS = 500;
    private static final int FETCH_WAIT_MILLIS = 2000;
    private static final Key<String> INITIAL_CWD_KEY = Key.create((String)"initial cwd");
    private final Map<Content, Data> myDataByContentMap = new HashMap<Content, Data>();

    TerminalWorkingDirectoryManager() {
    }

    @Nullable
    String getWorkingDirectory(@NotNull Content content) {
        Data data;
        if (content == null) {
            TerminalWorkingDirectoryManager.$$$reportNull$$$0(0);
        }
        return (data = this.getData(content)) != null ? data.myWorkingDirectory : null;
    }

    void init(@NotNull ToolWindow terminalToolWindow) {
        if (terminalToolWindow == null) {
            TerminalWorkingDirectoryManager.$$$reportNull$$$0(1);
        }
        ContentManager contentManager = terminalToolWindow.getContentManager();
        for (Content content : contentManager.getContents()) {
            this.watchTab(content);
        }
        contentManager.addContentManagerListener(new ContentManagerListener(){

            public void contentAdded(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                TerminalWorkingDirectoryManager.this.watchTab(event.getContent());
            }

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                TerminalWorkingDirectoryManager.this.unwatchTab(event.getContent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/terminal/arrangement/TerminalWorkingDirectoryManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void watchTab(final @NotNull Content content) {
        if (content == null) {
            TerminalWorkingDirectoryManager.$$$reportNull$$$0(2);
        }
        final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)content);
        final AtomicReference<Data> dataRef = new AtomicReference<Data>();
        KeyAdapter listener2 = new KeyAdapter(this){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && TerminalArrangementManager.isAvailable()) {
                    alarm.cancelAllRequests();
                    if (!alarm.isDisposed()) {
                        alarm.addRequest(() -> TerminalWorkingDirectoryManager.updateWorkingDirectory(content, (Data)dataRef.get()), 500);
                    }
                }
            }
        };
        Data data = new Data(listener2, content.getDisplayName());
        data.myWorkingDirectory = (String)content.getUserData(INITIAL_CWD_KEY);
        content.putUserData(INITIAL_CWD_KEY, null);
        dataRef.set(data);
        JBTerminalWidget widget = TerminalToolWindowManager.getWidgetByContent(content);
        if (widget != null) {
            widget.getTerminalPanel().addCustomKeyListener((KeyListener)listener2);
            Disposer.register((Disposable)content, () -> widget.getTerminalPanel().removeCustomKeyListener((KeyListener)listener2));
        }
        this.myDataByContentMap.put(content, data);
    }

    private static void updateWorkingDirectory(@NotNull Content content, @NotNull Data data) {
        JBTerminalWidget widget;
        TerminalWidget newWidget;
        if (content == null) {
            TerminalWorkingDirectoryManager.$$$reportNull$$$0(3);
        }
        if (data == null) {
            TerminalWorkingDirectoryManager.$$$reportNull$$$0(4);
        }
        TerminalWidget terminalWidget = newWidget = (widget = TerminalToolWindowManager.getWidgetByContent(content)) != null ? widget.asNewWidget() : null;
        if (widget != null) {
            data.myWorkingDirectory = TerminalWorkingDirectoryManager.getWorkingDirectory(newWidget);
        }
    }

    @Nullable
    public static String getWorkingDirectory(@NotNull TerminalWidget widget) {
        TtyConnector connector;
        if (widget == null) {
            TerminalWorkingDirectoryManager.$$$reportNull$$$0(5);
        }
        if ((connector = widget.getTtyConnector()) == null) {
            return null;
        }
        return TerminalWorkingDirectoryManager.getWorkingDirectory(connector);
    }

    @ApiStatus.Internal
    @Nullable
    public static String getWorkingDirectory(@NotNull TtyConnector connector) {
        ProcessTtyConnector processConnector;
        if (connector == null) {
            TerminalWorkingDirectoryManager.$$$reportNull$$$0(6);
        }
        if ((processConnector = ShellTerminalWidget.getProcessTtyConnector(connector)) == null) {
            return null;
        }
        try {
            long startNano = System.nanoTime();
            CompletableDeferred<String> cwdDeferred = ProcessInfoUtil.getInstance().getCurrentWorkingDirectoryDeferred(processConnector.getProcess());
            CompletableFuture cwdFuture = FutureKt.asCompletableFuture(cwdDeferred);
            String result = (String)cwdFuture.get(2000L, TimeUnit.MILLISECONDS);
            boolean exists = TerminalWorkingDirectoryManager.checkDirectory(result);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cwd (" + result + ", exists=" + exists + ") fetched in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms");
            }
            return exists ? result : null;
        }
        catch (InterruptedException startNano) {
        }
        catch (ExecutionException e) {
            String message = "Failed to fetch cwd for " + String.valueOf(connector);
            if (LOG.isDebugEnabled()) {
                LOG.warn(message, (Throwable)e);
            } else {
                LOG.warn(message + ": " + e.getCause().getMessage());
            }
        }
        catch (TimeoutException e) {
            LOG.warn("Timeout fetching cwd for " + String.valueOf(connector), (Throwable)e);
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static String getWorkingDirectory(@NotNull JBTerminalWidget widget, @Nullable String name) {
        if (widget == null) {
            TerminalWorkingDirectoryManager.$$$reportNull$$$0(7);
        }
        return TerminalWorkingDirectoryManager.getWorkingDirectory(widget.asNewWidget());
    }

    private static boolean checkDirectory(@Nullable String directory) {
        if (directory == null) {
            return false;
        }
        try {
            Path path = Path.of(directory, new String[0]);
            return path.isAbsolute() && Files.isDirectory(path, new LinkOption[0]);
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    private void unwatchTab(@NotNull Content content) {
        Data data;
        if (content == null) {
            TerminalWorkingDirectoryManager.$$$reportNull$$$0(8);
        }
        if ((data = this.getData(content)) != null) {
            this.myDataByContentMap.remove(content);
            JBTerminalWidget widget = TerminalToolWindowManager.getWidgetByContent(content);
            if (widget != null) {
                widget.getTerminalPanel().removeCustomKeyListener(data.myKeyListener);
            }
        }
    }

    @Nullable
    private Data getData(@NotNull Content content) {
        Data data;
        if (content == null) {
            TerminalWorkingDirectoryManager.$$$reportNull$$$0(9);
        }
        if ((data = this.myDataByContentMap.get(content)) == null) {
            LOG.error("No associated data");
        }
        return data;
    }

    public static void setInitialWorkingDirectory(@NotNull Content content, @Nullable String directory) {
        if (content == null) {
            TerminalWorkingDirectoryManager.$$$reportNull$$$0(10);
        }
        content.putUserData(INITIAL_CWD_KEY, (Object)directory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalToolWindow";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connector";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/terminal/arrangement/TerminalWorkingDirectoryManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getWorkingDirectory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "watchTab";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateWorkingDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "unwatchTab";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "setInitialWorkingDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Data {
        private final KeyListener myKeyListener;
        private final String myContentName;
        private volatile String myWorkingDirectory;

        private Data(@NotNull KeyListener keyListener, @Nullable String contentName) {
            if (keyListener == null) {
                Data.$$$reportNull$$$0(0);
            }
            this.myKeyListener = keyListener;
            this.myContentName = contentName;
        }

        public String toString() {
            return this.myContentName + ", cwd: " + this.myWorkingDirectory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyListener", "org/jetbrains/plugins/terminal/arrangement/TerminalWorkingDirectoryManager$Data", "<init>"));
        }
    }
}

