/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.model.TextBufferChangesListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.output.PartialCommandOutput;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputChangesTracker;
import org.jetbrains.plugins.terminal.block.session.ShellCommandOutputScraperImpl;
import org.jetbrains.plugins.terminal.block.session.StyledCommandOutput;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0018\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fH\u0002J\r\u0010 \u001a\u00020\bH\u0000\u00a2\u0006\u0002\b!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputChangesTracker;", "", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "onUpdateStart", "Lkotlin/Function0;", "", "<init>", "(Lcom/jediterm/terminal/model/TerminalTextBuffer;Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function0;)V", "lastChangedVisualLine", "", "discardedLogicalLinesCount", "isAnyLineChanged", "", "isChangesDiscarded", "changeListeners", "", "value", "Lorg/jetbrains/plugins/terminal/block/output/PartialCommandOutput;", "pendingOutput", "getPendingOutput", "()Lorg/jetbrains/plugins/terminal/block/output/PartialCommandOutput;", "collectChangedOutputOrWait", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "collectChangedOutputOrNull", "getChangedOutputDeferred", "Lkotlinx/coroutines/CompletableDeferred;", "collectOutput", "getLogicalLineIndex", "visualLine", "onOutputApplied", "onOutputApplied$intellij_terminal", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOutputChangesTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputChangesTracker.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputChangesTracker\n+ 2 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n647#2,7:202\n647#2,7:209\n1#3:216\n*S KotlinDebug\n*F\n+ 1 TerminalOutputChangesTracker.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputChangesTracker\n*L\n120#1:202,7\n134#1:209,7\n*E\n"})
public final class TerminalOutputChangesTracker {
    @NotNull
    private final TerminalTextBuffer textBuffer;
    private int lastChangedVisualLine;
    private int discardedLogicalLinesCount;
    private boolean isAnyLineChanged;
    private boolean isChangesDiscarded;
    @NotNull
    private final List<Function0<Unit>> changeListeners;
    @Nullable
    private volatile PartialCommandOutput pendingOutput;

    public TerminalOutputChangesTracker(@NotNull TerminalTextBuffer textBuffer, @NotNull Disposable parentDisposable, @NotNull Function0<Unit> onUpdateStart) {
        Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(onUpdateStart, (String)"onUpdateStart");
        this.textBuffer = textBuffer;
        this.isAnyLineChanged = true;
        this.changeListeners = new CopyOnWriteArrayList();
        TextBufferChangesListener listener2 = new TextBufferChangesListener(this, onUpdateStart){
            final /* synthetic */ TerminalOutputChangesTracker this$0;
            final /* synthetic */ Function0<Unit> $onUpdateStart;
            {
                this.this$0 = $receiver;
                this.$onUpdateStart = $onUpdateStart;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void linesChanged(int fromIndex) {
                void $this$withLock$iv;
                TerminalTextBuffer terminalTextBuffer = TerminalOutputChangesTracker.access$getTextBuffer$p(this.this$0);
                Function0<Unit> function0 = this.$onUpdateStart;
                TerminalOutputChangesTracker terminalOutputChangesTracker = this.this$0;
                boolean $i$f$withLock = false;
                $this$withLock$iv.lock();
                try {
                    void it = $this$withLock$iv;
                    boolean bl = false;
                    function0.invoke();
                    int line = TerminalOutputChangesTracker.access$getTextBuffer$p(terminalOutputChangesTracker).getHistoryLinesCount() + fromIndex;
                    TerminalOutputChangesTracker.access$setLastChangedVisualLine$p(terminalOutputChangesTracker, Math.min(TerminalOutputChangesTracker.access$getLastChangedVisualLine$p(terminalOutputChangesTracker), line));
                    TerminalOutputChangesTracker.access$setAnyLineChanged$p(terminalOutputChangesTracker, true);
                    for (Function0 listener2 : TerminalOutputChangesTracker.access$getChangeListeners$p(terminalOutputChangesTracker)) {
                        listener2.invoke();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    $this$withLock$iv.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void linesDiscardedFromHistory(List<TerminalLine> lines) {
                void $this$withLock$iv;
                Intrinsics.checkNotNullParameter(lines, (String)"lines");
                TerminalTextBuffer terminalTextBuffer = TerminalOutputChangesTracker.access$getTextBuffer$p(this.this$0);
                TerminalOutputChangesTracker terminalOutputChangesTracker = this.this$0;
                boolean $i$f$withLock = false;
                $this$withLock$iv.lock();
                try {
                    void it = $this$withLock$iv;
                    boolean bl = false;
                    if (TerminalOutputChangesTracker.access$getLastChangedVisualLine$p(terminalOutputChangesTracker) >= lines.size()) {
                        TerminalOutputChangesTracker.access$setLastChangedVisualLine$p(terminalOutputChangesTracker, TerminalOutputChangesTracker.access$getLastChangedVisualLine$p(terminalOutputChangesTracker) - lines.size());
                    } else {
                        TerminalOutputChangesTracker.access$setLastChangedVisualLine$p(terminalOutputChangesTracker, 0);
                        TerminalOutputChangesTracker.access$setChangesDiscarded$p(terminalOutputChangesTracker, true);
                    }
                    for (TerminalLine line : lines) {
                        if (line.isWrapped()) continue;
                        int n = TerminalOutputChangesTracker.access$getDiscardedLogicalLinesCount$p(terminalOutputChangesTracker);
                        TerminalOutputChangesTracker.access$setDiscardedLogicalLinesCount$p(terminalOutputChangesTracker, n + 1);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    $this$withLock$iv.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void widthResized() {
                void $this$withLock$iv;
                TerminalTextBuffer terminalTextBuffer = TerminalOutputChangesTracker.access$getTextBuffer$p(this.this$0);
                TerminalOutputChangesTracker terminalOutputChangesTracker = this.this$0;
                boolean $i$f$withLock = false;
                $this$withLock$iv.lock();
                try {
                    void it = $this$withLock$iv;
                    boolean bl = false;
                    TerminalOutputChangesTracker.access$setLastChangedVisualLine$p(terminalOutputChangesTracker, 0);
                    TerminalOutputChangesTracker.access$setAnyLineChanged$p(terminalOutputChangesTracker, true);
                    TerminalOutputChangesTracker.access$setChangesDiscarded$p(terminalOutputChangesTracker, true);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    $this$withLock$iv.unlock();
                }
            }
        };
        this.textBuffer.addChangesListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> TerminalOutputChangesTracker._init_$lambda$0(this, listener2));
    }

    @Nullable
    public final PartialCommandOutput getPendingOutput() {
        return this.pendingOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object collectChangedOutputOrWait(@NotNull Continuation<? super PartialCommandOutput> $completion) {
        CompletableDeferred completableDeferred;
        TerminalTextBuffer $this$withLock$iv = this.textBuffer;
        boolean $i$f$withLock = false;
        $this$withLock$iv.lock();
        try {
            TerminalTextBuffer it = $this$withLock$iv;
            boolean bl = false;
            completableDeferred = this.isAnyLineChanged ? CompletableDeferredKt.CompletableDeferred((Object)this.collectOutput()) : this.getChangedOutputDeferred();
        }
        finally {
            $this$withLock$iv.unlock();
        }
        CompletableDeferred deferred = completableDeferred;
        return deferred.await($completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final PartialCommandOutput collectChangedOutputOrNull() {
        PartialCommandOutput partialCommandOutput;
        TerminalTextBuffer $this$withLock$iv = this.textBuffer;
        boolean $i$f$withLock = false;
        $this$withLock$iv.lock();
        try {
            TerminalTextBuffer it = $this$withLock$iv;
            boolean bl = false;
            partialCommandOutput = this.isAnyLineChanged ? this.collectOutput() : null;
        }
        finally {
            $this$withLock$iv.unlock();
        }
        return partialCommandOutput;
    }

    private final CompletableDeferred<PartialCommandOutput> getChangedOutputDeferred() {
        if (!(!this.isAnyLineChanged)) {
            boolean $i$a$-check-TerminalOutputChangesTracker$getChangedOutputDeferred$22 = false;
            String $i$a$-check-TerminalOutputChangesTracker$getChangedOutputDeferred$22 = "Something was changed already, no need to wait for next change";
            throw new IllegalStateException($i$a$-check-TerminalOutputChangesTracker$getChangedOutputDeferred$22.toString());
        }
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        Function0 listener2 = () -> TerminalOutputChangesTracker.getChangedOutputDeferred$lambda$1(this, deferred);
        deferred.invokeOnCompletion(arg_0 -> TerminalOutputChangesTracker.getChangedOutputDeferred$lambda$2(this, listener2, arg_0));
        this.changeListeners.add((Function0<Unit>)listener2);
        return deferred;
    }

    private final PartialCommandOutput collectOutput() {
        PartialCommandOutput partialCommandOutput;
        int startLine = this.lastChangedVisualLine - this.textBuffer.getHistoryLinesCount();
        while (startLine - 1 >= -this.textBuffer.getHistoryLinesCount() && this.textBuffer.getLine(startLine - 1).isWrapped()) {
            --startLine;
        }
        StyledCommandOutput output = ShellCommandOutputScraperImpl.Companion.scrapeOutput(this.textBuffer, startLine);
        int logicalLineIndex = this.getLogicalLineIndex(startLine) + this.discardedLogicalLinesCount;
        boolean anyDiscarded = this.isChangesDiscarded;
        this.lastChangedVisualLine = this.textBuffer.getHistoryLinesCount();
        this.isAnyLineChanged = false;
        this.isChangesDiscarded = false;
        PartialCommandOutput it = partialCommandOutput = new PartialCommandOutput(output.getText(), output.getStyleRanges(), logicalLineIndex, this.textBuffer.getWidth(), anyDiscarded);
        boolean bl = false;
        this.pendingOutput = it;
        return partialCommandOutput;
    }

    private final int getLogicalLineIndex(int visualLine) {
        int count = 0;
        for (int ind = -this.textBuffer.getHistoryLinesCount(); ind < visualLine; ++ind) {
            if (this.textBuffer.getLine(ind).isWrapped()) continue;
            ++count;
        }
        return count;
    }

    public final void onOutputApplied$intellij_terminal() {
        this.pendingOutput = null;
    }

    private static final void _init_$lambda$0(TerminalOutputChangesTracker this$0, listener.1 $listener) {
        this$0.textBuffer.removeChangesListener((TextBufferChangesListener)$listener);
    }

    private static final Unit getChangedOutputDeferred$lambda$1(TerminalOutputChangesTracker this$0, CompletableDeferred $deferred) {
        if (!this$0.isAnyLineChanged) {
            boolean bl = false;
            String string = "Nothing was changed, but change event fired";
            throw new IllegalStateException(string.toString());
        }
        $deferred.complete((Object)this$0.collectOutput());
        return Unit.INSTANCE;
    }

    private static final Unit getChangedOutputDeferred$lambda$2(TerminalOutputChangesTracker this$0, Function0 $listener, Throwable it) {
        this$0.changeListeners.remove($listener);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ TerminalTextBuffer access$getTextBuffer$p(TerminalOutputChangesTracker $this) {
        return $this.textBuffer;
    }

    public static final /* synthetic */ void access$setLastChangedVisualLine$p(TerminalOutputChangesTracker $this, int n) {
        $this.lastChangedVisualLine = n;
    }

    public static final /* synthetic */ int access$getLastChangedVisualLine$p(TerminalOutputChangesTracker $this) {
        return $this.lastChangedVisualLine;
    }

    public static final /* synthetic */ void access$setAnyLineChanged$p(TerminalOutputChangesTracker $this, boolean bl) {
        $this.isAnyLineChanged = bl;
    }

    public static final /* synthetic */ List access$getChangeListeners$p(TerminalOutputChangesTracker $this) {
        return $this.changeListeners;
    }

    public static final /* synthetic */ void access$setChangesDiscarded$p(TerminalOutputChangesTracker $this, boolean bl) {
        $this.isChangesDiscarded = bl;
    }

    public static final /* synthetic */ int access$getDiscardedLogicalLinesCount$p(TerminalOutputChangesTracker $this) {
        return $this.discardedLogicalLinesCount;
    }

    public static final /* synthetic */ void access$setDiscardedLogicalLinesCount$p(TerminalOutputChangesTracker $this, int n) {
        $this.discardedLogicalLinesCount = n;
    }
}

