/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.session;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.EventDispatcher;
import com.jediterm.terminal.Terminal;
import java.util.EventListener;
import java.util.HexFormat;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptState;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.CommandFinishedEvent;
import org.jetbrains.plugins.terminal.block.session.GeneratorFinishedEvent;
import org.jetbrains.plugins.terminal.block.session.ShellCommandListener;
import org.jetbrains.plugins.terminal.block.session.StartedCommand;
import org.jetbrains.plugins.terminal.block.session.TerminalModel;
import org.jetbrains.plugins.terminal.util.ShellIntegration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 22\u00020\u0001:\u000223B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0016\u0010\u0017\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0016\u0010\u0018\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0016\u0010\u0019\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0016\u0010\u001a\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0016\u0010\u001b\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0002J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J\b\u0010\u001f\u001a\u00020\u0013H\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010!\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0016H\u0002J\u0016\u0010)\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J \u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010-\u001a\u00020\u0013H\u0002J\u0016\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u000201R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\u0015\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\f\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandManager;", "", "terminal", "Lcom/jediterm/terminal/Terminal;", "shellIntegration", "Lorg/jetbrains/plugins/terminal/util/ShellIntegration;", "<init>", "(Lcom/jediterm/terminal/Terminal;Lorg/jetbrains/plugins/terminal/util/ShellIntegration;)V", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "(Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;)V", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "startedCommand", "Lorg/jetbrains/plugins/terminal/block/session/StartedCommand;", "processInitialized", "", "event", "", "", "processCommandStartedEvent", "processCommandFinishedEvent", "processPromptStateUpdatedEvent", "processCommandHistoryEvent", "processGeneratorFinishedEvent", "clearTerminal", "fireInitialized", "rawShellInfo", "firePromptShown", "fireCommandStarted", "fireCommandFinished", "exitCode", "", "firePromptStateUpdated", "state", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptState;", "fireCommandHistoryReceived", "history", "fireShellEditorBufferReported", "fireGeneratorFinished", "requestId", "result", "fireClearInvoked", "addListener", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "Companion", "Param", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nShellCommandManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandManager\n+ 2 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandManager$Companion\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,279:1\n185#2,2:280\n187#2:286\n185#2,2:287\n187#2:293\n185#2,2:294\n187#2:300\n185#2,2:301\n187#2:307\n185#2,2:308\n187#2:314\n185#2,2:315\n187#2:321\n185#2,2:322\n187#2:328\n185#2,2:329\n187#2:335\n185#2,2:336\n187#2:342\n185#2,2:343\n187#2:349\n61#3,4:282\n61#3,4:289\n61#3,4:296\n61#3,4:303\n61#3,4:310\n61#3,4:317\n61#3,4:324\n61#3,4:331\n61#3,4:338\n61#3,4:345\n13#3:350\n*S KotlinDebug\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandManager\n*L\n118#1:280,2\n118#1:286\n123#1:287,2\n123#1:293\n130#1:294,2\n130#1:300\n135#1:301,2\n135#1:307\n145#1:308,2\n145#1:314\n153#1:315,2\n153#1:321\n157#1:322,2\n157#1:328\n163#1:329,2\n163#1:335\n168#1:336,2\n168#1:342\n174#1:343,2\n174#1:349\n118#1:282,4\n123#1:289,4\n130#1:296,4\n135#1:303,4\n145#1:310,4\n153#1:317,4\n157#1:324,4\n163#1:331,4\n168#1:338,4\n174#1:345,4\n183#1:350\n*E\n"})
public final class ShellCommandManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final ShellIntegration shellIntegration;
    @NotNull
    private final EventDispatcher<ShellCommandListener> dispatcher;
    @Nullable
    private volatile StartedCommand startedCommand;
    @NotNull
    private static final Logger LOG;

    public ShellCommandManager(@NotNull Terminal terminal, @NotNull ShellIntegration shellIntegration) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)shellIntegration, (String)"shellIntegration");
        this.terminal = terminal;
        this.shellIntegration = shellIntegration;
        EventDispatcher eventDispatcher2 = EventDispatcher.create(ShellCommandListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"create(...)");
        this.dispatcher = eventDispatcher2;
        this.terminal.addCustomCommandListener(arg_0 -> ShellCommandManager._init_$lambda$0(this, arg_0));
    }

    public ShellCommandManager(@NotNull BlockTerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this((Terminal)session2.getController(), session2.getShellIntegration());
    }

    private final void processInitialized(List<String> event) {
        String string = Param.SHELL_INFO.getDecodedValueOrNull((String)CollectionsKt.getOrNull(event, (int)1));
        if (string == null) {
            string = "{}";
        }
        String shellInfo = string;
        this.fireInitialized(shellInfo);
    }

    private final void processCommandStartedEvent(List<String> event) {
        StartedCommand startedCommand;
        String command2 = Param.COMMAND.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)1));
        String currentDirectory = Param.CURRENT_DIRECTORY.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)2));
        this.startedCommand = startedCommand = new StartedCommand(command2, currentDirectory, (TimeMark)TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto()));
        this.fireCommandStarted(startedCommand);
    }

    private final void processCommandFinishedEvent(List<String> event) {
        int exitCode = Param.EXIT_CODE.getIntValue((String)CollectionsKt.getOrNull(event, (int)1));
        StartedCommand startedCommand = this.startedCommand;
        this.fireCommandFinished(startedCommand, exitCode);
        this.startedCommand = null;
    }

    private final void processPromptStateUpdatedEvent(List<String> event) {
        String string = Param.CURRENT_DIRECTORY.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)1));
        String string2 = Param.USER_NAME.getDecodedNotEmptyValueOrNull((String)CollectionsKt.getOrNull(event, (int)2));
        String string3 = Param.USER_HOME.getDecodedNotEmptyValueOrNull((String)CollectionsKt.getOrNull(event, (int)3));
        String string4 = Param.GIT_BRANCH.getDecodedNotEmptyValueOrNull((String)CollectionsKt.getOrNull(event, (int)4));
        String string5 = Param.VIRTUAL_ENV.getDecodedNotEmptyValueOrNull((String)CollectionsKt.getOrNull(event, (int)5));
        String string6 = Param.CONDA_ENV.getDecodedNotEmptyValueOrNull((String)CollectionsKt.getOrNull(event, (int)6));
        String string7 = Param.ORIGINAL_PROMPT.getDecodedNotEmptyValueOrNull((String)CollectionsKt.getOrNull(event, (int)7));
        String string8 = Param.ORIGINAL_RIGHT_PROMPT.getDecodedNotEmptyValueOrNull((String)CollectionsKt.getOrNull(event, (int)8));
        String string9 = this.shellIntegration.getShellType().toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toLowerCase(...)");
        TerminalPromptState state = new TerminalPromptState(string, string2, string3, string4, string5, string6, string7, string8, string9);
        this.firePromptStateUpdated(state);
    }

    private final void processCommandHistoryEvent(List<String> event) {
        String history = Param.HISTORY_STRING.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)1));
        this.fireCommandHistoryReceived(history);
    }

    private final void processGeneratorFinishedEvent(List<String> event) {
        int requestId = Param.REQUEST_ID.getIntValue((String)CollectionsKt.getOrNull(event, (int)1));
        String result = Param.RESULT.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)2));
        int exitCode = Param.EXIT_CODE.getIntValue((String)CollectionsKt.getOrNull(event, (int)3));
        this.fireGeneratorFinished(requestId, result, exitCode);
    }

    /*
     * WARNING - void declaration
     */
    private final void clearTerminal() {
        void $this$debug$iv$iv;
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger logger = $this$iv.getLOG$intellij_terminal();
        Throwable e$iv$iv = e$iv;
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            void var8_7 = $this$debug$iv$iv;
            boolean bl = false;
            var8_7.debug("force clearing terminal", e$iv$iv);
        }
        TerminalModel.Companion.clearAllAndMoveCursorToTopLeftCorner$intellij_terminal(this.terminal);
    }

    /*
     * WARNING - void declaration
     */
    private final void fireInitialized(String rawShellInfo) {
        void $this$debug$iv$iv;
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger logger = $this$iv.getLOG$intellij_terminal();
        Throwable e$iv$iv = e$iv;
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            void var9_8 = $this$debug$iv$iv;
            boolean bl = false;
            var9_8.debug("Shell event: initialized. Shell info: " + rawShellInfo, e$iv$iv);
        }
        ((ShellCommandListener)this.dispatcher.getMulticaster()).shellInfoReceived(rawShellInfo);
        ((ShellCommandListener)this.dispatcher.getMulticaster()).initialized();
        this.clearTerminal();
    }

    /*
     * WARNING - void declaration
     */
    private final void firePromptShown() {
        void $this$debug$iv$iv;
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger logger = $this$iv.getLOG$intellij_terminal();
        Throwable e$iv$iv = e$iv;
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            void var8_7 = $this$debug$iv$iv;
            boolean bl = false;
            var8_7.debug("Shell event: prompt_shown", e$iv$iv);
        }
        ((ShellCommandListener)this.dispatcher.getMulticaster()).promptShown();
    }

    /*
     * WARNING - void declaration
     */
    private final void fireCommandStarted(StartedCommand startedCommand) {
        void $this$debug$iv$iv;
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger logger = $this$iv.getLOG$intellij_terminal();
        Throwable e$iv$iv = e$iv;
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            void var9_8 = $this$debug$iv$iv;
            boolean bl = false;
            var9_8.debug("Shell event: command_started - " + startedCommand, e$iv$iv);
        }
        ((ShellCommandListener)this.dispatcher.getMulticaster()).commandStarted(startedCommand.getCommand());
    }

    /*
     * WARNING - void declaration
     */
    private final void fireCommandFinished(StartedCommand startedCommand, int exitCode) {
        if (startedCommand == null) {
            LOG.info("Shell event: received command_finished without preceding command_started - skipping");
        } else {
            void $this$debug$iv$iv;
            CommandFinishedEvent event = new CommandFinishedEvent(startedCommand.getCommand(), exitCode, startedCommand.getCommandStarted().elapsedNow-UwyO8pc(), null);
            Companion $this$iv = Companion;
            Throwable e$iv = null;
            boolean $i$f$debug$intellij_terminal = false;
            Logger logger = $this$iv.getLOG$intellij_terminal();
            Throwable e$iv$iv = e$iv;
            boolean $i$f$debug = false;
            if ($this$debug$iv$iv.isDebugEnabled()) {
                void var11_10 = $this$debug$iv$iv;
                boolean bl = false;
                var11_10.debug("Shell event: command_finished - " + event, e$iv$iv);
            }
            ((ShellCommandListener)this.dispatcher.getMulticaster()).commandFinished(event);
        }
        this.clearTerminal();
    }

    /*
     * WARNING - void declaration
     */
    private final void firePromptStateUpdated(TerminalPromptState state) {
        void $this$debug$iv$iv;
        ((ShellCommandListener)this.dispatcher.getMulticaster()).promptStateUpdated(state);
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger logger = $this$iv.getLOG$intellij_terminal();
        Throwable e$iv$iv = e$iv;
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            void var9_8 = $this$debug$iv$iv;
            boolean bl = false;
            var9_8.debug("Prompt state updated: " + state, e$iv$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void fireCommandHistoryReceived(String history) {
        void $this$debug$iv$iv;
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger logger = $this$iv.getLOG$intellij_terminal();
        Throwable e$iv$iv = e$iv;
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            void var9_8 = $this$debug$iv$iv;
            boolean bl = false;
            var9_8.debug("Shell event: command_history of " + history.length() + " size", e$iv$iv);
        }
        ((ShellCommandListener)this.dispatcher.getMulticaster()).commandHistoryReceived(history);
    }

    /*
     * WARNING - void declaration
     */
    private final void fireShellEditorBufferReported(List<String> event) {
        void $this$debug$iv$iv;
        String buffer = Param.SHELL_EDITOR_BUFFER.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)1));
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger logger = $this$iv.getLOG$intellij_terminal();
        Throwable e$iv$iv = e$iv;
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            void var10_9 = $this$debug$iv$iv;
            boolean bl = false;
            var10_9.debug("Shell event: shell_editor_buffer_reported of " + buffer.length() + " size", e$iv$iv);
        }
        ((ShellCommandListener)this.dispatcher.getMulticaster()).commandBufferReceived(buffer);
    }

    /*
     * WARNING - void declaration
     */
    private final void fireGeneratorFinished(int requestId, String result, int exitCode) {
        void $this$debug$iv$iv;
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger logger = $this$iv.getLOG$intellij_terminal();
        Throwable e$iv$iv = e$iv;
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            void var11_10 = $this$debug$iv$iv;
            boolean bl = false;
            var11_10.debug("Shell event: generator_finished with requestId " + requestId + " and result of " + result.length() + " size", e$iv$iv);
        }
        ((ShellCommandListener)this.dispatcher.getMulticaster()).generatorFinished(new GeneratorFinishedEvent(requestId, result, exitCode));
        this.clearTerminal();
    }

    /*
     * WARNING - void declaration
     */
    private final void fireClearInvoked() {
        void $this$debug$iv$iv;
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger logger = $this$iv.getLOG$intellij_terminal();
        Throwable e$iv$iv = e$iv;
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            void var8_7 = $this$debug$iv$iv;
            boolean bl = false;
            var8_7.debug("Shell event: clear_invoked", e$iv$iv);
        }
        ((ShellCommandListener)this.dispatcher.getMulticaster()).clearInvoked();
    }

    public final void addListener(@NotNull ShellCommandListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.dispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void _init_$lambda$0(ShellCommandManager this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            String string = (String)CollectionsKt.getOrNull((List)it, (int)0);
            if (string != null) {
                int n = -1;
                switch (string.hashCode()) {
                    case 424089318: {
                        if (!string.equals("command_finished")) break;
                        n = 1;
                        break;
                    }
                    case -779416838: {
                        if (!string.equals("clear_invoked")) break;
                        n = 2;
                        break;
                    }
                    case -1808601184: {
                        if (!string.equals("command_history")) break;
                        n = 3;
                        break;
                    }
                    case -337753203: {
                        if (!string.equals("command_started")) break;
                        n = 4;
                        break;
                    }
                    case -872176010: {
                        if (!string.equals("prompt_shown")) break;
                        n = 5;
                        break;
                    }
                    case 140169743: {
                        if (!string.equals("shell_editor_buffer_reported")) break;
                        n = 6;
                        break;
                    }
                    case -268905378: {
                        if (!string.equals("generator_finished")) break;
                        n = 7;
                        break;
                    }
                    case 1234020052: {
                        if (!string.equals("initialized")) break;
                        n = 8;
                        break;
                    }
                    case 1940723570: {
                        if (!string.equals("prompt_state_updated")) break;
                        n = 9;
                        break;
                    }
                }
                switch (n) {
                    case 8: {
                        this$0.processInitialized(it);
                        return;
                    }
                    case 5: {
                        this$0.firePromptShown();
                        return;
                    }
                    case 4: {
                        this$0.processCommandStartedEvent(it);
                        return;
                    }
                    case 1: {
                        this$0.processCommandFinishedEvent(it);
                        return;
                    }
                    case 9: {
                        this$0.processPromptStateUpdatedEvent(it);
                        return;
                    }
                    case 3: {
                        this$0.processCommandHistoryEvent(it);
                        return;
                    }
                    case 6: {
                        this$0.fireShellEditorBufferReported(it);
                        return;
                    }
                    case 7: {
                        this$0.processGeneratorFinishedEvent(it);
                        return;
                    }
                    case 2: {
                        this$0.fireClearInvoked();
                        return;
                    }
                }
            }
            LOG.warn("Unknown custom command: " + it);
            return;
        }
        catch (Throwable t) {
            LOG.warn("Error while processing custom command: " + it, t);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ShellCommandManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\b\u001a\u00020\t2\u0010\b\u0002\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f2\u0011\u0010\r\u001a\r\u0012\t\u0012\u00070\u000f\u00a2\u0006\u0002\b\u00100\u000eH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_terminal", "()Lcom/intellij/openapi/diagnostic/Logger;", "debug", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "lazyMessage", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/NonNls;", "debug$intellij_terminal", "decodeHex", "hexStr", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nShellCommandManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandManager$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,279:1\n61#2,4:280\n*S KotlinDebug\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandManager$Companion\n*L\n186#1:280,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG$intellij_terminal() {
            return LOG;
        }

        /*
         * WARNING - void declaration
         */
        public final void debug$intellij_terminal(@Nullable Exception e, @NotNull Function0<String> lazyMessage) {
            void $this$debug$iv;
            Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
            boolean $i$f$debug$intellij_terminal = false;
            Logger logger = this.getLOG$intellij_terminal();
            Exception e$iv = e;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                $this$debug$iv.debug((String)lazyMessage.invoke(), (Throwable)e$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        public static /* synthetic */ void debug$intellij_terminal$default(Companion $this, Exception e, Function0 lazyMessage, int n, Object object) {
            void $this$debug$iv;
            if ((n & 1) != 0) {
                e = null;
            }
            Intrinsics.checkNotNullParameter((Object)lazyMessage, (String)"lazyMessage");
            boolean $i$f$debug$intellij_terminal = false;
            object = $this.getLOG$intellij_terminal();
            Exception e$iv = e;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                $this$debug$iv.debug((String)lazyMessage.invoke(), (Throwable)e$iv);
            }
        }

        private final String decodeHex(String hexStr) throws IllegalArgumentException {
            byte[] bytes = HexFormat.of().parseHex(hexStr);
            Intrinsics.checkNotNull((Object)bytes);
            return new String(bytes, Charsets.UTF_8);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0019\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0002J\u0013\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandManager$Param;", "", "<init>", "(Ljava/lang/String;I)V", "EXIT_CODE", "COMMAND", "HISTORY_STRING", "REQUEST_ID", "RESULT", "CURRENT_DIRECTORY", "USER_NAME", "USER_HOME", "GIT_BRANCH", "VIRTUAL_ENV", "CONDA_ENV", "SHELL_EDITOR_BUFFER", "ORIGINAL_PROMPT", "ORIGINAL_RIGHT_PROMPT", "SHELL_INFO", "paramNameWithSeparator", "", "paramName", "getIntValue", "", "nameAndValue", "getDecodedValue", "getDecodedNotEmptyValueOrNull", "getDecodedValueOrNull", "getValueOrNull", "fail", "T", "()Ljava/lang/Object;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nShellCommandManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandManager$Param\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,279:1\n1#2:280\n*E\n"})
    private static final class Param
    extends Enum<Param> {
        @NotNull
        private final String paramNameWithSeparator = this.paramName() + "=";
        public static final /* enum */ Param EXIT_CODE = new Param();
        public static final /* enum */ Param COMMAND = new Param();
        public static final /* enum */ Param HISTORY_STRING = new Param();
        public static final /* enum */ Param REQUEST_ID = new Param();
        public static final /* enum */ Param RESULT = new Param();
        public static final /* enum */ Param CURRENT_DIRECTORY = new Param();
        public static final /* enum */ Param USER_NAME = new Param();
        public static final /* enum */ Param USER_HOME = new Param();
        public static final /* enum */ Param GIT_BRANCH = new Param();
        public static final /* enum */ Param VIRTUAL_ENV = new Param();
        public static final /* enum */ Param CONDA_ENV = new Param();
        public static final /* enum */ Param SHELL_EDITOR_BUFFER = new Param();
        public static final /* enum */ Param ORIGINAL_PROMPT = new Param();
        public static final /* enum */ Param ORIGINAL_RIGHT_PROMPT = new Param();
        public static final /* enum */ Param SHELL_INFO = new Param();
        private static final /* synthetic */ Param[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private final String paramName() {
            String string = this.name();
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return string2;
        }

        public final int getIntValue(@Nullable String nameAndValue) {
            Object object = this.getValueOrNull(nameAndValue);
            return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? ((Integer)object).intValue() : ((Number)this.fail()).intValue();
        }

        @NotNull
        public final String getDecodedValue(@Nullable String nameAndValue) {
            String string = this.getDecodedValueOrNull(nameAndValue);
            if (string == null) {
                string = (String)this.fail();
            }
            return string;
        }

        @Nullable
        public final String getDecodedNotEmptyValueOrNull(@Nullable String nameAndValue) {
            String string;
            String string2 = this.getDecodedValueOrNull(nameAndValue);
            if (string2 != null) {
                String string3;
                String it = string3 = string2;
                boolean bl = false;
                string = ((CharSequence)it).length() > 0 ? string3 : null;
            } else {
                string = null;
            }
            return string;
        }

        @Nullable
        public final String getDecodedValueOrNull(@Nullable String nameAndValue) {
            String string = this.getValueOrNull(nameAndValue);
            if (string == null) {
                return null;
            }
            String encodedValue = string;
            return Companion.decodeHex(encodedValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String getValueOrNull(String nameAndValue) {
            String string;
            String string2 = nameAndValue;
            String string3 = string2;
            if (string2 == null) return null;
            String it = string = string3;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)this.paramNameWithSeparator, (boolean)false, (int)2, null)) return null;
            String string4 = string;
            string3 = string4;
            if (string4 == null) return null;
            String string5 = string3.substring(this.paramNameWithSeparator.length());
            String string6 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            return string6;
        }

        private final <T> T fail() {
            throw new IllegalStateException("Cannot parse " + this.paramName());
        }

        public static Param[] values() {
            return (Param[])$VALUES.clone();
        }

        public static Param valueOf(String value) {
            return Enum.valueOf(Param.class, value);
        }

        @NotNull
        public static EnumEntries<Param> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = paramArray = new Param[]{Param.EXIT_CODE, Param.COMMAND, Param.HISTORY_STRING, Param.REQUEST_ID, Param.RESULT, Param.CURRENT_DIRECTORY, Param.USER_NAME, Param.USER_HOME, Param.GIT_BRANCH, Param.VIRTUAL_ENV, Param.CONDA_ENV, Param.SHELL_EDITOR_BUFFER, Param.ORIGINAL_PROMPT, Param.ORIGINAL_RIGHT_PROMPT, Param.SHELL_INFO};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

