/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.runner;

import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPathBoundDescriptor;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.PathUtil;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 '2\u00020\u0001:\u0002&'B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0010\u001a\u00020\u0011J2\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u001a\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator;", "", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "envs", "", "", "customizerClass", "Ljava/lang/Class;", "Lorg/jetbrains/plugins/terminal/LocalTerminalCustomizer;", "<init>", "(Lcom/intellij/platform/eel/EelDescriptor;Ljava/util/Map;Ljava/lang/Class;)V", "multiPathEnvs", "", "Lorg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator$PathLikeEnv;", "singlePathEnvs", "translate", "", "translateEnvs", "pathLikeEnvs", "translator", "Lkotlin/Function2;", "doTranslate", "pathLikeEnv", "newValue", "translateHostPathEntriesToRemote", "pathEntries", "translateHostPathToRemote", "pathString", "translateWindowsDrivePathToMountedWslPath", "path", "Ljava/nio/file/Path;", "translateWslUncPathWithSamePrefix", "asWslEelDescriptorSafely", "Lcom/intellij/platform/eel/EelPathBoundDescriptor;", "joinEntries", "entriesLeft", "entriesRight", "PathLikeEnv", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalCustomizerLocalPathTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCustomizerLocalPathTranslator.kt\norg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,259:1\n60#2,5:260\n61#2,4:276\n61#2,4:280\n61#2,4:284\n13#2:289\n2783#3,7:265\n1563#3:272\n1634#3,3:273\n19#4:288\n*S KotlinDebug\n*F\n+ 1 TerminalCustomizerLocalPathTranslator.kt\norg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator\n*L\n65#1:260,5\n126#1:276,4\n140#1:280,4\n193#1:284,4\n230#1:289\n104#1:265,7\n114#1:272\n114#1:273,3\n201#1:288\n*E\n"})
public final class TerminalCustomizerLocalPathTranslator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EelDescriptor descriptor;
    @NotNull
    private final Map<String, String> envs;
    @NotNull
    private final Class<? extends LocalTerminalCustomizer> customizerClass;
    @NotNull
    private final List<PathLikeEnv> multiPathEnvs;
    @NotNull
    private final List<PathLikeEnv> singlePathEnvs;
    @NotNull
    private static final List<String> MULTI_PATH_ENV_NAMES;
    @NotNull
    private static final List<String> SINGLE_PATH_ENV_NAMES;
    @NotNull
    private static final Logger LOG;

    public TerminalCustomizerLocalPathTranslator(@NotNull EelDescriptor descriptor, @NotNull Map<String, String> envs, @NotNull Class<? extends LocalTerminalCustomizer> customizerClass) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Intrinsics.checkNotNullParameter(customizerClass, (String)"customizerClass");
        this.descriptor = descriptor;
        this.envs = envs;
        this.customizerClass = customizerClass;
        this.multiPathEnvs = TerminalCustomizerLocalPathTranslator.Companion.capturePathEnvs(TerminalCustomizerLocalPathTranslator.MULTI_PATH_ENV_NAMES, this.envs, this.descriptor);
        this.singlePathEnvs = TerminalCustomizerLocalPathTranslator.Companion.capturePathEnvs(TerminalCustomizerLocalPathTranslator.SINGLE_PATH_ENV_NAMES, this.envs, this.descriptor);
    }

    public final void translate() {
        this.translateEnvs(this.multiPathEnvs, (Function2<? super PathLikeEnv, ? super String, String>)((Function2)new Function2<PathLikeEnv, String, String>((Object)this){

            public final String invoke(PathLikeEnv p0, String p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return TerminalCustomizerLocalPathTranslator.access$doTranslate((TerminalCustomizerLocalPathTranslator)this.receiver, p0, p1);
            }
        }));
        this.translateEnvs(this.singlePathEnvs, (Function2<? super PathLikeEnv, ? super String, String>)((Function2)(arg_0, arg_1) -> TerminalCustomizerLocalPathTranslator.translate$lambda$0(this, arg_0, arg_1)));
    }

    private final void translateEnvs(List<PathLikeEnv> pathLikeEnvs, Function2<? super PathLikeEnv, ? super String, String> translator) {
        for (PathLikeEnv pathLikeEnv : pathLikeEnvs) {
            String translatedValue;
            String newValue = this.envs.get(pathLikeEnv.getName());
            if (newValue == null || Intrinsics.areEqual((Object)newValue, (Object)pathLikeEnv.getPrevValue()) || (translatedValue = (String)translator.invoke((Object)pathLikeEnv, (Object)newValue)) == null) continue;
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Translated " + pathLikeEnv.getName() + " for " + this.customizerClass.getName() + ": " + pathLikeEnv.getPrevValue() + " -> " + newValue + " -> " + translatedValue, e$iv);
            }
            this.envs.put(pathLikeEnv.getName(), translatedValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String doTranslate(PathLikeEnv pathLikeEnv, String newValue) {
        String prevValue = pathLikeEnv.getPrevValue();
        int ind = StringsKt.indexOf$default((CharSequence)newValue, (String)prevValue, (int)0, (boolean)false, (int)6, null);
        if (ind >= 0) {
            String prepended = StringsKt.take((String)newValue, (int)ind);
            String string = newValue.substring(ind + prevValue.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String appended = string;
            if (TerminalCustomizerLocalPathTranslator.Companion.canJoinWithoutSeparator(prepended, prevValue, (EelDescriptor)LocalEelDescriptor.INSTANCE) && TerminalCustomizerLocalPathTranslator.Companion.canJoinWithoutSeparator(prevValue, appended, (EelDescriptor)LocalEelDescriptor.INSTANCE)) {
                Object[] objectArray = new String[]{this.translateHostPathEntriesToRemote(prepended), prevValue, this.translateHostPathEntriesToRemote(appended)};
                List remoteEntries = CollectionsKt.listOf((Object[])objectArray);
                Iterable $this$reduce$iv = remoteEntries;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void entries;
                    String string2 = (String)iterator$iv.next();
                    String result = (String)accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = this.joinEntries(result, (String)entries);
                }
                return (String)accumulator$iv;
            }
        }
        LOG.info(this.customizerClass.getName() + " changed " + pathLikeEnv.getName() + " in unexpected way, keeping it as is");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final String translateHostPathEntriesToRemote(String pathEntries) {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{EelPlatformKt.getPathSeparator((EelOsFamily)LocalEelDescriptor.INSTANCE.getOsFamily())};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)pathEntries, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.translateHostPathToRemote((String)it));
        }
        List remotePaths = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)remotePaths, (CharSequence)EelPlatformKt.getPathSeparator((EelOsFamily)this.descriptor.getOsFamily()), null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String translateHostPathToRemote(String pathString) {
        EelPath eelPath;
        Path path;
        if (StringsKt.isBlank((CharSequence)pathString)) {
            return pathString;
        }
        try {
            path = Path.of(pathString, new String[0]);
            Intrinsics.checkNotNull((Object)path);
        }
        catch (InvalidPathException e) {
            void $this$debug$iv;
            Logger logger = LOG;
            Exception e$iv = e;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                void var10_11 = $this$debug$iv;
                boolean bl = false;
                var10_11.debug("Failed to create Path from " + pathString + ", adding it as is (without translation)", (Throwable)e$iv);
            }
            return pathString;
        }
        Path path2 = path;
        if (!path2.isAbsolute()) {
            return pathString;
        }
        try {
            eelPath = EelNioBridgeServiceKt.asEelPath((Path)path2, (EelDescriptor)this.descriptor);
        }
        catch (Exception e) {
            void $this$debug$iv;
            String e$iv = this.translateWindowsDrivePathToMountedWslPath(path2);
            if (e$iv != null) {
                String it = e$iv;
                boolean bl = false;
                return it;
            }
            e$iv = this.translateWslUncPathWithSamePrefix(pathString);
            if (e$iv != null) {
                String it = e$iv;
                boolean bl = false;
                return it;
            }
            e$iv = LOG;
            Exception e$iv2 = e;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                void var10_12 = $this$debug$iv;
                boolean bl = false;
                var10_12.debug("Failed to convert " + path2 + " to EelPath (" + this.descriptor + "), adding it as is (without translation)", (Throwable)e$iv2);
            }
            return pathString;
        }
        EelPath eelPath2 = eelPath;
        return eelPath2.toString();
    }

    private final String translateWindowsDrivePathToMountedWslPath(Path path) {
        EelPathBoundDescriptor eelPathBoundDescriptor = this.asWslEelDescriptorSafely();
        if (eelPathBoundDescriptor == null) {
            return null;
        }
        EelPathBoundDescriptor wslEelDescriptor = eelPathBoundDescriptor;
        if (OSAgnosticPathUtil.isAbsoluteDosPath((String)((Object)path).toString())) {
            WslPath wslPath = WslPath.Companion.parseWindowsUncPath(((Object)wslEelDescriptor.getRootPath()).toString());
            if (wslPath == null) {
                TerminalCustomizerLocalPathTranslator $this$translateWindowsDrivePathToMountedWslPath_u24lambda_u240 = this;
                boolean bl = false;
                LOG.warn("Failed to parse " + wslEelDescriptor.getRootPath() + " as WSL UNC path");
                return null;
            }
            WslPath wslPath2 = wslPath;
            return wslPath2.getDistribution().getWslPath(path);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final String translateWslUncPathWithSamePrefix(String pathString) {
        EelPathBoundDescriptor eelPathBoundDescriptor = this.asWslEelDescriptorSafely();
        if (eelPathBoundDescriptor == null) {
            return null;
        }
        EelPathBoundDescriptor wslEelDescriptor = eelPathBoundDescriptor;
        WslPath wslPath = WslPath.Companion.parseWindowsUncPath(pathString);
        if (wslPath == null) {
            return null;
        }
        WslPath path = wslPath;
        WslPath wslPath2 = WslPath.Companion.parseWindowsUncPath(((Object)wslEelDescriptor.getRootPath()).toString());
        if (wslPath2 == null) {
            return null;
        }
        WslPath eelRootPath = wslPath2;
        if (Intrinsics.areEqual((Object)path.getDistributionId(), (Object)eelRootPath.getDistributionId()) && !Intrinsics.areEqual((Object)path.getWslRoot(), (Object)eelRootPath.getWslRoot())) {
            String winPathString = PathUtil.toSystemDependentName((String)pathString);
            Intrinsics.checkNotNull((Object)winPathString);
            if (!StringsKt.startsWith$default((String)winPathString, (String)path.getWslRoot(), (boolean)false, (int)2, null)) {
                throw new IllegalStateException("Check failed.");
            }
            String string = eelRootPath.getWslRoot();
            String string2 = winPathString.substring(path.getWslRoot().length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String newPathString = string + string2;
            try {
                Path newPath = Path.of(newPathString, new String[0]);
                Intrinsics.checkNotNull((Object)newPath);
                return EelNioBridgeServiceKt.asEelPath((Path)newPath, (EelDescriptor)this.descriptor).toString();
            }
            catch (Exception e) {
                void $this$debug$iv;
                Logger logger = LOG;
                Exception e$iv = e;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    void var13_12 = $this$debug$iv;
                    boolean bl = false;
                    var13_12.debug("Failed to translate " + newPathString + " after changing wsl prefix", (Throwable)e$iv);
                }
                return pathString;
            }
        }
        return null;
    }

    private final EelPathBoundDescriptor asWslEelDescriptorSafely() {
        Object object;
        EelDescriptor $this$asSafely$iv = this.descriptor;
        boolean $i$f$asSafely = false;
        EelDescriptor eelDescriptor = $this$asSafely$iv;
        if (!(eelDescriptor instanceof EelPathBoundDescriptor)) {
            eelDescriptor = null;
        }
        EelPathBoundDescriptor eelPathBoundDescriptor = (EelPathBoundDescriptor)eelDescriptor;
        if (eelPathBoundDescriptor != null) {
            EelPathBoundDescriptor eelPathBoundDescriptor2;
            EelPathBoundDescriptor it = eelPathBoundDescriptor2 = eelPathBoundDescriptor;
            boolean bl = false;
            object = Intrinsics.areEqual((Object)it.getClass().getName(), (Object)"com.intellij.platform.ide.impl.wsl.WslEelDescriptor") ? eelPathBoundDescriptor2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final String joinEntries(String entriesLeft, String entriesRight) {
        return TerminalCustomizerLocalPathTranslator.Companion.canJoinWithoutSeparator(entriesLeft, entriesRight, this.descriptor) ? entriesLeft + entriesRight : entriesLeft + EelPlatformKt.getPathSeparator((EelOsFamily)this.descriptor.getOsFamily()) + entriesRight;
    }

    private static final String translate$lambda$0(TerminalCustomizerLocalPathTranslator this$0, PathLikeEnv pathLikeEnv, String newValue) {
        Intrinsics.checkNotNullParameter((Object)pathLikeEnv, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        return this$0.translateHostPathToRemote(newValue);
    }

    public static final /* synthetic */ String access$doTranslate(TerminalCustomizerLocalPathTranslator $this, PathLikeEnv pathLikeEnv, String newValue) {
        return $this.doTranslate(pathLikeEnv, newValue);
    }

    static {
        Object[] objectArray = new String[]{"PATH", "GOPATH"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"_INTELLIJ_FORCE_PREPEND_", "_INTELLIJ_FORCE_SET_"};
        MULTI_PATH_ENV_NAMES = TerminalCustomizerLocalPathTranslator.Companion.duplicateWithPrefixes(list, (String[])objectArray);
        objectArray = new String[]{"GOROOT", "GOBIN"};
        List list2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"_INTELLIJ_FORCE_SET_"};
        SINGLE_PATH_ENV_NAMES = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"JEDITERM_SOURCE"), (Iterable)TerminalCustomizerLocalPathTranslator.Companion.duplicateWithPrefixes(list2, (String[])objectArray));
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalCustomizerLocalPathTranslator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\f\"\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\rJ8\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator$Companion;", "", "<init>", "()V", "MULTI_PATH_ENV_NAMES", "", "", "SINGLE_PATH_ENV_NAMES", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "duplicateWithPrefixes", "prefixes", "", "(Ljava/util/List;[Ljava/lang/String;)Ljava/util/List;", "capturePathEnvs", "Lorg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator$PathLikeEnv;", "envNamesToCapture", "envs", "", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "canJoinWithoutSeparator", "", "entriesLeft", "entriesRight", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalCustomizerLocalPathTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCustomizerLocalPathTranslator.kt\norg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,259:1\n10468#2:260\n10890#2,2:261\n10892#2,3:267\n1563#3:263\n1634#3,3:264\n1563#3:270\n1634#3,3:271\n*S KotlinDebug\n*F\n+ 1 TerminalCustomizerLocalPathTranslator.kt\norg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator$Companion\n*L\n233#1:260\n233#1:261,2\n233#1:267,3\n234#1:263\n234#1:264,3\n244#1:270\n244#1:271,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> duplicateWithPrefixes(List<String> $this$duplicateWithPrefixes, String ... prefixes) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            String[] stringArray = prefixes;
            Collection collection = $this$duplicateWithPrefixes;
            boolean $i$f$flatMap = false;
            void var5_6 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void $this$mapTo$iv$iv;
                void element$iv$iv;
                void prefix = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl = false;
                Iterable $this$map$iv = $this$duplicateWithPrefixes;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add((String)prefix + (String)it);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        }

        /*
         * WARNING - void declaration
         */
        private final List<PathLikeEnv> capturePathEnvs(List<String> envNamesToCapture, Map<String, String> envs, EelDescriptor descriptor) {
            List list;
            if (Intrinsics.areEqual((Object)descriptor, (Object)LocalEelDescriptor.INSTANCE)) {
                list = CollectionsKt.emptyList();
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = envNamesToCapture;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string2 = envs.get(it);
                    if (string2 == null) {
                        string2 = "";
                    }
                    collection.add(new PathLikeEnv((String)it, string2));
                }
                list = (List)destination$iv$iv;
            }
            return list;
        }

        private final boolean canJoinWithoutSeparator(String entriesLeft, String entriesRight, EelDescriptor descriptor) {
            return ((CharSequence)entriesLeft).length() == 0 || ((CharSequence)entriesRight).length() == 0 || StringsKt.endsWith$default((String)entriesLeft, (String)EelPlatformKt.getPathSeparator((EelOsFamily)descriptor.getOsFamily()), (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)entriesRight, (String)EelPlatformKt.getPathSeparator((EelOsFamily)descriptor.getOsFamily()), (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator$PathLikeEnv;", "", "name", "", "prevValue", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getPrevValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.terminal"})
    private static final class PathLikeEnv {
        @NotNull
        private final String name;
        @NotNull
        private final String prevValue;

        public PathLikeEnv(@NotNull String name, @NotNull String prevValue) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)prevValue, (String)"prevValue");
            this.name = name;
            this.prevValue = prevValue;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getPrevValue() {
            return this.prevValue;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.prevValue;
        }

        @NotNull
        public final PathLikeEnv copy(@NotNull String name, @NotNull String prevValue) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)prevValue, (String)"prevValue");
            return new PathLikeEnv(name, prevValue);
        }

        public static /* synthetic */ PathLikeEnv copy$default(PathLikeEnv pathLikeEnv, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = pathLikeEnv.name;
            }
            if ((n & 2) != 0) {
                string2 = pathLikeEnv.prevValue;
            }
            return pathLikeEnv.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "PathLikeEnv(name=" + this.name + ", prevValue=" + this.prevValue + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.prevValue.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathLikeEnv)) {
                return false;
            }
            PathLikeEnv pathLikeEnv = (PathLikeEnv)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)pathLikeEnv.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.prevValue, (Object)pathLikeEnv.prevValue);
        }
    }
}

