/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.util;

import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0080\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\f\u001a\u00020\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eJ\u0006\u0010\u000f\u001a\u00020\bJ\u0006\u0010\u0010\u001a\u00020\u0011J\t\u0010\u0012\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c2\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0011H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/terminal/util/TerminalSettingsFloatValueImpl;", "", "rawIntValue", "", "digits", "<init>", "(II)V", "multiplier", "", "actualDigits", "getActualDigits", "()I", "coerceIn", "range", "Lkotlin/ranges/ClosedFloatingPointRange;", "toFloat", "toFormattedString", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "intellij.terminal"})
public final class TerminalSettingsFloatValueImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int rawIntValue;
    private final int digits;
    private final float multiplier;

    public TerminalSettingsFloatValueImpl(int rawIntValue, int digits) {
        this.rawIntValue = rawIntValue;
        this.digits = digits;
        this.multiplier = TerminalSettingsFloatValueImpl.Companion.multiplier(this.digits);
    }

    private final int getActualDigits() {
        int actualDigits = this.digits;
        int value = this.rawIntValue;
        while (actualDigits > 1 && value % 10 == 0) {
            --actualDigits;
            value /= 10;
        }
        return actualDigits;
    }

    @NotNull
    public final TerminalSettingsFloatValueImpl coerceIn(@NotNull ClosedFloatingPointRange<Float> range) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        return Companion.ofFloat(((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(this.toFloat()), range))).floatValue(), this.digits);
    }

    public final float toFloat() {
        return (float)this.rawIntValue / this.multiplier;
    }

    @NotNull
    public final String toFormattedString() {
        Locale locale = Locale.ROOT;
        String string = "%." + this.getActualDigits() + "f";
        Object[] objectArray = new Object[]{Float.valueOf(this.toFloat())};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final int component1() {
        return this.rawIntValue;
    }

    private final int component2() {
        return this.digits;
    }

    @NotNull
    public final TerminalSettingsFloatValueImpl copy(int rawIntValue, int digits) {
        return new TerminalSettingsFloatValueImpl(rawIntValue, digits);
    }

    public static /* synthetic */ TerminalSettingsFloatValueImpl copy$default(TerminalSettingsFloatValueImpl terminalSettingsFloatValueImpl, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = terminalSettingsFloatValueImpl.rawIntValue;
        }
        if ((n3 & 2) != 0) {
            n2 = terminalSettingsFloatValueImpl.digits;
        }
        return terminalSettingsFloatValueImpl.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "TerminalSettingsFloatValueImpl(rawIntValue=" + this.rawIntValue + ", digits=" + this.digits + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.rawIntValue);
        result = result * 31 + Integer.hashCode(this.digits);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TerminalSettingsFloatValueImpl)) {
            return false;
        }
        TerminalSettingsFloatValueImpl terminalSettingsFloatValueImpl = (TerminalSettingsFloatValueImpl)other;
        if (this.rawIntValue != terminalSettingsFloatValueImpl.rawIntValue) {
            return false;
        }
        return this.digits == terminalSettingsFloatValueImpl.digits;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/terminal/util/TerminalSettingsFloatValueImpl$Companion;", "", "<init>", "()V", "ofFloat", "Lorg/jetbrains/plugins/terminal/util/TerminalSettingsFloatValueImpl;", "value", "", "digits", "", "parse", "", "defaultValue", "multiplier", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TerminalSettingsFloatValueImpl ofFloat(float value, int digits) {
            return new TerminalSettingsFloatValueImpl(MathKt.roundToInt((float)(value * this.multiplier(digits))), digits);
        }

        @NotNull
        public final TerminalSettingsFloatValueImpl parse(@NotNull String value, float defaultValue, int digits) {
            TerminalSettingsFloatValueImpl terminalSettingsFloatValueImpl;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                terminalSettingsFloatValueImpl = this.ofFloat(Float.parseFloat(value), digits);
            }
            catch (Exception exception) {
                terminalSettingsFloatValueImpl = this.ofFloat(defaultValue, digits);
            }
            return terminalSettingsFloatValueImpl;
        }

        private final float multiplier(int digits) {
            return (float)Math.pow(10.0f, digits);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

