/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.metrics.benchmark;

import com.intellij.openapi.application.PathManager;
import com.intellij.tools.ide.metrics.collector.MetricsCollector;
import com.intellij.tools.ide.metrics.collector.metrics.CollectionExtensionKt;
import com.intellij.tools.ide.metrics.collector.metrics.PerformanceMetrics;
import com.intellij.tools.ide.metrics.collector.telemetry.OpentelemetrySpanJsonParser;
import com.intellij.tools.ide.metrics.collector.telemetry.SpanElement;
import com.intellij.tools.ide.metrics.collector.telemetry.SpanFilter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0016J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/tools/ide/metrics/benchmark/BenchmarksSpanMetricsCollector;", "Lcom/intellij/tools/ide/metrics/collector/MetricsCollector;", "spanName", "", "telemetryJsonFile", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "getSpanName", "()Ljava/lang/String;", "collect", "", "Lcom/intellij/tools/ide/metrics/collector/metrics/PerformanceMetrics$Metric;", "logsDirPath", "getAttemptsSpansStatisticalMetrics", "attempts", "metricsPrefix", "getAggregatedCustomSpansMetricsReportedFromTests", "customMetrics", "extractOpenTelemetrySpanMetrics", "forWarmup", "", "Companion", "intellij.tools.ide.metrics.benchmark"})
@SourceDebugExtension(value={"SMAP\nBenchmarksSpanMetricsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BenchmarksSpanMetricsCollector.kt\ncom/intellij/tools/ide/metrics/benchmark/BenchmarksSpanMetricsCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,80:1\n1586#2:81\n1661#2,3:82\n1512#2:86\n1538#2,3:87\n1541#2,3:97\n1586#2:103\n1661#2,3:104\n1586#2:108\n1661#2,3:109\n777#2:112\n873#2,2:113\n1068#2:115\n629#2,12:116\n832#2:128\n862#2,2:129\n1#3:85\n383#4,7:90\n129#5:100\n158#5,2:101\n160#5:107\n*S KotlinDebug\n*F\n+ 1 BenchmarksSpanMetricsCollector.kt\ncom/intellij/tools/ide/metrics/benchmark/BenchmarksSpanMetricsCollector\n*L\n24#1:81\n24#1:82,3\n47#1:86\n47#1:87,3\n47#1:97,3\n49#1:103\n49#1:104,3\n56#1:108\n56#1:109,3\n63#1:112\n63#1:113,2\n65#1:115\n72#1:116,12\n75#1:128\n75#1:129,2\n47#1:90,7\n48#1:100\n48#1:101,2\n48#1:107\n*E\n"})
public final class BenchmarksSpanMetricsCollector
implements MetricsCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String spanName;
    @NotNull
    private final Path telemetryJsonFile;

    public BenchmarksSpanMetricsCollector(@NotNull String spanName, @NotNull Path telemetryJsonFile) {
        Intrinsics.checkNotNullParameter((Object)spanName, (String)"spanName");
        Intrinsics.checkNotNullParameter((Object)telemetryJsonFile, (String)"telemetryJsonFile");
        this.spanName = spanName;
        this.telemetryJsonFile = telemetryJsonFile;
    }

    public /* synthetic */ BenchmarksSpanMetricsCollector(String string, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path = Companion.getDefaultPathToTelemetrySpanJson();
        }
        this(string, path);
    }

    @NotNull
    public final String getSpanName() {
        return this.spanName;
    }

    @NotNull
    public List<PerformanceMetrics.Metric> collect(@NotNull Path logsDirPath) {
        Intrinsics.checkNotNullParameter((Object)logsDirPath, (String)"logsDirPath");
        List list = CollectionsKt.plus((Collection)this.extractOpenTelemetrySpanMetrics(this.spanName, true), (Iterable)this.extractOpenTelemetrySpanMetrics(this.spanName, false));
        if (list == null) {
            boolean bl = false;
            String string = "Unable to extract metrics for '" + this.spanName + "' from " + this.telemetryJsonFile;
            throw new IllegalArgumentException(string.toString());
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PerformanceMetrics.Metric> getAttemptsSpansStatisticalMetrics(List<PerformanceMetrics.Metric> attempts, String metricsPrefix) {
        Object object;
        Collection<Integer> collection;
        Object[] objectArray2;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = attempts;
        String string = metricsPrefix + "attempt.mean.ms";
        PerformanceMetrics.Companion companion = PerformanceMetrics.Companion;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Iterator destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            objectArray2 = (PerformanceMetrics.Metric)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.value);
        }
        collection = (List)((Object)destination$iv$iv);
        PerformanceMetrics.Metric attemptMeanMetric = companion.newDuration(string, (int)CollectionsKt.averageOfInt((Iterable)collection));
        PerformanceMetrics.Metric attemptMedianMetric = PerformanceMetrics.Companion.newDuration(metricsPrefix + "attempt.median.ms", CollectionExtensionKt.medianValue((Iterable)attempts));
        $this$mapTo$iv$iv = attempts;
        string = metricsPrefix + "attempt.min.ms";
        companion = PerformanceMetrics.Companion;
        destination$iv$iv = $this$mapTo$iv$iv.iterator();
        if (!destination$iv$iv.hasNext()) {
            object = null;
        } else {
            Object it = (PerformanceMetrics.Metric)destination$iv$iv.next();
            boolean bl = false;
            it = ((PerformanceMetrics.Metric)it).value;
            while (destination$iv$iv.hasNext()) {
                Object it2 = (PerformanceMetrics.Metric)destination$iv$iv.next();
                $i$a$-minOfOrNull-BenchmarksSpanMetricsCollector$getAttemptsSpansStatisticalMetrics$attemptMinMetric$1 = false;
                it2 = it2.value;
                if (it.compareTo(it2) <= 0) continue;
                it = it2;
            }
            object = it;
        }
        Collection<Integer> collection2 = collection = object;
        Intrinsics.checkNotNull(collection2);
        PerformanceMetrics.Metric attemptMinMetric = companion.newDuration(string, ((Number)((Object)collection2)).intValue());
        PerformanceMetrics.Metric attemptRangeMetric = PerformanceMetrics.Companion.newDuration(metricsPrefix + "attempt.range.ms", CollectionExtensionKt.rangeValue((Iterable)attempts));
        Iterable it = attempts;
        string = metricsPrefix + "attempt.sum.ms";
        companion = PerformanceMetrics.Companion;
        int it2 = 0;
        for (Object[] objectArray2 : it) {
            void it3;
            Object bl = objectArray2;
            int n = it2;
            boolean bl2 = false;
            int n2 = it3.value;
            it2 = n + n2;
        }
        int n = it2;
        PerformanceMetrics.Metric attemptSumMetric = companion.newDuration(string, n);
        PerformanceMetrics.Metric attemptCountMetric = PerformanceMetrics.Companion.newCounter(metricsPrefix + "attempt.count", attempts.size());
        PerformanceMetrics.Metric attemptStandardDeviationMetric = PerformanceMetrics.Companion.newDuration(metricsPrefix + "attempt.standard.deviation", CollectionExtensionKt.standardDeviationValue((Iterable)attempts));
        PerformanceMetrics.Metric attemptMadMetric = PerformanceMetrics.Companion.newDuration(metricsPrefix + "attempt.mad.ms", CollectionExtensionKt.madValue((Iterable)attempts));
        objectArray2 = new PerformanceMetrics.Metric[]{attemptMeanMetric, attemptMedianMetric, attemptMinMetric, attemptRangeMetric, attemptSumMetric, attemptCountMetric, attemptStandardDeviationMetric, attemptMadMetric};
        return CollectionsKt.listOf((Object[])objectArray2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PerformanceMetrics.Metric> getAggregatedCustomSpansMetricsReportedFromTests(List<PerformanceMetrics.Metric> customMetrics, String metricsPrefix) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        Object value$iv$iv$iv;
        Object object;
        Object key$iv$iv;
        boolean bl;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = customMetrics;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            Object t = iterator.next();
            PerformanceMetrics.Metric it = (PerformanceMetrics.Metric)t;
            bl = false;
            key$iv$iv = it.id.getName();
            object = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(t);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void group;
            list$iv$iv = entry;
            Object object3 = destination$iv$iv;
            bl = false;
            key$iv$iv = (Iterable)group.getValue();
            object = metricsPrefix + group.getKey();
            PerformanceMetrics.Companion companion = PerformanceMetrics.Companion;
            boolean $i$f$map2 = false;
            value$iv$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                PerformanceMetrics.Metric metric = (PerformanceMetrics.Metric)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(it.value);
            }
            collection = (List)destination$iv$iv2;
            object3.add(companion.newDuration((String)object, (int)CollectionsKt.averageOfInt((Iterable)collection)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PerformanceMetrics.Metric> extractOpenTelemetrySpanMetrics(String spanName, boolean forWarmup) {
        void $this$filterNotTo$iv$iv;
        List attempts;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = new OpentelemetrySpanJsonParser(SpanFilter.Companion.any()).getSpanElements(this.telemetryJsonFile, arg_0 -> BenchmarksSpanMetricsCollector.extractOpenTelemetrySpanMetrics$lambda$0(spanName, forWarmup, arg_0));
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SpanElement spanElement = (SpanElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PerformanceMetrics.Companion.newDuration(it.name, (int)Duration.getInWholeMilliseconds-impl((long)it.getDuration-UwyO8pc())));
        }
        List originalMetrics = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        String attemptSuffix = "Attempt";
        String metricsPrefix = "";
        if (forWarmup) {
            metricsPrefix = "warmup.";
        }
        Iterable $this$filter$iv = originalMetrics;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PerformanceMetrics.Metric it = (PerformanceMetrics.Metric)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith((String)it.id.getName(), (String)attemptSuffix, (boolean)true)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List allAttempts = (List)destination$iv$iv2;
        int worstCount = (int)((double)allAttempts.size() * 0.05);
        if (forWarmup) {
            v0 = allAttempts;
        } else {
            Iterable $this$sortedBy$iv = allAttempts;
            boolean $i$f$sortedBy = false;
            v0 = attempts = CollectionsKt.dropLast((List)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PerformanceMetrics.Metric it = (PerformanceMetrics.Metric)a;
                    boolean bl = false;
                    it = (PerformanceMetrics.Metric)b;
                    Comparable comparable = Integer.valueOf(it.value);
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.value));
                }
            }), (int)worstCount);
        }
        if (forWarmup && attempts.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List<PerformanceMetrics.Metric> attemptsStatisticalMetrics = this.getAttemptsSpansStatisticalMetrics(attempts, metricsPrefix);
        Iterable $this$single$iv = originalMetrics;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            PerformanceMetrics.Metric it = (PerformanceMetrics.Metric)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.id.getName(), (Object)spanName)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        int mainMetricValue = ((PerformanceMetrics.Metric)single$iv).value;
        PerformanceMetrics.Metric totalTestDurationMetric = PerformanceMetrics.Companion.newDuration(metricsPrefix + "total.test.duration.ms", mainMetricValue);
        Iterable $this$filterNot$iv = originalMetrics;
        boolean $i$f$filterNot = false;
        Iterable bl = $this$filterNot$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            PerformanceMetrics.Metric it = (PerformanceMetrics.Metric)element$iv$iv;
            boolean bl2 = false;
            if (StringsKt.startsWith((String)it.id.getName(), (String)attemptSuffix, (boolean)true) || Intrinsics.areEqual((Object)it.id.getName(), (Object)spanName)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List customMetrics = (List)destination$iv$iv3;
        List<PerformanceMetrics.Metric> aggregatedCustomMetrics = this.getAggregatedCustomSpansMetricsReportedFromTests(customMetrics, metricsPrefix);
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)attemptsStatisticalMetrics, (Object)totalTestDurationMetric), (Iterable)aggregatedCustomMetrics);
    }

    private static final boolean extractOpenTelemetrySpanMetrics$lambda$0(String $spanName, boolean $forWarmup, SpanElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.name, (Object)$spanName) && it.isWarmup == $forWarmup;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/tools/ide/metrics/benchmark/BenchmarksSpanMetricsCollector$Companion;", "", "<init>", "()V", "getDefaultPathToTelemetrySpanJson", "Ljava/nio/file/Path;", "intellij.tools.ide.metrics.benchmark"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path getDefaultPathToTelemetrySpanJson() {
            Path path = Path.of(System.getProperty("idea.diagnostic.opentelemetry.file", ((Object)PathManager.getLogDir().resolve("opentelemetry.json").toAbsolutePath()).toString()), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

