/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.metrics.benchmark;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.testFramework.BenchmarkTestInfo;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.ProfilerForTests;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.tools.ide.metrics.benchmark.BenchmarksSpanMetricsCollector;
import com.intellij.tools.ide.metrics.benchmark.IJPerfBenchmarksMetricsPublisher;
import com.intellij.tools.ide.metrics.collector.MetricsCollector;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StorageLockContext;
import io.opentelemetry.api.trace.SpanBuilder;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kotlin.coroutines.CoroutineContext;
import kotlin.reflect.KFunction;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BenchmarkTestInfoImpl
implements BenchmarkTestInfo {
    private ThrowableComputable<Integer, ?> test;
    private int expectedInputSize;
    private ThrowableRunnable<?> setup;
    private int maxMeasurementAttempts;
    public String launchName;
    private int warmupIterations;
    private String uniqueTestName;
    @NotNull
    private final IJTracer tracer;
    private final ArrayList<MetricsCollector> metricsCollectors;
    private boolean setInStressTest;
    private boolean useDefaultSpanMetricExporter;
    private static final CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob(null).plus((CoroutineContext)Dispatchers.getIO()));

    public BenchmarkTestInfoImpl disableDefaultSpanMetricsExporter() {
        this.useDefaultSpanMetricExporter = false;
        return this;
    }

    private static void initOpenTelemetry() {
        System.setProperty("idea.diagnostic.opentelemetry.file", PathManager.getLogDir().resolve("opentelemetry.json").toAbsolutePath().toString());
        TelemetryManager telemetryInstance = TelemetryManager.getInstance();
        if (telemetryInstance.hasSpanExporters()) {
            return;
        }
        System.err.printf("%nTelemetry instance will be overriden since span exporters aren't registered. This means your metrics (meters or spans), configured before any test execution will not be reported. Consider using TestApplication that will setup proper instance of telemetry.%n", new Object[0]);
        try {
            TelemetryManager.Companion.resetGlobalSdk();
            Class<?> telemetryClazz = Class.forName("com.intellij.platform.diagnostic.telemetry.impl.TelemetryManagerImpl");
            Object instance = Arrays.stream(telemetryClazz.getDeclaredConstructors()).filter(it -> it.getParameterCount() > 0).findFirst().get().newInstance(coroutineScope, true);
            TelemetryManager.Companion.forceSetTelemetryManager((TelemetryManager)instance);
        }
        catch (Throwable e) {
            System.err.println("Couldn't setup TelemetryManager without TestApplication. Either test should use TestApplication or somewhere is a bug");
            e.printStackTrace();
        }
    }

    private static void cleanupOutdatedMetrics() {
        try {
            TelemetryManager.getInstance().resetExportersBlocking();
            IJPerfBenchmarksMetricsPublisher.Companion.truncateTestLog();
            try (Stream<Path> logDirChildren = Files.list(PathManager.getLogDir());){
                logDirChildren.filter(child -> {
                    String name = child.toString();
                    return name.contains("-metrics") || name.contains("-meters") || name.endsWith(".jfr");
                }).forEach(childToRemove -> {
                    try {
                        Files.deleteIfExists(childToRemove);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
        }
        catch (Exception e) {
            System.err.println("Error during removing Telemetry files with meters before start of perf test. This might affect collected metrics value.");
            e.printStackTrace();
        }
    }

    public BenchmarkTestInfoImpl(@NotNull ThrowableComputable<Integer, ?> test, int expectedInputSize, @NotNull String launchName) {
        if (test == null) {
            BenchmarkTestInfoImpl.$$$reportNull$$$0(0);
        }
        if (launchName == null) {
            BenchmarkTestInfoImpl.$$$reportNull$$$0(1);
        }
        this();
        this.initialize((ThrowableComputable)test, expectedInputSize, launchName);
    }

    public BenchmarkTestInfoImpl() {
        this.maxMeasurementAttempts = 3;
        this.warmupIterations = 1;
        this.metricsCollectors = new ArrayList();
        this.setInStressTest = false;
        this.useDefaultSpanMetricExporter = true;
        BenchmarkTestInfoImpl.initOpenTelemetry();
        BenchmarkTestInfoImpl.cleanupOutdatedMetrics();
        this.tracer = TelemetryManager.getInstance().getTracer(new Scope("benchmarkUnitTests", null));
    }

    public BenchmarkTestInfoImpl initialize(@NotNull ThrowableComputable<Integer, ?> test, int expectedInputSize, @NotNull String launchName) {
        if (test == null) {
            BenchmarkTestInfoImpl.$$$reportNull$$$0(2);
        }
        if (launchName == null) {
            BenchmarkTestInfoImpl.$$$reportNull$$$0(3);
        }
        this.test = test;
        this.expectedInputSize = expectedInputSize;
        assert (expectedInputSize > 0) : "Expected input size must be > 0. Was: " + expectedInputSize;
        this.launchName = launchName;
        return this;
    }

    @Contract(pure=true)
    public BenchmarkTestInfoImpl setup(@NotNull ThrowableRunnable<?> setup) {
        if (setup == null) {
            BenchmarkTestInfoImpl.$$$reportNull$$$0(4);
        }
        assert (this.setup == null);
        this.setup = setup;
        return this;
    }

    @Contract(pure=true)
    public BenchmarkTestInfoImpl attempts(int attempts) {
        this.maxMeasurementAttempts = attempts;
        return this;
    }

    @Contract(pure=true)
    public BenchmarkTestInfoImpl withMetricsCollector(MetricsCollector meterCollector) {
        this.metricsCollectors.add(meterCollector);
        return this;
    }

    @Contract(pure=true)
    public BenchmarkTestInfoImpl warmupIterations(int iterations) {
        this.warmupIterations = iterations;
        return this;
    }

    @Contract(pure=true)
    public BenchmarkTestInfoImpl runAsStressTest() {
        this.setInStressTest = true;
        return this;
    }

    public String getUniqueTestName() {
        return this.uniqueTestName;
    }

    private static Method filterMethodFromStackTrace(Function<Method, Boolean> methodFilter) {
        StackTraceElement[] stackTraceElements;
        for (StackTraceElement element : stackTraceElements = Thread.currentThread().getStackTrace()) {
            try {
                Method foundMethod = (Method)ContainerUtil.find((Object[])Class.forName(element.getClassName()).getDeclaredMethods(), method -> method.getName().equals(element.getMethodName()) && (Boolean)methodFilter.apply((Method)method) != false);
                if (foundMethod == null) continue;
                return foundMethod;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Method tryToFindCallingTestMethodByJUnitAnnotation() {
        return BenchmarkTestInfoImpl.filterMethodFromStackTrace(method -> ContainerUtil.exists((Object[])method.getDeclaredAnnotations(), annotation -> annotation.annotationType().getName().contains("junit")));
    }

    private static Method tryToFindCallingTestMethodByNamePattern() {
        return BenchmarkTestInfoImpl.filterMethodFromStackTrace(method -> method.getName().toLowerCase(Locale.ROOT).startsWith("test"));
    }

    private static Method getCallingTestMethod() {
        Method callingTestMethod = BenchmarkTestInfoImpl.tryToFindCallingTestMethodByJUnitAnnotation();
        if (callingTestMethod == null && (callingTestMethod = BenchmarkTestInfoImpl.tryToFindCallingTestMethodByNamePattern()) == null) {
            throw new AssertionError((Object)"Couldn't manage to detect the calling test method. Please use one of the overloads of com.intellij.tools.ide.metrics.benchmark.BenchmarkTestInfoImpl.start()");
        }
        return callingTestMethod;
    }

    public void start() {
        if (this.setInStressTest) {
            boolean wasInStressTestBefore = ApplicationManagerEx.isInStressTest();
            ApplicationManagerEx.setInStressTest((boolean)true);
            try {
                this.start(BenchmarkTestInfoImpl.getCallingTestMethod(), this.launchName);
            }
            finally {
                ApplicationManagerEx.setInStressTest((boolean)wasInStressTestBefore);
            }
        } else {
            Application app = ApplicationManager.getApplication();
            if (app != null && !ApplicationManagerEx.isInStressTest()) {
                Logger log = Logger.getInstance(BenchmarkTestInfoImpl.class);
                log.error("ApplicationManagerEx.isInStressTest=false -- not good for reliable benchmarks!\nEither use .runInStressTest() on the benchmark, or @StressTestApplication on the test itself");
            }
            this.start(BenchmarkTestInfoImpl.getCallingTestMethod(), this.launchName);
        }
    }

    public void start(@NotNull Method javaTestMethod, String subTestName) {
        if (javaTestMethod == null) {
            BenchmarkTestInfoImpl.$$$reportNull$$$0(5);
        }
        Object fullTestName = String.format("%s.%s", javaTestMethod.getDeclaringClass().getName(), javaTestMethod.getName());
        if (subTestName != null && !subTestName.isEmpty()) {
            fullTestName = (String)fullTestName + " - " + subTestName;
        }
        this.start((String)fullTestName);
    }

    public void start(@NotNull KFunction<?> kotlinTestMethod) {
        if (kotlinTestMethod == null) {
            BenchmarkTestInfoImpl.$$$reportNull$$$0(6);
        }
        this.start(String.format("%s.%s", kotlinTestMethod.getClass().getName(), kotlinTestMethod.getName()));
    }

    public void startAsSubtest() {
        this.startAsSubtest(this.launchName);
    }

    public void startAsSubtest(@Nullable String subTestName) {
        this.start(BenchmarkTestInfoImpl.getCallingTestMethod(), subTestName);
    }

    public void start(String fullQualifiedTestMethodName) {
        String sanitizedFullQualifiedTestMethodName = BenchmarkTestInfoImpl.sanitizeFullTestNameForArtifactPublishing(fullQualifiedTestMethodName);
        this.start(IterationMode.WARMUP, sanitizedFullQualifiedTestMethodName);
        this.start(IterationMode.MEASURE, sanitizedFullQualifiedTestMethodName);
    }

    public String getLaunchName() {
        return this.launchName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(IterationMode iterationType, String uniqueTestName) {
        this.uniqueTestName = uniqueTestName;
        if (PlatformTestUtil.COVERAGE_ENABLED_BUILD) {
            return;
        }
        System.out.printf("Starting benchmark test \"%s\" in mode: %s%n", new Object[]{uniqueTestName, iterationType});
        int maxIterationsNumber = iterationType.equals((Object)IterationMode.WARMUP) ? this.warmupIterations : this.maxMeasurementAttempts;
        if (maxIterationsNumber == 1) {
            System.gc();
        }
        try {
            TraceKt.use((SpanBuilder)this.tracer.spanBuilder(uniqueTestName).setAttribute("warmup", String.valueOf(iterationType.equals((Object)IterationMode.WARMUP))), __ -> {
                try {
                    PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
                    for (int attempt = 1; attempt <= maxIterationsNumber; ++attempt) {
                        if (this.setup != null) {
                            this.setup.run();
                        }
                        AtomicInteger actualInputSize = new AtomicInteger(this.expectedInputSize);
                        Supplier<Object> perfTestWorkload = this.getPerfTestWorkloadSupplier(iterationType, attempt, actualInputSize);
                        TraceKt.use((SpanBuilder)this.tracer.spanBuilder("Attempt: " + attempt).setAttribute("warmup", String.valueOf(iterationType.equals((Object)IterationMode.WARMUP))), ignore -> perfTestWorkload.get());
                        if (!UsefulTestCase.IS_UNDER_TEAMCITY) {
                            // empty if block
                        }
                        System.gc();
                        StorageLockContext.forceDirectMemoryCache();
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtil.rethrowUnchecked((Throwable)throwable);
                    throw new RuntimeException(throwable);
                }
                return null;
            });
        }
        finally {
            try {
                if (iterationType.equals((Object)IterationMode.MEASURE)) {
                    ArrayList<MetricsCollector> collectors = new ArrayList<MetricsCollector>();
                    if (this.useDefaultSpanMetricExporter) {
                        collectors.add(new BenchmarksSpanMetricsCollector(uniqueTestName, BenchmarksSpanMetricsCollector.Companion.getDefaultPathToTelemetrySpanJson()));
                    }
                    collectors.addAll(this.metricsCollectors);
                    IJPerfBenchmarksMetricsPublisher.Companion.publishSync(uniqueTestName, collectors.toArray(new MetricsCollector[0]));
                }
            }
            catch (Throwable t) {
                System.err.println("Something unexpected happened during publishing benchmark metrics");
                throw t;
            }
        }
    }

    @NotNull
    private Supplier<Object> getPerfTestWorkloadSupplier(IterationMode iterationType, int attempt, AtomicInteger actualInputSize) {
        Supplier<Object> supplier = () -> {
            try {
                Profiler.startProfiling(iterationType.name() + attempt);
                actualInputSize.set((Integer)this.test.compute());
            }
            catch (Throwable e) {
                ExceptionUtil.rethrowUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                Profiler.stopProfiling();
            }
            return null;
        };
        if (supplier == null) {
            BenchmarkTestInfoImpl.$$$reportNull$$$0(7);
        }
        return supplier;
    }

    @NotNull
    private static String sanitizeFullTestNameForArtifactPublishing(@NotNull String fullTestName) {
        String string;
        if (fullTestName == null) {
            BenchmarkTestInfoImpl.$$$reportNull$$$0(8);
        }
        try {
            Path.of("./" + fullTestName, new String[0]);
            string = fullTestName;
        }
        catch (InvalidPathException e) {
            String string2 = FileUtil.sanitizeFileName((String)fullTestName, (boolean)false);
            if (string2 == null) {
                BenchmarkTestInfoImpl.$$$reportNull$$$0(10);
            }
            return string2;
        }
        if (string == null) {
            BenchmarkTestInfoImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    static {
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaTestMethod";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinTestMethod";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tools/ide/metrics/benchmark/BenchmarkTestInfoImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullTestName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tools/ide/metrics/benchmark/BenchmarkTestInfoImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPerfTestWorkloadSupplier";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeFullTestNameForArtifactPublishing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setup";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeFullTestNameForArtifactPublishing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 10 -> new IllegalStateException(string);
        };
    }

    private static enum IterationMode {
        WARMUP,
        MEASURE;

    }

    private static final class Profiler {
        private static final ProfilerForTests profiler = Profiler.getProfilerInstance();

        private Profiler() {
        }

        private static ProfilerForTests getProfilerInstance() {
            ServiceLoader<ProfilerForTests> loader = ServiceLoader.load(ProfilerForTests.class);
            for (ProfilerForTests service : loader) {
                if (service == null) continue;
                return service;
            }
            System.out.println("No service com.intellij.testFramework.Profiler is found in class path");
            return null;
        }

        public static void stopProfiling() {
            if (profiler != null) {
                try {
                    profiler.stopProfiling();
                }
                catch (IOException e) {
                    System.out.println("Can't stop profiling");
                }
            }
        }

        public static void startProfiling(String fileName) {
            Path logDir = PathManager.getLogDir();
            if (profiler != null) {
                try {
                    profiler.startProfiling(logDir, fileName);
                }
                catch (IllegalStateException e) {
                    System.out.println(e.getMessage());
                }
                catch (IOException e) {
                    System.out.println("Can't start profiling");
                }
            }
        }
    }
}

