/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.metrics.collector.starter.fus;

import com.intellij.ide.starter.ide.IDETestContext;
import com.intellij.internal.statistic.eventLog.SerializationHelper;
import com.intellij.tools.ide.util.common.LoggingKt;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001b\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u0013J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0016\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/tools/ide/metrics/collector/starter/fus/StatisticsEventsHarvester;", "", "eventLogsDir", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "testContext", "Lcom/intellij/ide/starter/ide/IDETestContext;", "recorder", "", "(Lcom/intellij/ide/starter/ide/IDETestContext;Ljava/lang/String;)V", "getStatisticEventsByGroup", "", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "groupId", "failOnNoEventsWritten", "", "getStatisticEvents", "filter", "Lkotlin/Function1;", "getStatisticsLogFiles", "deserializeEventLogFile", "eventLogPath", "intellij.tools.ide.metrics.collector.starter"})
@SourceDebugExtension(value={"SMAP\nStatisticsEventsHarvester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsEventsHarvester.kt\ncom/intellij/tools/ide/metrics/collector/starter/fus/StatisticsEventsHarvester\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ReadWrite.kt\nkotlin/io/TextStreamsKt\n*L\n1#1,68:1\n1374#2:69\n1460#2,5:70\n774#2:75\n865#2,2:76\n1#3:78\n1#3:80\n57#4:79\n*S KotlinDebug\n*F\n+ 1 StatisticsEventsHarvester.kt\ncom/intellij/tools/ide/metrics/collector/starter/fus/StatisticsEventsHarvester\n*L\n29#1:69\n29#1:70,5\n31#1:75\n31#1:76,2\n55#1:80\n55#1:79\n*E\n"})
public final class StatisticsEventsHarvester {
    @NotNull
    private final Path eventLogsDir;

    public StatisticsEventsHarvester(@NotNull Path eventLogsDir) {
        Intrinsics.checkNotNullParameter((Object)eventLogsDir, (String)"eventLogsDir");
        this.eventLogsDir = eventLogsDir;
    }

    public StatisticsEventsHarvester(@NotNull IDETestContext testContext, @NotNull String recorder) {
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
        Path path = testContext.getPaths().getEventLogDataDir().resolve("logs/" + recorder);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this(path);
    }

    public /* synthetic */ StatisticsEventsHarvester(IDETestContext iDETestContext, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "FUS";
        }
        this(iDETestContext, string);
    }

    @NotNull
    public final List<LogEvent> getStatisticEventsByGroup(@NotNull String groupId, boolean failOnNoEventsWritten) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.getStatisticEvents(failOnNoEventsWritten, (Function1<? super LogEvent, Boolean>)((Function1)arg_0 -> StatisticsEventsHarvester.getStatisticEventsByGroup$lambda$0(groupId, arg_0)));
    }

    public static /* synthetic */ List getStatisticEventsByGroup$default(StatisticsEventsHarvester statisticsEventsHarvester, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return statisticsEventsHarvester.getStatisticEventsByGroup(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LogEvent> getStatisticEvents(boolean failOnNoEventsWritten, @NotNull Function1<? super LogEvent, Boolean> filter) {
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        List<Path> logs = this.getStatisticsLogFiles(failOnNoEventsWritten);
        Iterable $this$flatMap$iv = logs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.deserializeEventLogFile(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allEvents = (List)destination$iv$iv;
        Iterable $this$filter$iv = allEvents;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)filter.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getStatisticEvents$default(StatisticsEventsHarvester statisticsEventsHarvester, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            function1 = StatisticsEventsHarvester::getStatisticEvents$lambda$0;
        }
        return statisticsEventsHarvester.getStatisticEvents(bl, (Function1<? super LogEvent, Boolean>)function1);
    }

    private final List<Path> getStatisticsLogFiles(boolean failOnNoEventsWritten) {
        if (failOnNoEventsWritten) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(this.eventLogsDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                boolean bl = false;
                String string = "Statistics logs folder must exists at " + this.eventLogsDir;
                throw new IllegalArgumentException(string.toString());
            }
        } else {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(this.eventLogsDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return CollectionsKt.emptyList();
            }
        }
        List logFiles = PathsKt.listDirectoryEntries((Path)this.eventLogsDir, (String)"*.log");
        logFiles = CollectionsKt.sortedWith((Iterable)logFiles, (arg_0, arg_1) -> StatisticsEventsHarvester.getStatisticsLogFiles$lambda$2(StatisticsEventsHarvester::getStatisticsLogFiles$lambda$1, arg_0, arg_1));
        LoggingKt.logOutput((String)("Found statistics log files: " + logFiles));
        return logFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<LogEvent> deserializeEventLogFile(Path eventLogPath) {
        List list;
        Path path = eventLogPath;
        Object object = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(path, Arrays.copyOf(object, ((OpenOption[])object).length)), charset), n);
        Reader $this$useLines$iv = reader;
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        closeable = (BufferedReader)closeable;
        object = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl = false;
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            list = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)lines, StatisticsEventsHarvester::deserializeEventLogFile$lambda$0$0));
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return list;
    }

    private static final boolean getStatisticEventsByGroup$lambda$0(String $groupId, LogEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getGroup().getId(), (Object)$groupId);
    }

    private static final boolean getStatisticEvents$lambda$0(LogEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final int getStatisticsLogFiles$lambda$1(Path path1, Path path2) {
        Intrinsics.checkNotNull((Object)path1);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        FileTime fileTime = Files.getLastModifiedTime(path1, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
        Intrinsics.checkNotNull((Object)path2);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        FileTime fileTime2 = Files.getLastModifiedTime(path2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"getLastModifiedTime(...)");
        return fileTime.compareTo(fileTime2);
    }

    private static final int getStatisticsLogFiles$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final LogEvent deserializeEventLogFile$lambda$0$0(String it) {
        LogEvent logEvent;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            logEvent = SerializationHelper.INSTANCE.deserializeLogEvent(it);
        }
        catch (Exception e) {
            LoggingKt.logError((String)("Statistics log deserialization failure on line: " + System.lineSeparator() + it));
            throw e;
        }
        return logEvent;
    }
}

