/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.metrics.collector.starter.metrics;

import com.intellij.ide.starter.models.IDEStartResult;
import com.intellij.tools.ide.metrics.collector.metrics.MetricsSelectionStrategy;
import com.intellij.tools.ide.metrics.collector.metrics.PerformanceMetrics;
import com.intellij.tools.ide.metrics.collector.starter.collector.StarterTelemetryJsonMeterCollector;
import com.intellij.tools.ide.util.common.LoggingKt;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/tools/ide/metrics/collector/starter/metrics/CommonMetrics;", "", "<init>", "()V", "convertNsToMs", "", "", "getAwtMetrics", "", "Lcom/intellij/tools/ide/metrics/collector/metrics/PerformanceMetrics$Metric;", "startResult", "Lcom/intellij/ide/starter/models/IDEStartResult;", "getWriteActionMetrics", "getJvmMetrics", "metricsStrategies", "", "", "Lcom/intellij/tools/ide/metrics/collector/metrics/MetricsSelectionStrategy;", "intellij.tools.ide.metrics.collector.starter"})
@SourceDebugExtension(value={"SMAP\nCommonMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonMetrics.kt\ncom/intellij/tools/ide/metrics/collector/starter/metrics/CommonMetrics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,85:1\n1563#2:86\n1634#2,3:87\n1563#2:93\n1634#2,3:94\n1563#2:103\n1634#2,3:104\n77#3:90\n97#3,2:91\n99#3,3:97\n77#3:100\n97#3,2:101\n99#3,3:107\n*S KotlinDebug\n*F\n+ 1 CommonMetrics.kt\ncom/intellij/tools/ide/metrics/collector/starter/metrics/CommonMetrics\n*L\n18#1:86\n18#1:87,3\n36#1:93\n36#1:94,3\n70#1:103\n70#1:104,3\n34#1:90\n34#1:91,2\n34#1:97,3\n63#1:100\n63#1:101,2\n63#1:107,3\n*E\n"})
public final class CommonMetrics {
    @NotNull
    public static final CommonMetrics INSTANCE = new CommonMetrics();

    private CommonMetrics() {
    }

    private final int convertNsToMs(Number $this$convertNsToMs) {
        return (int)($this$convertNsToMs.longValue() / (long)1000000);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PerformanceMetrics.Metric> getAwtMetrics(@NotNull IDEStartResult startResult) {
        Intrinsics.checkNotNullParameter((Object)startResult, (String)"startResult");
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = new StarterTelemetryJsonMeterCollector(MetricsSelectionStrategy.LATEST, (Function1<? super MetricData, Boolean>)((Function1)CommonMetrics::getAwtMetrics$lambda$0)).collect(startResult.getRunContext().getLogsDir(), CommonMetrics::getAwtMetrics$lambda$1);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PerformanceMetrics.Metric metric = (PerformanceMetrics.Metric)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(PerformanceMetrics.Metric.Companion.newDuration("AWTEventQueue.dispatchTimeTotal", it.value));
            }
            return (List)destination$iv$iv;
        }
        catch (Exception e) {
            LoggingKt.logError((String)("Collecting AWT metrics: " + e.getMessage()));
            return CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PerformanceMetrics.Metric> getWriteActionMetrics(@NotNull IDEStartResult startResult) {
        Intrinsics.checkNotNullParameter((Object)startResult, (String)"startResult");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"writeAction.count", (Object)MetricsSelectionStrategy.SUM), TuplesKt.to((Object)"writeAction.wait.ms", (Object)MetricsSelectionStrategy.SUM), TuplesKt.to((Object)"writeAction.max.wait.ms", (Object)MetricsSelectionStrategy.MAXIMUM), TuplesKt.to((Object)"writeAction.median.wait.ms", (Object)MetricsSelectionStrategy.LATEST)};
        Map metricsToStrategy = MapsKt.mapOf((Pair[])pairArray);
        try {
            void $this$flatMapTo$iv$iv;
            Map $this$flatMap$iv = metricsToStrategy;
            boolean $i$f$flatMap = false;
            Map map = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$mapTo$iv$iv;
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator.next();
                boolean bl = false;
                String metricName = (String)entry.getKey();
                MetricsSelectionStrategy strategy = (MetricsSelectionStrategy)entry.getValue();
                Iterable $this$map$iv = new StarterTelemetryJsonMeterCollector(strategy, (Function1<? super MetricData, Boolean>)((Function1)arg_0 -> CommonMetrics.getWriteActionMetrics$lambda$0$0(metricName, arg_0))).collect(startResult.getRunContext());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PerformanceMetrics.Metric metric = (PerformanceMetrics.Metric)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(PerformanceMetrics.Metric.Companion.newCounter(metricName, it.value));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        catch (Exception e) {
            LoggingKt.logError((String)("Collecting Write Action metrics: " + e.getMessage()));
            return CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PerformanceMetrics.Metric> getJvmMetrics(@NotNull IDEStartResult startResult, @NotNull Map<String, ? extends MetricsSelectionStrategy> metricsStrategies) {
        Intrinsics.checkNotNullParameter((Object)startResult, (String)"startResult");
        Intrinsics.checkNotNullParameter(metricsStrategies, (String)"metricsStrategies");
        try {
            void $this$flatMapTo$iv$iv;
            Map<String, ? extends MetricsSelectionStrategy> $this$flatMap$iv = metricsStrategies;
            boolean $i$f$flatMap = false;
            Map<String, ? extends MetricsSelectionStrategy> map = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator.next();
                boolean bl = false;
                String metricName = (String)entry.getKey();
                MetricsSelectionStrategy strategy = (MetricsSelectionStrategy)entry.getValue();
                Iterable iterable = new StarterTelemetryJsonMeterCollector(strategy, (Function1<? super MetricData, Boolean>)((Function1)arg_0 -> CommonMetrics.getJvmMetrics$lambda$0$0(metricName, arg_0))).collect(startResult.getRunContext(), (Function2<? super String, ? super Long, Pair<String, Integer>>)((Function2)CommonMetrics::getJvmMetrics$lambda$0$1));
                boolean $i$f$map = false;
                void var16_17 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PerformanceMetrics.Metric metric = (PerformanceMetrics.Metric)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(StringsKt.contains$default((CharSequence)it.id.getName(), (CharSequence)"Time", (boolean)false, (int)2, null) ? PerformanceMetrics.Metric.Companion.newDuration(it.id.getName(), it.value) : PerformanceMetrics.Metric.Companion.newCounter(it.id.getName(), it.value));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        catch (Exception e) {
            LoggingKt.logError((String)("Collecting JVM metrics: " + e.getMessage()));
            return CollectionsKt.emptyList();
        }
    }

    public static /* synthetic */ List getJvmMetrics$default(CommonMetrics commonMetrics, IDEStartResult iDEStartResult, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"MEM.avgRamBytes", (Object)MetricsSelectionStrategy.LATEST), TuplesKt.to((Object)"MEM.avgRamMinusFileMappingsBytes", (Object)MetricsSelectionStrategy.LATEST), TuplesKt.to((Object)"MEM.avgRamPlusSwapMinusFileMappingsBytes", (Object)MetricsSelectionStrategy.LATEST), TuplesKt.to((Object)"MEM.avgFileMappingsRamBytes", (Object)MetricsSelectionStrategy.LATEST), TuplesKt.to((Object)"JVM.GC.collections", (Object)MetricsSelectionStrategy.SUM), TuplesKt.to((Object)"JVM.GC.collectionTimesMs", (Object)MetricsSelectionStrategy.SUM), TuplesKt.to((Object)"JVM.totalCpuTimeMs", (Object)MetricsSelectionStrategy.SUM), TuplesKt.to((Object)"JVM.maxHeapBytes", (Object)MetricsSelectionStrategy.MAXIMUM), TuplesKt.to((Object)"JVM.committedHeapBytes", (Object)MetricsSelectionStrategy.LATEST), TuplesKt.to((Object)"JVM.maxThreadCount", (Object)MetricsSelectionStrategy.MAXIMUM), TuplesKt.to((Object)"JVM.totalTimeToSafepointsMs", (Object)MetricsSelectionStrategy.SUM)};
            map = MapsKt.mapOf((Pair[])pairArray);
        }
        return commonMetrics.getJvmMetrics(iDEStartResult, map);
    }

    private static final boolean getAwtMetrics$lambda$0(MetricData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)"AWTEventQueue.dispatchTimeTotalNS");
    }

    private static final Pair getAwtMetrics$lambda$1(String name, long value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return TuplesKt.to((Object)name, (Object)INSTANCE.convertNsToMs(value));
    }

    private static final boolean getWriteActionMetrics$lambda$0$0(String $metricName, MetricData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.startsWith$default((String)string, (String)$metricName, (boolean)false, (int)2, null);
    }

    private static final boolean getJvmMetrics$lambda$0$0(String $metricName, MetricData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.startsWith$default((String)string, (String)$metricName, (boolean)false, (int)2, null);
    }

    private static final Pair getJvmMetrics$lambda$0$1(String name, long value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"Bytes", (boolean)false, (int)2, null)) {
            return TuplesKt.to((Object)StringsKt.replace$default((String)name, (String)"Bytes", (String)"Megabytes", (boolean)false, (int)4, null), (Object)((int)(value / (long)1024 / (long)1024)));
        }
        return TuplesKt.to((Object)name, (Object)((int)value));
    }
}

