/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.metrics.collector.starter.metrics;

import com.intellij.ide.starter.models.IDEStartResult;
import com.intellij.ide.starter.path.GlobalPaths;
import com.intellij.ide.starter.process.exec.ProcessExecutor;
import com.intellij.ide.starter.runner.IDERunContext;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.HttpClient;
import com.intellij.tools.ide.metrics.collector.metrics.PerformanceMetrics;
import com.intellij.tools.ide.metrics.collector.starter.metrics.GCLogAnalyzerKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u000eJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J)\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u0015\u001a\u00020\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0017\u0010 \u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/tools/ide/metrics/collector/starter/metrics/GCLogAnalyzer;", "", "ideStartResult", "Lcom/intellij/ide/starter/models/IDEStartResult;", "<init>", "(Lcom/intellij/ide/starter/models/IDEStartResult;)V", "getGCMetrics", "", "Lcom/intellij/tools/ide/metrics/collector/metrics/PerformanceMetrics$Metric;", "requestedMetrics", "", "", "([Ljava/lang/String;)Ljava/lang/Iterable;", "findExistingSummary", "Ljava/nio/file/Path;", "generateGCSummaryFile", "runGCViewer", "", "context", "Lcom/intellij/ide/starter/runner/IDERunContext;", "gcViewer", "gcSummary", "processGCSummary", "", "(Ljava/nio/file/Path;[Ljava/lang/String;)Ljava/util/List;", "extractAdditionalGcMetrics", "gcLogFile", "Ljava/io/File;", "extractConcurrentMarkCycleTimeMicroseconds", "", "line", "(Ljava/lang/String;)Ljava/lang/Integer;", "extractHeapSizeMegabytes", "Companion", "intellij.tools.ide.metrics.collector.starter"})
@SourceDebugExtension(value={"SMAP\nGCLogAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCLogAnalyzer.kt\ncom/intellij/tools/ide/metrics/collector/starter/metrics/GCLogAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n295#2,2:188\n1#3:190\n*S KotlinDebug\n*F\n+ 1 GCLogAnalyzer.kt\ncom/intellij/tools/ide/metrics/collector/starter/metrics/GCLogAnalyzer\n*L\n36#1:188,2\n*E\n"})
public final class GCLogAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IDEStartResult ideStartResult;
    @NotNull
    private static final String gcViewerUrl = "https://packages.jetbrains.team/files/p/ij/intellij-dependencies/gcviewer/gcviewer-1.37-05122022.jar";

    public GCLogAnalyzer(@NotNull IDEStartResult ideStartResult) {
        Intrinsics.checkNotNullParameter((Object)ideStartResult, (String)"ideStartResult");
        this.ideStartResult = ideStartResult;
    }

    @NotNull
    public final Iterable<PerformanceMetrics.Metric> getGCMetrics(@NotNull String[] requestedMetrics) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)requestedMetrics, (String)"requestedMetrics");
        Path path = this.ideStartResult.getRunContext().getReportsDir().resolve("gcLog.log");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        File gcLogFile = path.toFile();
        if (gcLogFile.exists()) {
            Path path2 = this.findExistingSummary();
            if (path2 == null) {
                path2 = this.generateGCSummaryFile();
            }
            Collection collection = this.processGCSummary(path2, requestedMetrics);
            Intrinsics.checkNotNull((Object)gcLogFile);
            iterable = CollectionsKt.plus((Collection)collection, (Iterable)this.extractAdditionalGcMetrics(gcLogFile));
        } else {
            iterable = CollectionsKt.emptyList();
        }
        return iterable;
    }

    public static /* synthetic */ Iterable getGCMetrics$default(GCLogAnalyzer gCLogAnalyzer, String[] stringArray, int n, Object object) {
        if ((n & 1) != 0) {
            String[] stringArray2 = new String[]{"gcPause", "fullGCPause", "gcPauseCount", "totalHeapUsedMax", "freedMemoryByGC", "freedMemoryByFullGC", "freedMemory"};
            stringArray = stringArray2;
        }
        return gCLogAnalyzer.getGCMetrics(stringArray);
    }

    private final Path findExistingSummary() {
        Path path;
        List list = FileSystem.INSTANCE.listDirectoryEntriesQuietly(this.ideStartResult.getRunContext().getReportsDir());
        if (list != null) {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Path file = (Path)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)PathsKt.getName((Path)file), (String)"gcSummary_", (boolean)false, (int)2, null)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            path = v1;
        } else {
            path = null;
        }
        return path;
    }

    @NotNull
    public final Path generateGCSummaryFile() {
        Path summaryFile = this.ideStartResult.getRunContext().getReportsDir().resolve("gcSummary_" + System.currentTimeMillis() + ".log");
        Path toolsDir = GlobalPaths.Companion.getInstance().getCacheDirectoryFor("tools");
        Path gcViewerPath = toolsDir.resolve(StringsKt.substringAfterLast$default((String)gcViewerUrl, (char)'/', null, (int)2, null));
        Intrinsics.checkNotNull((Object)gcViewerPath);
        HttpClient.downloadIfMissing-Wn2Vu4Y$default((HttpClient)HttpClient.INSTANCE, (String)gcViewerUrl, (Path)gcViewerPath, (long)0L, (long)0L, (int)12, null);
        IDERunContext iDERunContext = this.ideStartResult.getRunContext();
        Intrinsics.checkNotNull((Object)summaryFile);
        this.runGCViewer(iDERunContext, gcViewerPath, summaryFile);
        return summaryFile;
    }

    private final void runGCViewer(IDERunContext context, Path gcViewer, Path gcSummary) {
        Path path = context.getReportsDir().resolve("gcLog.log");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path gcLogPath = path.toAbsolutePath();
        List<Object> logsFiles = Files.list(context.getReportsDir()).filter(arg_0 -> GCLogAnalyzer.runGCViewer$lambda$1(GCLogAnalyzer::runGCViewer$lambda$0, arg_0)).toList();
        if (!logsFiles.isEmpty()) {
            Intrinsics.checkNotNull(logsFiles);
            String paths = CollectionsKt.joinToString$default((Iterable)logsFiles, (CharSequence)";", null, null, (int)0, null, GCLogAnalyzer::runGCViewer$lambda$2, (int)30, null);
            String command = ProcessHandle.current().info().command().orElse(null);
            Object[] objectArray = (Object[])command;
            String javaCommand = objectArray == null || StringsKt.isBlank((CharSequence)objectArray) ? "java" : command;
            try {
                objectArray = new String[]{javaCommand, "-jar", ((Object)gcViewer.toAbsolutePath()).toString(), paths, ((Object)gcSummary.toAbsolutePath()).toString()};
                ProcessExecutor.start$default((ProcessExecutor)new ProcessExecutor("gcviewer", gcViewer.getParent(), DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, null, null, null, null, null, false, 0, false, false, 32744, null), (boolean)false, (int)1, null);
            }
            catch (Throwable t) {
                System.out.println((Object)("gcviewer process failed by: " + t.getMessage()));
            }
        } else {
            System.out.println((Object)(gcLogPath + " doesn't exists"));
        }
    }

    private final List<PerformanceMetrics.Metric> processGCSummary(Path gcSummary, String[] requestedMetrics) {
        List gcMetrics = new ArrayList();
        NumberFormat format = NumberFormat.getNumberInstance(Locale.getDefault());
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(gcSummary, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            System.out.println((Object)(gcSummary + " doesn't exists"));
            return gcMetrics;
        }
        File file = gcSummary.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        FilesKt.forEachLine$default((File)file, null, arg_0 -> GCLogAnalyzer.processGCSummary$lambda$0(format, requestedMetrics, gcMetrics, arg_0), (int)1, null);
        return gcMetrics;
    }

    private final List<PerformanceMetrics.Metric> extractAdditionalGcMetrics(File gcLogFile) {
        Ref.IntRef concurrentMarkCycleCount = new Ref.IntRef();
        Ref.IntRef concurrentMarkCycleTimeMicrosecondsSum = new Ref.IntRef();
        Ref.IntRef heapShrinkageCount = new Ref.IntRef();
        Ref.IntRef heapShrinkageMegabytes = new Ref.IntRef();
        Ref.IntRef lastHeapSize = new Ref.IntRef();
        lastHeapSize.element = -1;
        FilesKt.forEachLine$default((File)gcLogFile, null, arg_0 -> GCLogAnalyzer.extractAdditionalGcMetrics$lambda$0(this, concurrentMarkCycleCount, concurrentMarkCycleTimeMicrosecondsSum, lastHeapSize, heapShrinkageCount, heapShrinkageMegabytes, arg_0), (int)1, null);
        Object[] objectArray = new PerformanceMetrics.Metric[]{PerformanceMetrics.Metric.Companion.newCounter("g1gcConcurrentMarkCycles", concurrentMarkCycleCount.element), PerformanceMetrics.Metric.Companion.newDuration("g1gcConcurrentMarkTimeMs", concurrentMarkCycleTimeMicrosecondsSum.element / 1000), PerformanceMetrics.Metric.Companion.newCounter("g1gcHeapShrinkageCount", heapShrinkageCount.element), PerformanceMetrics.Metric.Companion.newCounter("g1gcHeapShrinkageMegabytes", heapShrinkageMegabytes.element)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final Integer extractConcurrentMarkCycleTimeMicroseconds(String line) {
        String string;
        String string2;
        String string3;
        List list;
        MatchResult matchResult = Regex.find$default((Regex)GCLogAnalyzerKt.access$getCONCURRENT_MARK_CYCLE_REGEX$p(), (CharSequence)line, (int)0, (int)2, null);
        return matchResult != null && (list = matchResult.getGroupValues()) != null && (string3 = (String)list.get(1)) != null && (string2 = StringsKt.replace$default((String)string3, (String)",", (String)"", (boolean)false, (int)4, null)) != null && (string = StringsKt.replace$default((String)string2, (String)".", (String)"", (boolean)false, (int)4, null)) != null ? StringsKt.toIntOrNull((String)string) : null;
    }

    private final Integer extractHeapSizeMegabytes(String line) {
        String string;
        List list;
        MatchResult matchResult = Regex.find$default((Regex)GCLogAnalyzerKt.access$getHEAP_SIZE_REGEX$p(), (CharSequence)line, (int)0, (int)2, null);
        return matchResult != null && (list = matchResult.getGroupValues()) != null && (string = (String)list.get(1)) != null ? StringsKt.toIntOrNull((String)string) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean runGCViewer$lambda$0(Path it) {
        if (it.getFileName() == null) return false;
        Intrinsics.checkNotNull((Object)it);
        if (!StringsKt.startsWith$default((String)PathsKt.getName((Path)it), (String)"gcLog.log", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final boolean runGCViewer$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence runGCViewer$lambda$2(Path it) {
        Intrinsics.checkNotNull((Object)it);
        return ((Object)it).toString();
    }

    /*
     * Unable to fully structure code
     */
    private static final Unit processGCSummary$lambda$0(NumberFormat $format, String[] $requestedMetrics, List $gcMetrics, String line) {
        block11: {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            var5_4 = new String[]{";"};
            splitLine = StringsKt.split$default((CharSequence)line, (String[])var5_4, (boolean)false, (int)0, (int)6, null);
            if (splitLine.size() < 3) {
                return Unit.INSTANCE;
            }
            parameter = StringsKt.trim((CharSequence)((String)splitLine.get(0))).toString();
            var7_6 = $format;
            try {
                $this$processGCSummary_u24lambda_u240_u240 = var7_6;
                $i$a$-runCatching-GCLogAnalyzer$processGCSummary$1$value$1 = false;
                $this$processGCSummary_u24lambda_u240_u240 = Result.constructor-impl((Object)$this$processGCSummary_u24lambda_u240_u240.parse(StringsKt.trim((CharSequence)((String)splitLine.get(1))).toString()).doubleValue());
            }
            catch (Throwable var9_9) {
                $this$processGCSummary_u24lambda_u240_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var9_9));
            }
            var7_6 = $this$processGCSummary_u24lambda_u240_u240;
            value = (Double)(Result.isFailure-impl((Object)var7_6) != false ? null : var7_6);
            if (value == null) {
                return Unit.INSTANCE;
            }
            type = StringsKt.trim((CharSequence)((String)splitLine.get(2))).toString();
            if (Intrinsics.areEqual((Object)type, (Object)"bool")) {
                return Unit.INSTANCE;
            }
            v0 = type = Intrinsics.areEqual((Object)type, (Object)"") != false ? "" : type;
            if (!ArraysKt.contains((Object[])$requestedMetrics, (Object)parameter)) break block11;
            var8_7 = type;
            switch (var8_7.hashCode()) {
                case 115: {
                    if (var8_7.equals("s")) break;
                    ** break;
                }
                case 45: {
                    if (!var8_7.equals("-")) {
                        ** break;
                    }
                    ** GOTO lbl38
                }
                case 77: {
                    if (!var8_7.equals("M")) ** break;
lbl38:
                    // 2 sources

                    $gcMetrics.add(PerformanceMetrics.Metric.Companion.newCounter(parameter, (int)value.doubleValue()));
                    break block11;
                }
            }
            $gcMetrics.add(PerformanceMetrics.Metric.Companion.newDuration(parameter, (int)(value * (double)1000)));
            break block11;
lbl44:
            // 4 sources

            System.out.println((Object)("Unknown type: " + type));
        }
        return Unit.INSTANCE;
    }

    private static final Unit extractAdditionalGcMetrics$lambda$0(GCLogAnalyzer this$0, Ref.IntRef $concurrentMarkCycleCount, Ref.IntRef $concurrentMarkCycleTimeMicrosecondsSum, Ref.IntRef $lastHeapSize, Ref.IntRef $heapShrinkageCount, Ref.IntRef $heapShrinkageMegabytes, String line) {
        block2: {
            int n;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Integer n2 = this$0.extractConcurrentMarkCycleTimeMicroseconds(line);
            if (n2 != null) {
                int concurrentMarkCycleTimeMicroseconds = ((Number)n2).intValue();
                boolean bl = false;
                n = $concurrentMarkCycleCount.element;
                $concurrentMarkCycleCount.element = n + 1;
                $concurrentMarkCycleTimeMicrosecondsSum.element += concurrentMarkCycleTimeMicroseconds;
            }
            Integer n3 = this$0.extractHeapSizeMegabytes(line);
            if (n3 == null) break block2;
            int heapSize = ((Number)n3).intValue();
            boolean bl = false;
            if ($lastHeapSize.element != -1 && heapSize < $lastHeapSize.element) {
                n = $heapShrinkageCount.element;
                $heapShrinkageCount.element = n + 1;
                $heapShrinkageMegabytes.element += $lastHeapSize.element - heapSize;
            }
            $lastHeapSize.element = heapSize;
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/tools/ide/metrics/collector/starter/metrics/GCLogAnalyzer$Companion;", "", "<init>", "()V", "gcViewerUrl", "", "intellij.tools.ide.metrics.collector.starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

