/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.metrics.collector.telemetry;

import com.intellij.tools.ide.metrics.collector.metrics.CollectionExtensionKt;
import com.intellij.tools.ide.metrics.collector.metrics.PerformanceMetrics;
import com.intellij.tools.ide.metrics.collector.telemetry.MetricWithAttributes;
import com.intellij.tools.ide.metrics.collector.telemetry.MetricsPostProcessor;
import com.intellij.tools.ide.metrics.collector.telemetry.OpenTelemetryKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00050\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/tools/ide/metrics/collector/telemetry/CombinedMetricsPostProcessor;", "Lcom/intellij/tools/ide/metrics/collector/telemetry/MetricsPostProcessor;", "<init>", "()V", "process", "", "Lcom/intellij/tools/ide/metrics/collector/metrics/PerformanceMetrics$Metric;", "groupedMetrics", "", "", "Lcom/intellij/tools/ide/metrics/collector/telemetry/MetricWithAttributes;", "intellij.tools.ide.metrics.collector"})
@SourceDebugExtension(value={"SMAP\nMetricsPostProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsPostProcessor.kt\ncom/intellij/tools/ide/metrics/collector/telemetry/CombinedMetricsPostProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1915#2,2:73\n1586#2:76\n1661#2,3:77\n1586#2:80\n1661#2,3:81\n1#3:75\n*S KotlinDebug\n*F\n+ 1 MetricsPostProcessor.kt\ncom/intellij/tools/ide/metrics/collector/telemetry/CombinedMetricsPostProcessor\n*L\n32#1:73,2\n60#1:76\n60#1:77,3\n61#1:80\n61#1:81,3\n*E\n"})
public final class CombinedMetricsPostProcessor
implements MetricsPostProcessor {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PerformanceMetrics.Metric> process(@NotNull Map<String, ? extends List<MetricWithAttributes>> groupedMetrics) {
        Intrinsics.checkNotNullParameter(groupedMetrics, (String)"groupedMetrics");
        List result = new ArrayList();
        for (Map.Entry<String, ? extends List<MetricWithAttributes>> entry : groupedMetrics.entrySet()) {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            Object collection;
            int value;
            if (entry.getValue().size() == 1) {
                MetricWithAttributes metric = (MetricWithAttributes)CollectionsKt.first(entry.getValue());
                result.addAll(OpenTelemetryKt.getAttributes(entry.getKey(), metric));
                if (Intrinsics.areEqual((Object)metric.metric.id.getName(), (Object)"test")) continue;
                result.add(metric.metric);
                continue;
            }
            int counter = 1;
            Map mediumAttributes = new LinkedHashMap();
            for (MetricWithAttributes metricWithAttributes : entry.getValue()) {
                value = metricWithAttributes.metric.value;
                String spanUpdatedName = entry.getKey() + "_" + counter;
                result.add(PerformanceMetrics.Metric.Companion.newDuration(spanUpdatedName, value));
                result.addAll(OpenTelemetryKt.getAttributes(spanUpdatedName, metricWithAttributes));
                Object $this$forEach$iv = OpenTelemetryKt.getAttributes(entry.getKey(), metricWithAttributes);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    PerformanceMetrics.Metric it = (PerformanceMetrics.Metric)element$iv;
                    boolean bl = false;
                    String key = it.id.getName();
                    collection = mediumAttributes.getOrDefault(key, (List)new ArrayList());
                    collection.add(it.value);
                    mediumAttributes.put(key, collection);
                }
                ++counter;
            }
            for (Map.Entry entry2 : mediumAttributes.entrySet()) {
                if (StringsKt.endsWith$default((String)((String)entry2.getKey()), (String)"#max", (boolean)false, (int)2, null)) {
                    result.add(PerformanceMetrics.Metric.Companion.newDuration((String)entry2.getKey(), ((Number)((Object)CollectionsKt.maxOrThrow((Iterable)((Iterable)entry2.getValue())))).intValue()));
                    continue;
                }
                if (StringsKt.endsWith$default((String)((String)entry2.getKey()), (String)"#p90", (boolean)false, (int)2, null)) continue;
                if (StringsKt.endsWith$default((String)((String)entry2.getKey()), (String)"#mean_value", (boolean)false, (int)2, null)) {
                    result.add(PerformanceMetrics.Metric.Companion.newDuration((String)entry2.getKey(), (int)CollectionsKt.averageOfInt((Iterable)((Iterable)entry2.getValue()))));
                    continue;
                }
                result.add(PerformanceMetrics.Metric.Companion.newCounter(entry2.getKey() + "#count", ((List)entry2.getValue()).size()));
                result.add(PerformanceMetrics.Metric.Companion.newDuration(entry2.getKey() + "#mean_value", (int)CollectionsKt.averageOfInt((Iterable)((Iterable)entry2.getValue()))));
                result.add(PerformanceMetrics.Metric.Companion.newDuration(entry2.getKey() + "#standard_deviation", CollectionExtensionKt.standardDeviation((Iterable)entry2.getValue())));
            }
            Iterable iterable = entry.getValue();
            value = 0;
            for (Object $this$forEach$iv : iterable) {
                void it;
                MetricWithAttributes $i$f$forEach = (MetricWithAttributes)$this$forEach$iv;
                int n = value;
                boolean bl = false;
                int n2 = it.metric.value;
                value = n + n2;
            }
            int sum = value;
            int n = entry.getValue().size();
            int mean = sum / n;
            Iterable $this$map$iv = entry.getValue();
            boolean $i$f$map = false;
            Iterable bl = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                collection = (MetricWithAttributes)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(it.metric.value);
            }
            int median = CollectionExtensionKt.median((List)destination$iv$iv);
            Iterable $this$map$iv2 = entry.getValue();
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MetricWithAttributes bl2 = (MetricWithAttributes)item$iv$iv;
                Collection collection3 = destination$iv$iv2;
                boolean bl3 = false;
                collection3.add(it.metric.value);
            }
            int standardDeviation = CollectionExtensionKt.standardDeviation((List)destination$iv$iv2);
            result.add(PerformanceMetrics.Metric.Companion.newDuration(entry.getKey(), sum));
            result.add(PerformanceMetrics.Metric.Companion.newCounter(entry.getKey() + "#count", n));
            result.add(PerformanceMetrics.Metric.Companion.newDuration(entry.getKey() + "#mean_value", mean));
            result.add(PerformanceMetrics.Metric.Companion.newDuration(entry.getKey() + "#median_value", median));
            result.add(PerformanceMetrics.Metric.Companion.newDuration(entry.getKey() + "#standard_deviation", standardDeviation));
        }
        return result;
    }
}

