/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.metrics.collector;

import com.intellij.platform.diagnostic.telemetry.exporters.meters.OpenTelemetryMetersJsonImporter;
import com.intellij.tools.ide.metrics.collector.MetricsCollector;
import com.intellij.tools.ide.metrics.collector.OpenTelemetryCsvMeterCollector;
import com.intellij.tools.ide.metrics.collector.meters.DoubleCounterToMetricConverter;
import com.intellij.tools.ide.metrics.collector.meters.DoubleGaugeToMetricConverter;
import com.intellij.tools.ide.metrics.collector.meters.DoubleHistogramMeterToMetricConverter;
import com.intellij.tools.ide.metrics.collector.meters.LongCounterToMetricConverter;
import com.intellij.tools.ide.metrics.collector.meters.LongGaugeToMetricConverter;
import com.intellij.tools.ide.metrics.collector.metrics.MetricsSelectionStrategy;
import com.intellij.tools.ide.metrics.collector.metrics.PerformanceMetrics;
import com.intellij.tools.ide.util.common.LoggingKt;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.Data;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.resources.Resource;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ:\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122$\u0010\u0013\u001a \u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00180\u00170\u0014J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/tools/ide/metrics/collector/OpenTelemetryJsonMeterCollector;", "Lcom/intellij/tools/ide/metrics/collector/MetricsCollector;", "metricsSelectionStrategy", "Lcom/intellij/tools/ide/metrics/collector/metrics/MetricsSelectionStrategy;", "meterFilter", "Lkotlin/Function1;", "Lio/opentelemetry/sdk/metrics/data/MetricData;", "", "<init>", "(Lcom/intellij/tools/ide/metrics/collector/metrics/MetricsSelectionStrategy;Lkotlin/jvm/functions/Function1;)V", "getMetricsSelectionStrategy", "()Lcom/intellij/tools/ide/metrics/collector/metrics/MetricsSelectionStrategy;", "getMeterFilter", "()Lkotlin/jvm/functions/Function1;", "collect", "", "Lcom/intellij/tools/ide/metrics/collector/metrics/PerformanceMetrics$Metric;", "logsDirPath", "Ljava/nio/file/Path;", "transform", "Lkotlin/Function2;", "", "", "Lkotlin/Pair;", "", "intellij.tools.ide.metrics.collector"})
@SourceDebugExtension(value={"SMAP\nOpenTelemetryJsonMeterCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenTelemetryJsonMeterCollector.kt\ncom/intellij/tools/ide/metrics/collector/OpenTelemetryJsonMeterCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,79:1\n777#2:80\n873#2,2:81\n1391#2:83\n1480#2,5:84\n777#2:89\n873#2,2:90\n1512#2:92\n1538#2,3:93\n1541#2,3:103\n1391#2:110\n1480#2,5:111\n383#3,7:96\n129#4:106\n158#4,3:107\n*S KotlinDebug\n*F\n+ 1 OpenTelemetryJsonMeterCollector.kt\ncom/intellij/tools/ide/metrics/collector/OpenTelemetryJsonMeterCollector\n*L\n36#1:80\n36#1:81,2\n58#1:83\n58#1:84,5\n59#1:89\n59#1:90,2\n61#1:92\n61#1:93,3\n61#1:103,3\n64#1:110\n64#1:111,5\n61#1:96,7\n62#1:106\n62#1:107,3\n*E\n"})
public class OpenTelemetryJsonMeterCollector
implements MetricsCollector {
    @NotNull
    private final MetricsSelectionStrategy metricsSelectionStrategy;
    @NotNull
    private final Function1<MetricData, Boolean> meterFilter;

    public OpenTelemetryJsonMeterCollector(@NotNull MetricsSelectionStrategy metricsSelectionStrategy, @NotNull Function1<? super MetricData, Boolean> meterFilter) {
        Intrinsics.checkNotNullParameter((Object)((Object)metricsSelectionStrategy), (String)"metricsSelectionStrategy");
        Intrinsics.checkNotNullParameter(meterFilter, (String)"meterFilter");
        this.metricsSelectionStrategy = metricsSelectionStrategy;
        this.meterFilter = meterFilter;
    }

    @NotNull
    public final MetricsSelectionStrategy getMetricsSelectionStrategy() {
        return this.metricsSelectionStrategy;
    }

    @NotNull
    public final Function1<MetricData, Boolean> getMeterFilter() {
        return this.meterFilter;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PerformanceMetrics.Metric> collect(@NotNull Path logsDirPath, @NotNull Function2<? super String, ? super Long, Pair<String, Integer>> transform) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Object metricsGroupedByName;
        Object object;
        void $this$groupByTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$flatMapTo$iv$iv2;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)logsDirPath, (String)"logsDirPath");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Iterable $this$filter$iv2 = PathsKt.listDirectoryEntries((Path)logsDirPath, (String)"*.json");
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)PathsKt.getName((Path)it), (String)"open-telemetry-meter", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List metricsFiles = (List)destination$iv$iv;
        if (metricsFiles.isEmpty()) {
            LoggingKt.logError((String)("Cannot find JSON files with metrics `open-telemetry-meters.***.json` in '" + logsDirPath.toUri() + "'. Falling back to use metrics from *.csv files"));
            return new OpenTelemetryCsvMeterCollector(this.metricsSelectionStrategy, (Function1<? super Map.Entry<String, ? extends List<? extends LongPointData>>, Boolean>)((Function1)arg_0 -> OpenTelemetryJsonMeterCollector.collect$lambda$1(this, arg_0))).collect(logsDirPath, transform);
        }
        Iterable $this$flatMap$iv = metricsFiles;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = OpenTelemetryMetersJsonImporter.INSTANCE.fromJsonFile(it);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        Function1<MetricData, Boolean> predicate$iv = this.meterFilter;
        boolean $i$f$filter2 = false;
        destination$iv$iv2 = $this$filter$iv;
        Object destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List telemetryMetrics = (List)destination$iv$iv3;
        Iterable $this$groupBy$iv = telemetryMetrics;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            String key$iv$iv;
            MetricData it = (MetricData)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getName(), (String)"getName(...)");
            object = destination$iv$iv3;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$map$iv = metricsGroupedByName = destination$iv$iv3;
        boolean $i$f$map = false;
        destination$iv$iv3 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry bl = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv4;
            boolean bl3 = false;
            List list = (List)it.getValue();
            MetricDataType metricDataType = ((MetricData)CollectionsKt.first((List)((List)it.getValue()))).getType();
            Intrinsics.checkNotNullExpressionValue((Object)metricDataType, (String)"getType(...)");
            collection.add(this.metricsSelectionStrategy.selectMetric(list, metricDataType));
        }
        List selectedMetric = (List)destination$iv$iv4;
        Iterable $this$flatMap$iv2 = selectedMetric;
        boolean $i$f$flatMap2 = false;
        $this$mapTo$iv$iv = $this$flatMap$iv2;
        destination$iv$iv4 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Map.Entry element$iv$iv : $this$flatMapTo$iv$iv) {
            MetricData it = (MetricData)element$iv$iv;
            boolean bl = false;
            MetricDataType metricDataType = it.getType();
            Iterable list$iv$iv = (switch (metricDataType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[metricDataType.ordinal()]) {
                case 1 -> new LongCounterToMetricConverter();
                case 2 -> new DoubleCounterToMetricConverter();
                case 3 -> new LongGaugeToMetricConverter();
                case 4 -> new DoubleGaugeToMetricConverter();
                case 5 -> new DoubleHistogramMeterToMetricConverter();
                default -> {
                    object = "Type " + it.getType() + " isn't supported yet";
                    throw new NotImplementedError("An operation is not implemented: " + (String)object);
                }
            }).convert(it, transform);
            CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv4;
    }

    @Override
    @NotNull
    public List<PerformanceMetrics.Metric> collect(@NotNull Path logsDirPath) {
        Intrinsics.checkNotNullParameter((Object)logsDirPath, (String)"logsDirPath");
        return this.collect(logsDirPath, (Function2<? super String, ? super Long, Pair<String, Integer>>)((Function2)OpenTelemetryJsonMeterCollector::collect$lambda$6));
    }

    private static final boolean collect$lambda$1(OpenTelemetryJsonMeterCollector this$0, Map.Entry metricEntry) {
        Intrinsics.checkNotNullParameter((Object)metricEntry, (String)"metricEntry");
        MetricData metricData2 = new MetricData(metricEntry){
            final /* synthetic */ Map.Entry<String, List<LongPointData>> $metricEntry;
            {
                this.$metricEntry = $metricEntry;
            }

            public Resource getResource() {
                throw new NotImplementedError(null, 1, null);
            }

            public InstrumentationScopeInfo getInstrumentationScopeInfo() {
                throw new NotImplementedError(null, 1, null);
            }

            public String getName() {
                return this.$metricEntry.getKey();
            }

            public String getDescription() {
                throw new NotImplementedError(null, 1, null);
            }

            public String getUnit() {
                throw new NotImplementedError(null, 1, null);
            }

            public MetricDataType getType() {
                throw new NotImplementedError(null, 1, null);
            }

            public Data<?> getData() {
                throw new NotImplementedError(null, 1, null);
            }
        };
        return (Boolean)this$0.meterFilter.invoke((Object)metricData2);
    }

    private static final Pair collect$lambda$6(String name, long value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return TuplesKt.to((Object)name, (Object)((int)value));
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MetricDataType.values().length];
            try {
                nArray[MetricDataType.LONG_SUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.DOUBLE_SUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.LONG_GAUGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.DOUBLE_GAUGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.HISTOGRAM.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

