/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.metrics.collector.meters;

import com.intellij.tools.ide.metrics.collector.meters.MeterToMetricConverter;
import com.intellij.tools.ide.metrics.collector.metrics.HistogramExtensionKt;
import com.intellij.tools.ide.metrics.collector.metrics.PerformanceMetrics;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u0002J<\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00062$\u0010\u000e\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u00110\u000fH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/tools/ide/metrics/collector/meters/DoubleHistogramMeterToMetricConverter;", "Lcom/intellij/tools/ide/metrics/collector/meters/MeterToMetricConverter;", "<init>", "()V", "getMetricName", "", "Lio/opentelemetry/sdk/metrics/data/MetricData;", "additionalMetricName", "addUnitSuffix", "", "convert", "", "Lcom/intellij/tools/ide/metrics/collector/metrics/PerformanceMetrics$Metric;", "metricData", "transform", "Lkotlin/Function2;", "", "Lkotlin/Pair;", "", "intellij.tools.ide.metrics.collector"})
public final class DoubleHistogramMeterToMetricConverter
implements MeterToMetricConverter {
    private final String getMetricName(MetricData $this$getMetricName, String additionalMetricName, boolean addUnitSuffix) {
        String string = $this$getMetricName.getUnit();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUnit(...)");
        String unit = string;
        String string2 = $this$getMetricName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return StringsKt.removeSuffix((String)(StringsKt.removeSuffix((String)string2, (CharSequence)unit) + (addUnitSuffix ? "." + additionalMetricName + "." + unit : "." + additionalMetricName)), (CharSequence)".");
    }

    static /* synthetic */ String getMetricName$default(DoubleHistogramMeterToMetricConverter doubleHistogramMeterToMetricConverter, MetricData metricData2, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return doubleHistogramMeterToMetricConverter.getMetricName(metricData2, string, bl);
    }

    @Override
    @NotNull
    public List<PerformanceMetrics.Metric> convert(@NotNull MetricData metricData2, @NotNull Function2<? super String, ? super Long, Pair<String, Integer>> transform) {
        Intrinsics.checkNotNullParameter((Object)metricData2, (String)"metricData");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Collection collection = metricData2.getHistogramData().getPoints();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPoints(...)");
        Object object = CollectionsKt.first((Iterable)collection);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        HistogramPointData dataPoint = (HistogramPointData)object;
        PerformanceMetrics.Metric minMetric = PerformanceMetrics.Companion.newDuration(DoubleHistogramMeterToMetricConverter.getMetricName$default(this, metricData2, "min", false, 2, null), (int)dataPoint.getMin());
        PerformanceMetrics.Metric maxMetric = PerformanceMetrics.Companion.newDuration(DoubleHistogramMeterToMetricConverter.getMetricName$default(this, metricData2, "max", false, 2, null), (int)dataPoint.getMax());
        PerformanceMetrics.Metric measurementsCountMetric = PerformanceMetrics.Companion.newDuration(this.getMetricName(metricData2, "measurements.count", false), (int)dataPoint.getCount());
        String string = DoubleHistogramMeterToMetricConverter.getMetricName$default(this, metricData2, "median", false, 2, null);
        HistogramData histogramData = metricData2.getHistogramData();
        Intrinsics.checkNotNullExpressionValue((Object)histogramData, (String)"getHistogramData(...)");
        PerformanceMetrics.Metric medianMetric = PerformanceMetrics.Companion.newDuration(string, (int)HistogramExtensionKt.median(histogramData));
        String string2 = DoubleHistogramMeterToMetricConverter.getMetricName$default(this, metricData2, "standard.deviation", false, 2, null);
        HistogramData histogramData2 = metricData2.getHistogramData();
        Intrinsics.checkNotNullExpressionValue((Object)histogramData2, (String)"getHistogramData(...)");
        PerformanceMetrics.Metric stdevMetric = PerformanceMetrics.Companion.newDuration(string2, (int)HistogramExtensionKt.standardDeviation(histogramData2));
        String string3 = DoubleHistogramMeterToMetricConverter.getMetricName$default(this, metricData2, "95.percentile", false, 2, null);
        HistogramData histogramData3 = metricData2.getHistogramData();
        Intrinsics.checkNotNullExpressionValue((Object)histogramData3, (String)"getHistogramData(...)");
        PerformanceMetrics.Metric pctl95 = PerformanceMetrics.Companion.newDuration(string3, (int)HistogramExtensionKt.calculatePercentile(histogramData3, (byte)95));
        String string4 = DoubleHistogramMeterToMetricConverter.getMetricName$default(this, metricData2, "99.percentile", false, 2, null);
        HistogramData histogramData4 = metricData2.getHistogramData();
        Intrinsics.checkNotNullExpressionValue((Object)histogramData4, (String)"getHistogramData(...)");
        PerformanceMetrics.Metric pctl99 = PerformanceMetrics.Companion.newDuration(string4, (int)HistogramExtensionKt.calculatePercentile(histogramData4, (byte)99));
        String string5 = DoubleHistogramMeterToMetricConverter.getMetricName$default(this, metricData2, "mad", false, 2, null);
        HistogramData histogramData5 = metricData2.getHistogramData();
        Intrinsics.checkNotNullExpressionValue((Object)histogramData5, (String)"getHistogramData(...)");
        PerformanceMetrics.Metric madMetric = PerformanceMetrics.Companion.newDuration(string5, (int)HistogramExtensionKt.mad(histogramData5));
        String string6 = DoubleHistogramMeterToMetricConverter.getMetricName$default(this, metricData2, "range", false, 2, null);
        HistogramData histogramData6 = metricData2.getHistogramData();
        Intrinsics.checkNotNullExpressionValue((Object)histogramData6, (String)"getHistogramData(...)");
        PerformanceMetrics.Metric rangeMetric = PerformanceMetrics.Companion.newDuration(string6, (int)HistogramExtensionKt.range(histogramData6));
        Object[] objectArray = new PerformanceMetrics.Metric[]{minMetric, maxMetric, measurementsCountMetric, medianMetric, stdevMetric, pctl95, pctl99, madMetric, rangeMetric};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

