/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.metrics.collector.metrics;

import com.intellij.tools.ide.metrics.collector.metrics.PerformanceMetrics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00050\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00070\u0002\u001a\u0010\u0010\b\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00050\u0002\u001a\u001a\u0010\t\u001a\u00020\u0003\"\b\b\u0000\u0010\n*\u00020\u000b*\b\u0012\u0004\u0012\u0002H\n0\u0002\u001a\u0010\u0010\f\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00050\u0002\u001a\u0010\u0010\r\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00050\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0018\u0010\u0011\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00050\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"median", "", "", "", "medianValue", "Lcom/intellij/tools/ide/metrics/collector/metrics/PerformanceMetrics$Metric;", "mad", "", "madValue", "standardDeviation", "T", "", "standardDeviationValue", "range", "rangeValue", "percentile", "", "percentileValue", "intellij.tools.ide.metrics.collector"})
@SourceDebugExtension(value={"SMAP\ncollectionExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 collectionExtension.kt\ncom/intellij/tools/ide/metrics/collector/metrics/CollectionExtensionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1#2:88\n1586#3:89\n1661#3,3:90\n1586#3:93\n1661#3,3:94\n1586#3:97\n1661#3,3:98\n1586#3:101\n1661#3,3:102\n1586#3:105\n1661#3,3:106\n1586#3:109\n1661#3,3:110\n1586#3:113\n1661#3,3:114\n1586#3:117\n1661#3,3:118\n1586#3:121\n1661#3,3:122\n1586#3:125\n1661#3,3:126\n*S KotlinDebug\n*F\n+ 1 collectionExtension.kt\ncom/intellij/tools/ide/metrics/collector/metrics/CollectionExtensionKt\n*L\n26#1:89\n26#1:90,3\n29#1:93\n29#1:94,3\n41#1:97\n41#1:98,3\n45#1:101\n45#1:102,3\n48#1:105\n48#1:106,3\n57#1:109\n57#1:110,3\n58#1:113\n58#1:114,3\n62#1:117\n62#1:118,3\n71#1:121\n71#1:122,3\n86#1:125\n86#1:126,3\n*E\n"})
public final class CollectionExtensionKt {
    public static final double median(@NotNull Iterable<Double> $this$median) {
        Intrinsics.checkNotNullParameter($this$median, (String)"<this>");
        int size = CollectionsKt.count($this$median);
        if (!(size > 0)) {
            boolean bl = false;
            String string = "Cannot calculate median value because collection is empty";
            throw new IllegalArgumentException(string.toString());
        }
        List sortedList = CollectionsKt.sorted($this$median);
        return size % 2 == 1 ? ((Number)sortedList.get(size / 2)).doubleValue() : (((Number)sortedList.get(size / 2 - 1)).doubleValue() + ((Number)sortedList.get(size / 2)).doubleValue()) / (double)2;
    }

    /*
     * WARNING - void declaration
     */
    public static final int median(@NotNull Iterable<Integer> $this$median) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$median, (String)"<this>");
        Iterable<Integer> $this$map$iv = $this$median;
        boolean $i$f$map = false;
        Iterable<Integer> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((double)it);
        }
        return (int)CollectionExtensionKt.median((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final int medianValue(@NotNull Iterable<PerformanceMetrics.Metric> $this$medianValue) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$medianValue, (String)"<this>");
        Iterable<PerformanceMetrics.Metric> $this$map$iv = $this$medianValue;
        boolean $i$f$map = false;
        Iterable<PerformanceMetrics.Metric> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PerformanceMetrics.Metric metric = (PerformanceMetrics.Metric)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Double.valueOf(it.value));
        }
        return (int)CollectionExtensionKt.median((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final double mad(@NotNull Iterable<Double> $this$mad) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$mad, (String)"<this>");
        double medianValue = CollectionExtensionKt.median($this$mad);
        Iterable<Double> $this$map$iv = $this$mad;
        boolean $i$f$map = false;
        Iterable<Double> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Math.abs((double)(it - medianValue)));
        }
        return CollectionExtensionKt.median((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final int mad(@NotNull Iterable<Long> $this$mad) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$mad, (String)"<this>");
        Iterable<Long> $this$map$iv = $this$mad;
        boolean $i$f$map = false;
        Iterable<Long> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            long l = ((Number)item$iv$iv).longValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((double)it);
        }
        return (int)CollectionExtensionKt.mad((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final int madValue(@NotNull Iterable<PerformanceMetrics.Metric> $this$madValue) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$madValue, (String)"<this>");
        Iterable<PerformanceMetrics.Metric> $this$map$iv = $this$madValue;
        boolean $i$f$map = false;
        Iterable<PerformanceMetrics.Metric> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PerformanceMetrics.Metric metric = (PerformanceMetrics.Metric)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Double.valueOf(it.value));
        }
        return (int)CollectionExtensionKt.mad((List)destination$iv$iv);
    }

    public static final <T extends Number> int standardDeviation(@NotNull Iterable<? extends T> $this$standardDeviation) {
        Number it;
        Collection collection;
        Iterable<T> $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$standardDeviation, (String)"<this>");
        Iterable<T> $this$map$iv = $this$standardDeviation;
        boolean $i$f$map = false;
        Iterable<T> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Number number = (Number)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.doubleValue());
        }
        double mean = CollectionsKt.averageOfDouble((Iterable)((List)destination$iv$iv));
        $this$map$iv = $this$standardDeviation;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Number)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Math.pow(it.doubleValue() - mean, 2));
        }
        return (int)Math.sqrt(CollectionsKt.averageOfDouble((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    public static final int standardDeviationValue(@NotNull Iterable<PerformanceMetrics.Metric> $this$standardDeviationValue) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$standardDeviationValue, (String)"<this>");
        Iterable<PerformanceMetrics.Metric> $this$map$iv = $this$standardDeviationValue;
        boolean $i$f$map = false;
        Iterable<PerformanceMetrics.Metric> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PerformanceMetrics.Metric metric = (PerformanceMetrics.Metric)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.value);
        }
        return CollectionExtensionKt.standardDeviation((List)destination$iv$iv);
    }

    public static final int range(@NotNull Iterable<Integer> $this$range) {
        Intrinsics.checkNotNullParameter($this$range, (String)"<this>");
        List sorted = CollectionsKt.sorted($this$range);
        return ((Number)CollectionsKt.last((List)sorted)).intValue() - ((Number)CollectionsKt.first((List)sorted)).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public static final int rangeValue(@NotNull Iterable<PerformanceMetrics.Metric> $this$rangeValue) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$rangeValue, (String)"<this>");
        Iterable<PerformanceMetrics.Metric> $this$map$iv = $this$rangeValue;
        boolean $i$f$map = false;
        Iterable<PerformanceMetrics.Metric> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PerformanceMetrics.Metric metric = (PerformanceMetrics.Metric)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.value);
        }
        return CollectionExtensionKt.range((List)destination$iv$iv);
    }

    public static final int percentile(@NotNull Iterable<Integer> $this$percentile, byte percentile) {
        Intrinsics.checkNotNullParameter($this$percentile, (String)"<this>");
        byte by = percentile;
        if (!(0 <= by ? by < 101 : false)) {
            boolean $i$a$-require-CollectionExtensionKt$percentile$32 = false;
            String $i$a$-require-CollectionExtensionKt$percentile$32 = "Percentile must be between 0 and 100";
            throw new IllegalArgumentException($i$a$-require-CollectionExtensionKt$percentile$32.toString());
        }
        if (!(CollectionsKt.count($this$percentile) > 0)) {
            boolean bl = false;
            String string = "Cannot calculate percentile because collection is empty";
            throw new IllegalArgumentException(string.toString());
        }
        List sorted = CollectionsKt.sorted($this$percentile);
        return ((Number)sorted.get(RangesKt.coerceIn((int)MathKt.roundToInt((double)((double)(percentile * (sorted.size() - 1)) / 100.0)), (ClosedRange)((ClosedRange)CollectionsKt.getIndices((Collection)sorted))))).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public static final int percentileValue(@NotNull Iterable<PerformanceMetrics.Metric> $this$percentileValue, byte percentile) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$percentileValue, (String)"<this>");
        Iterable<PerformanceMetrics.Metric> $this$map$iv = $this$percentileValue;
        boolean $i$f$map = false;
        Iterable<PerformanceMetrics.Metric> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PerformanceMetrics.Metric metric = (PerformanceMetrics.Metric)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.value);
        }
        return CollectionExtensionKt.percentile((List)destination$iv$iv, percentile);
    }
}

