/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.metrics.collector;

import com.intellij.tools.ide.metrics.collector.MetricsCollector;
import com.intellij.tools.ide.metrics.collector.metrics.PerformanceMetrics;
import com.intellij.tools.ide.metrics.collector.telemetry.CombinedMetricsPostProcessor;
import com.intellij.tools.ide.metrics.collector.telemetry.MetricSpanProcessor;
import com.intellij.tools.ide.metrics.collector.telemetry.MetricWithAttributes;
import com.intellij.tools.ide.metrics.collector.telemetry.MetricsPostProcessor;
import com.intellij.tools.ide.metrics.collector.telemetry.OpentelemetrySpanJsonParser;
import com.intellij.tools.ide.metrics.collector.telemetry.SpanElement;
import com.intellij.tools.ide.metrics.collector.telemetry.SpanFilter;
import com.intellij.tools.ide.metrics.collector.telemetry.SpanProcessor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016JL\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00032\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/tools/ide/metrics/collector/OpenTelemetrySpanCollector;", "Lcom/intellij/tools/ide/metrics/collector/MetricsCollector;", "spanFilter", "Lcom/intellij/tools/ide/metrics/collector/telemetry/SpanFilter;", "spanAliases", "", "", "<init>", "(Lcom/intellij/tools/ide/metrics/collector/telemetry/SpanFilter;Ljava/util/Map;)V", "getSpanFilter", "()Lcom/intellij/tools/ide/metrics/collector/telemetry/SpanFilter;", "collect", "", "Lcom/intellij/tools/ide/metrics/collector/metrics/PerformanceMetrics$Metric;", "logsDirPath", "Ljava/nio/file/Path;", "getMetricsFromSpanAndChildren", "file", "filter", "metricSpanProcessor", "Lcom/intellij/tools/ide/metrics/collector/telemetry/SpanProcessor;", "Lcom/intellij/tools/ide/metrics/collector/telemetry/MetricWithAttributes;", "metricsPostProcessor", "Lcom/intellij/tools/ide/metrics/collector/telemetry/MetricsPostProcessor;", "intellij.tools.ide.metrics.collector"})
@SourceDebugExtension(value={"SMAP\nOpenTelemetrySpanCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenTelemetrySpanCollector.kt\ncom/intellij/tools/ide/metrics/collector/OpenTelemetrySpanCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,57:1\n1563#2:58\n1634#2,3:59\n1617#2,9:62\n1869#2:71\n1870#2:73\n1626#2:74\n1491#2:75\n1516#2,3:76\n1519#2,3:86\n1#3:72\n382#4,7:79\n*S KotlinDebug\n*F\n+ 1 OpenTelemetrySpanCollector.kt\ncom/intellij/tools/ide/metrics/collector/OpenTelemetrySpanCollector\n*L\n45#1:58\n45#1:59,3\n53#1:62,9\n53#1:71\n53#1:73\n53#1:74\n54#1:75\n54#1:76,3\n54#1:86,3\n53#1:72\n54#1:79,7\n*E\n"})
public class OpenTelemetrySpanCollector
implements MetricsCollector {
    @NotNull
    private final SpanFilter spanFilter;
    @NotNull
    private final Map<String, String> spanAliases;

    public OpenTelemetrySpanCollector(@NotNull SpanFilter spanFilter, @NotNull Map<String, String> spanAliases) {
        Intrinsics.checkNotNullParameter((Object)spanFilter, (String)"spanFilter");
        Intrinsics.checkNotNullParameter(spanAliases, (String)"spanAliases");
        this.spanFilter = spanFilter;
        this.spanAliases = spanAliases;
    }

    public /* synthetic */ OpenTelemetrySpanCollector(SpanFilter spanFilter, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(spanFilter, map);
    }

    @NotNull
    public final SpanFilter getSpanFilter() {
        return this.spanFilter;
    }

    @Override
    @NotNull
    public List<PerformanceMetrics.Metric> collect(@NotNull Path logsDirPath) {
        Intrinsics.checkNotNullParameter((Object)logsDirPath, (String)"logsDirPath");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        Path telemetryJsonFile = Files.isDirectory(logsDirPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? logsDirPath.resolve("opentelemetry.json").toAbsolutePath() : logsDirPath;
        Intrinsics.checkNotNull((Object)telemetryJsonFile);
        return OpenTelemetrySpanCollector.getMetricsFromSpanAndChildren$default(this, telemetryJsonFile, this.spanFilter, null, this.spanAliases, null, 20, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PerformanceMetrics.Metric> getMetricsFromSpanAndChildren(@NotNull Path file, @NotNull SpanFilter filter, @NotNull SpanProcessor<MetricWithAttributes> metricSpanProcessor, @NotNull Map<String, String> spanAliases, @NotNull MetricsPostProcessor metricsPostProcessor) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter(metricSpanProcessor, (String)"metricSpanProcessor");
        Intrinsics.checkNotNullParameter(spanAliases, (String)"spanAliases");
        Intrinsics.checkNotNullParameter((Object)metricsPostProcessor, (String)"metricsPostProcessor");
        Iterable $this$map$iv = OpentelemetrySpanJsonParser.getSpanElements$default(new OpentelemetrySpanJsonParser(filter), file, null, 2, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SpanElement spanElement = (SpanElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name = spanAliases.getOrDefault(it.name, it.name);
            collection.add(!Intrinsics.areEqual((Object)name, (Object)it.name) ? SpanElement.copy-SYHnMyU$default((SpanElement)it, false, name, 0L, null, null, null, null, 125, null) : it);
        }
        List spanElements = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = spanElements;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            MetricWithAttributes it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            SpanElement it = (SpanElement)element$iv$iv;
            boolean bl3 = false;
            if (metricSpanProcessor.process(it) == null) continue;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            MetricWithAttributes it = (MetricWithAttributes)element$iv$iv;
            boolean bl5 = false;
            String key$iv$iv = it.metric.id.getName();
            Object bl2 = destination$iv$iv2;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object spanToMetricMap = destination$iv$iv2;
        return metricsPostProcessor.process((Map<String, ? extends List<MetricWithAttributes>>)spanToMetricMap);
    }

    public static /* synthetic */ List getMetricsFromSpanAndChildren$default(OpenTelemetrySpanCollector openTelemetrySpanCollector, Path path, SpanFilter spanFilter, SpanProcessor spanProcessor, Map map, MetricsPostProcessor metricsPostProcessor, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getMetricsFromSpanAndChildren");
        }
        if ((n & 4) != 0) {
            spanProcessor = new MetricSpanProcessor(false, 1, null);
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            metricsPostProcessor = new CombinedMetricsPostProcessor();
        }
        return openTelemetrySpanCollector.getMetricsFromSpanAndChildren(path, spanFilter, spanProcessor, map, metricsPostProcessor);
    }
}

