/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.metrics.collector.metrics;

import com.intellij.tools.ide.metrics.collector.metrics.CollectionExtensionKt;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\t"}, d2={"calculatePercentile", "", "Lio/opentelemetry/sdk/metrics/data/HistogramData;", "percentile", "", "median", "standardDeviation", "mad", "range", "intellij.tools.ide.metrics.collector"})
@SourceDebugExtension(value={"SMAP\nhistogramExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 histogramExtension.kt\ncom/intellij/tools/ide/metrics/collector/metrics/HistogramExtensionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1#2:74\n1869#3:75\n3544#3,7:76\n1870#3:83\n1869#3:84\n3544#3,7:85\n1870#3:92\n1869#3:93\n3544#3,7:94\n1870#3:101\n1563#3:102\n1634#3,3:103\n1374#3:106\n1460#3,5:107\n*S KotlinDebug\n*F\n+ 1 histogramExtension.kt\ncom/intellij/tools/ide/metrics/collector/metrics/HistogramExtensionKt\n*L\n37#1:75\n38#1:76,7\n37#1:83\n47#1:84\n48#1:85,7\n47#1:92\n61#1:93\n62#1:94,7\n61#1:101\n66#1:102\n66#1:103,3\n70#1:106\n70#1:107,5\n*E\n"})
public final class HistogramExtensionKt {
    public static final double calculatePercentile(@NotNull HistogramData $this$calculatePercentile, byte percentile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$calculatePercentile, (String)"<this>");
        byte by = percentile;
        byte by2 = 0 <= by ? (by < 101 ? (byte)1 : 0) : (by = 0);
        if (_Assertions.ENABLED && by == 0) {
            boolean $i$a$-assert-HistogramExtensionKt$calculatePercentile$32 = false;
            String $i$a$-assert-HistogramExtensionKt$calculatePercentile$32 = "Percentile must be between 0 and 100";
            throw new AssertionError((Object)$i$a$-assert-HistogramExtensionKt$calculatePercentile$32);
        }
        Collection collection = $this$calculatePercentile.getPoints();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPoints(...)");
        HistogramPointData point = (HistogramPointData)CollectionsKt.first((Iterable)collection);
        List list = point.getBoundaries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBoundaries(...)");
        List boundaries = list;
        List list2 = point.getCounts();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getCounts(...)");
        List counts = list2;
        boolean bl2 = !((Collection)boundaries).isEmpty() && !((Collection)counts).isEmpty() ? true : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Boundaries and counts of histogram should not be empty";
            throw new AssertionError((Object)string);
        }
        double rank = (double)(CollectionsKt.sumOfLong((Iterable)counts) * (long)percentile) / 100.0;
        long runningTotal = 0L;
        Iterator iterator = ((Iterable)counts).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            long count = ((Number)iterator.next()).longValue();
            if (!((double)(runningTotal += count) >= rank)) continue;
            return index < boundaries.size() ? ((Number)boundaries.get(index)).doubleValue() : ((Number)CollectionsKt.last((List)boundaries)).doubleValue();
        }
        return ((Number)CollectionsKt.last((List)boundaries)).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static final double median(@NotNull HistogramData $this$median) {
        Intrinsics.checkNotNullParameter((Object)$this$median, (String)"<this>");
        List frequencies = new ArrayList();
        Collection collection = $this$median.getPoints();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPoints(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$zip$iv;
            HistogramPointData point = (HistogramPointData)element$iv;
            boolean bl = false;
            List list = point.getBoundaries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBoundaries(...)");
            Iterable iterable = list;
            List list2 = point.getCounts();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getCounts(...)");
            Iterable other$iv = list2;
            boolean $i$f$zip = false;
            Iterator first$iv = $this$zip$iv.iterator();
            Iterator second$iv = other$iv.iterator();
            ArrayList<Unit> list$iv = new ArrayList<Unit>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10)));
            while (first$iv.hasNext() && second$iv.hasNext()) {
                void count;
                Long l = (Long)second$iv.next();
                Double d = (Double)first$iv.next();
                ArrayList<Unit> arrayList = list$iv;
                boolean bl2 = false;
                int n = (int)count.longValue();
                int n2 = 0;
                while (n2 < n) {
                    void boundary;
                    int it = n2++;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)boundary);
                    frequencies.add(boundary);
                }
                arrayList.add(Unit.INSTANCE);
            }
        }
        return CollectionExtensionKt.median(frequencies);
    }

    /*
     * WARNING - void declaration
     */
    public static final double standardDeviation(@NotNull HistogramData $this$standardDeviation) {
        Intrinsics.checkNotNullParameter((Object)$this$standardDeviation, (String)"<this>");
        List frequencies = new ArrayList();
        Collection collection = $this$standardDeviation.getPoints();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPoints(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$zip$iv;
            HistogramPointData point = (HistogramPointData)element$iv;
            boolean bl = false;
            List list = point.getBoundaries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBoundaries(...)");
            Iterable iterable = list;
            List list2 = point.getCounts();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getCounts(...)");
            Iterable other$iv = list2;
            boolean $i$f$zip = false;
            Iterator first$iv = $this$zip$iv.iterator();
            Iterator second$iv = other$iv.iterator();
            ArrayList<Unit> list$iv = new ArrayList<Unit>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10)));
            while (first$iv.hasNext() && second$iv.hasNext()) {
                void count;
                Long l = (Long)second$iv.next();
                Double d = (Double)first$iv.next();
                ArrayList<Unit> arrayList = list$iv;
                boolean bl2 = false;
                int n = (int)count.longValue();
                int n2 = 0;
                while (n2 < n) {
                    void boundary;
                    int it = n2++;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)boundary);
                    frequencies.add(boundary);
                }
                arrayList.add(Unit.INSTANCE);
            }
        }
        return CollectionExtensionKt.standardDeviation(frequencies);
    }

    /*
     * WARNING - void declaration
     */
    public static final double mad(@NotNull HistogramData $this$mad) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$mad, (String)"<this>");
        List frequencies = new ArrayList();
        Collection collection = $this$mad.getPoints();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPoints(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$zip$iv;
            HistogramPointData point = (HistogramPointData)element$iv;
            boolean bl = false;
            List list = point.getBoundaries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBoundaries(...)");
            Iterable iterable = list;
            List list2 = point.getCounts();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getCounts(...)");
            Iterable other$iv = list2;
            boolean $i$f$zip = false;
            Iterator first$iv = $this$zip$iv.iterator();
            Iterator second$iv = other$iv.iterator();
            ArrayList<Unit> list$iv = new ArrayList<Unit>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10)));
            while (first$iv.hasNext() && second$iv.hasNext()) {
                void count;
                Long l = (Long)second$iv.next();
                Double d = (Double)first$iv.next();
                ArrayList<Unit> arrayList = list$iv;
                boolean bl2 = false;
                int n = (int)count.longValue();
                int n2 = 0;
                while (n2 < n) {
                    void boundary;
                    int it = n2++;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)boundary);
                    frequencies.add(boundary);
                }
                arrayList.add(Unit.INSTANCE);
            }
        }
        Iterable $this$map$iv = frequencies;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double other$iv = ((Number)item$iv$iv).doubleValue();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add((double)it);
        }
        return CollectionExtensionKt.mad((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final double range(@NotNull HistogramData $this$range) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$range, (String)"<this>");
        Collection collection = $this$range.getPoints();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPoints(...)");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            HistogramPointData it = (HistogramPointData)element$iv$iv;
            boolean bl = false;
            List list = it.getBoundaries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBoundaries(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List boundaries = (List)destination$iv$iv;
        Double d = CollectionsKt.maxOrNull((Iterable)boundaries);
        Intrinsics.checkNotNull((Object)d);
        double d2 = d;
        Double d3 = CollectionsKt.minOrNull((Iterable)boundaries);
        Intrinsics.checkNotNull((Object)d3);
        return d2 - d3;
    }
}

