/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.metrics.collector.telemetry;

import com.intellij.tools.ide.metrics.collector.telemetry.CachedElementSerializer;
import com.intellij.tools.ide.metrics.collector.telemetry.SpanData;
import com.intellij.tools.ide.metrics.collector.telemetry.SpanElement;
import com.intellij.tools.ide.metrics.collector.telemetry.SpanRef;
import com.intellij.tools.ide.metrics.collector.telemetry.SpanTag;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001aU\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\n0\t\"\n\b\u0000\u0010\u000b\u0018\u0001*\u00020\f2\u001e\u0010\r\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\n0\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0082\b\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0007H\u0000\u001a\"\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00130\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\"\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00130\nH\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0017"}, d2={"finishTimestamp", "Ljava/time/Instant;", "Lcom/intellij/tools/ide/metrics/collector/telemetry/SpanElement;", "getFinishTimestamp", "(Lcom/intellij/tools/ide/metrics/collector/telemetry/SpanElement;)Ljava/time/Instant;", "toSpanElement", "span", "Lcom/intellij/tools/ide/metrics/collector/telemetry/SpanData;", "createCachedListSerializer", "Lkotlinx/serialization/KSerializer;", "", "T", "", "listCache", "", "elementCache", "getParentSpanId", "", "getTags", "Lkotlin/Pair;", "isWarmup", "", "tags", "intellij.tools.ide.metrics.collector"})
@SourceDebugExtension(value={"SMAP\nSpanElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpanElement.kt\ncom/intellij/tools/ide/metrics/collector/telemetry/SpanElementKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n1#2:182\n295#3,2:183\n*S KotlinDebug\n*F\n+ 1 SpanElement.kt\ncom/intellij/tools/ide/metrics/collector/telemetry/SpanElementKt\n*L\n166#1:183,2\n*E\n"})
public final class SpanElementKt {
    @NotNull
    public static final Instant getFinishTimestamp(@NotNull SpanElement $this$finishTimestamp) {
        Intrinsics.checkNotNullParameter((Object)$this$finishTimestamp, (String)"<this>");
        Instant instant = $this$finishTimestamp.startTimestamp.plusNanos(Duration.getInWholeNanoseconds-impl((long)$this$finishTimestamp.getDuration-UwyO8pc()));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plusNanos(...)");
        return instant;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SpanElement toSpanElement(@NotNull SpanData span) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        List<Pair<String, String>> tags = SpanElementKt.getTags(span);
        boolean bl = SpanElementKt.isWarmup(tags);
        String string = span.operationName;
        Duration duration = span.getDurationNano-FghU774();
        long l = duration != null ? duration.unbox-impl() : Duration.times-UwyO8pc((long)span.getDuration-UwyO8pc(), (int)1000);
        Instant instant = span.getStartTimeNano();
        if (instant == null) {
            Instant instant2;
            Long l2 = span.getStartTime();
            if (l2 != null) {
                void it;
                long l3 = ((Number)l2).longValue();
                long l4 = l;
                String string2 = string;
                boolean bl2 = bl;
                boolean bl3 = false;
                Instant instant3 = Instant.ofEpochMilli((long)(it / (long)1000));
                bl = bl2;
                string = string2;
                l = l4;
                instant2 = instant3;
            } else {
                instant2 = instant = null;
            }
            if (instant2 == null) {
                throw new IllegalStateException("startTime or startTimeNano should exists");
            }
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        List<Pair<String, String>> list = tags;
        String string3 = SpanElementKt.getParentSpanId(span);
        String string4 = span.spanID;
        Instant instant4 = instant;
        long l5 = l;
        String string5 = string;
        boolean bl4 = bl;
        return new SpanElement(bl4, string5, l5, instant4, string4, string3, list, defaultConstructorMarker);
    }

    private static final /* synthetic */ <T> KSerializer<List<T>> createCachedListSerializer(Map<List<T>, List<T>> listCache, Map<T, T> elementCache) {
        boolean $i$f$createCachedListSerializer = false;
        Intrinsics.needClassReification();
        return new KSerializer<List<? extends T>>(elementCache, listCache){
            private final CachedElementSerializer<T> elementSerializer;
            private final KSerializer<List<T>> delegate;
            private final SerialDescriptor descriptor;
            final /* synthetic */ Map<List<T>, List<T>> $listCache;
            {
                this.$listCache = $listCache;
                Intrinsics.reifiedOperationMarker((int)6, (String)"T");
                MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.simple");
                this.elementSerializer = new CachedElementSerializer<T>(SerializersKt.serializer(null), $elementCache);
                this.delegate = BuiltinSerializersKt.ListSerializer((KSerializer)this.elementSerializer);
                this.descriptor = this.delegate.getDescriptor();
            }

            public SerialDescriptor getDescriptor() {
                return this.descriptor;
            }

            public void serialize(Encoder encoder, List<? extends T> value) {
                Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
                Intrinsics.checkNotNullParameter(value, (String)"value");
                this.delegate.serialize(encoder, value);
            }

            /*
             * WARNING - void declaration
             */
            public List<T> deserialize(Decoder decoder) {
                Object object;
                void $this$getOrPut$iv;
                Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
                List deserialized = (List)this.delegate.deserialize(decoder);
                Map<List<T>, List<T>> map = this.$listCache;
                List key$iv = deserialized;
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = deserialized;
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                return (List)object;
            }
        };
    }

    @Nullable
    public static final String getParentSpanId(@NotNull SpanData $this$getParentSpanId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getParentSpanId, (String)"<this>");
            Iterable $this$firstOrNull$iv = $this$getParentSpanId.references;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SpanRef it = (SpanRef)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.refType, (Object)"CHILD_OF")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        SpanRef spanRef = v0;
        return spanRef != null ? spanRef.spanID : null;
    }

    private static final List<Pair<String, String>> getTags(SpanData span) {
        ArrayList<Pair> tags = new ArrayList<Pair>(span.tags.size());
        for (SpanTag tag : span.tags) {
            String textValue;
            String attributeName;
            Intrinsics.checkNotNull((Object)tag.key);
            Intrinsics.checkNotNull((Object)tag.value);
            tags.add(new Pair((Object)attributeName, (Object)textValue));
        }
        return tags;
    }

    private static final boolean isWarmup(List<Pair<String, String>> tags) {
        Object v0;
        block1: {
            Iterable iterable = tags;
            for (Object t : iterable) {
                Pair it = (Pair)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getFirst(), (Object)"warmup") && Intrinsics.areEqual((Object)it.getSecond(), (Object)"true"))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }
}

