/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.performanceTesting.commands.codeTyping;

import com.intellij.tools.ide.performanceTesting.commands.CommandChain;
import com.intellij.tools.ide.performanceTesting.commands.GeneralCommandChainKt;
import com.intellij.tools.ide.performanceTesting.commands.Keys;
import com.intellij.tools.ide.performanceTesting.commands.codeTyping.CodeTypingPlan;
import com.intellij.tools.ide.performanceTesting.commands.codeTyping.CodeTypingPlanGenerator;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J-\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J/\u0010\u0014\u001a\u00020\u0015\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0018J%\u0010\u0019\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\u0006\u0010\u0010\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/tools/ide/performanceTesting/commands/codeTyping/CodeTypingCommandGenerator;", "", "<init>", "()V", "CODE_TYPING_SPAN_NAME", "", "CODE_TYPING_WARMUP_SPAN_NAME", "TYPING_DELAY_MS", "", "preparePlan", "Lcom/intellij/tools/ide/performanceTesting/commands/codeTyping/CodeTypingPlan;", "input", "generateCommands", "T", "Lcom/intellij/tools/ide/performanceTesting/commands/CommandChain;", "commands", "plan", "isWarmup", "", "(Lcom/intellij/tools/ide/performanceTesting/commands/CommandChain;Lcom/intellij/tools/ide/performanceTesting/commands/codeTyping/CodeTypingPlan;Z)Lcom/intellij/tools/ide/performanceTesting/commands/CommandChain;", "generateTokenCommand", "", "token", "Lcom/intellij/tools/ide/performanceTesting/commands/codeTyping/CodeTypingPlan$Token;", "(Lcom/intellij/tools/ide/performanceTesting/commands/CommandChain;Lcom/intellij/tools/ide/performanceTesting/commands/codeTyping/CodeTypingPlan$Token;Z)V", "generateReverseCommands", "(Lcom/intellij/tools/ide/performanceTesting/commands/CommandChain;Lcom/intellij/tools/ide/performanceTesting/commands/codeTyping/CodeTypingPlan;)Lcom/intellij/tools/ide/performanceTesting/commands/CommandChain;", "intellij.tools.ide.performanceTesting.commands"})
@SourceDebugExtension(value={"SMAP\nCodeTypingCommandGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeTypingCommandGenerator.kt\ncom/intellij/tools/ide/performanceTesting/commands/codeTyping/CodeTypingCommandGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,358:1\n1915#2,2:359\n1834#2,4:361\n*S KotlinDebug\n*F\n+ 1 CodeTypingCommandGenerator.kt\ncom/intellij/tools/ide/performanceTesting/commands/codeTyping/CodeTypingCommandGenerator\n*L\n88#1:359,2\n168#1:361,4\n*E\n"})
public final class CodeTypingCommandGenerator {
    @NotNull
    public static final CodeTypingCommandGenerator INSTANCE = new CodeTypingCommandGenerator();
    @NotNull
    private static final String CODE_TYPING_SPAN_NAME = "codeTyping";
    @NotNull
    private static final String CODE_TYPING_WARMUP_SPAN_NAME = "codeTyping_warmup";
    private static final int TYPING_DELAY_MS = 50;

    private CodeTypingCommandGenerator() {
    }

    @NotNull
    public final CodeTypingPlan preparePlan(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return CodeTypingPlanGenerator.INSTANCE.generatePlan(input);
    }

    @NotNull
    public final <T extends CommandChain> T generateCommands(@NotNull T commands, @NotNull CodeTypingPlan plan, boolean isWarmup) {
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        Intrinsics.checkNotNullParameter((Object)plan, (String)"plan");
        String spanName = isWarmup ? CODE_TYPING_WARMUP_SPAN_NAME : CODE_TYPING_SPAN_NAME;
        GeneralCommandChainKt.startNewSpan(commands, spanName);
        Iterable $this$forEach$iv = plan.getTokens();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeTypingPlan.Token token = (CodeTypingPlan.Token)element$iv;
            boolean bl = false;
            INSTANCE.generateTokenCommand(commands, token, isWarmup);
        }
        GeneralCommandChainKt.waitForCodeAnalysisFinished(commands);
        GeneralCommandChainKt.stopSpan(commands, spanName);
        return commands;
    }

    private final <T extends CommandChain> void generateTokenCommand(T commands, CodeTypingPlan.Token token, boolean isWarmup) {
        CodeTypingPlan.Token token2 = token;
        if (token2 instanceof CodeTypingPlan.TextToken) {
            v0 = GeneralCommandChainKt.delayType$default(commands, 50, ((CodeTypingPlan.TextToken)token).getText(), false, false, 12, null);
        } else if (Intrinsics.areEqual((Object)token2, (Object)CodeTypingPlan.NewLineToken.INSTANCE)) {
            GeneralCommandChainKt.pressKey(commands, Keys.ENTER);
            v0 = GeneralCommandChainKt.waitForCodeAnalysisFinished(commands);
        } else if (Intrinsics.areEqual((Object)token2, (Object)CodeTypingPlan.SkipLineToken.INSTANCE)) {
            v0 = GeneralCommandChainKt.pressKey(commands, Keys.ARROW_DOWN);
        } else if (token2 instanceof CodeTypingPlan.CompletionToken) {
            GeneralCommandChainKt.delayType$default(commands, 50, ((CodeTypingPlan.CompletionToken)token).getShortcut(), false, false, 12, null);
            CommandChain commandChain = isWarmup ? GeneralCommandChainKt.doCompleteWarmup$default(commands, null, 1, null) : GeneralCommandChainKt.doComplete$default(commands, null, 1, null);
            GeneralCommandChainKt.delay(commands, 200);
            GeneralCommandChainKt.pressKey(commands, Keys.ESCAPE);
            int n = ((CodeTypingPlan.CompletionToken)token).getShortcut().length();
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                GeneralCommandChainKt.pressKey(commands, Keys.BACKSPACE);
            }
            v0 = GeneralCommandChainKt.delayType$default(commands, 10, ((CodeTypingPlan.CompletionToken)token).getFullIdentifier(), false, false, 12, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends CommandChain> T generateReverseCommands(@NotNull T commands, @NotNull CodeTypingPlan plan) {
        int n;
        void $this$count$iv;
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        Intrinsics.checkNotNullParameter((Object)plan, (String)"plan");
        Iterable iterable = plan.getTokens();
        int n2 = 1;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                CodeTypingPlan.Token it = (CodeTypingPlan.Token)element$iv;
                boolean bl = false;
                if (!(it instanceof CodeTypingPlan.NewLineToken || it instanceof CodeTypingPlan.SkipLineToken) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n3 = n;
        int lines = n2 + n3;
        int n4 = 0;
        while (n4 < lines) {
            int it = n4++;
            boolean bl = false;
            GeneralCommandChainKt.pressKey(commands, Keys.DELETE_LINE);
            GeneralCommandChainKt.pressKey(commands, Keys.ARROW_UP);
        }
        GeneralCommandChainKt.pressKey(commands, Keys.ENTER);
        return commands;
    }
}

