/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.performanceTesting.commands.codeTyping;

import com.intellij.tools.ide.performanceTesting.commands.codeTyping.CodeTypingPlan;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J&\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J$\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/tools/ide/performanceTesting/commands/codeTyping/CodeTypingPlanGenerator;", "", "<init>", "()V", "generatePlan", "Lcom/intellij/tools/ide/performanceTesting/commands/codeTyping/CodeTypingPlan;", "input", "", "parseInput", "", "Lcom/intellij/tools/ide/performanceTesting/commands/codeTyping/CodeTypingPlan$Token;", "parseExplicitShortcut", "Lkotlin/Pair;", "", "startIndex", "generateShortcut", "identifier", "parseIdentifier", "simplifyTokens", "", "tokens", "intellij.tools.ide.performanceTesting.commands"})
@SourceDebugExtension(value={"SMAP\nCodeTypingCommandGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeTypingCommandGenerator.kt\ncom/intellij/tools/ide/performanceTesting/commands/codeTyping/CodeTypingPlanGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,358:1\n1924#2,3:359\n*S KotlinDebug\n*F\n+ 1 CodeTypingCommandGenerator.kt\ncom/intellij/tools/ide/performanceTesting/commands/codeTyping/CodeTypingPlanGenerator\n*L\n324#1:359,3\n*E\n"})
final class CodeTypingPlanGenerator {
    @NotNull
    public static final CodeTypingPlanGenerator INSTANCE = new CodeTypingPlanGenerator();

    private CodeTypingPlanGenerator() {
    }

    @NotNull
    public final CodeTypingPlan generatePlan(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        List<CodeTypingPlan.Token> tokens = this.parseInput(input);
        List<CodeTypingPlan.Token> simplifiedTokens = this.simplifyTokens(tokens);
        return new CodeTypingPlan(simplifiedTokens);
    }

    private final List<CodeTypingPlan.Token> parseInput(String input) {
        List tokens = new ArrayList();
        StringBuilder rawBuffer = new StringBuilder();
        int i = 0;
        block5: while (i < input.length()) {
            switch (input.charAt(i)) {
                case '~': {
                    int newIndex2;
                    int newIndex;
                    CodeTypingPlanGenerator.parseInput$flushRawBuffer(rawBuffer, tokens);
                    Pair<String, Integer> pair = this.parseExplicitShortcut(input, ++i);
                    String explicitShortcut = (String)pair.component1();
                    i = newIndex = ((Number)pair.component2()).intValue();
                    Pair<String, Integer> pair2 = this.parseIdentifier(input, i);
                    String identifier = (String)pair2.component1();
                    i = newIndex2 = ((Number)pair2.component2()).intValue();
                    String string = explicitShortcut;
                    if (string == null) {
                        string = this.generateShortcut(identifier);
                    }
                    String shortcut = string;
                    tokens.add(new CodeTypingPlan.CompletionToken(shortcut, identifier));
                    continue block5;
                }
                case '\n': {
                    CodeTypingPlanGenerator.parseInput$flushRawBuffer(rawBuffer, tokens);
                    tokens.add(CodeTypingPlan.NewLineToken.INSTANCE);
                    ++i;
                    continue block5;
                }
                case '\u2193': {
                    CodeTypingPlanGenerator.parseInput$flushRawBuffer(rawBuffer, tokens);
                    tokens.add(CodeTypingPlan.SkipLineToken.INSTANCE);
                    ++i;
                    continue block5;
                }
            }
            rawBuffer.append(input.charAt(i));
            ++i;
        }
        CodeTypingPlanGenerator.parseInput$flushRawBuffer(rawBuffer, tokens);
        return tokens;
    }

    private final Pair<String, Integer> parseExplicitShortcut(String input, int startIndex) {
        Pair pair;
        int i = startIndex;
        if (i < input.length() && input.charAt(i) == '[') {
            Pair<String, Integer> pair2 = this.parseIdentifier(input, ++i);
            String shortcut = (String)pair2.component1();
            int newIndex = ((Number)pair2.component2()).intValue();
            i = newIndex;
            if (i >= input.length() || input.charAt(i) != ']') {
                throw new IllegalStateException("Missing closing `]` in explicit shortcut for completion command!".toString());
            }
            pair = TuplesKt.to((Object)shortcut, (Object)(++i));
        } else {
            pair = TuplesKt.to(null, (Object)i);
        }
        return pair;
    }

    private final String generateShortcut(String identifier) {
        int firstWordEnd;
        if (((CharSequence)identifier).length() == 0) {
            return "";
        }
        for (firstWordEnd = 1; firstWordEnd < identifier.length() && !Character.isUpperCase(identifier.charAt(firstWordEnd)); ++firstWordEnd) {
        }
        String string = identifier.substring(0, firstWordEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String firstWord = string;
        return StringsKt.take((String)firstWord, (int)5);
    }

    private final Pair<String, Integer> parseIdentifier(String input, int startIndex) {
        int i;
        for (i = startIndex; i < input.length() && (Character.isLetterOrDigit(input.charAt(i)) || input.charAt(i) == '_'); ++i) {
        }
        String string = input.substring(startIndex, i);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String identifier = string;
        return TuplesKt.to((Object)identifier, (Object)i);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CodeTypingPlan.Token> simplifyTokens(List<? extends CodeTypingPlan.Token> tokens) {
        List list;
        List $this$simplifyTokens_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = tokens;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void token;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            CodeTypingPlan.Token token2 = (CodeTypingPlan.Token)item$iv;
            int index = n;
            boolean bl2 = false;
            CodeTypingPlan.Token nextToken = (CodeTypingPlan.Token)CollectionsKt.getOrNull(tokens, (int)(index + 1));
            if (Intrinsics.areEqual((Object)token, (Object)CodeTypingPlan.NewLineToken.INSTANCE) && Intrinsics.areEqual((Object)nextToken, (Object)CodeTypingPlan.SkipLineToken.INSTANCE)) continue;
            $this$simplifyTokens_u24lambda_u240.add(token);
        }
        return CollectionsKt.build((List)list);
    }

    private static final void parseInput$flushRawBuffer(StringBuilder rawBuffer, List<CodeTypingPlan.Token> tokens) {
        if (((CharSequence)rawBuffer).length() > 0) {
            String string = rawBuffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String text = string;
            String trimmedText = Intrinsics.areEqual((Object)CollectionsKt.lastOrNull(tokens), (Object)CodeTypingPlan.NewLineToken.INSTANCE) ? ((Object)StringsKt.trimStart((CharSequence)text)).toString() : text;
            if (((CharSequence)trimmedText).length() > 0) {
                tokens.add(new CodeTypingPlan.TextToken(trimmedText));
            }
            StringsKt.clear((StringBuilder)rawBuffer);
        }
    }
}

