/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.starter.bus.shared.server.services;

import com.intellij.tools.ide.starter.bus.shared.dto.SharedEventDto;
import com.intellij.tools.ide.starter.bus.shared.dto.SubscriberDto;
import com.intellij.tools.ide.starter.bus.shared.server.services.EventsFlowServiceKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010!\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0006J\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0006J\u0006\u0010\u001f\u001a\u00020\u0012Rb\u0010\u0004\u001aV\u0012\u0004\u0012\u00020\u0006\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b0\u0005j*\u0012\u0004\u0012\u00020\u0006\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/tools/ide/starter/bus/shared/server/services/EventsFlowService;", "", "<init>", "()V", "subscribersPerProcess", "Ljava/util/HashMap;", "", "Lcom/intellij/tools/ide/starter/bus/shared/server/services/EventsFlowService$SubscribersWithEvents;", "Lkotlin/collections/HashMap;", "subscribersPerProcessLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "eventsLatch", "Ljava/util/concurrent/CountDownLatch;", "eventsLatchLock", "lockByEvent", "getLock", "key", "postAndWaitProcessing", "", "sharedEventDto", "Lcom/intellij/tools/ide/starter/bus/shared/dto/SharedEventDto;", "newSubscriber", "subscriber", "Lcom/intellij/tools/ide/starter/bus/shared/dto/SubscriberDto;", "unsubscribe", "getEvents", "", "", "processId", "processedEvent", "eventId", "clear", "SubscribersWithEvents", "intellij.tools.ide.starter.bus"})
@SourceDebugExtension(value={"SMAP\nEventsFlowService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventsFlowService.kt\ncom/intellij/tools/ide/starter/bus/shared/server/services/EventsFlowService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n777#2:108\n873#2,2:109\n1391#2:111\n1480#2,5:112\n1391#2:117\n1480#2,5:118\n1915#2,2:124\n1205#2,2:126\n1282#2,4:128\n1#3:123\n*S KotlinDebug\n*F\n+ 1 EventsFlowService.kt\ncom/intellij/tools/ide/starter/bus/shared/server/services/EventsFlowService\n*L\n38#1:108\n38#1:109,2\n41#1:111\n41#1:112,5\n42#1:117\n42#1:118,5\n48#1:124,2\n80#1:126,2\n80#1:128,4\n*E\n"})
public final class EventsFlowService {
    @NotNull
    private final HashMap<String, HashMap<String, SubscribersWithEvents>> subscribersPerProcess = new HashMap();
    @NotNull
    private final ReentrantReadWriteLock subscribersPerProcessLock = new ReentrantReadWriteLock();
    @NotNull
    private final HashMap<String, CountDownLatch> eventsLatch = new HashMap();
    @NotNull
    private final ReentrantReadWriteLock eventsLatchLock = new ReentrantReadWriteLock();
    @NotNull
    private final HashMap<String, Object> lockByEvent = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object getLock(String key) {
        HashMap<String, Object> hashMap = this.lockByEvent;
        synchronized (hashMap) {
            boolean bl = false;
            Object object = this.lockByEvent.computeIfAbsent(key, arg_0 -> EventsFlowService.getLock$lambda$0$1(EventsFlowService::getLock$lambda$0$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeIfAbsent(...)");
            Object object2 = object;
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void postAndWaitProcessing(@NotNull SharedEventDto sharedEventDto) {
        Intrinsics.checkNotNullParameter((Object)sharedEventDto, (String)"sharedEventDto");
        EventsFlowServiceKt.access$getLOG$p().debug("Before synchronized");
        Object object = this.getLock(sharedEventDto.getEventId());
        synchronized (object) {
            int n;
            boolean bl = false;
            EventsFlowServiceKt.access$getLOG$p().debug("Start synchronized");
            Ref.LongRef timeout = new Ref.LongRef();
            ReentrantReadWriteLock.ReadLock readLock = this.subscribersPerProcessLock.readLock();
            Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
            Lock lock = readLock;
            lock.lock();
            try {
                long l;
                Iterable list$iv$iv;
                Iterable $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                Object it;
                void $this$filterTo$iv$iv;
                n = 0;
                Collection<HashMap<String, SubscribersWithEvents>> collection = this.subscribersPerProcess.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Object destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (HashMap)element$iv$iv;
                    boolean bl2 = false;
                    if (!(((HashMap)it).get(sharedEventDto.getEventName()) != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List matchingSubscribers = (List)destination$iv$iv;
                $this$filter$iv = matchingSubscribers;
                Ref.LongRef longRef = timeout;
                boolean $i$f$flatMap = false;
                $this$filterTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (HashMap)element$iv$iv;
                    boolean bl3 = false;
                    Collection collection2 = ((HashMap)it).values();
                    Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
                    list$iv$iv = collection2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                $i$f$flatMap = false;
                $this$flatMapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (SubscribersWithEvents)element$iv$iv;
                    boolean bl4 = false;
                    list$iv$iv = ((SubscribersWithEvents)it).getSubscribers();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                long l2 = 0L;
                for (Object $i$f$flatMapTo2 : $this$flatMap$iv) {
                    void it2;
                    SubscriberDto subscriberDto = (SubscriberDto)$i$f$flatMapTo2;
                    l = l2;
                    boolean bl5 = false;
                    long l3 = it2.getTimeoutMs();
                    l2 = l + l3;
                }
                longRef.element = l = l2;
                n = matchingSubscribers.size();
            }
            finally {
                lock.unlock();
            }
            int n2 = n;
            CountDownLatch latch = new CountDownLatch(n2);
            ReentrantReadWriteLock.WriteLock writeLock = this.eventsLatchLock.writeLock();
            Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
            lock = writeLock;
            lock.lock();
            try {
                boolean $i$a$-withLock-EventsFlowService$postAndWaitProcessing$1$32 = false;
                ((Map)this.eventsLatch).put(sharedEventDto.getEventId(), latch);
                Unit $i$a$-withLock-EventsFlowService$postAndWaitProcessing$1$32 = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock2 = this.subscribersPerProcessLock.writeLock();
            Intrinsics.checkNotNullExpressionValue((Object)writeLock2, (String)"writeLock(...)");
            lock = writeLock2;
            lock.lock();
            try {
                boolean bl6 = false;
                Collection<HashMap<String, SubscribersWithEvents>> collection = this.subscribersPerProcess.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    HashMap it = (HashMap)element$iv;
                    boolean bl7 = false;
                    Object object2 = (SubscribersWithEvents)it.get(sharedEventDto.getEventName());
                    if (object2 == null || (object2 = ((SubscribersWithEvents)object2).getEvents()) == null) continue;
                    object2.add(sharedEventDto);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            EventsFlowServiceKt.access$getLOG$p().debug("Before latch awaiting. Count " + latch.getCount());
            latch.await(timeout.element, TimeUnit.MILLISECONDS);
            EventsFlowServiceKt.access$getLOG$p().debug("After latch awaiting");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void newSubscriber(@NotNull SubscriberDto subscriber) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        String string = subscriber.getEventName();
        synchronized (string) {
            boolean bl;
            boolean bl2 = false;
            ReentrantReadWriteLock.WriteLock writeLock = this.subscribersPerProcessLock.writeLock();
            Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
            Lock lock = writeLock;
            lock.lock();
            try {
                boolean bl3 = false;
                bl = this.subscribersPerProcess.computeIfAbsent(subscriber.getProcessId(), arg_0 -> EventsFlowService.newSubscriber$lambda$0$0$1(EventsFlowService::newSubscriber$lambda$0$0$0, arg_0)).computeIfAbsent(subscriber.getEventName(), arg_0 -> EventsFlowService.newSubscriber$lambda$0$0$3(EventsFlowService::newSubscriber$lambda$0$0$2, arg_0)).getSubscribers().add(subscriber);
            }
            finally {
                lock.unlock();
            }
            boolean bl4 = bl;
        }
        EventsFlowServiceKt.access$getLOG$p().info("New subscriber " + subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unsubscribe(@NotNull SubscriberDto subscriber) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        String string = subscriber.getEventName();
        synchronized (string) {
            Boolean bl;
            boolean bl2 = false;
            ReentrantReadWriteLock.WriteLock writeLock = this.subscribersPerProcessLock.writeLock();
            Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
            Lock lock = writeLock;
            lock.lock();
            try {
                boolean bl3 = false;
                HashMap<String, SubscribersWithEvents> data = this.subscribersPerProcess.get(subscriber.getProcessId());
                Object object = data;
                bl = object != null && (object = ((HashMap)object).get(subscriber.getEventName())) != null && (object = ((SubscribersWithEvents)object).getSubscribers()) != null ? Boolean.valueOf(object.removeIf(arg_0 -> EventsFlowService.unsubscribe$lambda$0$0$1(arg_0 -> EventsFlowService.unsubscribe$lambda$0$0$0(subscriber, arg_0), arg_0))) : null;
            }
            finally {
                lock.unlock();
            }
            Boolean bl4 = bl;
        }
        EventsFlowServiceKt.access$getLOG$p().debug("Unsubscribed " + subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<SharedEventDto>> getEvents(@NotNull String processId) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        ReentrantReadWriteLock.ReadLock readLock = this.subscribersPerProcessLock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            void $this$associateTo$iv$iv;
            boolean bl = false;
            Set set = this.subscribersPerProcess.getOrDefault(processId, new HashMap()).entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Iterable $this$associate$iv = set;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to(it.getKey(), ((SubscribersWithEvents)it.getValue()).getEvents());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv;
        }
        finally {
            lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processedEvent(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        ReentrantReadWriteLock.ReadLock readLock = this.eventsLatchLock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            Unit unit;
            boolean bl = false;
            CountDownLatch countDownLatch = this.eventsLatch.get(eventId);
            if (countDownLatch != null) {
                countDownLatch.countDown();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        ReentrantReadWriteLock.WriteLock writeLock = this.eventsLatchLock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean $i$a$-withLock-EventsFlowService$clear$32 = false;
            this.eventsLatch.clear();
            Unit $i$a$-withLock-EventsFlowService$clear$32 = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock2 = this.subscribersPerProcessLock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock2, (String)"writeLock(...)");
        lock = writeLock2;
        lock.lock();
        try {
            boolean bl = false;
            this.subscribersPerProcess.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.lockByEvent.clear();
    }

    private static final Object getLock$lambda$0$0(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        return new Object();
    }

    private static final Object getLock$lambda$0$1(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    private static final HashMap newSubscriber$lambda$0$0$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashMap();
    }

    private static final HashMap newSubscriber$lambda$0$0$1(Function1 $tmp0, Object p0) {
        return (HashMap)$tmp0.invoke(p0);
    }

    private static final SubscribersWithEvents newSubscriber$lambda$0$0$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new SubscribersWithEvents(new ArrayList(), new ArrayList());
    }

    private static final SubscribersWithEvents newSubscriber$lambda$0$0$3(Function1 $tmp0, Object p0) {
        return (SubscribersWithEvents)$tmp0.invoke(p0);
    }

    private static final boolean unsubscribe$lambda$0$0$0(SubscriberDto $subscriber, SubscriberDto it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getSubscriberName(), (Object)$subscriber.getSubscriberName());
    }

    private static final boolean unsubscribe$lambda$0$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/intellij/tools/ide/starter/bus/shared/server/services/EventsFlowService$SubscribersWithEvents;", "", "subscribers", "", "Lcom/intellij/tools/ide/starter/bus/shared/dto/SubscriberDto;", "events", "Lcom/intellij/tools/ide/starter/bus/shared/dto/SharedEventDto;", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getSubscribers", "()Ljava/util/List;", "getEvents", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.tools.ide.starter.bus"})
    private static final class SubscribersWithEvents {
        @NotNull
        private final List<SubscriberDto> subscribers;
        @NotNull
        private final List<SharedEventDto> events;

        public SubscribersWithEvents(@NotNull List<SubscriberDto> subscribers, @NotNull List<SharedEventDto> events) {
            Intrinsics.checkNotNullParameter(subscribers, (String)"subscribers");
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.subscribers = subscribers;
            this.events = events;
        }

        @NotNull
        public final List<SubscriberDto> getSubscribers() {
            return this.subscribers;
        }

        @NotNull
        public final List<SharedEventDto> getEvents() {
            return this.events;
        }

        @NotNull
        public final List<SubscriberDto> component1() {
            return this.subscribers;
        }

        @NotNull
        public final List<SharedEventDto> component2() {
            return this.events;
        }

        @NotNull
        public final SubscribersWithEvents copy(@NotNull List<SubscriberDto> subscribers, @NotNull List<SharedEventDto> events) {
            Intrinsics.checkNotNullParameter(subscribers, (String)"subscribers");
            Intrinsics.checkNotNullParameter(events, (String)"events");
            return new SubscribersWithEvents(subscribers, events);
        }

        public static /* synthetic */ SubscribersWithEvents copy$default(SubscribersWithEvents subscribersWithEvents, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = subscribersWithEvents.subscribers;
            }
            if ((n & 2) != 0) {
                list2 = subscribersWithEvents.events;
            }
            return subscribersWithEvents.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "SubscribersWithEvents(subscribers=" + this.subscribers + ", events=" + this.events + ")";
        }

        public int hashCode() {
            int result = ((Object)this.subscribers).hashCode();
            result = result * 31 + ((Object)this.events).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SubscribersWithEvents)) {
                return false;
            }
            SubscribersWithEvents subscribersWithEvents = (SubscribersWithEvents)other;
            if (!Intrinsics.areEqual(this.subscribers, subscribersWithEvents.subscribers)) {
                return false;
            }
            return Intrinsics.areEqual(this.events, subscribersWithEvents.events);
        }
    }
}

