/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.starter.bus.shared.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.tools.ide.starter.bus.shared.dto.SharedEventDto;
import com.intellij.tools.ide.starter.bus.shared.dto.SubscriberDto;
import com.intellij.tools.ide.starter.bus.shared.server.LocalEventBusServerKt;
import com.intellij.tools.ide.starter.bus.shared.server.services.EventsFlowService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@ChannelHandler.Sharable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0014J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/tools/ide/starter/bus/shared/server/EventBusServerHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lio/netty/handler/codec/http/FullHttpRequest;", "eventsFlowService", "Lcom/intellij/tools/ide/starter/bus/shared/server/services/EventsFlowService;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lcom/intellij/tools/ide/starter/bus/shared/server/services/EventsFlowService;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "channelRead0", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "request", "handlePostAndWaitProcessing", "handleNewSubscriber", "handleUnsubscribe", "handleGetEvents", "handleProcessedEvent", "handleClear", "sendResponse", "message", "", "sendJsonResponse", "jsonBytes", "", "sendError", "status", "Lio/netty/handler/codec/http/HttpResponseStatus;", "exceptionCaught", "cause", "", "intellij.tools.ide.starter.bus"})
final class EventBusServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    @NotNull
    private final EventsFlowService eventsFlowService;
    @NotNull
    private final ObjectMapper objectMapper;

    public EventBusServerHandler(@NotNull EventsFlowService eventsFlowService, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)eventsFlowService, (String)"eventsFlowService");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.eventsFlowService = eventsFlowService;
        this.objectMapper = objectMapper;
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String uri = request.uri();
        Intrinsics.checkNotNull((Object)uri);
        String path = StringsKt.substringBefore$default((String)uri, (char)'?', null, (int)2, null);
        LocalEventBusServerKt.access$getLOG$p().debug("Incoming request: method=" + request.method() + ", path=" + path + ", uri=" + uri + ", headers=" + request.headers());
        try {
            if (Intrinsics.areEqual((Object)path, (Object)"/postAndWaitProcessing") && Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.POST)) {
                this.handlePostAndWaitProcessing(ctx, request);
            } else if (Intrinsics.areEqual((Object)path, (Object)"/newSubscriber") && Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.POST)) {
                this.handleNewSubscriber(ctx, request);
            } else if (Intrinsics.areEqual((Object)path, (Object)"/unsubscribe") && Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.POST)) {
                this.handleUnsubscribe(ctx, request);
            } else if (Intrinsics.areEqual((Object)path, (Object)"/getEvents") && Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.POST)) {
                this.handleGetEvents(ctx, request);
            } else if (Intrinsics.areEqual((Object)path, (Object)"/processedEvent") && Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.POST)) {
                this.handleProcessedEvent(ctx, request);
            } else if (Intrinsics.areEqual((Object)path, (Object)"/clear") && Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.POST)) {
                this.handleClear(ctx, request);
            } else {
                LocalEventBusServerKt.access$getLOG$p().error("Unknown endpoint: " + path);
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
                this.sendError(ctx, httpResponseStatus, "Endpoint not found");
            }
        }
        catch (Throwable t) {
            LocalEventBusServerKt.access$getLOG$p().error("Error handling request: " + t.getMessage());
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"INTERNAL_SERVER_ERROR");
            String string = t.getMessage();
            if (string == null) {
                string = t.toString();
            }
            this.sendError(ctx, httpResponseStatus, string);
        }
    }

    private final void handlePostAndWaitProcessing(ChannelHandlerContext ctx, FullHttpRequest request) {
        String json = request.content().toString(CharsetUtil.UTF_8);
        ((CompletableFuture)CompletableFuture.runAsync(() -> EventBusServerHandler.handlePostAndWaitProcessing$lambda$0(this, json)).thenRun(() -> EventBusServerHandler.handlePostAndWaitProcessing$lambda$1(this, ctx))).exceptionally(arg_0 -> EventBusServerHandler.handlePostAndWaitProcessing$lambda$2(this, ctx, arg_0));
    }

    private final void handleNewSubscriber(ChannelHandlerContext ctx, FullHttpRequest request) {
        String json = request.content().toString(CharsetUtil.UTF_8);
        SubscriberDto subscriberDto = (SubscriberDto)this.objectMapper.readValue(json, SubscriberDto.class);
        Intrinsics.checkNotNull((Object)subscriberDto);
        this.eventsFlowService.newSubscriber(subscriberDto);
        this.sendResponse(ctx, "Created");
    }

    private final void handleUnsubscribe(ChannelHandlerContext ctx, FullHttpRequest request) {
        String json = request.content().toString(CharsetUtil.UTF_8);
        SubscriberDto subscriberDto = (SubscriberDto)this.objectMapper.readValue(json, SubscriberDto.class);
        Intrinsics.checkNotNull((Object)subscriberDto);
        this.eventsFlowService.unsubscribe(subscriberDto);
        this.sendResponse(ctx, "Unsubscribed");
    }

    private final void handleGetEvents(ChannelHandlerContext ctx, FullHttpRequest request) {
        String processId = request.content().toString(CharsetUtil.UTF_8);
        Intrinsics.checkNotNull((Object)processId);
        byte[] eventsJson = this.objectMapper.writeValueAsBytes(this.eventsFlowService.getEvents(processId));
        Intrinsics.checkNotNull((Object)eventsJson);
        this.sendJsonResponse(ctx, eventsJson);
    }

    private final void handleProcessedEvent(ChannelHandlerContext ctx, FullHttpRequest request) {
        String eventName = request.content().toString(CharsetUtil.UTF_8);
        Intrinsics.checkNotNull((Object)eventName);
        this.eventsFlowService.processedEvent(eventName);
        this.sendResponse(ctx, "Processed");
    }

    private final void handleClear(ChannelHandlerContext ctx, FullHttpRequest request) {
        this.eventsFlowService.clear();
        this.sendResponse(ctx, "Cleared");
    }

    private final void sendResponse(ChannelHandlerContext ctx, String message) {
        ByteBuf content = Unpooled.copiedBuffer((CharSequence)message, (Charset)CharsetUtil.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private final void sendJsonResponse(ChannelHandlerContext ctx, byte[] jsonBytes) {
        ByteBuf content = Unpooled.copiedBuffer((byte[])jsonBytes);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=UTF-8");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private final void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, String message) {
        ByteBuf content = Unpooled.copiedBuffer((CharSequence)message, (Charset)CharsetUtil.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        LocalEventBusServerKt.access$getLOG$p().error("Exception in channel " + cause);
        ctx.close();
    }

    private static final void handlePostAndWaitProcessing$lambda$0(EventBusServerHandler this$0, String $json) {
        LocalEventBusServerKt.access$getLOG$p().debug("Got postAndWait request");
        EventsFlowService eventsFlowService = this$0.eventsFlowService;
        Object object = this$0.objectMapper.readValue($json, SharedEventDto.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        eventsFlowService.postAndWaitProcessing((SharedEventDto)object);
    }

    private static final void handlePostAndWaitProcessing$lambda$1(EventBusServerHandler this$0, ChannelHandlerContext $ctx) {
        LocalEventBusServerKt.access$getLOG$p().debug("Processed postAndWait request");
        this$0.sendResponse($ctx, "Processed");
    }

    private static final Void handlePostAndWaitProcessing$lambda$2(EventBusServerHandler this$0, ChannelHandlerContext $ctx, Throwable throwable) {
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"INTERNAL_SERVER_ERROR");
        String string = throwable.getMessage();
        if (string == null) {
            string = throwable.toString();
        }
        this$0.sendError($ctx, httpResponseStatus, string);
        return null;
    }
}

