/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools.ide.starter.bus.shared.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.tools.ide.starter.bus.shared.server.EventBusServer;
import com.intellij.tools.ide.starter.bus.shared.server.EventBusServerHandler;
import com.intellij.tools.ide.starter.bus.shared.server.LocalEventBusServerKt;
import com.intellij.tools.ide.starter.bus.shared.server.services.EventsFlowService;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultSelectStrategyFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.SelectStrategyFactory;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.BindException;
import java.nio.channels.spi.SelectorProvider;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/intellij/tools/ide/starter/bus/shared/server/LocalEventBusServer;", "Lcom/intellij/tools/ide/starter/bus/shared/server/EventBusServer;", "<init>", "()V", "portsPool", "", "", "currentPortIndex", "eventsFlowService", "Lcom/intellij/tools/ide/starter/bus/shared/server/services/EventsFlowService;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "bossGroup", "Lio/netty/channel/EventLoopGroup;", "workerGroup", "serverChannel", "Lio/netty/channel/Channel;", "threadFactory", "Lio/netty/util/concurrent/DefaultThreadFactory;", "port", "getPort", "()I", "endServer", "", "updatePort", "", "startServer", "intellij.tools.ide.starter.bus"})
public final class LocalEventBusServer
implements EventBusServer {
    @NotNull
    public static final LocalEventBusServer INSTANCE = new LocalEventBusServer();
    @NotNull
    private static final List<Integer> portsPool = CollectionsKt.toList((Iterable)((Iterable)RangesKt.step((IntProgression)((IntProgression)new IntRange(45654, 45754)), (int)10)));
    private static int currentPortIndex;
    private static EventsFlowService eventsFlowService;
    @NotNull
    private static final ObjectMapper objectMapper;
    @Nullable
    private static EventLoopGroup bossGroup;
    @Nullable
    private static EventLoopGroup workerGroup;
    @Nullable
    private static Channel serverChannel;
    @NotNull
    private static final DefaultThreadFactory threadFactory;

    private LocalEventBusServer() {
    }

    @Override
    public int getPort() {
        return ((Number)portsPool.get(currentPortIndex)).intValue();
    }

    @Override
    public void endServer() {
        Channel channel = serverChannel;
        if (channel != null && (channel = channel.close()) != null) {
            channel.sync();
        }
        EventLoopGroup eventLoopGroup = workerGroup;
        if (eventLoopGroup != null) {
            eventLoopGroup.shutdownGracefully(1L, 1L, TimeUnit.SECONDS);
        }
        EventLoopGroup eventLoopGroup2 = bossGroup;
        if (eventLoopGroup2 != null) {
            eventLoopGroup2.shutdownGracefully(1L, 1L, TimeUnit.SECONDS);
        }
        serverChannel = null;
        workerGroup = null;
        bossGroup = null;
        currentPortIndex = 0;
        LocalEventBusServerKt.access$getLOG$p().info("Server stopped");
    }

    @Override
    public boolean updatePort() {
        if (currentPortIndex == portsPool.size() - 1) {
            return false;
        }
        int n = currentPortIndex;
        currentPortIndex = n + 1;
        return true;
    }

    @Override
    public void startServer() {
        try {
            eventsFlowService = new EventsFlowService();
            bossGroup = (EventLoopGroup)new MultiThreadIoEventLoopGroup(1, (ThreadFactory)threadFactory, NioIoHandler.newFactory((SelectorProvider)SelectorProvider.provider(), (SelectStrategyFactory)DefaultSelectStrategyFactory.INSTANCE));
            workerGroup = (EventLoopGroup)new MultiThreadIoEventLoopGroup(Runtime.getRuntime().availableProcessors(), (ThreadFactory)threadFactory, NioIoHandler.newFactory((SelectorProvider)SelectorProvider.provider(), (SelectStrategyFactory)DefaultSelectStrategyFactory.INSTANCE));
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                    ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new HttpServerCodec()};
                    ch.pipeline().addLast(channelHandlerArray);
                    channelHandlerArray = new ChannelHandler[]{new HttpObjectAggregator(0x100000)};
                    ch.pipeline().addLast(channelHandlerArray);
                    ChannelPipeline channelPipeline = ch.pipeline();
                    channelHandlerArray = new ChannelHandler[1];
                    EventsFlowService eventsFlowService = LocalEventBusServer.access$getEventsFlowService$p();
                    if (eventsFlowService == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"eventsFlowService");
                        eventsFlowService = null;
                    }
                    channelHandlerArray[0] = new EventBusServerHandler(eventsFlowService, LocalEventBusServer.access$getObjectMapper$p());
                    channelPipeline.addLast(channelHandlerArray);
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            ChannelFuture future = bootstrap.bind(this.getPort()).sync();
            serverChannel = future.channel();
            LocalEventBusServerKt.access$getLOG$p().info("Server started on port " + this.getPort());
        }
        catch (BindException bind) {
            LocalEventBusServerKt.access$getLOG$p().info("Port " + this.getPort() + " is busy. Trying use another");
            this.endServer();
            if (!this.updatePort()) {
                throw new BindException("All ports from ports pool are busy");
            }
            this.startServer();
        }
    }

    public static final /* synthetic */ EventsFlowService access$getEventsFlowService$p() {
        return eventsFlowService;
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p() {
        return objectMapper;
    }

    static {
        objectMapper = ExtensionsKt.jacksonObjectMapper();
        threadFactory = new DefaultThreadFactory(Reflection.getOrCreateKotlinClass(LocalEventBusServer.class).getSimpleName() + "Thread");
    }
}

