/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.junit5;

import com.intellij.ide.starter.report.AllureReport;
import com.intellij.tools.ide.util.common.LoggingKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/starter/junit5/ShutdownListener;", "Lorg/junit/jupiter/api/extension/ExecutionCondition;", "<init>", "()V", "evaluateExecutionCondition", "Lorg/junit/jupiter/api/extension/ConditionEvaluationResult;", "context", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "Companion", "intellij.tools.ide.starter.junit5"})
public final class ShutdownListener
implements ExecutionCondition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static boolean shuttingDown;

    public ShutdownListener() {
        Runtime.getRuntime().addShutdownHook(new Thread(ShutdownListener::_init_$lambda$0, "Shutdown-indicator"));
    }

    @Nullable
    public ConditionEvaluationResult evaluateExecutionCondition(@Nullable ExtensionContext context) {
        ConditionEvaluationResult conditionEvaluationResult;
        if (shuttingDown) {
            ExtensionContext extensionContext = context;
            String message = "Execution of '" + (extensionContext != null ? extensionContext.getDisplayName() : null) + "' cannot begin because shutdown is in progress, see AT-2253";
            LoggingKt.logOutput((String)message);
            AllureReport.reportFailure$default((AllureReport)AllureReport.INSTANCE, (String)"BuildExecution", (String)"Test execution cannot begin because shutdown is in progress, probably Build timeout see AT-2253", (String)"", null, (String)"BuildError", (int)8, null);
            conditionEvaluationResult = ConditionEvaluationResult.disabled((String)message);
        } else {
            conditionEvaluationResult = ConditionEvaluationResult.enabled((String)"Test execution can begin");
        }
        return conditionEvaluationResult;
    }

    private static final void _init_$lambda$0() {
        shuttingDown = true;
        LoggingKt.logOutput((String)"ShutdownListener registered shutting down, no more tests should start after this point");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/starter/junit5/ShutdownListener$Companion;", "", "<init>", "()V", "shuttingDown", "", "getShuttingDown", "()Z", "setShuttingDown", "(Z)V", "intellij.tools.ide.starter.junit5"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getShuttingDown() {
            return shuttingDown;
        }

        public final void setShuttingDown(boolean bl) {
            shuttingDown = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

