/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.junit5;

import com.intellij.ide.starter.config.ConfigurationStorage;
import com.intellij.ide.starter.coroutine.CommonScope;
import com.intellij.ide.starter.junit5.TestCleanupListenerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/starter/junit5/TestCleanupListener;", "Lorg/junit/platform/launcher/TestExecutionListener;", "<init>", "()V", "cancelPerTestSupervisorScope", "", "testIdentifier", "Lorg/junit/platform/launcher/TestIdentifier;", "executionFinished", "testExecutionResult", "Lorg/junit/platform/engine/TestExecutionResult;", "testPlanExecutionFinished", "testPlan", "Lorg/junit/platform/launcher/TestPlan;", "intellij.tools.ide.starter.junit5"})
public class TestCleanupListener
implements TestExecutionListener {
    public final void cancelPerTestSupervisorScope(@NotNull TestIdentifier testIdentifier) {
        Intrinsics.checkNotNullParameter((Object)testIdentifier, (String)"testIdentifier");
        if (!testIdentifier.isTest()) {
            return;
        }
        TestCleanupListenerKt.cancelSupervisorScope(CommonScope.INSTANCE.getPerTestSupervisorScope(), "Test `" + testIdentifier.getDisplayName() + "` execution is finished");
        ConfigurationStorage.Companion.instance().resetToDefault();
    }

    public void executionFinished(@NotNull TestIdentifier testIdentifier, @NotNull TestExecutionResult testExecutionResult) {
        Intrinsics.checkNotNullParameter((Object)testIdentifier, (String)"testIdentifier");
        Intrinsics.checkNotNullParameter((Object)testExecutionResult, (String)"testExecutionResult");
        String testIdentifierName = testIdentifier.getDisplayName();
        if (testIdentifier.isContainer()) {
            TestCleanupListenerKt.cancelSupervisorScope(CommonScope.INSTANCE.getPerClassSupervisorScope(), "Test class `" + testIdentifierName + "` execution is finished");
        } else {
            this.cancelPerTestSupervisorScope(testIdentifier);
        }
    }

    public void testPlanExecutionFinished(@NotNull TestPlan testPlan) {
        Intrinsics.checkNotNullParameter((Object)testPlan, (String)"testPlan");
        TestCleanupListenerKt.cancelSupervisorScope(CommonScope.INSTANCE.getTestSuiteSupervisorScope(), "Test plan execution is finished");
    }
}

