/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter;

import com.intellij.ide.starter.ide.IDETestContext;
import com.intellij.ide.starter.models.VMOptions;
import com.intellij.ide.starter.path.GlobalPaths;
import com.intellij.ide.starter.process.exec.ExecOutputRedirect;
import com.intellij.ide.starter.process.exec.ProcessExecutor;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.HttpClient;
import com.intellij.ide.starter.utils.PathEnvUtilsKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.tools.ide.util.common.LoggingKt;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import com.intellij.util.text.SemVer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u001a(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b\u001a\u0012\u0010\u000f\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b\u001a\u0012\u0010\u0010\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u0012\u0010\u0011\u001a\u00020\r*\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0003\u001a\u0012\u0010\u0013\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b\u001a\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\r\u001a\b\u0010\u0016\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"TSGO_VERSION", "", "downloadAndConfigureNodejs", "Ljava/nio/file/Path;", "version", "installNodeModules", "", "projectDir", "nodeVersion", "packageManager", "noFrozenLockFile", "", "setUseTypesFromServer", "Lcom/intellij/ide/starter/ide/IDETestContext;", "value", "setAbortTypeScriptCompilerRequestsOutsideProject", "setTypeScriptServiceNodeArguments", "updatePath", "path", "setTSGOtypeEvaluator", "writeConfigWithEmbeddedTSGo", "context", "getTsGoExecutablePath", "buildNodePath", "getApplicationExecutablePath", "nodejsRoot", "application", "enableCorepack", "getNodePathByVersion", "intellij.tools.ide.starter"})
public final class WebstormKt {
    @NotNull
    public static final String TSGO_VERSION = "v0.0.5";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final Path downloadAndConfigureNodejs(@NotNull String version) {
        String string;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (SystemInfo.isMac && CpuArch.isIntel64()) {
            string = "darwin-x64";
        } else if (SystemInfo.isMac && CpuArch.isArm64()) {
            SemVer semVer = SemVer.parseFromText((String)version);
            boolean bl = semVer != null ? semVer.isGreaterOrEqualThan(16, 0, 0) : false;
            if (!bl) throw new IllegalStateException(("Platform " + SystemInfo.OS_NAME + " @ " + CpuArch.CURRENT + " is supported in version 16.0.0 or higher. Requested version: " + version).toString());
            string = "darwin-arm64";
        } else if (SystemInfo.isLinux && CpuArch.isIntel64()) {
            string = "linux-x64";
        } else if (SystemInfo.isLinux && CpuArch.isArm64()) {
            string = "linux-arm64";
        } else {
            if (!SystemInfo.isWindows || !CpuArch.isIntel64()) throw new IllegalStateException(("Platform " + SystemInfo.OS_NAME + " @ " + CpuArch.CURRENT + " is not supported").toString());
            string = "win-x64";
        }
        String arch = string;
        String extension = SystemInfo.isWindows ? ".zip" : ".tar.gz";
        String fileNameWithoutExt = "node-v" + version + "-" + arch;
        String url = "https://nodejs.org/dist/v" + version + "/" + fileNameWithoutExt + extension;
        Path dirToDownload = GlobalPaths.Companion.getInstance().getCacheDirectoryFor("nodejs");
        Path downloadedFile = dirToDownload.resolve(fileNameWithoutExt + extension);
        Path nodejsRoot = dirToDownload.resolve(fileNameWithoutExt);
        Intrinsics.checkNotNull((Object)nodejsRoot);
        Path nodePath = WebstormKt.buildNodePath(nodejsRoot);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(nodejsRoot, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return nodePath;
        }
        Intrinsics.checkNotNull((Object)downloadedFile);
        HttpClient.download-Wn2Vu4Y$default(HttpClient.INSTANCE, url, downloadedFile, 0L, 0L, 12, null);
        FileSystem.INSTANCE.unpack(downloadedFile, dirToDownload);
        WebstormKt.enableCorepack(nodePath);
        return nodePath;
    }

    public static final void installNodeModules(@NotNull Path projectDir, @NotNull String nodeVersion, @NotNull String packageManager, boolean noFrozenLockFile) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)nodeVersion, (String)"nodeVersion");
        Intrinsics.checkNotNullParameter((Object)packageManager, (String)"packageManager");
        Path path = projectDir.resolve("node_modules");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LoggingKt.logOutput((String)"node_modules folder already exists");
            return;
        }
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Path nodejsRoot = WebstormKt.getNodePathByVersion(nodeVersion);
        Path packageManagerPath = WebstormKt.getApplicationExecutablePath(nodejsRoot, packageManager);
        Object[] objectArray = new String[]{String.valueOf(packageManagerPath), "install"};
        List args = CollectionsKt.mutableListOf((Object[])objectArray);
        if (noFrozenLockFile) {
            ((Collection)args).add("--no-frozen-lockfile");
        }
        long l = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES);
        Map<String, String> map = PathEnvUtilsKt.getUpdateEnvVarsWithPrependedPath(nodejsRoot);
        ExecOutputRedirect.ToStdOut toStdOut = new ExecOutputRedirect.ToStdOut(packageManager + " install");
        ProcessExecutor.start$default(new ProcessExecutor("installing node modules", projectDir, l, map, args, null, stdout, toStdOut, null, null, null, false, 0, false, false, 32544, null), false, 1, null);
    }

    public static /* synthetic */ void installNodeModules$default(Path path, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        WebstormKt.installNodeModules(path, string, string2, bl);
    }

    @NotNull
    public static final IDETestContext setUseTypesFromServer(@NotNull IDETestContext $this$setUseTypesFromServer, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$setUseTypesFromServer, (String)"<this>");
        return $this$setUseTypesFromServer.applyVMOptionsPatch((Function1<? super VMOptions, Unit>)((Function1)arg_0 -> WebstormKt.setUseTypesFromServer$lambda$0(value, arg_0)));
    }

    @NotNull
    public static final IDETestContext setAbortTypeScriptCompilerRequestsOutsideProject(@NotNull IDETestContext $this$setAbortTypeScriptCompilerRequestsOutsideProject, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$setAbortTypeScriptCompilerRequestsOutsideProject, (String)"<this>");
        return $this$setAbortTypeScriptCompilerRequestsOutsideProject.applyVMOptionsPatch((Function1<? super VMOptions, Unit>)((Function1)arg_0 -> WebstormKt.setAbortTypeScriptCompilerRequestsOutsideProject$lambda$0(value, arg_0)));
    }

    @NotNull
    public static final IDETestContext setTypeScriptServiceNodeArguments(@NotNull IDETestContext $this$setTypeScriptServiceNodeArguments, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$setTypeScriptServiceNodeArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return $this$setTypeScriptServiceNodeArguments.applyVMOptionsPatch((Function1<? super VMOptions, Unit>)((Function1)arg_0 -> WebstormKt.setTypeScriptServiceNodeArguments$lambda$0(value, arg_0)));
    }

    @NotNull
    public static final IDETestContext updatePath(@NotNull IDETestContext $this$updatePath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$updatePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return $this$updatePath.applyVMOptionsPatch((Function1<? super VMOptions, Unit>)((Function1)arg_0 -> WebstormKt.updatePath$lambda$0(path, arg_0)));
    }

    @NotNull
    public static final IDETestContext setTSGOtypeEvaluator(@NotNull IDETestContext $this$setTSGOtypeEvaluator, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$setTSGOtypeEvaluator, (String)"<this>");
        return !value ? $this$setTSGOtypeEvaluator : $this$setTSGOtypeEvaluator.applyVMOptionsPatch((Function1<? super VMOptions, Unit>)((Function1)WebstormKt::setTSGOtypeEvaluator$lambda$0));
    }

    public static final void writeConfigWithEmbeddedTSGo(@NotNull IDETestContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Path compilerXMLFilePath = context.getResolvedProjectHome().resolve(".idea").resolve("compiler.xml");
        Path path = compilerXMLFilePath.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Intrinsics.checkNotNull((Object)compilerXMLFilePath);
        PathsKt.writeText$default((Path)compilerXMLFilePath, (CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project version=\"4\">\n  <component name=\"TypeScriptCompiler\">\n    <option name=\"versionType\" value=\"EMBEDDED_TS_GO\" />\n  </component>\n</project>", null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    private static final Path getTsGoExecutablePath() {
        String string;
        int n;
        OS oS = OS.CURRENT;
        int n2 = n = oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()];
        if (n == 1 && CpuArch.isArm64()) {
            string = "darwin-arm64";
        } else if (n == 2 && CpuArch.isIntel64()) {
            string = "linux-amd64";
        } else {
            throw new IllegalStateException(("unsupported OS: " + OS.CURRENT).toString());
        }
        String tsGoBinOS = string;
        String tsGoBinName = "tsgo-v0.0.5-" + tsGoBinOS;
        Path tsGoBinPath = GlobalPaths.Companion.getInstance().getCacheDirectoryFor("tsgo/bin").resolve(tsGoBinName);
        Intrinsics.checkNotNull((Object)tsGoBinPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(tsGoBinPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return tsGoBinPath;
        }
        HttpClient.download-Wn2Vu4Y$default(HttpClient.INSTANCE, "https://packages.jetbrains.team/files/p/ij/intellij-test-data-public/webstorm/tsgo/bin/" + tsGoBinName, tsGoBinPath, 0L, 0L, 12, null);
        String[] stringArray = new String[]{"chmod", "a+x", ((Object)tsGoBinPath).toString()};
        Process process = new ProcessBuilder(stringArray).redirectErrorStream(true).start();
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new IllegalStateException(("error in executing chmode for " + tsGoBinPath).toString());
        }
        System.out.println((Object)("chmode has been successfully executed for " + tsGoBinPath));
        return tsGoBinPath;
    }

    private static final Path buildNodePath(Path path) {
        Path path2;
        if (SystemInfo.isWindows) {
            path2 = path;
        } else {
            Path path3 = path.resolve("bin");
            path2 = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        }
        return path2;
    }

    private static final Path getApplicationExecutablePath(Path nodejsRoot, String application) {
        Path path;
        if (SystemInfo.isWindows) {
            Path path2 = nodejsRoot.resolve(application + ".cmd");
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        } else {
            Path path3 = nodejsRoot.resolve(application);
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        }
        return path;
    }

    private static final void enableCorepack(Path nodejsRoot) {
        Path corePackPath = WebstormKt.getApplicationExecutablePath(nodejsRoot, "corepack");
        long l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES);
        Object object = new String[]{String.valueOf(corePackPath), "--install-directory", ".", "enable"};
        List list = CollectionsKt.listOf((Object[])object);
        object = PathEnvUtilsKt.getUpdateEnvVarsWithPrependedPath(nodejsRoot);
        ProcessExecutor.start$default(new ProcessExecutor("corepack enable", nodejsRoot, l, (Map)object, list, null, null, null, null, null, null, false, 0, false, false, 32736, null), false, 1, null);
    }

    private static final Path getNodePathByVersion(String version) {
        Path nodeJSDir = GlobalPaths.Companion.getInstance().getCacheDirectoryFor("nodejs");
        List<Object> list = Files.list(nodeJSDir).filter(arg_0 -> WebstormKt.getNodePathByVersion$lambda$1(WebstormKt::getNodePathByVersion$lambda$0, arg_0)).filter(arg_0 -> WebstormKt.getNodePathByVersion$lambda$3(arg_0 -> WebstormKt.getNodePathByVersion$lambda$2(version, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        Path matchingFolder = (Path)CollectionsKt.first(list);
        Intrinsics.checkNotNull((Object)matchingFolder);
        return WebstormKt.buildNodePath(matchingFolder);
    }

    private static final Unit setUseTypesFromServer$lambda$0(boolean $value, VMOptions $this$applyVMOptionsPatch) {
        Intrinsics.checkNotNullParameter((Object)$this$applyVMOptionsPatch, (String)"$this$applyVMOptionsPatch");
        $this$applyVMOptionsPatch.addSystemProperty("typescript.compiler.evaluation", String.valueOf($value));
        return Unit.INSTANCE;
    }

    private static final Unit setAbortTypeScriptCompilerRequestsOutsideProject$lambda$0(boolean $value, VMOptions $this$applyVMOptionsPatch) {
        Intrinsics.checkNotNullParameter((Object)$this$applyVMOptionsPatch, (String)"$this$applyVMOptionsPatch");
        $this$applyVMOptionsPatch.addSystemProperty("typescript.service.abort.requests.outside.project", String.valueOf($value));
        return Unit.INSTANCE;
    }

    private static final Unit setTypeScriptServiceNodeArguments$lambda$0(String $value, VMOptions $this$applyVMOptionsPatch) {
        Intrinsics.checkNotNullParameter((Object)$this$applyVMOptionsPatch, (String)"$this$applyVMOptionsPatch");
        $this$applyVMOptionsPatch.addSystemProperty("typescript.service.node.arguments", $value);
        return Unit.INSTANCE;
    }

    private static final Unit updatePath$lambda$0(Path $path, VMOptions $this$applyVMOptionsPatch) {
        Intrinsics.checkNotNullParameter((Object)$this$applyVMOptionsPatch, (String)"$this$applyVMOptionsPatch");
        PathEnvUtilsKt.updatePathEnvVariable($this$applyVMOptionsPatch, $path);
        return Unit.INSTANCE;
    }

    private static final Unit setTSGOtypeEvaluator$lambda$0(VMOptions $this$applyVMOptionsPatch) {
        Intrinsics.checkNotNullParameter((Object)$this$applyVMOptionsPatch, (String)"$this$applyVMOptionsPatch");
        $this$applyVMOptionsPatch.addSystemProperty("typescript.ts-go.type-evaluator.path", WebstormKt.getTsGoExecutablePath());
        return Unit.INSTANCE;
    }

    private static final boolean getNodePathByVersion$lambda$0(Path it) {
        return Files.isDirectory(it, new LinkOption[0]);
    }

    private static final boolean getNodePathByVersion$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getNodePathByVersion$lambda$2(String $version, Path it) {
        return StringsKt.contains$default((CharSequence)((Object)it.getFileName()).toString(), (CharSequence)("node-v" + $version), (boolean)false, (int)2, null);
    }

    private static final boolean getNodePathByVersion$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.macOS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

