/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.ide;

import com.intellij.ide.starter.ide.IdeDistribution;
import com.intellij.ide.starter.ide.InstalledBackedIDEStartConfig;
import com.intellij.ide.starter.ide.InstalledIde;
import com.intellij.ide.starter.ide.MacOsIdeDistribution;
import com.intellij.ide.starter.models.VMOptions;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.JvmUtils;
import com.intellij.ide.starter.utils.XmlBuilder;
import com.intellij.tools.ide.util.common.LoggingKt;
import com.intellij.util.system.OS;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/starter/ide/MacOsIdeDistribution;", "Lcom/intellij/ide/starter/ide/IdeDistribution;", "<init>", "()V", "getExecutableNameFromInfoPlist", "", "appDir", "Ljava/nio/file/Path;", "keyName", "installIde", "Lcom/intellij/ide/starter/ide/InstalledIde;", "unpackDir", "executableFileName", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nMacOsIdeDistribution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacOsIdeDistribution.kt\ncom/intellij/ide/starter/ide/MacOsIdeDistribution\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n672#2,11:103\n1#3:114\n*S KotlinDebug\n*F\n+ 1 MacOsIdeDistribution.kt\ncom/intellij/ide/starter/ide/MacOsIdeDistribution\n*L\n44#1:103,11\n*E\n"})
public final class MacOsIdeDistribution
extends IdeDistribution {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getExecutableNameFromInfoPlist(Path appDir, String keyName) {
        Path infoPlistFile = appDir.resolve("Contents/Info.plist");
        Intrinsics.checkNotNull((Object)infoPlistFile);
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(infoPlistFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Document document = XmlBuilder.INSTANCE.parse(it);
            NodeList keys = document.getElementsByTagName("key");
            int n = keys.getLength();
            for (int index = 0; index < n; ++index) {
                Node keyItem = keys.item(index);
                if (!Intrinsics.areEqual((Object)keyItem.getFirstChild().getNodeValue(), (Object)keyName)) continue;
                Node node = keyItem.getNextSibling();
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNextSibling(...)");
                Node sibling = node;
                while (sibling.getNodeType() != 1) {
                    Intrinsics.checkNotNullExpressionValue((Object)sibling.getNextSibling(), (String)"getNextSibling(...)");
                }
                String string = sibling.getTextContent();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextContent(...)");
                String string2 = string;
                return string2;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        throw new IllegalStateException(("Failed to resolve key: " + keyName + " in " + infoPlistFile).toString());
    }

    @Override
    @NotNull
    public InstalledIde installIde(@NotNull Path unpackDir, @NotNull String executableFileName) {
        Iterable<Path> iterable;
        block9: {
            block8: {
                Object v1;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)unpackDir, (String)"unpackDir");
                    Intrinsics.checkNotNullParameter((Object)executableFileName, (String)"executableFileName");
                    iterable = FileSystem.INSTANCE.listDirectoryEntriesQuietly(unpackDir);
                    if (iterable == null) break block8;
                    Iterable $this$singleOrNull$iv = iterable;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        Path it = (Path)element$iv;
                        boolean bl = false;
                        if (!StringsKt.endsWith$default((String)PathsKt.getName((Path)it), (String)".app", (boolean)false, (int)2, null)) continue;
                        if (found$iv) {
                            v1 = null;
                            break block7;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                if ((iterable = (Path)v1) != null && (iterable = iterable.toAbsolutePath()) != null) break block9;
            }
            throw new IllegalStateException(("Invalid macOS application directory: " + unpackDir).toString());
        }
        Iterable<Path> appDir = iterable;
        String executableName = this.getExecutableNameFromInfoPlist((Path)appDir, "CFBundleExecutable");
        Path appHome2 = appDir.resolve("Contents").toAbsolutePath();
        Intrinsics.checkNotNull((Object)appHome2);
        Path path = appHome2.resolve("MacOS");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path.resolve(executableName);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path executablePath = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(executablePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean $i$a$-require-MacOsIdeDistribution$installIde$22 = false;
            String $i$a$-require-MacOsIdeDistribution$installIde$22 = "Cannot find macOS IDE executable file in " + executablePath;
            throw new IllegalArgumentException($i$a$-require-MacOsIdeDistribution$installIde$22.toString());
        }
        Path path3 = appHome2.resolve("Resources");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        Path path4 = path3.resolve("build.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        Pair<String, String> pair = IdeDistribution.Companion.readProductCodeAndBuildNumberFromBuildTxt(path4);
        String productCode = (String)pair.component1();
        String build = (String)pair.component2();
        return new InstalledIde(appHome2, (Path)appDir, build, productCode, executablePath){
            private final Path bundledPluginsDir;
            private final VMOptions vmOptionsFinal;
            private final Path patchedVMOptionsFile;
            private final String build;
            private final OS os;
            private final String productCode;
            private final boolean isFromSources;
            private final Path installationPath;
            final /* synthetic */ Path $appHome;
            final /* synthetic */ Path $appDir;
            final /* synthetic */ String $build;
            final /* synthetic */ String $productCode;
            final /* synthetic */ Path $executablePath;
            {
                this.$appHome = $appHome;
                this.$appDir = $appDir;
                this.$build = $build;
                this.$productCode = $productCode;
                this.$executablePath = $executablePath;
                Intrinsics.checkNotNull((Object)$appHome);
                Path path = $appHome.resolve("plugins");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                this.bundledPluginsDir = path;
                this.vmOptionsFinal = new VMOptions(this, CollectionsKt.emptyList(), MapsKt.emptyMap());
                this.patchedVMOptionsFile = $appDir.getParent().resolve($appDir.getFileName() + ".vmoptions");
                this.build = $build;
                this.os = OS.macOS;
                this.productCode = $productCode;
                this.installationPath = $appHome;
            }

            public Path getBundledPluginsDir() {
                return this.bundledPluginsDir;
            }

            public VMOptions getVmOptions() {
                return this.vmOptionsFinal;
            }

            public Path getPatchedVMOptionsFile() {
                return this.patchedVMOptionsFile;
            }

            public installIde.startConfig.1 startConfig(VMOptions vmOptions, Path logsDir) {
                Intrinsics.checkNotNullParameter((Object)vmOptions, (String)"vmOptions");
                Intrinsics.checkNotNullParameter((Object)logsDir, (String)"logsDir");
                Path path = this.getPatchedVMOptionsFile();
                return new InstalledBackedIDEStartConfig(this.$appDir, this.$executablePath, vmOptions, path){
                    private final Path workDir;
                    private final List<String> commandLine;
                    {
                        Intrinsics.checkNotNull((Object)$super_call_param$1);
                        super($super_call_param$1, $vmOptions);
                        this.workDir = $appDir;
                        this.commandLine = CollectionsKt.listOf((Object)((Object)$executablePath.toAbsolutePath()).toString());
                    }

                    public Path getWorkDir() {
                        return this.workDir;
                    }

                    public List<String> getCommandLine() {
                        return this.commandLine;
                    }
                };
            }

            public String getBuild() {
                return this.build;
            }

            public OS getOs() {
                return this.os;
            }

            public String getProductCode() {
                return this.productCode;
            }

            public boolean isFromSources() {
                return this.isFromSources;
            }

            public Path getInstallationPath() {
                return this.installationPath;
            }

            public String toString() {
                return "IDE{" + this.$productCode + ", " + this.$build + ", " + this.getOs() + ", home=" + this.$appDir + "}";
            }

            public Object resolveAndDownloadTheSameJDK(Continuation<? super Path> $completion) {
                Path path = this.$appHome;
                Intrinsics.checkNotNull((Object)path);
                Path path2 = path.resolve("jbr");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                Path jbrHome = path2;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isDirectory(jbrHome, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    boolean $i$a$-require-MacOsIdeDistribution$installIde$2$resolveAndDownloadTheSameJDK$42 = false;
                    String $i$a$-require-MacOsIdeDistribution$installIde$2$resolveAndDownloadTheSameJDK$42 = "JbrHome is not found under " + jbrHome;
                    throw new IllegalArgumentException($i$a$-require-MacOsIdeDistribution$installIde$2$resolveAndDownloadTheSameJDK$42.toString());
                }
                Path path3 = jbrHome.resolve("Contents");
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                Path path4 = path3.resolve("Home");
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
                Path javaHome = path4;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isDirectory(javaHome, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    boolean bl = false;
                    String string = "JavaHome is not found under " + javaHome;
                    throw new IllegalArgumentException(string.toString());
                }
                String jbrFullVersion = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)JvmUtils.INSTANCE.callJavaVersion(javaHome), (String)"build ", null, (int)2, null), (String)")", null, (int)2, null);
                LoggingKt.logOutput((String)("Found following " + jbrFullVersion + " in the product: " + this.$productCode + " " + this.$build));
                return javaHome;
            }
        };
    }
}

