/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.models;

import com.intellij.ide.starter.models.VMOptions;
import com.intellij.openapi.util.SystemInfo;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/starter/models/VMTrace;", "", "<init>", "()V", "vmTraceFile", "Ljava/nio/file/Path;", "getVmTraceFile", "()Ljava/nio/file/Path;", "isSupported", "", "()Z", "getExtension", "", "fileName", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nVMTrace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VMTrace.kt\ncom/intellij/ide/starter/models/VMTrace\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,40:1\n1#2:41\n*E\n"})
public final class VMTrace {
    @NotNull
    public static final VMTrace INSTANCE = new VMTrace();
    @NotNull
    private static final Path vmTraceFile;

    private VMTrace() {
    }

    @NotNull
    public final Path getVmTraceFile() {
        return vmTraceFile;
    }

    public final boolean isSupported() {
        return SystemInfo.isLinux && !SystemInfo.isAarch64 || SystemInfo.isMac || SystemInfo.isWindows;
    }

    private final String getExtension(String fileName) {
        return StringsKt.substringAfterLast((String)fileName, (String)".", (String)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        if (INSTANCE.isSupported()) {
            byte[] byArray;
            String string;
            if (SystemInfo.isLinux && !SystemInfo.isAarch64) {
                string = "/libvmtrace.so";
            } else if (SystemInfo.isWindows) {
                string = "/libvmtrace.dll";
            } else if (SystemInfo.isMac && !SystemInfo.isAarch64) {
                string = "/libvmtrace.dylib";
            } else if (SystemInfo.isMac && SystemInfo.isAarch64) {
                string = "/libvmtrace-aarch64.dylib";
            } else {
                throw new UnsupportedOperationException("Unsupported platform for libvmtrace");
            }
            String resourceName = string;
            Path path = Files.createTempFile("libvmtrace", "." + INSTANCE.getExtension(resourceName), new FileAttribute[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
            vmTraceFile = path;
            InputStream inputStream = VMOptions.class.getResourceAsStream(resourceName);
            Intrinsics.checkNotNull((Object)inputStream);
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                byArray = it.readAllBytes();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            byte[] vmTraceBytes = byArray;
            Files.write(vmTraceFile, vmTraceBytes, new OpenOption[0]);
        } else {
            Path path = Path.of("unsupported-platform-libvmtrace", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            vmTraceFile = path;
        }
    }
}

