/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.report;

import com.intellij.ide.starter.ci.teamcity.TeamCityCIServer;
import com.intellij.ide.starter.report.AllureLink;
import com.intellij.ide.starter.runner.CurrentTestMethod;
import com.intellij.ide.starter.runner.TestMethod;
import com.intellij.ide.starter.utils.GenerifyKt;
import com.intellij.tools.ide.util.common.LoggingKt;
import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Link;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.TestResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0006J>\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/starter/report/AllureReport;", "", "<init>", "()V", "ignoreLabels", "", "", "errorLink", "Lio/qameta/allure/model/Link;", "reportFailure", "", "contextName", "message", "originalStackTrace", "links", "", "Lcom/intellij/ide/starter/report/AllureLink;", "suffix", "reportErrorInNewThread", "parentContext", "Lcom/intellij/ide/starter/report/AllureReport$AllureContextSnapshot;", "formattedStackTrace", "captureCurrentAllureContext", "AllureContextSnapshot", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nAllureReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllureReport.kt\ncom/intellij/ide/starter/report/AllureReport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1#2:121\n777#3:122\n873#3,2:123\n*S KotlinDebug\n*F\n+ 1 AllureReport.kt\ncom/intellij/ide/starter/report/AllureReport\n*L\n70#1:122\n70#1:123,2\n*E\n"})
public final class AllureReport {
    @NotNull
    public static final AllureReport INSTANCE = new AllureReport();
    @NotNull
    private static final Set<String> ignoreLabels;
    @NotNull
    private static final Link errorLink;

    private AllureReport() {
    }

    public final void reportFailure(@NotNull String contextName, @NotNull String message, @NotNull String originalStackTrace, @NotNull List<AllureLink> links, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)originalStackTrace, (String)"originalStackTrace");
        Intrinsics.checkNotNullParameter(links, (String)"links");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        try {
            StringBuilder stringBuilder;
            AllureContextSnapshot parentContext = this.captureCurrentAllureContext();
            TestMethod testMethod = CurrentTestMethod.INSTANCE.get();
            String currentTestMethodName = testMethod != null ? testMethod.fullName() : null;
            StringBuilder $this$reportFailure_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$reportFailure_u24lambda_u240.append(originalStackTrace);
            $this$reportFailure_u24lambda_u240.append('\n').append('\n');
            $this$reportFailure_u24lambda_u240.append("ContextName: " + contextName).append('\n');
            $this$reportFailure_u24lambda_u240.append("TestName: " + currentTestMethodName);
            String formattedStackTrace = stringBuilder.toString();
            this.reportErrorInNewThread(parentContext, links, formattedStackTrace, suffix, contextName, message);
        }
        catch (Exception e) {
            LoggingKt.logError((String)"Fail to write allure", (Throwable)e);
        }
    }

    public static /* synthetic */ void reportFailure$default(AllureReport allureReport, String string, String string2, String string3, List list, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            string4 = "Exception";
        }
        allureReport.reportFailure(string, string2, string3, list, string4);
    }

    private final void reportErrorInNewThread(AllureContextSnapshot parentContext, List<AllureLink> links, String formattedStackTrace, String suffix, String contextName, String message) {
        ThreadsKt.thread$default((boolean)true, (boolean)false, null, null, (int)0, () -> AllureReport.reportErrorInNewThread$lambda$0(parentContext, links, formattedStackTrace, suffix, message, contextName), (int)28, null).join();
    }

    private final AllureContextSnapshot captureCurrentAllureContext() {
        Ref.ObjectRef snapshot = new Ref.ObjectRef();
        snapshot.element = new AllureContextSnapshot(CollectionsKt.emptyList(), "", "", "");
        Allure.getLifecycle().updateTestCase(arg_0 -> AllureReport.captureCurrentAllureContext$lambda$0(snapshot, arg_0));
        return (AllureContextSnapshot)snapshot.element;
    }

    private static final void reportErrorInNewThread$lambda$0$2(String $suffix, AllureContextSnapshot $parentContext, String $message, String $formattedStackTrace, String $hash, List $linksList, List $errorLabels, String $contextName, TestResult it) {
        CharSequence charSequence;
        CharSequence charSequence2;
        TestResult testResult;
        it.setStatus(Status.FAILED);
        TestResult testResult2 = it;
        String string = $suffix;
        CharSequence charSequence3 = $parentContext.getTestName();
        if (StringsKt.isBlank((CharSequence)charSequence3)) {
            String string2 = string;
            testResult = testResult2;
            boolean bl = false;
            String string3 = $contextName;
            testResult2 = testResult;
            string = string2;
            charSequence2 = string3;
        } else {
            charSequence2 = charSequence3;
        }
        testResult2.setName(string + " in " + charSequence2);
        it.setStatusDetails(new StatusDetails().setMessage($message).setTrace($formattedStackTrace));
        TestResult testResult3 = it;
        charSequence3 = $parentContext.getFullName();
        if (StringsKt.isBlank((CharSequence)charSequence3)) {
            testResult = testResult3;
            boolean bl = false;
            charSequence = $contextName;
            testResult3 = testResult;
        } else {
            charSequence = charSequence3;
        }
        String string4 = $suffix.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        testResult3.setFullName(charSequence + "." + $hash + "." + string4);
        it.setTestCaseName($parentContext.getTestCaseName());
        it.setHistoryId($hash);
        it.setDescription("IDE " + $suffix + " error that appears when running " + $parentContext.getFullName());
        it.setLinks($linksList);
        it.setLabels($errorLabels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit reportErrorInNewThread$lambda$0(AllureContextSnapshot $parentContext, List $links, String $formattedStackTrace, String $suffix, String $message, String $contextName) {
        TestResult testResult;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String uuid = string;
        AllureLifecycle lifecycle = Allure.getLifecycle();
        TestResult $this$reportErrorInNewThread_u24lambda_u240_u240 = testResult = new TestResult();
        boolean bl = false;
        $this$reportErrorInNewThread_u24lambda_u240_u240.setUuid(uuid);
        TestResult result2 = testResult;
        lifecycle.scheduleTestCase(result2);
        lifecycle.startTestCase(uuid);
        try {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $parentContext.getLabels();
            boolean $i$f$filter = false;
            Object object2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Label label = (Label)element$iv$iv;
                boolean bl2 = false;
                if (!(!ignoreLabels.contains(label.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List errorLabels = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            List linksList = new ArrayList();
            for (Object object2 : $links) {
                String name = ((AllureLink)object2).component1();
                String url = ((AllureLink)object2).component2();
                Allure.link((String)name, (String)url);
                Link link = new Link().setName(name).setUrl(url);
                Intrinsics.checkNotNullExpressionValue((Object)link, (String)"setUrl(...)");
                linksList.add(link);
            }
            linksList.add(errorLink);
            Label label = new Label().setName("layer").setValue("Exception");
            Intrinsics.checkNotNullExpressionValue((Object)label, (String)"setValue(...)");
            errorLabels.add(label);
            Label label2 = new Label().setName("AS_ID").setValue("-1");
            Intrinsics.checkNotNullExpressionValue((Object)label2, (String)"setValue(...)");
            errorLabels.add(label2);
            String hash = GenerifyKt.convertToHashCodeWithOnlyLetters(GenerifyKt.generifyErrorMessage(TeamCityCIServer.Companion.processStringForTC($formattedStackTrace)).hashCode());
            Allure.getLifecycle().updateTestCase(arg_0 -> AllureReport.reportErrorInNewThread$lambda$0$2($suffix, $parentContext, $message, $formattedStackTrace, hash, linksList, errorLabels, $contextName, arg_0));
        }
        finally {
            Allure.getLifecycle().stopTestCase(uuid);
            Allure.getLifecycle().writeTestCase(uuid);
        }
        return Unit.INSTANCE;
    }

    private static final void captureCurrentAllureContext$lambda$0(Ref.ObjectRef $snapshot, TestResult it) {
        String string;
        String string2;
        String string3;
        List list = it.getLabels();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if ((string3 = it.getName()) == null) {
            string3 = "";
        }
        if ((string2 = it.getFullName()) == null) {
            string2 = "";
        }
        if ((string = it.getTestCaseName()) == null) {
            string = "";
        }
        $snapshot.element = new AllureContextSnapshot(list, string3, string2, string);
    }

    static {
        Object[] objectArray = new String[]{"layer", "AS_ID"};
        ignoreLabels = SetsKt.setOf((Object[])objectArray);
        errorLink = new Link();
        errorLink.setName("How to process exception");
        errorLink.setUrl("https://jb.gg/ide-test-errors");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J7\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004J\n\u0010\u001b\u001a\u00020\u0006H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/starter/report/AllureReport$AllureContextSnapshot;", "", "labels", "", "Lio/qameta/allure/model/Label;", "testName", "", "fullName", "testCaseName", "<init>", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLabels", "()Ljava/util/List;", "getTestName", "()Ljava/lang/String;", "getFullName", "getTestCaseName", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.tools.ide.starter"})
    private static final class AllureContextSnapshot {
        @NotNull
        private final List<Label> labels;
        @NotNull
        private final String testName;
        @NotNull
        private final String fullName;
        @NotNull
        private final String testCaseName;

        public AllureContextSnapshot(@NotNull List<? extends Label> labels, @NotNull String testName, @NotNull String fullName, @NotNull String testCaseName) {
            Intrinsics.checkNotNullParameter(labels, (String)"labels");
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
            Intrinsics.checkNotNullParameter((Object)testCaseName, (String)"testCaseName");
            this.labels = labels;
            this.testName = testName;
            this.fullName = fullName;
            this.testCaseName = testCaseName;
        }

        @NotNull
        public final List<Label> getLabels() {
            return this.labels;
        }

        @NotNull
        public final String getTestName() {
            return this.testName;
        }

        @NotNull
        public final String getFullName() {
            return this.fullName;
        }

        @NotNull
        public final String getTestCaseName() {
            return this.testCaseName;
        }

        @NotNull
        public final List<Label> component1() {
            return this.labels;
        }

        @NotNull
        public final String component2() {
            return this.testName;
        }

        @NotNull
        public final String component3() {
            return this.fullName;
        }

        @NotNull
        public final String component4() {
            return this.testCaseName;
        }

        @NotNull
        public final AllureContextSnapshot copy(@NotNull List<? extends Label> labels, @NotNull String testName, @NotNull String fullName, @NotNull String testCaseName) {
            Intrinsics.checkNotNullParameter(labels, (String)"labels");
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
            Intrinsics.checkNotNullParameter((Object)testCaseName, (String)"testCaseName");
            return new AllureContextSnapshot(labels, testName, fullName, testCaseName);
        }

        public static /* synthetic */ AllureContextSnapshot copy$default(AllureContextSnapshot allureContextSnapshot, List list, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                list = allureContextSnapshot.labels;
            }
            if ((n & 2) != 0) {
                string = allureContextSnapshot.testName;
            }
            if ((n & 4) != 0) {
                string2 = allureContextSnapshot.fullName;
            }
            if ((n & 8) != 0) {
                string3 = allureContextSnapshot.testCaseName;
            }
            return allureContextSnapshot.copy(list, string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "AllureContextSnapshot(labels=" + this.labels + ", testName=" + this.testName + ", fullName=" + this.fullName + ", testCaseName=" + this.testCaseName + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.labels).hashCode();
            result2 = result2 * 31 + this.testName.hashCode();
            result2 = result2 * 31 + this.fullName.hashCode();
            result2 = result2 * 31 + this.testCaseName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AllureContextSnapshot)) {
                return false;
            }
            AllureContextSnapshot allureContextSnapshot = (AllureContextSnapshot)other;
            if (!Intrinsics.areEqual(this.labels, allureContextSnapshot.labels)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.testName, (Object)allureContextSnapshot.testName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fullName, (Object)allureContextSnapshot.fullName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.testCaseName, (Object)allureContextSnapshot.testCaseName);
        }
    }
}

