/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.report.sarif;

import com.intellij.ide.starter.models.IDEStartResult;
import com.intellij.ide.starter.report.sarif.SarifBuilderKt;
import com.jetbrains.qodana.sarif.SarifUtil;
import com.jetbrains.qodana.sarif.model.Invocation;
import com.jetbrains.qodana.sarif.model.ReportingDescriptor;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.SarifReport;
import com.jetbrains.qodana.sarif.model.ToolComponent;
import com.jetbrains.qodana.sarif.model.VersionControlDetails;
import java.net.URL;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/starter/report/sarif/TestContextToQodanaSarifMapper;", "", "<init>", "()V", "map", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "ideStartResult", "Lcom/intellij/ide/starter/models/IDEStartResult;", "intellij.tools.ide.starter"})
public final class TestContextToQodanaSarifMapper {
    @NotNull
    public static final TestContextToQodanaSarifMapper INSTANCE = new TestContextToQodanaSarifMapper();

    private TestContextToQodanaSarifMapper() {
    }

    @NotNull
    public final SarifReport map(@NotNull IDEStartResult ideStartResult) {
        String defaultReportPath;
        Intrinsics.checkNotNullParameter((Object)ideStartResult, (String)"ideStartResult");
        URL uRL = this.getClass().getClassLoader().getResource("sarif/qodana.sarif.json");
        String string = defaultReportPath = uRL != null ? uRL.getPath() : null;
        if (defaultReportPath == null) {
            throw new RuntimeException("Default report doesn' exits");
        }
        SarifReport sarifReport = SarifUtil.readReport((Path)Path.of(defaultReportPath, new String[0]));
        Intrinsics.checkNotNull((Object)sarifReport);
        return SarifBuilderKt.sarifReport(sarifReport, (Function1<? super SarifReport, Unit>)((Function1)arg_0 -> TestContextToQodanaSarifMapper.map$lambda$0(ideStartResult, arg_0)));
    }

    private static final Unit map$lambda$0$0$0$0(IDEStartResult $ideStartResult, ReportingDescriptor $this$taxa) {
        Intrinsics.checkNotNullParameter((Object)$this$taxa, (String)"$this$taxa");
        $this$taxa.setId($ideStartResult.getContext().getTestName());
        $this$taxa.setName($ideStartResult.getContext().getTestName());
        return Unit.INSTANCE;
    }

    private static final Unit map$lambda$0$0$0(IDEStartResult $ideStartResult, ToolComponent $this$driver) {
        Intrinsics.checkNotNullParameter((Object)$this$driver, (String)"$this$driver");
        $this$driver.getTaxa().add(SarifBuilderKt.taxa((Function1<? super ReportingDescriptor, Unit>)((Function1)arg_0 -> TestContextToQodanaSarifMapper.map$lambda$0$0$0$0($ideStartResult, arg_0))));
        return Unit.INSTANCE;
    }

    private static final Unit map$lambda$0$0$1(IDEStartResult $ideStartResult, Invocation $this$invocation) {
        Intrinsics.checkNotNullParameter((Object)$this$invocation, (String)"$this$invocation");
        $this$invocation.setExitCode($ideStartResult.getFailureError() == null ? Integer.valueOf(0) : Integer.valueOf(1));
        $this$invocation.setExecutionSuccessful(Boolean.valueOf($ideStartResult.getFailureError() == null));
        return Unit.INSTANCE;
    }

    private static final Unit map$lambda$0$0$2(VersionControlDetails $this$versionControlProvenance) {
        Intrinsics.checkNotNullParameter((Object)$this$versionControlProvenance, (String)"$this$versionControlProvenance");
        return Unit.INSTANCE;
    }

    private static final Unit map$lambda$0$0$3(Result $this$result) {
        Intrinsics.checkNotNullParameter((Object)$this$result, (String)"$this$result");
        $this$result.setRuleId("Perf test");
        return Unit.INSTANCE;
    }

    private static final Unit map$lambda$0$0(IDEStartResult $ideStartResult, Run $this$sarifRun) {
        Intrinsics.checkNotNullParameter((Object)$this$sarifRun, (String)"$this$sarifRun");
        ToolComponent toolComponent = $this$sarifRun.getTool().getDriver();
        Intrinsics.checkNotNullExpressionValue((Object)toolComponent, (String)"getDriver(...)");
        SarifBuilderKt.driver(toolComponent, (Function1<? super ToolComponent, Unit>)((Function1)arg_0 -> TestContextToQodanaSarifMapper.map$lambda$0$0$0($ideStartResult, arg_0)));
        $this$sarifRun.getInvocations().add(SarifBuilderKt.invocation((Function1<? super Invocation, Unit>)((Function1)arg_0 -> TestContextToQodanaSarifMapper.map$lambda$0$0$1($ideStartResult, arg_0))));
        $this$sarifRun.getVersionControlProvenance().add(SarifBuilderKt.versionControlProvenance((Function1<? super VersionControlDetails, Unit>)((Function1)TestContextToQodanaSarifMapper::map$lambda$0$0$2)));
        $this$sarifRun.getResults().add(SarifBuilderKt.result((Function1<? super Result, Unit>)((Function1)TestContextToQodanaSarifMapper::map$lambda$0$0$3)));
        return Unit.INSTANCE;
    }

    private static final Unit map$lambda$0(IDEStartResult $ideStartResult, SarifReport $this$sarifReport) {
        Intrinsics.checkNotNullParameter((Object)$this$sarifReport, (String)"$this$sarifReport");
        Object e = $this$sarifReport.getRuns().get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        SarifBuilderKt.sarifRun((Run)e, (Function1<? super Run, Unit>)((Function1)arg_0 -> TestContextToQodanaSarifMapper.map$lambda$0$0($ideStartResult, arg_0)));
        return Unit.INSTANCE;
    }
}

