/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.sdk.go;

import com.intellij.ide.starter.sdk.go.GoSdkPaths;
import com.intellij.tools.ide.performanceTesting.commands.SdkObject;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0003J\u0014\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u0096\u0080\u0004J\n\u0010\u001b\u001a\u00020\u0003H\u0096\u0080\u0004J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c2\u0003J7\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/intellij/ide/starter/sdk/go/GoSdkDownloadItem;", "", "version", "", "os", "arch", "download", "Lkotlin/Function0;", "Lcom/intellij/ide/starter/sdk/go/GoSdkPaths;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "installGoSdk", "Lkotlin/Lazy;", "home", "Ljava/nio/file/Path;", "getHome", "()Ljava/nio/file/Path;", "installPath", "getInstallPath", "toSdk", "Lcom/intellij/tools/ide/performanceTesting/commands/SdkObject;", "sdkName", "equals", "", "other", "hashCode", "", "toString", "component1", "component2", "component3", "component4", "copy", "intellij.tools.ide.starter"})
public final class GoSdkDownloadItem {
    @JvmField
    @NotNull
    public final String version;
    @JvmField
    @NotNull
    public final String os;
    @JvmField
    @NotNull
    public final String arch;
    @NotNull
    private final Function0<GoSdkPaths> download;
    @NotNull
    private final Lazy<GoSdkPaths> installGoSdk;

    public GoSdkDownloadItem(@NotNull String version, @NotNull String os, @NotNull String arch, @NotNull Function0<GoSdkPaths> download2) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        Intrinsics.checkNotNullParameter(download2, (String)"download");
        this.version = version;
        this.os = os;
        this.arch = arch;
        this.download = download2;
        this.installGoSdk = LazyKt.lazy(() -> GoSdkDownloadItem.installGoSdk$lambda$0(this));
    }

    @NotNull
    public final Path getHome() {
        return ((GoSdkPaths)this.installGoSdk.getValue()).homePath;
    }

    @NotNull
    public final Path getInstallPath() {
        return ((GoSdkPaths)this.installGoSdk.getValue()).installPath;
    }

    @NotNull
    public final SdkObject toSdk(@NotNull String sdkName) {
        Intrinsics.checkNotNullParameter((Object)sdkName, (String)"sdkName");
        return new SdkObject(sdkName, "Go SDK", this.getHome());
    }

    public static /* synthetic */ SdkObject toSdk$default(GoSdkDownloadItem goSdkDownloadItem, String object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = "Go " + goSdkDownloadItem.version;
        }
        return goSdkDownloadItem.toSdk((String)object);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof GoSdkDownloadItem && Intrinsics.areEqual((Object)((GoSdkDownloadItem)other).version, (Object)this.version) && Intrinsics.areEqual((Object)((GoSdkDownloadItem)other).os, (Object)this.os) && Intrinsics.areEqual((Object)((GoSdkDownloadItem)other).arch, (Object)this.arch);
    }

    public int hashCode() {
        Object[] objectArray = new String[]{this.version, this.os, this.arch};
        return Arrays.hashCode(objectArray);
    }

    @NotNull
    public String toString() {
        return "GoSdkDownloadItem(go" + this.version + "-" + this.os + "-" + this.arch + ")";
    }

    @NotNull
    public final String component1() {
        return this.version;
    }

    @NotNull
    public final String component2() {
        return this.os;
    }

    @NotNull
    public final String component3() {
        return this.arch;
    }

    private final Function0<GoSdkPaths> component4() {
        return this.download;
    }

    @NotNull
    public final GoSdkDownloadItem copy(@NotNull String version, @NotNull String os, @NotNull String arch, @NotNull Function0<GoSdkPaths> download2) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        Intrinsics.checkNotNullParameter(download2, (String)"download");
        return new GoSdkDownloadItem(version, os, arch, download2);
    }

    public static /* synthetic */ GoSdkDownloadItem copy$default(GoSdkDownloadItem goSdkDownloadItem, String string, String string2, String string3, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            string = goSdkDownloadItem.version;
        }
        if ((n & 2) != 0) {
            string2 = goSdkDownloadItem.os;
        }
        if ((n & 4) != 0) {
            string3 = goSdkDownloadItem.arch;
        }
        if ((n & 8) != 0) {
            function0 = goSdkDownloadItem.download;
        }
        return goSdkDownloadItem.copy(string, string2, string3, function0);
    }

    private static final GoSdkPaths installGoSdk$lambda$0(GoSdkDownloadItem this$0) {
        return (GoSdkPaths)this$0.download.invoke();
    }
}

