/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.utils;

import com.intellij.ide.starter.path.GlobalPaths;
import com.intellij.ide.starter.process.exec.ExecOutputRedirect;
import com.intellij.ide.starter.process.exec.ProcessExecutor;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.FileSystemKt;
import com.intellij.ide.starter.utils.SizeKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.tools.ide.util.common.LoggingKt;
import com.intellij.util.ThreeState;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.rauschig.jarchivelib.CompressionType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\rJ\u0016\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nJ=\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2%\b\u0002\u0010\u0017\u001a\u001f\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0018J\u0018\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nJ\u0016\u0010!\u001a\u00020\b2\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nJ\"\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%J\u0016\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0016\u001a\u00020(J\n\u0010)\u001a\u00020\u000f*\u00020\nJ\u0012\u0010*\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010+*\u00020\nJ\u0018\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\n\u0010,\u001a\u00020\r*\u00020\nJ\n\u0010-\u001a\u00020\u0005*\u00020\nJ\u0014\u0010.\u001a\u00020\u0005*\u00020\n2\b\b\u0002\u0010/\u001a\u000200J\u0006\u00101\u001a\u00020\u0005J\n\u00102\u001a\u00020\u000f*\u00020\nJ\n\u00103\u001a\u00020\u000f*\u00020\nJ\f\u00104\u001a\u00020\u000f*\u00020\nH\u0002J\u0010\u00105\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u00066"}, d2={"Lcom/intellij/ide/starter/utils/FileSystem;", "", "<init>", "()V", "cleanPathFromSlashes", "", "replaceWith", "validatePath", "", "path", "Ljava/nio/file/Path;", "additionalString", "countFiles", "", "hasAtLeastFiles", "", "minCount", "compressToZip", "sourceToCompress", "outputArchive", "unpackZip", "zipFile", "targetDir", "map", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "setFilePermissions", "file", "entry", "Lcom/intellij/util/io/zip/JBZipEntry;", "unpackIfMissing", "archive", "unpack", "compressToTar", "source", "compressionType", "Lorg/rauschig/jarchivelib/CompressionType;", "unpackTarGz", "tarFile", "Ljava/io/File;", "deleteRecursivelyQuietly", "listDirectoryEntriesQuietly", "", "zippedLength", "getFileOrDirectoryPresentableSize", "getDirectoryTreePresentableSizes", "depth", "", "getDiskUsageDiagnostics", "isFileUpToDate", "isDirUpToDate", "isUpToDate", "isSymlink", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystem.kt\ncom/intellij/ide/starter/utils/FileSystem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,392:1\n1#2:393\n*E\n"})
public final class FileSystem {
    @NotNull
    public static final FileSystem INSTANCE = new FileSystem();

    private FileSystem() {
    }

    @NotNull
    public final String cleanPathFromSlashes(@NotNull String $this$cleanPathFromSlashes, @NotNull String replaceWith) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanPathFromSlashes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)replaceWith, (String)"replaceWith");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)$this$cleanPathFromSlashes, (String)"\"", (String)replaceWith, (boolean)false, (int)4, null), (String)"/", (String)replaceWith, (boolean)false, (int)4, null);
    }

    public static /* synthetic */ String cleanPathFromSlashes$default(FileSystem fileSystem, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        return fileSystem.cleanPathFromSlashes(string, string2);
    }

    public final void validatePath(@NotNull Path path, @NotNull String additionalString) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)additionalString, (String)"additionalString");
        if (SystemInfo.isWindows) {
            String string;
            boolean bl;
            boolean bl2 = bl = ((CharSequence)additionalString).length() > 0;
            if (bl) {
                string = ((Object)path.resolve(additionalString)).toString();
            } else if (!bl) {
                string = ((Object)path).toString();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String pathToValidate = string;
            if (!(pathToValidate.length() < 260)) {
                boolean bl3 = false;
                String string2 = pathToValidate + " >= 260 symbols on Windows may lead to unexpected problems";
                throw new IllegalStateException(string2.toString());
            }
        }
    }

    public static /* synthetic */ void validatePath$default(FileSystem fileSystem, Path path, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        fileSystem.validatePath(path, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long countFiles(@NotNull Path path) {
        long l;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        AutoCloseable autoCloseable = Files.walk(path, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl = false;
            l = it.count();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasAtLeastFiles(@NotNull Path path, long minCount) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        AutoCloseable autoCloseable = Files.walk(path, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            Iterator iterator = stream.iterator();
            long seen = 0L;
            while (iterator.hasNext()) {
                iterator.next();
                if (++seen < minCount) continue;
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = false;
            return bl3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void compressToZip(@NotNull Path sourceToCompress, @NotNull Path outputArchive) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)sourceToCompress, (String)"sourceToCompress");
        Intrinsics.checkNotNullParameter((Object)outputArchive, (String)"outputArchive");
        if (Intrinsics.areEqual((Object)PathsKt.getExtension((Path)sourceToCompress), (Object)"zip")) {
            LoggingKt.logOutput((String)("Looks like " + sourceToCompress + " already compressed to zip file"));
            return;
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(outputArchive, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.deleteRecursivelyQuietly(outputArchive);
        }
        Path $this$compressToZip_u24lambda_u240 = path = outputArchive.getParent();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$compressToZip_u24lambda_u240);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories($this$compressToZip_u24lambda_u240, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Path outputArchiveParentDir = path;
        Archiver archiver = ArchiverFactory.createArchiver((ArchiveFormat)ArchiveFormat.ZIP);
        archiver.create(PathsKt.getNameWithoutExtension((Path)outputArchive), outputArchiveParentDir.toFile(), sourceToCompress.toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unpackZip(@NotNull Path zipFile, @NotNull Path targetDir, @NotNull Function1<? super String, String> map) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        try {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(targetDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            List symlinks = new ArrayList();
            Closeable closeable = (Closeable)new JBZipFile(zipFile, StandardCharsets.UTF_8, false, ThreeState.UNSURE);
            Throwable throwable = null;
            try {
                @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000)\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"com/intellij/ide/starter/utils/FileSystem$unpackZip$SymlinkInfo", "", "file", "Ljava/nio/file/Path;", "targetPath", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "getFile", "()Ljava/nio/file/Path;", "getTargetPath", "()Ljava/lang/String;", "component1", "component2", "copy", "(Ljava/nio/file/Path;Ljava/lang/String;)Lcom/intellij/ide/starter/utils/FileSystem$unpackZip$SymlinkInfo;", "equals", "", "other", "hashCode", "", "toString", "intellij.tools.ide.starter"})
                public final class SymlinkInfo {
                    private final Path file;
                    private final String targetPath;

                    public SymlinkInfo(Path file, String targetPath) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
                        this.file = file;
                        this.targetPath = targetPath;
                    }

                    public final Path getFile() {
                        return this.file;
                    }

                    public final String getTargetPath() {
                        return this.targetPath;
                    }

                    public final Path component1() {
                        return this.file;
                    }

                    public final String component2() {
                        return this.targetPath;
                    }

                    public final SymlinkInfo copy(Path file, String targetPath) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
                        return new SymlinkInfo(file, targetPath);
                    }

                    public static /* synthetic */ SymlinkInfo copy$default(SymlinkInfo symlinkInfo, Path path, String string, int n, Object object) {
                        if ((n & 1) != 0) {
                            path = symlinkInfo.file;
                        }
                        if ((n & 2) != 0) {
                            string = symlinkInfo.targetPath;
                        }
                        return symlinkInfo.copy(path, string);
                    }

                    public String toString() {
                        return "SymlinkInfo(file=" + this.file + ", targetPath=" + this.targetPath + ")";
                    }

                    public int hashCode() {
                        int result2 = ((Object)this.file).hashCode();
                        result2 = result2 * 31 + this.targetPath.hashCode();
                        return result2;
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof SymlinkInfo)) {
                            return false;
                        }
                        SymlinkInfo symlinkInfo = (SymlinkInfo)other;
                        if (!Intrinsics.areEqual((Object)this.file, (Object)symlinkInfo.file)) {
                            return false;
                        }
                        return Intrinsics.areEqual((Object)this.targetPath, (Object)symlinkInfo.targetPath);
                    }
                }
                JBZipFile zip = (JBZipFile)closeable;
                boolean bl = false;
                for (JBZipEntry entry : zip.getEntries()) {
                    Object targetPath;
                    Path path;
                    if (entry.isDirectory()) {
                        Path dir = targetDir.resolve(entry.getName());
                        Intrinsics.checkNotNull((Object)dir);
                        FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
                        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(dir, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length)), (String)"createDirectories(...)");
                        continue;
                    }
                    String string = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    String string2 = (String)map.invoke((Object)string);
                    if (string2 == null) continue;
                    Path file = targetDir.resolve(string2);
                    Intrinsics.checkNotNullExpressionValue((Object)file.getParent(), (String)"getParent(...)");
                    Object object = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"createDirectories(...)");
                    Intrinsics.checkNotNull((Object)entry);
                    if (INSTANCE.isSymlink(entry)) {
                        byte[] byArray = entry.getData();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getData(...)");
                        object = byArray;
                        targetPath = new String((byte[])object, Charsets.UTF_8);
                        Intrinsics.checkNotNull((Object)file);
                        symlinks.add(new SymlinkInfo(file, (String)targetPath));
                        continue;
                    }
                    Intrinsics.checkNotNull((Object)file);
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    OutputStream outputStream = Files.newOutputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                    targetPath = outputStream;
                    object = null;
                    try {
                        long l;
                        OutputStream it = (OutputStream)targetPath;
                        boolean bl2 = false;
                        Closeable closeable2 = entry.getInputStream();
                        Throwable throwable2 = null;
                        try {
                            InputStream entryStream = (InputStream)closeable2;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull((Object)entryStream);
                            l = ByteStreamsKt.copyTo$default((InputStream)entryStream, (OutputStream)it, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                        long l2 = l;
                    }
                    catch (Throwable throwable4) {
                        object = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)targetPath, (Throwable)object);
                    }
                    targetPath = file;
                    FileTime fileTime = FileTime.fromMillis(entry.getTime());
                    Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"fromMillis(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)Files.setLastModifiedTime((Path)targetPath, fileTime), (String)"setLastModifiedTime(...)");
                    INSTANCE.setFilePermissions(file, entry);
                }
                for (SymlinkInfo symlinkInfo : symlinks) {
                    try {
                        Files.deleteIfExists(symlinkInfo.getFile());
                        Files.createSymbolicLink(symlinkInfo.getFile(), Path.of(symlinkInfo.getTargetPath(), new String[0]), new FileAttribute[0]);
                    }
                    catch (Exception e) {
                        LoggingKt.logOutput((String)("Failed to create symbolic link at " + symlinkInfo.getFile() + ", falling back to regular file: " + e.getMessage()));
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            this.deleteRecursivelyQuietly(targetDir);
            Files.deleteIfExists(zipFile);
            throw new IOException("Failed to unpack " + zipFile + " to " + targetDir + ". " + e.getMessage(), e);
        }
    }

    public static /* synthetic */ void unpackZip$default(FileSystem fileSystem, Path path, Path path2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = FileSystem::unpackZip$lambda$0;
        }
        fileSystem.unpackZip(path, path2, (Function1<? super String, String>)function1);
    }

    private final void setFilePermissions(Path file, JBZipEntry entry) {
        try {
            if (!Files.getFileStore(file).supportsFileAttributeView(PosixFileAttributeView.class)) {
                return;
            }
            long externalAttrs = entry.getExternalAttributes();
            int unixMode = (int)(externalAttrs >> 16);
            if (externalAttrs == 0L || unixMode == 0) {
                return;
            }
            Set permissions = new LinkedHashSet();
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
            if ((unixMode & 0x40) != 0) {
                permissions.add(PosixFilePermission.OWNER_EXECUTE);
            }
            permissions.add(PosixFilePermission.GROUP_READ);
            permissions.add(PosixFilePermission.GROUP_WRITE);
            if ((unixMode & 8) != 0) {
                permissions.add(PosixFilePermission.GROUP_EXECUTE);
            }
            permissions.add(PosixFilePermission.OTHERS_READ);
            permissions.add(PosixFilePermission.OTHERS_WRITE);
            if ((unixMode & 1) != 0) {
                permissions.add(PosixFilePermission.OTHERS_EXECUTE);
            }
            Files.setPosixFilePermissions(file, permissions);
        }
        catch (Exception e) {
            LoggingKt.logOutput((String)("Failed to set permissions for " + file + ": " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unpackIfMissing(@NotNull Path archive, @NotNull Path targetDir) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        if (Files.isDirectory(targetDir, new LinkOption[0])) {
            boolean bl;
            Closeable closeable = Files.newDirectoryStream(targetDir);
            Throwable throwable = null;
            try {
                DirectoryStream it = (DirectoryStream)closeable;
                boolean bl2 = false;
                bl = it.iterator().hasNext();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (bl) {
                return;
            }
        }
        this.unpack(archive, targetDir);
    }

    public final void unpack(@NotNull Path archive, @NotNull Path targetDir) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
            Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
            LoggingKt.logOutput((String)("Extracting " + archive + " to " + targetDir));
            Files.createDirectories(targetDir, new FileAttribute[0]);
            String name = ((Object)archive.getFileName()).toString();
            try {
                if (StringsKt.endsWith$default((String)name, (String)".zip", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".ijx", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".jar", (boolean)false, (int)2, null)) {
                    FileSystem.unpackZip$default(this, archive, targetDir, null, 4, null);
                    break block5;
                }
                if (StringsKt.endsWith$default((String)name, (String)".tar.gz", (boolean)false, (int)2, null)) {
                    this.unpackTarGz(archive, targetDir);
                    break block5;
                }
                throw new IllegalStateException(("Archive " + name + " is not supported").toString());
            }
            catch (IOException e) {
                String string = e.getMessage();
                boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"No space left on device", (boolean)false, (int)2, null) : false;
                if (bl) {
                    StringBuilder stringBuilder;
                    StringBuilder $this$unpack_u24lambda_u240 = stringBuilder = new StringBuilder();
                    boolean bl2 = false;
                    $this$unpack_u24lambda_u240.append("No space left while extracting " + archive + " to " + targetDir).append('\n');
                    StringBuilder stringBuilder2 = $this$unpack_u24lambda_u240;
                    FileStore fileStore = Files.getFileStore(targetDir);
                    Intrinsics.checkNotNullExpressionValue((Object)fileStore, (String)"getFileStore(...)");
                    stringBuilder2.append(FileSystemKt.getDiskInfo(fileStore)).append('\n');
                    $this$unpack_u24lambda_u240.append(INSTANCE.getDiskUsageDiagnostics()).append('\n');
                    String string2 = stringBuilder.toString();
                    throw new IOException(string2);
                }
                throw e;
            }
        }
    }

    public final void compressToTar(@NotNull Path source, @NotNull Path outputArchive, @Nullable CompressionType compressionType) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)outputArchive, (String)"outputArchive");
        Archiver archiver = compressionType == null ? ArchiverFactory.createArchiver((ArchiveFormat)ArchiveFormat.TAR) : ArchiverFactory.createArchiver((ArchiveFormat)ArchiveFormat.TAR, (CompressionType)compressionType);
        Path $this$compressToTar_u24lambda_u240 = path = outputArchive.getParent();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$compressToTar_u24lambda_u240);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories($this$compressToTar_u24lambda_u240, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Path outputArchiveParentDir = path;
        archiver.create(PathsKt.getNameWithoutExtension((Path)outputArchive), outputArchiveParentDir.toFile(), source.toFile());
    }

    public static /* synthetic */ void compressToTar$default(FileSystem fileSystem, Path path, Path path2, CompressionType compressionType, int n, Object object) {
        if ((n & 4) != 0) {
            compressionType = null;
        }
        fileSystem.compressToTar(path, path2, compressionType);
    }

    public final void unpackTarGz(@NotNull File tarFile, @NotNull File targetDir) {
        Intrinsics.checkNotNullParameter((Object)tarFile, (String)"tarFile");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        FilesKt.deleteRecursively((File)targetDir);
        Path path = tarFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        Path path2 = targetDir.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
        this.unpackTarGz(path, path2);
    }

    public final boolean deleteRecursivelyQuietly(@NotNull Path $this$deleteRecursivelyQuietly) {
        Object result2;
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)$this$deleteRecursivelyQuietly, (String)"<this>");
            Object object2 = $this$deleteRecursivelyQuietly;
            try {
                Path $this$deleteRecursivelyQuietly_u24lambda_u240 = object2;
                boolean bl = false;
                PathsKt.deleteRecursively((Path)$this$deleteRecursivelyQuietly_u24lambda_u240);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = result2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object error = object = throwable;
            boolean bl = false;
            LoggingKt.logError((String)("Failed to delete " + $this$deleteRecursivelyQuietly), (Throwable)error);
        }
        return Result.isSuccess-impl((Object)result2);
    }

    @Nullable
    public final List<Path> listDirectoryEntriesQuietly(@NotNull Path $this$listDirectoryEntriesQuietly) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$listDirectoryEntriesQuietly, (String)"<this>");
        Object object2 = $this$listDirectoryEntriesQuietly;
        try {
            Path $this$listDirectoryEntriesQuietly_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)PathsKt.listDirectoryEntries$default((Path)$this$listDirectoryEntriesQuietly_u24lambda_u240, null, (int)1, null));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (List)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    private final void unpackTarGz(Path tarFile, Path targetDir) {
        if (!StringsKt.endsWith$default((String)((Object)tarFile.getFileName()).toString(), (String)".tar.gz", (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string = "File " + tarFile + " must be tar.gz archive";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            if (SystemInfo.isWindows) {
                Archiver archiver = ArchiverFactory.createArchiver((ArchiveFormat)ArchiveFormat.TAR, (CompressionType)CompressionType.GZIP);
                archiver.extract(tarFile.toFile(), targetDir.toFile());
            } else if (SystemInfo.isLinux || SystemInfo.isMac) {
                Files.createDirectories(targetDir, new FileAttribute[0]);
                long archiver = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES);
                ExecOutputRedirect.ToStdOut toStdOut = new ExecOutputRedirect.ToStdOut("tar");
                Object[] objectArray = new String[]{"tar", "-z", "-x", "-f", ((Object)tarFile.toAbsolutePath()).toString(), "-C", ((Object)targetDir.toAbsolutePath()).toString()};
                List list = CollectionsKt.listOf((Object[])objectArray);
                ProcessExecutor.start$default(new ProcessExecutor("extract-tar", targetDir, archiver, null, list, null, null, toStdOut, null, null, null, false, 0, false, false, 32616, null), false, 1, null);
            }
        }
        catch (Exception e) {
            this.deleteRecursivelyQuietly(targetDir);
            Files.deleteIfExists(tarFile);
            throw new Exception("Failed to unpack " + tarFile + ". " + e.getMessage() + ". File and unpack targets are removed.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long zippedLength(@NotNull Path $this$zippedLength) {
        Intrinsics.checkNotNullParameter((Object)$this$zippedLength, (String)"<this>");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile($this$zippedLength, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return 0L;
        }
        var output2 = new OutputStream(){
            private long count;

            public final long getCount() {
                return this.count;
            }

            public final void setCount(long l) {
                this.count = l;
            }

            public void write(int b) {
                long l = this.count;
                this.count = l + 1L;
            }

            public void write(byte[] b) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                this.count += (long)b.length;
            }

            public void write(byte[] b, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                this.count += (long)len;
            }
        };
        Closeable closeable = new GZIPOutputStream(output2);
        Throwable throwable = null;
        try {
            long l;
            GZIPOutputStream zipStream = (GZIPOutputStream)closeable;
            boolean bl = false;
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream($this$zippedLength, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            Closeable closeable2 = inputStream;
            Throwable throwable2 = null;
            try {
                InputStream it = (InputStream)closeable2;
                boolean bl2 = false;
                l = ByteStreamsKt.copyTo((InputStream)it, (OutputStream)zipStream, (int)0x100000);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return output2.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getFileOrDirectoryPresentableSize(@NotNull Path $this$getFileOrDirectoryPresentableSize) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$getFileOrDirectoryPresentableSize, (String)"<this>");
        Path path = $this$getFileOrDirectoryPresentableSize;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)basicFileAttributes, (String)"readAttributes(...)");
        BasicFileAttributes attributes = basicFileAttributes;
        if (attributes.isRegularFile()) {
            l = attributes.size();
        } else {
            AutoCloseable autoCloseable = Files.walk($this$getFileOrDirectoryPresentableSize, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                Stream pathStream = (Stream)autoCloseable;
                boolean bl = false;
                long l2 = pathStream.mapToLong(arg_0 -> FileSystem.getFileOrDirectoryPresentableSize$lambda$0$1(FileSystem::getFileOrDirectoryPresentableSize$lambda$0$0, arg_0)).sum();
                l = l2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        long size = l;
        return SizeKt.formatSize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getDirectoryTreePresentableSizes(@NotNull Path $this$getDirectoryTreePresentableSizes, int depth) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$getDirectoryTreePresentableSizes, (String)"<this>");
        Path thisPath = $this$getDirectoryTreePresentableSizes;
        StringBuilder $this$getDirectoryTreePresentableSizes_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        AutoCloseable autoCloseable = Files.walk(thisPath, depth, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream dirStream = (Stream)autoCloseable;
            boolean bl2 = false;
            dirStream.forEach(arg_0 -> FileSystem.getDirectoryTreePresentableSizes$lambda$0$0$1(arg_0 -> FileSystem.getDirectoryTreePresentableSizes$lambda$0$0$0(thisPath, $this$getDirectoryTreePresentableSizes_u24lambda_u240, arg_0), arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return stringBuilder.toString();
    }

    public static /* synthetic */ String getDirectoryTreePresentableSizes$default(FileSystem fileSystem, Path path, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return fileSystem.getDirectoryTreePresentableSizes(path, n);
    }

    @NotNull
    public final String getDiskUsageDiagnostics() {
        StringBuilder stringBuilder;
        GlobalPaths paths = GlobalPaths.Companion.getInstance();
        StringBuilder $this$getDiskUsageDiagnostics_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getDiskUsageDiagnostics_u24lambda_u240.append("Disk usage by integration tests (home " + paths.getTestHomePath() + ")").append('\n');
        StringBuilder stringBuilder2 = $this$getDiskUsageDiagnostics_u24lambda_u240;
        FileStore fileStore = Files.getFileStore(paths.getTestHomePath());
        Intrinsics.checkNotNullExpressionValue((Object)fileStore, (String)"getFileStore(...)");
        stringBuilder2.append(FileSystemKt.getDiskInfo(fileStore)).append('\n');
        $this$getDiskUsageDiagnostics_u24lambda_u240.append('\n');
        $this$getDiskUsageDiagnostics_u24lambda_u240.append(INSTANCE.getDirectoryTreePresentableSizes(paths.getTestHomePath(), 3)).append('\n');
        Path path = paths.getLocalCacheDirectory();
        Path path2 = paths.getTestHomePath().resolve("cache");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        if (!Intrinsics.areEqual((Object)path, (Object)path2)) {
            $this$getDiskUsageDiagnostics_u24lambda_u240.append("Agent persistent cache directory disk usage " + paths.getLocalCacheDirectory()).append('\n');
            $this$getDiskUsageDiagnostics_u24lambda_u240.append(INSTANCE.getDirectoryTreePresentableSizes(paths.getLocalCacheDirectory(), 2)).append('\n');
        }
        $this$getDiskUsageDiagnostics_u24lambda_u240.append('\n');
        $this$getDiskUsageDiagnostics_u24lambda_u240.append("Directories' size from " + paths.getDevServerDirectory()).append('\n');
        $this$getDiskUsageDiagnostics_u24lambda_u240.append(FileSystem.getDirectoryTreePresentableSizes$default(INSTANCE, paths.getDevServerDirectory(), 0, 1, null)).append('\n');
        return stringBuilder.toString();
    }

    public final boolean isFileUpToDate(@NotNull Path $this$isFileUpToDate) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isFileUpToDate, (String)"<this>");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile($this$isFileUpToDate, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LoggingKt.logOutput((String)("File " + $this$isFileUpToDate + " does not exist"));
            return false;
        }
        if (Files.size($this$isFileUpToDate) <= 0L) {
            LoggingKt.logOutput((String)("File " + $this$isFileUpToDate + " is empty"));
            bl = false;
        } else {
            bl = this.isUpToDate($this$isFileUpToDate);
        }
        return bl;
    }

    public final boolean isDirUpToDate(@NotNull Path $this$isDirUpToDate) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isDirUpToDate, (String)"<this>");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory($this$isDirUpToDate, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LoggingKt.logOutput((String)("Path " + $this$isDirUpToDate + " does not exist"));
            return false;
        }
        if (Files.size($this$isDirUpToDate) <= 0L) {
            LoggingKt.logOutput((String)("Project dir " + $this$isDirUpToDate + " is empty"));
            bl = false;
        } else {
            bl = this.isUpToDate($this$isDirUpToDate);
        }
        return bl;
    }

    private final boolean isUpToDate(Path $this$isUpToDate) {
        boolean upToDate;
        FileTime lastModified = Files.getLastModifiedTime($this$isUpToDate, new LinkOption[0]);
        Duration timeSinceLastModified = Duration.between(lastModified.toInstant(), Instant.now());
        boolean bl = upToDate = timeSinceLastModified.compareTo(Duration.ofDays(1L)) < 0;
        if (upToDate) {
            LoggingKt.logOutput((String)($this$isUpToDate + " is up to date"));
        } else {
            LoggingKt.logOutput((String)($this$isUpToDate + " is not up to date"));
        }
        return upToDate;
    }

    private final boolean isSymlink(JBZipEntry entry) {
        long fileMode = entry.getExternalAttributes() >>> 16 & 0xFFFFL;
        return (int)(fileMode & 0xF000L) == 40960;
    }

    private static final String unpackZip$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final long getFileOrDirectoryPresentableSize$lambda$0$0(Path p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Path path = p;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)basicFileAttributes, (String)"readAttributes(...)");
        BasicFileAttributes attributes = basicFileAttributes;
        return attributes.isRegularFile() ? attributes.size() : 0L;
    }

    private static final long getFileOrDirectoryPresentableSize$lambda$0$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    private static final Unit getDirectoryTreePresentableSizes$lambda$0$0$0(Path $thisPath, StringBuilder $this_buildString, Path child) {
        if (Intrinsics.areEqual((Object)child, (Object)$thisPath)) {
            v0 = $this_buildString.append("Total size: " + INSTANCE.getFileOrDirectoryPresentableSize($thisPath)).append('\n');
        } else {
            String indent = StringsKt.repeat((CharSequence)"  ", (int)$thisPath.relativize(child).getNameCount());
            Path path = $thisPath.relativize(child);
            Intrinsics.checkNotNull((Object)child);
            v0 = $this_buildString.append(indent + path + ": " + INSTANCE.getFileOrDirectoryPresentableSize(child)).append('\n');
        }
        return Unit.INSTANCE;
    }

    private static final void getDirectoryTreePresentableSizes$lambda$0$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

