/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.utils.threadDumpParser;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.starter.utils.threadDumpParser.ThreadDumpParser;
import com.intellij.ide.starter.utils.threadDumpParser.ThreadOperation;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0016\u0018\u0000 <2\u00020\u0001:\u0001<B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u001a\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u001bH\u0016J\r\u0010\u001c\u001a\u00070\u0003\u00a2\u0006\u0002\b\u001bH\u0016J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u000bJ\u0006\u0010!\u001a\u00020\u0019J\u0006\u0010\"\u001a\u00020\u000bJ\n\u0010#\u001a\u00020\u0003H\u0096\u0080\u0004J\u0010\u0010$\u001a\u00020\u001e2\b\u0010%\u001a\u0004\u0018\u00010\u0003J\u0015\u0010&\u001a\u00020\u001e2\r\u0010'\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b(J\n\u0010)\u001a\u0004\u0018\u00010\u0003H\u0016J\u000f\u0010*\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u001bH\u0016J\b\u0010+\u001a\u00020\u000bH\u0016J\u0010\u0010,\u001a\u00020\u001e2\b\u0010-\u001a\u0004\u0018\u00010\u0003J\b\u0010.\u001a\u00020\u000bH\u0016J\b\u0010/\u001a\u00020\u000bH\u0002J\u0012\u00100\u001a\u00020\u000b2\b\u00101\u001a\u0004\u0018\u00010\u0000H\u0016J\u000e\u00102\u001a\u00020\u001e2\u0006\u00101\u001a\u00020\u0000J\u0010\u00103\u001a\u00020\u001e2\b\u00101\u001a\u0004\u0018\u00010\u0000J\n\u00104\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u00105\u001a\u00020\u001e2\b\u00106\u001a\u0004\u0018\u00010\u0015J\b\u00107\u001a\u00020\u000bH\u0016J\b\u00108\u001a\u0004\u0018\u00010\u0003J\u0010\u00109\u001a\u00020\u001e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003J\u000e\u0010:\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020\u000bR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/ide/starter/utils/threadDumpParser/ThreadState;", "", "name", "", "state", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "myName", "myState", "myStackTrace", "myEmptyStackTrace", "", "myJavaThreadState", "myThreadStateDetail", "myExtraState", "isDaemon", "myThreadsWaitingForMyLock", "", "myDeadlockedThreads", "ownableSynchronizers", "myOperation", "Lcom/intellij/ide/starter/utils/threadDumpParser/ThreadOperation;", "myKnownJDKThread", "Ljava/lang/Boolean;", "myStackDepth", "", "getName", "Lcom/intellij/openapi/util/NlsSafe;", "getStackTrace", "setStackTrace", "", "stackTrace", "isEmpty", "getStackDepth", "isKnownJDKThread", "toString", "setJavaThreadState", "javaThreadState", "setThreadStateDetail", "threadStateDetail", "Lorg/jetbrains/annotations/NonNls;", "getJavaThreadState", "getThreadStateDetail", "isEmptyStackTrace", "setExtraState", "extraState", "isSleeping", "isThreadPoolExecutor", "isAwaitedBy", "thread", "addWaitingThread", "addDeadlockedThread", "getOperation", "setOperation", "operation", "isEDT", "getOwnableSynchronizers", "setOwnableSynchronizers", "setDaemon", "daemon", "Companion", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nThreadState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadState.kt\ncom/intellij/ide/starter/utils/threadDumpParser/ThreadState\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,146:1\n106#2:147\n78#2,22:148\n*S KotlinDebug\n*F\n+ 1 ThreadState.kt\ncom/intellij/ide/starter/utils/threadDumpParser/ThreadState\n*L\n29#1:147\n29#1:148,22\n*E\n"})
public class ThreadState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String myName;
    @NotNull
    private final String myState;
    @Nullable
    private String myStackTrace;
    private boolean myEmptyStackTrace;
    @Nullable
    private String myJavaThreadState;
    @Nullable
    private String myThreadStateDetail;
    @Nullable
    private String myExtraState;
    private boolean isDaemon;
    @NotNull
    private final Set<ThreadState> myThreadsWaitingForMyLock;
    @NotNull
    private final Set<ThreadState> myDeadlockedThreads;
    @Nullable
    private String ownableSynchronizers;
    @Nullable
    private ThreadOperation myOperation;
    @Nullable
    private Boolean myKnownJDKThread;
    private int myStackDepth;

    /*
     * WARNING - void declaration
     */
    public ThreadState(@Nullable String name, @NotNull String state) {
        void $this$trim$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.myThreadsWaitingForMyLock = new HashSet();
        this.myDeadlockedThreads = new HashSet();
        this.myName = name;
        String string = state;
        ThreadState threadState = this;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        threadState.myState = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getStackTrace() {
        String string = this.myStackTrace;
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final void setStackTrace(@NotNull String stackTrace, boolean isEmpty) {
        Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
        this.myStackTrace = stackTrace;
        this.myEmptyStackTrace = isEmpty;
        this.myKnownJDKThread = null;
        String string = this.myStackTrace;
        Intrinsics.checkNotNull((Object)string);
        this.myStackDepth = StringUtil.countNewLines((CharSequence)string);
    }

    public final int getStackDepth() {
        return this.myStackDepth;
    }

    public final boolean isKnownJDKThread() {
        String stackTrace = this.myStackTrace;
        if (stackTrace == null) {
            return false;
        }
        if (this.myKnownJDKThread == null) {
            this.myKnownJDKThread = ThreadDumpParser.INSTANCE.isKnownJdkThread(stackTrace);
        }
        Boolean bl = this.myKnownJDKThread;
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    @NotNull
    public String toString() {
        String string = this.myName;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public final void setJavaThreadState(@Nullable String javaThreadState) {
        this.myJavaThreadState = javaThreadState;
    }

    public final void setThreadStateDetail(@Nullable String threadStateDetail) {
        this.myThreadStateDetail = threadStateDetail;
    }

    @Nullable
    public String getJavaThreadState() {
        return this.myJavaThreadState;
    }

    @Nullable
    public String getThreadStateDetail() {
        if (this.myOperation != null) {
            return String.valueOf((Object)this.myOperation);
        }
        return this.myThreadStateDetail;
    }

    public boolean isEmptyStackTrace() {
        return this.myEmptyStackTrace;
    }

    public final void setExtraState(@Nullable String extraState) {
        this.myExtraState = extraState;
    }

    public boolean isSleeping() {
        return Intrinsics.areEqual((Object)"sleeping", (Object)this.getThreadStateDetail()) || (Intrinsics.areEqual((Object)"parking", (Object)this.getThreadStateDetail()) || Intrinsics.areEqual((Object)"waiting on condition", (Object)this.myState)) && this.isThreadPoolExecutor();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isThreadPoolExecutor() {
        String string = this.myStackTrace;
        Intrinsics.checkNotNull((Object)string);
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"java.util.concurrent.ScheduledThreadPoolExecutor$DelayedWorkQueue.take", (boolean)false, (int)2, null)) return true;
        String string2 = this.myStackTrace;
        Intrinsics.checkNotNull((Object)string2);
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"java.util.concurrent.ThreadPoolExecutor.getTask", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public boolean isAwaitedBy(@Nullable ThreadState thread) {
        return this.myThreadsWaitingForMyLock.contains(thread);
    }

    public final void addWaitingThread(@NotNull ThreadState thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.myThreadsWaitingForMyLock.add(thread);
    }

    public final void addDeadlockedThread(@Nullable ThreadState thread) {
        this.myDeadlockedThreads.add(thread);
    }

    @Nullable
    public ThreadOperation getOperation() {
        return this.myOperation;
    }

    public final void setOperation(@Nullable ThreadOperation operation) {
        this.myOperation = operation;
    }

    public boolean isEDT() {
        String name = this.getName();
        return Companion.isEDT(name);
    }

    @Nullable
    public final String getOwnableSynchronizers() {
        return this.ownableSynchronizers;
    }

    public final void setOwnableSynchronizers(@Nullable String ownableSynchronizers) {
        this.ownableSynchronizers = ownableSynchronizers;
    }

    public final void setDaemon(boolean daemon) {
        this.isDaemon = daemon;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/starter/utils/threadDumpParser/ThreadState$Companion;", "", "<init>", "()V", "isEDT", "", "name", "", "intellij.tools.ide.starter"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEDT(@Nullable String name) {
            return ThreadDumper.isEDT((String)name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

