/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.community;

import com.intellij.ide.starter.community.JetBrainsDataServiceClient;
import com.intellij.ide.starter.community.ProductInfoRequestParameters;
import com.intellij.ide.starter.community.model.OperatingSystem;
import com.intellij.ide.starter.community.model.ReleaseInfo;
import com.intellij.ide.starter.ide.IdeDownloader;
import com.intellij.ide.starter.ide.installer.IdeInstallerFile;
import com.intellij.ide.starter.models.IdeInfo;
import com.intellij.ide.starter.runner.SetupException;
import com.intellij.ide.starter.utils.HttpClient;
import com.intellij.tools.ide.util.common.LoggingKt;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\t0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ide/starter/community/PublicIdeDownloader;", "Lcom/intellij/ide/starter/ide/IdeDownloader;", "<init>", "()V", "findSpecificRelease", "Lcom/intellij/ide/starter/community/model/ReleaseInfo;", "releaseInfoMap", "", "", "", "filteringParams", "Lcom/intellij/ide/starter/community/ProductInfoRequestParameters;", "downloadIdeInstaller", "Lcom/intellij/ide/starter/ide/installer/IdeInstallerFile;", "ideInfo", "Lcom/intellij/ide/starter/models/IdeInfo;", "installerDirectory", "Ljava/nio/file/Path;", "downloadDedicatedInstaller", "", "mapDownloadLink", "downloadLink", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nPublicIdeDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublicIdeDownloader.kt\ncom/intellij/ide/starter/community/PublicIdeDownloader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1080#2:114\n231#2,2:115\n231#2,2:117\n296#2,2:119\n*S KotlinDebug\n*F\n+ 1 PublicIdeDownloader.kt\ncom/intellij/ide/starter/community/PublicIdeDownloader\n*L\n25#1:114\n28#1:115,2\n32#1:117,2\n38#1:119,2\n*E\n"})
public class PublicIdeDownloader
implements IdeDownloader {
    private final ReleaseInfo findSpecificRelease(Map<String, ? extends List<ReleaseInfo>> releaseInfoMap, ProductInfoRequestParameters filteringParams) {
        try {
            ReleaseInfo build;
            Iterable $this$sortedByDescending$iv = (Iterable)CollectionsKt.first((Iterable)releaseInfoMap.values());
            boolean $i$f$sortedByDescending = false;
            List sortedByDate = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ReleaseInfo it = (ReleaseInfo)b;
                    boolean bl = false;
                    Comparable comparable = it.getDate();
                    it = (ReleaseInfo)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getDate());
                }
            });
            if (!StringsKt.isBlank((CharSequence)filteringParams.getMajorVersion())) {
                block16: {
                    Iterable $this$first$iv = sortedByDate;
                    boolean $i$f$first = false;
                    for (Object element$iv : $this$first$iv) {
                        it = (ReleaseInfo)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getMajorVersion(), (Object)filteringParams.getMajorVersion())) continue;
                        break block16;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                v0 = (ReleaseInfo)element$iv;
            } else if (StringsKt.isBlank((CharSequence)filteringParams.getVersionNumber()) && StringsKt.isBlank((CharSequence)filteringParams.getBuildNumber())) {
                v0 = (ReleaseInfo)CollectionsKt.first((List)sortedByDate);
            } else if (!StringsKt.isBlank((CharSequence)filteringParams.getVersionNumber())) {
                block17: {
                    Iterable $this$first$iv = sortedByDate;
                    boolean $i$f$first = false;
                    for (Object element$iv : $this$first$iv) {
                        it = (ReleaseInfo)element$iv;
                        boolean bl = false;
                        String version = StringsKt.substringBefore$default((String)it.getVersion(), (char)'-', null, (int)2, null);
                        if (!Intrinsics.areEqual((Object)version, (Object)filteringParams.getVersionNumber())) continue;
                        break block17;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                v0 = (ReleaseInfo)element$iv;
            } else if (!StringsKt.isBlank((CharSequence)filteringParams.getBuildNumber())) {
                Object v1;
                block18: {
                    Iterable $this$firstOrNull$iv = sortedByDate;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ReleaseInfo it = (ReleaseInfo)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getBuild(), (Object)filteringParams.getBuildNumber())) continue;
                        v1 = element$iv;
                        break block18;
                    }
                    v1 = null;
                }
                if ((v0 = (ReleaseInfo)v1) == null) {
                    throw new IllegalStateException(("Build not found for " + filteringParams).toString());
                }
            } else {
                v0 = build = null;
            }
            if (build != null) {
                LocalDate expirationDate = build.getDate().plusDays(30L);
                if (Intrinsics.areEqual((Object)build.getType(), (Object)"eap") && expirationDate.isBefore(LocalDate.now())) {
                    throw new SetupException("EAP build " + build.getBuild() + " expired on " + expirationDate, null, 2, null);
                }
                return build;
            }
        }
        catch (Exception e) {
            LoggingKt.logError((String)("Failed to find specific release by parameters " + filteringParams));
            throw e;
        }
        throw new NoSuchElementException("Couldn't find specified release by parameters " + filteringParams);
    }

    @Override
    @NotNull
    public IdeInstallerFile downloadIdeInstaller(@NotNull IdeInfo ideInfo, @NotNull Path installerDirectory) {
        Intrinsics.checkNotNullParameter((Object)ideInfo, (String)"ideInfo");
        Intrinsics.checkNotNullParameter((Object)installerDirectory, (String)"installerDirectory");
        return this.downloadIdeInstaller(ideInfo, installerDirectory, false);
    }

    @NotNull
    public final IdeInstallerFile downloadIdeInstaller(@NotNull IdeInfo ideInfo, @NotNull Path installerDirectory, boolean downloadDedicatedInstaller) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)ideInfo, (String)"ideInfo");
        Intrinsics.checkNotNullParameter((Object)installerDirectory, (String)"installerDirectory");
        ProductInfoRequestParameters params = new ProductInfoRequestParameters(ideInfo.getProductCode(), ideInfo.getBuildType(), null, ideInfo.getBuildNumber(), ideInfo.getVersion(), 4, null);
        Map<String, List<ReleaseInfo>> releaseInfoMap = JetBrainsDataServiceClient.INSTANCE.getReleases(params);
        if (releaseInfoMap.size() != 1) {
            throw new RuntimeException("Only one product can be downloaded at once. Found " + releaseInfoMap.keySet());
        }
        ReleaseInfo possibleBuild = this.findSpecificRelease(releaseInfoMap, params);
        OS oS = OS.CURRENT;
        switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1: {
                if (CpuArch.CURRENT == CpuArch.ARM64) {
                    object = possibleBuild.getDownloads().getLinuxArm();
                    if (object != null && (object = ((OperatingSystem)object).getLink()) != null) break;
                    throw new IllegalStateException("LinuxARM download link is not specified".toString());
                }
                object = possibleBuild.getDownloads().getLinux();
                if (object != null && (object = ((OperatingSystem)object).getLink()) != null) break;
                throw new IllegalStateException("Linux download link is not specified".toString());
            }
            case 2: {
                if (CpuArch.CURRENT == CpuArch.ARM64) {
                    object = possibleBuild.getDownloads().getMacM1();
                    if (object != null && (object = ((OperatingSystem)object).getLink()) != null) break;
                    throw new IllegalStateException("MacOS M1 download link is not specified".toString());
                }
                object = possibleBuild.getDownloads().getMac();
                if (object != null && (object = ((OperatingSystem)object).getLink()) != null) break;
                throw new IllegalStateException("MacOS x64 download link is not specified".toString());
            }
            case 3: {
                if (downloadDedicatedInstaller) {
                    object = possibleBuild.getDownloads().getWindows();
                    if (object != null && (object = ((OperatingSystem)object).getLink()) != null) break;
                    throw new IllegalStateException("Windows installer download link is not specified".toString());
                }
                if (CpuArch.CURRENT == CpuArch.ARM64) {
                    object = possibleBuild.getDownloads().getWindowsArm();
                    if (object != null && (object = ((OperatingSystem)object).getLink()) != null) break;
                    throw new IllegalStateException("Windows ARM download link is not specified".toString());
                }
                object = possibleBuild.getDownloads().getWindowsZip();
                if (object != null && (object = ((OperatingSystem)object).getLink()) != null) break;
                throw new IllegalStateException("Windows download link is not specified".toString());
            }
            default: {
                throw new RuntimeException("Unsupported OS " + OS.CURRENT);
            }
        }
        Object rawDownloadLink = object;
        String mappedDownloadLink = this.mapDownloadLink((String)rawDownloadLink);
        Path installerFile = installerDirectory.resolve(ideInfo.getInstallerFilePrefix() + "-" + possibleBuild.getBuild() + ideInfo.getInstallerFileExt());
        Intrinsics.checkNotNull((Object)installerFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(installerFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LoggingKt.logOutput((String)("Downloading " + ideInfo + " from " + mappedDownloadLink + "..."));
            HttpClient.download-Wn2Vu4Y$default(HttpClient.INSTANCE, mappedDownloadLink, installerFile, 0L, 0L, 12, null);
        } else {
            LoggingKt.logOutput((String)("Installer file " + installerFile + " already exists. Skipping download."));
        }
        return new IdeInstallerFile(installerFile, possibleBuild.getBuild());
    }

    @NotNull
    protected String mapDownloadLink(@NotNull String downloadLink) {
        Intrinsics.checkNotNullParameter((Object)downloadLink, (String)"downloadLink");
        return downloadLink;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

