/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.plugins;

import com.intellij.ide.starter.ide.IDETestContext;
import com.intellij.ide.starter.ide.InstalledIde;
import com.intellij.ide.starter.path.GlobalPaths;
import com.intellij.ide.starter.plugins.PluginInstalledState;
import com.intellij.ide.starter.plugins.PluginLatestForIde;
import com.intellij.ide.starter.plugins.PluginNotFoundException;
import com.intellij.ide.starter.plugins.PluginSourceDescriptor;
import com.intellij.ide.starter.plugins.PluginWithExactVersion;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.HttpClient;
import com.intellij.tools.ide.util.common.LoggingKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\tJ\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J.\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0015J.\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0015J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ\u001f\u0010\u001f\u001a\u00020\u00002\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150!\"\u00020\u0015\u00a2\u0006\u0002\u0010\"J\u0014\u0010\u001f\u001a\u00020\u00002\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150#J\u001f\u0010$\u001a\u00020\u00002\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150!\"\u00020\u0015\u00a2\u0006\u0002\u0010\"J\u0016\u0010$\u001a\u00020\u00002\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150#H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\tH\u0002J\u000e\u0010+\u001a\u00020,2\u0006\u0010\u0017\u001a\u00020\u0015J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00150#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006."}, d2={"Lcom/intellij/ide/starter/plugins/PluginConfigurator;", "", "testContext", "Lcom/intellij/ide/starter/ide/IDETestContext;", "<init>", "(Lcom/intellij/ide/starter/ide/IDETestContext;)V", "getTestContext", "()Lcom/intellij/ide/starter/ide/IDETestContext;", "disabledPluginsPath", "Ljava/nio/file/Path;", "getDisabledPluginsPath", "()Ljava/nio/file/Path;", "installPluginFromPath", "pathToPluginArchive", "installPluginFromDir", "pathToPluginDir", "installPluginFromFolder", "pathToPluginFolder", "Ljava/io/File;", "installPluginFromURL", "urlToPluginZipFile", "", "installPluginFromPluginManager", "pluginId", "ide", "Lcom/intellij/ide/starter/ide/InstalledIde;", "channel", "pluginFileName", "pluginVersion", "plugin", "Lcom/intellij/ide/starter/plugins/PluginSourceDescriptor;", "disablePlugins", "pluginIds", "", "([Ljava/lang/String;)Lcom/intellij/ide/starter/plugins/PluginConfigurator;", "", "enablePlugins", "disabledPluginIds", "getDisabledPluginIds", "()Ljava/util/Set;", "findPluginXmlByPluginIdInAGivenDir", "", "bundledPluginsDir", "getPluginInstalledState", "Lcom/intellij/ide/starter/plugins/PluginInstalledState;", "assertPluginIsInstalled", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nPluginConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginConfigurator.kt\ncom/intellij/ide/starter/plugins/PluginConfigurator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1276#2:157\n1277#2:159\n1#3:158\n*S KotlinDebug\n*F\n+ 1 PluginConfigurator.kt\ncom/intellij/ide/starter/plugins/PluginConfigurator\n*L\n118#1:157\n118#1:159\n*E\n"})
public class PluginConfigurator {
    @NotNull
    private final IDETestContext testContext;

    public PluginConfigurator(@NotNull IDETestContext testContext) {
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        this.testContext = testContext;
    }

    @NotNull
    public final IDETestContext getTestContext() {
        return this.testContext;
    }

    @NotNull
    public final Path getDisabledPluginsPath() {
        Path path = this.testContext.getPaths().getConfigDir().resolve("disabled_plugins.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final PluginConfigurator installPluginFromPath(@NotNull Path pathToPluginArchive) {
        PluginConfigurator pluginConfigurator;
        Intrinsics.checkNotNullParameter((Object)pathToPluginArchive, (String)"pathToPluginArchive");
        PluginConfigurator $this$installPluginFromPath_u24lambda_u240 = pluginConfigurator = this;
        boolean bl = false;
        FileSystem.INSTANCE.unpack(pathToPluginArchive, $this$installPluginFromPath_u24lambda_u240.testContext.getPaths().getPluginsDir());
        return pluginConfigurator;
    }

    @NotNull
    public final PluginConfigurator installPluginFromDir(@NotNull Path pathToPluginDir) {
        PluginConfigurator pluginConfigurator;
        Intrinsics.checkNotNullParameter((Object)pathToPluginDir, (String)"pathToPluginDir");
        PluginConfigurator $this$installPluginFromDir_u24lambda_u240 = pluginConfigurator = this;
        boolean bl = false;
        Path targetPluginsDir = $this$installPluginFromDir_u24lambda_u240.testContext.getPaths().getPluginsDir();
        Path targetPluginDir = targetPluginsDir.resolve(PathsKt.getName((Path)pathToPluginDir));
        LoggingKt.logOutput((String)("Copy plugins from " + pathToPluginDir + " to " + targetPluginDir));
        Intrinsics.checkNotNull((Object)targetPluginDir);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(targetPluginDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LoggingKt.logOutput((String)("Deleting the plugin directory from previous runs: " + targetPluginDir));
            PathsKt.deleteRecursively((Path)targetPluginDir);
        }
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(targetPluginDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        PathsKt.copyToRecursively$default((Path)pathToPluginDir, (Path)targetPluginDir, null, (boolean)false, (boolean)false, (int)2, null);
        return pluginConfigurator;
    }

    @Deprecated(message="Use [installPluginFromDir] instead", level=DeprecationLevel.ERROR)
    @NotNull
    public final PluginConfigurator installPluginFromFolder(@NotNull File pathToPluginFolder) {
        Intrinsics.checkNotNullParameter((Object)pathToPluginFolder, (String)"pathToPluginFolder");
        Path path = pathToPluginFolder.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return this.installPluginFromDir(path);
    }

    @NotNull
    public final PluginConfigurator installPluginFromURL(@NotNull String urlToPluginZipFile) {
        PluginConfigurator pluginConfigurator;
        Intrinsics.checkNotNullParameter((Object)urlToPluginZipFile, (String)"urlToPluginZipFile");
        PluginConfigurator $this$installPluginFromURL_u24lambda_u240 = pluginConfigurator = this;
        boolean bl = false;
        Path pluginRootDir = GlobalPaths.Companion.getInstance().getCacheDirectoryFor("plugins");
        Path pluginZip = pluginRootDir.resolve($this$installPluginFromURL_u24lambda_u240.testContext.getIde().getBuild()).resolve(StringsKt.substringAfterLast$default((String)urlToPluginZipFile, (String)"/", null, (int)2, null));
        LoggingKt.logOutput((String)("Downloading " + urlToPluginZipFile));
        try {
            Intrinsics.checkNotNull((Object)pluginZip);
            HttpClient.download-Wn2Vu4Y$default(HttpClient.INSTANCE, urlToPluginZipFile, pluginZip, 0L, 0L, 12, null);
        }
        catch (HttpClient.HttpNotFound t) {
            throw new PluginNotFoundException("Plugin " + urlToPluginZipFile + " couldn't be downloaded: " + t.getMessage(), (Throwable)((Object)t));
        }
        FileSystem.INSTANCE.unpack(pluginZip, $this$installPluginFromURL_u24lambda_u240.testContext.getPaths().getPluginsDir());
        return pluginConfigurator;
    }

    @NotNull
    public final PluginConfigurator installPluginFromPluginManager(@NotNull String pluginId, @NotNull InstalledIde ide, @Nullable String channel, @Nullable String pluginFileName) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter((Object)ide, (String)"ide");
        return this.installPluginFromPluginManager(new PluginLatestForIde(pluginId, ide, channel, pluginFileName));
    }

    public static /* synthetic */ PluginConfigurator installPluginFromPluginManager$default(PluginConfigurator pluginConfigurator, String string, InstalledIde installedIde, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: installPluginFromPluginManager");
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        return pluginConfigurator.installPluginFromPluginManager(string, installedIde, string2, string3);
    }

    @NotNull
    public final PluginConfigurator installPluginFromPluginManager(@NotNull String pluginId, @NotNull String pluginVersion, @Nullable String channel, @Nullable String pluginFileName) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter((Object)pluginVersion, (String)"pluginVersion");
        return this.installPluginFromPluginManager(new PluginWithExactVersion(pluginId, pluginVersion, channel, pluginFileName));
    }

    public static /* synthetic */ PluginConfigurator installPluginFromPluginManager$default(PluginConfigurator pluginConfigurator, String string, String string2, String string3, String string4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: installPluginFromPluginManager");
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        return pluginConfigurator.installPluginFromPluginManager(string, string2, string3, string4);
    }

    @NotNull
    public final PluginConfigurator installPluginFromPluginManager(@NotNull PluginSourceDescriptor plugin) {
        Path path;
        PluginSourceDescriptor pluginSourceDescriptor;
        String fileName;
        PluginConfigurator pluginConfigurator;
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        PluginConfigurator $this$installPluginFromPluginManager_u24lambda_u240 = pluginConfigurator = this;
        boolean bl = false;
        String pluginId = plugin.getPluginId();
        LoggingKt.logOutput((String)("Setting up plugin: " + pluginId + " ..."));
        Path pluginsCacheDir = GlobalPaths.Companion.getInstance().getCacheDirectoryFor("plugins");
        Object object = plugin.getPluginFileName();
        if (object == null) {
            object = fileName = StringsKt.replace$default((String)pluginId, (String)".", (String)"-", (boolean)false, (int)4, null) + ".zip";
        }
        if ((pluginSourceDescriptor = plugin) instanceof PluginLatestForIde) {
            Path path2 = pluginsCacheDir.resolve(((PluginLatestForIde)plugin).getIde().getBuild());
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            var9_9 = path2;
            var10_10 = new FileAttribute[]{};
            Path path3 = Files.createDirectories(var9_9, Arrays.copyOf(var10_10, var10_10.length));
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
            path = path3.resolve(fileName);
        } else if (pluginSourceDescriptor instanceof PluginWithExactVersion) {
            Path path4 = pluginsCacheDir.resolve(((PluginWithExactVersion)plugin).getVersion());
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            var9_9 = path4;
            var10_10 = new FileAttribute[]{};
            Path path5 = Files.createDirectories(var9_9, Arrays.copyOf(var10_10, var10_10.length));
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"createDirectories(...)");
            path = path5.resolve(fileName);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Path downloadedPlugin = path;
        String string = plugin.downloadUrl();
        Intrinsics.checkNotNull((Object)downloadedPlugin);
        HttpClient.downloadIfMissing-Wn2Vu4Y$default(HttpClient.INSTANCE, string, downloadedPlugin, 1L, 0L, 8, null);
        if (StringsKt.endsWith$default((String)fileName, (String)".jar", (boolean)false, (int)2, null)) {
            Files.copy(downloadedPlugin, $this$installPluginFromPluginManager_u24lambda_u240.testContext.getPaths().getPluginsDir().resolve(fileName), new CopyOption[0]);
        } else {
            FileSystem.INSTANCE.unpack(downloadedPlugin, $this$installPluginFromPluginManager_u24lambda_u240.testContext.getPaths().getPluginsDir());
        }
        LoggingKt.logOutput((String)("Plugin " + pluginId + " setup finished"));
        return pluginConfigurator;
    }

    @NotNull
    public final PluginConfigurator disablePlugins(String ... pluginIds) {
        Intrinsics.checkNotNullParameter((Object)pluginIds, (String)"pluginIds");
        return this.disablePlugins(ArraysKt.toSet((Object[])pluginIds));
    }

    @NotNull
    public final PluginConfigurator disablePlugins(@NotNull Set<String> pluginIds) {
        PluginConfigurator pluginConfigurator;
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        PluginConfigurator $this$disablePlugins_u24lambda_u240 = pluginConfigurator = this;
        boolean bl = false;
        Path path = $this$disablePlugins_u24lambda_u240.getDisabledPluginsPath();
        Iterable iterable = SetsKt.plus($this$disablePlugins_u24lambda_u240.getDisabledPluginIds(), (Iterable)pluginIds);
        OpenOption[] openOptionArray = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)Files.write(path, (Iterable<? extends CharSequence>)iterable, charset, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(...)");
        return pluginConfigurator;
    }

    @NotNull
    public final PluginConfigurator enablePlugins(String ... pluginIds) {
        Intrinsics.checkNotNullParameter((Object)pluginIds, (String)"pluginIds");
        return this.enablePlugins(ArraysKt.toSet((Object[])pluginIds));
    }

    private final PluginConfigurator enablePlugins(Set<String> pluginIds) {
        PluginConfigurator pluginConfigurator;
        PluginConfigurator $this$enablePlugins_u24lambda_u240 = pluginConfigurator = this;
        boolean bl = false;
        Path path = $this$enablePlugins_u24lambda_u240.getDisabledPluginsPath();
        Iterable iterable = SetsKt.minus($this$enablePlugins_u24lambda_u240.getDisabledPluginIds(), (Iterable)pluginIds);
        OpenOption[] openOptionArray = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)Files.write(path, (Iterable<? extends CharSequence>)iterable, charset, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(...)");
        return pluginConfigurator;
    }

    private final Set<String> getDisabledPluginIds() {
        Set set;
        Path file = this.getDisabledPluginsPath();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Path path = file;
            List<String> list = Files.readAllLines(path, Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
            set = CollectionsKt.toSet((Iterable)list);
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean findPluginXmlByPluginIdInAGivenDir(String pluginId, Path bundledPluginsDir) {
        boolean bl;
        block9: {
            Sequence $this$any$iv = SequencesKt.filter((Sequence)PathsKt.walk((Path)bundledPluginsDir, (PathWalkOption[])new PathWalkOption[0]), PluginConfigurator::findPluginXmlByPluginIdInAGivenDir$lambda$0);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                boolean bl2;
                Path file = (Path)element$iv;
                boolean bl3 = false;
                JarFile jarFile = new JarFile(((Object)file).toString());
                JarEntry entry = jarFile.getJarEntry("META-INF/plugin.xml");
                if (entry == null) {
                    bl2 = false;
                } else {
                    InputStream inputStream = jarFile.getInputStream(entry);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    Closeable closeable = inputStream;
                    Object object = Charsets.UTF_8;
                    Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
                    int n = 8192;
                    closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                    object = null;
                    try {
                        BufferedReader it = (BufferedReader)closeable;
                        boolean bl4 = false;
                        object2 = TextStreamsKt.readText((Reader)it);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                    }
                    bl2 = StringsKt.contains$default((CharSequence)((CharSequence)object2), (CharSequence)("<id>" + pluginId + "</id>"), (boolean)false, (int)2, null);
                }
                if (!bl2) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final PluginInstalledState getPluginInstalledState(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(this.getDisabledPluginsPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && this.getDisabledPluginIds().contains(pluginId)) {
            return PluginInstalledState.DISABLED;
        }
        Path installedPluginDir = this.testContext.getPaths().getPluginsDir();
        if (this.findPluginXmlByPluginIdInAGivenDir(pluginId, installedPluginDir)) {
            return PluginInstalledState.INSTALLED;
        }
        Path bundledPluginsDir = this.testContext.getIde().getBundledPluginsDir();
        if (bundledPluginsDir == null) {
            LoggingKt.logOutput((String)("Cannot ensure a plugin '" + pluginId + "' is installed in " + this.testContext.getIde() + ". Consider it is installed."));
            return PluginInstalledState.INSTALLED;
        }
        if (this.findPluginXmlByPluginIdInAGivenDir(pluginId, bundledPluginsDir)) {
            return PluginInstalledState.BUNDLED_TO_IDE;
        }
        return PluginInstalledState.NOT_INSTALLED;
    }

    @NotNull
    public final PluginConfigurator assertPluginIsInstalled(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getPluginInstalledState(pluginId).ordinal()]) {
            case 1 -> throw new IllegalStateException(("Plugin '" + pluginId + "' must not be listed in the disabled plugins file " + this.getDisabledPluginsPath()).toString());
            case 2 -> throw new IllegalStateException(("Plugin '" + pluginId + "' must be installed").toString());
            case 3 -> this;
            case 4 -> this;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final boolean findPluginXmlByPluginIdInAGivenDir$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)PathsKt.getExtension((Path)it), (Object)"jar");
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PluginInstalledState.values().length];
            try {
                nArray[PluginInstalledState.DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginInstalledState.NOT_INSTALLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginInstalledState.BUNDLED_TO_IDE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginInstalledState.INSTALLED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

