/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.process;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.SystemInfo;
import oshi.software.os.OSProcess;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!BS\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0014\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u001d\u001a\u00020\u000eH\u0096\u0080\u0004J\n\u0010\u001e\u001a\u00020\u0005H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0011\u0010\u001f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0014\u00a8\u0006\""}, d2={"Lcom/intellij/ide/starter/process/ProcessInfo;", "", "pid", "", "name", "", "arguments", "", "startTime", "Ljava/time/Instant;", "user", "processHandle", "Ljava/lang/ProcessHandle;", "portThatIsUsedByProcess", "", "<init>", "(JLjava/lang/String;Ljava/util/List;Ljava/time/Instant;Ljava/lang/String;Ljava/lang/ProcessHandle;Ljava/lang/Integer;)V", "getPid", "()J", "getName", "()Ljava/lang/String;", "getArguments", "()Ljava/util/List;", "getProcessHandle", "()Ljava/lang/ProcessHandle;", "Ljava/lang/Integer;", "equals", "", "other", "hashCode", "toString", "description", "getDescription", "Companion", "intellij.tools.ide.starter"})
public final class ProcessInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long pid;
    @NotNull
    private final String name;
    @NotNull
    private final List<String> arguments;
    @Nullable
    private final Instant startTime;
    @Nullable
    private final String user;
    @Nullable
    private final ProcessHandle processHandle;
    @Nullable
    private final Integer portThatIsUsedByProcess;
    @NotNull
    private final String description;

    /*
     * WARNING - void declaration
     */
    private ProcessInfo(long pid, String name, List<String> arguments, Instant startTime, String user, ProcessHandle processHandle, Integer portThatIsUsedByProcess) {
        void $this$description_u24lambda_u240;
        StringBuilder stringBuilder;
        this.pid = pid;
        this.name = name;
        this.arguments = arguments;
        this.startTime = startTime;
        this.user = user;
        this.processHandle = processHandle;
        this.portThatIsUsedByProcess = portThatIsUsedByProcess;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        ProcessInfo processInfo = this;
        boolean bl = false;
        $this$description_u24lambda_u240.append("PID: " + this.pid).append('\n');
        if (this.portThatIsUsedByProcess != null) {
            $this$description_u24lambda_u240.append("Port that is used by a process: " + this.portThatIsUsedByProcess).append('\n');
        }
        $this$description_u24lambda_u240.append("Name: " + this.name).append('\n');
        $this$description_u24lambda_u240.append("Arguments: " + this.arguments).append('\n');
        $this$description_u24lambda_u240.append("Start time: " + this.startTime).append('\n');
        $this$description_u24lambda_u240.append("User: " + this.user).append('\n');
        processInfo.description = stringBuilder.toString();
    }

    /* synthetic */ ProcessInfo(long l, String string, List list, Instant instant, String string2, ProcessHandle processHandle, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            processHandle = null;
        }
        if ((n2 & 0x40) != 0) {
            n = null;
        }
        this(l, string, list, instant, string2, processHandle, n);
    }

    public final long getPid() {
        return this.pid;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<String> getArguments() {
        return this.arguments;
    }

    @Nullable
    public final ProcessHandle getProcessHandle() {
        return this.processHandle;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ProcessInfo)) {
            return false;
        }
        return this.pid == ((ProcessInfo)other).pid;
    }

    public int hashCode() {
        return Long.hashCode(this.pid);
    }

    @NotNull
    public String toString() {
        return this.pid + " " + this.name;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public /* synthetic */ ProcessInfo(long pid, String name, List arguments, Instant startTime, String user, ProcessHandle processHandle, Integer portThatIsUsedByProcess, DefaultConstructorMarker $constructor_marker) {
        this(pid, name, arguments, startTime, user, processHandle, portThatIsUsedByProcess);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001b\u0010\u000b\u001a\u00020\u0005*\u00020\f2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\rJ\n\u0010\u000b\u001a\u00020\u0005*\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/starter/process/ProcessInfo$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/ide/starter/process/ProcessInfo;", "pid", "", "portThatIsUsedByProcess", "", "(JLjava/lang/Integer;)Lcom/intellij/ide/starter/process/ProcessInfo;", "toProcessInfo", "Loshi/software/os/OSProcess;", "(Loshi/software/os/OSProcess;Ljava/lang/Integer;)Lcom/intellij/ide/starter/process/ProcessInfo;", "Ljava/lang/Process;", "intellij.tools.ide.starter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProcessInfo create(long pid, @Nullable Integer portThatIsUsedByProcess) {
            OSProcess opProcess = new SystemInfo().getOperatingSystem().getProcess((int)pid);
            if (opProcess == null) {
                return new ProcessInfo(pid, "Not Available", CollectionsKt.emptyList(), null, null, null, portThatIsUsedByProcess, null);
            }
            return this.toProcessInfo(opProcess, portThatIsUsedByProcess);
        }

        public static /* synthetic */ ProcessInfo create$default(Companion companion, long l, Integer n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = null;
            }
            return companion.create(l, n);
        }

        @NotNull
        public final ProcessInfo toProcessInfo(@NotNull OSProcess $this$toProcessInfo, @Nullable Integer portThatIsUsedByProcess) {
            Intrinsics.checkNotNullParameter((Object)$this$toProcessInfo, (String)"<this>");
            long l = $this$toProcessInfo.getProcessID();
            String string = $this$toProcessInfo.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            List list = $this$toProcessInfo.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArguments(...)");
            Instant instant = Instant.ofEpochMilli($this$toProcessInfo.getStartTime());
            String string2 = $this$toProcessInfo.getUser();
            Optional<ProcessHandle> optional = ProcessHandle.of($this$toProcessInfo.getProcessID());
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            return new ProcessInfo(l, string, list, instant, string2, (ProcessHandle)OptionalsKt.getOrNull(optional), portThatIsUsedByProcess, null);
        }

        public static /* synthetic */ ProcessInfo toProcessInfo$default(Companion companion, OSProcess oSProcess, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = null;
            }
            return companion.toProcessInfo(oSProcess, n);
        }

        @NotNull
        public final ProcessInfo toProcessInfo(@NotNull Process $this$toProcessInfo) {
            Intrinsics.checkNotNullParameter((Object)$this$toProcessInfo, (String)"<this>");
            return com.intellij.ide.starter.process.ProcessInfo$Companion.create$default(this, $this$toProcessInfo.pid(), null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

