/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.process;

import com.intellij.ide.starter.process.ProcessInfo;
import com.intellij.ide.starter.process.exec.ExecOutputRedirect;
import com.intellij.ide.starter.process.exec.ProcessExecutor;
import com.intellij.ide.starter.utils.UtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.tools.ide.util.common.LoggingKt;
import com.intellij.util.system.OS;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J)\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/starter/process/ProcessKiller;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "killProcesses", "", "processInfosToKill", "", "Lcom/intellij/ide/starter/process/ProcessInfo;", "workDir", "Ljava/nio/file/Path;", "timeout", "Lkotlin/time/Duration;", "killProcesses-SxA4cEA", "(Ljava/util/List;Ljava/nio/file/Path;J)Z", "killProcessUsingCommandLine", "pid", "", "killProcessUsingCommandLine-SxA4cEA", "(JLjava/nio/file/Path;J)Z", "killProcessUsingHandle", "processHandle", "Ljava/lang/ProcessHandle;", "killProcessUsingHandle-HG0u8IE", "(Ljava/lang/ProcessHandle;J)Z", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nProcessKiller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessKiller.kt\ncom/intellij/ide/starter/process/ProcessKiller\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 utils.kt\ncom/intellij/ide/starter/utils/UtilsKt\n*L\n1#1,114:1\n1586#2:115\n1661#2,3:116\n1786#2,3:119\n40#3,9:122\n40#3,9:131\n*S KotlinDebug\n*F\n+ 1 ProcessKiller.kt\ncom/intellij/ide/starter/process/ProcessKiller\n*L\n27#1:115\n27#1:116,3\n42#1:119,3\n98#1:122,9\n106#1:131,9\n*E\n"})
public final class ProcessKiller {
    @NotNull
    public static final ProcessKiller INSTANCE = new ProcessKiller();
    @NotNull
    private static final Logger logger;

    private ProcessKiller() {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean killProcesses-SxA4cEA(@NotNull List<ProcessInfo> processInfosToKill, @Nullable Path workDir, long timeout) {
        boolean bl;
        block5: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(processInfosToKill, (String)"processInfosToKill");
            if (!(!((Collection)processInfosToKill).isEmpty())) {
                throw new IllegalStateException("Check failed.");
            }
            Iterable $this$map$iv = processInfosToKill;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void processInfo;
                ProcessInfo processInfo2 = (ProcessInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(processInfo.getProcessHandle() != null ? (!INSTANCE.killProcessUsingHandle-HG0u8IE(processInfo.getProcessHandle(), timeout) ? INSTANCE.killProcessUsingCommandLine-SxA4cEA(processInfo.getPid(), workDir, timeout) : true) : true);
            }
            List results = (List)destination$iv$iv;
            Iterable $this$all$iv = results;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean it = (Boolean)element$iv;
                    boolean bl3 = false;
                    if (it) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean killProcesses-SxA4cEA$default(ProcessKiller processKiller, List list, Path path, long l, int n, Object object) {
        if ((n & 2) != 0) {
            path = null;
        }
        if ((n & 4) != 0) {
            l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES);
        }
        return processKiller.killProcesses-SxA4cEA(list, path, l);
    }

    public final boolean killProcessUsingCommandLine-SxA4cEA(long pid, @Nullable Path workDir, long timeout) {
        boolean bl;
        List list;
        LoggingKt.logOutput((String)("Killing process " + pid + " using command line"));
        if (OS.CURRENT == OS.Windows) {
            var7_4 = new String[]{"taskkill", "/pid", String.valueOf(pid), "/f"};
            list = CollectionsKt.listOf((Object[])var7_4);
        } else {
            var7_4 = new String[]{"kill", "-9", String.valueOf(pid)};
            list = CollectionsKt.listOf((Object[])var7_4);
        }
        List args = list;
        ExecOutputRedirect.ToStdOutAndString stdout = new ExecOutputRedirect.ToStdOutAndString("[kill-pid-" + pid + "]");
        ExecOutputRedirect.ToStdOutAndString stderr = new ExecOutputRedirect.ToStdOutAndString("[kill-pid-" + pid + "]");
        ProcessExecutor.start$default(new ProcessExecutor("Kill Process " + pid, workDir, timeout, null, args, null, stdout, stderr, null, null, null, false, 0, false, false, 32552, null), false, 1, null);
        String errorMsg = stderr.read();
        if (((CharSequence)errorMsg).length() > 0) {
            if (StringsKt.contains$default((CharSequence)errorMsg, (CharSequence)"No such process", (boolean)false, (int)2, null)) {
                logger.warn("Process " + pid + " is already terminated");
                return true;
            }
            logger.warn("Process kill command reported errors: " + errorMsg);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public static /* synthetic */ boolean killProcessUsingCommandLine-SxA4cEA$default(ProcessKiller processKiller, long l, Path path, long l2, int n, Object object) {
        if ((n & 2) != 0) {
            path = null;
        }
        return processKiller.killProcessUsingCommandLine-SxA4cEA(l, path, l2);
    }

    public final boolean killProcessUsingHandle-HG0u8IE(@NotNull ProcessHandle processHandle, long timeout) {
        boolean $i$f$catchAll;
        String message$iv;
        Intrinsics.checkNotNullParameter((Object)processHandle, (String)"processHandle");
        LoggingKt.logOutput((String)("Kill process '" + processHandle.pid() + " " + processHandle.info().command() + "' using ProcessHandle"));
        if (processHandle.destroy()) {
            message$iv = "Waiting on exit for process '" + processHandle.pid() + "'";
            $i$f$catchAll = false;
            try {
                if (((CharSequence)message$iv).length() > 0) {
                    LoggingKt.logOutput((String)("Performing '" + message$iv + "' with catching all exceptions"));
                }
                boolean bl = false;
                processHandle.onExit().get(Duration.getInWholeMilliseconds-impl((long)timeout), TimeUnit.MILLISECONDS);
                return true;
            }
            catch (Throwable t$iv) {
                LoggingKt.logError((String)("CatchAll " + (String)(((CharSequence)message$iv).length() > 0 ? "for '" + message$iv + "' " : "") + " swallowed error: " + t$iv.getMessage()));
                LoggingKt.logError((String)UtilsKt.getThrowableText(t$iv));
            }
        }
        processHandle.destroyForcibly();
        message$iv = "Waiting on exit for process '" + processHandle.pid() + "' after forcible termination";
        $i$f$catchAll = false;
        try {
            if (((CharSequence)message$iv).length() > 0) {
                LoggingKt.logOutput((String)("Performing '" + message$iv + "' with catching all exceptions"));
            }
            boolean bl = false;
            processHandle.onExit().get(2L, TimeUnit.SECONDS);
            return true;
        }
        catch (Throwable t$iv) {
            LoggingKt.logError((String)("CatchAll " + (String)(((CharSequence)message$iv).length() > 0 ? "for '" + message$iv + "' " : "") + " swallowed error: " + t$iv.getMessage()));
            LoggingKt.logError((String)UtilsKt.getThrowableText(t$iv));
            return false;
        }
    }

    public static /* synthetic */ boolean killProcessUsingHandle-HG0u8IE$default(ProcessKiller processKiller, ProcessHandle processHandle, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
        }
        return processKiller.killProcessUsingHandle-HG0u8IE(processHandle, l);
    }

    static {
        Logger logger = Logger.getInstance(ProcessKiller.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProcessKiller.logger = logger;
    }
}

