/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.sdk.go;

import com.intellij.ide.starter.path.GlobalPaths;
import com.intellij.ide.starter.runner.targets.TargetIdentifier;
import com.intellij.ide.starter.sdk.go.DownloadGoSdkException;
import com.intellij.ide.starter.sdk.go.GoSdkDownloadItem;
import com.intellij.ide.starter.sdk.go.GoSdkPaths;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.HttpClient;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.tools.ide.util.common.LoggingKt;
import com.intellij.tools.ide.util.common.RetryKt;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/starter/sdk/go/GoSdkDownloaderFacade;", "", "<init>", "()V", "goSdk", "Lcom/intellij/ide/starter/sdk/go/GoSdkDownloadItem;", "version", "", "getTargetPlatformInfo", "Lcom/intellij/ide/starter/sdk/go/GoSdkDownloaderFacade$PlatformInfo;", "downloadGoSdkItem", "Lcom/intellij/ide/starter/sdk/go/GoSdkPaths;", "platformInfo", "downloadAndInstallGoSdk", "", "installPath", "Ljava/nio/file/Path;", "getTargetPlatform", "Lcom/intellij/platform/eel/EelPlatform;", "PlatformInfo", "intellij.tools.ide.starter"})
public final class GoSdkDownloaderFacade {
    @NotNull
    public static final GoSdkDownloaderFacade INSTANCE = new GoSdkDownloaderFacade();

    private GoSdkDownloaderFacade() {
    }

    @NotNull
    public final GoSdkDownloadItem goSdk(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        PlatformInfo platformInfo = this.getTargetPlatformInfo();
        return new GoSdkDownloadItem(version, platformInfo.getOs(), platformInfo.getArch(), (Function0<GoSdkPaths>)((Function0)() -> GoSdkDownloaderFacade.goSdk$lambda$0(version, platformInfo)));
    }

    @NotNull
    public final PlatformInfo getTargetPlatformInfo() {
        PlatformInfo platformInfo;
        EelPlatform platform = this.getTargetPlatform();
        if (platform != null) {
            String string;
            if (EelPlatformKt.isWindows((EelPlatform)platform)) {
                string = "windows";
            } else if (EelPlatformKt.isLinux((EelPlatform)platform)) {
                string = "linux";
            } else if (EelPlatformKt.isMac((EelPlatform)platform)) {
                string = "darwin";
            } else {
                throw new DownloadGoSdkException("Unknown OS: " + platform);
            }
            platformInfo = new PlatformInfo(string, EelPlatformKt.isArm64((EelPlatform)platform) ? "arm64" : "amd64", EelPlatformKt.isWindows((EelPlatform)platform) ? ".zip" : ".tar.gz");
        } else {
            OS oS = OS.CURRENT;
            platformInfo = new PlatformInfo(switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
                case 1 -> "windows";
                case 2 -> "linux";
                case 3 -> "darwin";
                default -> throw new DownloadGoSdkException("Unknown OS");
            }, CpuArch.isArm64() ? "arm64" : "amd64", OS.CURRENT == OS.Windows ? ".zip" : ".tar.gz");
        }
        return platformInfo;
    }

    private final GoSdkPaths downloadGoSdkItem(String version, PlatformInfo platformInfo) {
        String cacheKey = version + "-" + platformInfo.getOs() + "-" + platformInfo.getArch();
        Path installPath = GlobalPaths.Companion.getInstance().getCacheDirectoryFor("go-sdk/" + cacheKey);
        Path goHome = installPath.resolve("go");
        LoggingKt.logOutput((String)("Checking Go SDK at " + installPath));
        Intrinsics.checkNotNull((Object)goHome);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(goHome, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.downloadAndInstallGoSdk(version, platformInfo, installPath);
        }
        return new GoSdkPaths(goHome, installPath);
    }

    private final void downloadAndInstallGoSdk(String version, PlatformInfo platformInfo, Path installPath) {
        String sdkFileName = "go" + version + "." + platformInfo.getOs() + "-" + platformInfo.getArch() + platformInfo.getExtension();
        String url = "https://cache-redirector.jetbrains.com/dl.google.com/go/" + sdkFileName;
        Path downloadedFile = installPath.resolve(sdkFileName);
        RetryKt.withRetryBlocking-zkXUZaI$default((String)"Failure on downloading/installing Go SDK", (long)3L, null, (long)0L, (Function1)((Function1)new Function1<Continuation<? super Boolean>, Object>(url, installPath, downloadedFile, null){
            int label;
            final /* synthetic */ String $url;
            final /* synthetic */ Path $installPath;
            final /* synthetic */ Path $downloadedFile;
            {
                this.$url = $url;
                this.$installPath = $installPath;
                this.$downloadedFile = $downloadedFile;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        LoggingKt.logOutput((String)("Downloading Go SDK from " + this.$url + " to " + this.$installPath));
                        PathsKt.deleteRecursively((Path)this.$installPath);
                        Files.createDirectories(this.$installPath, new FileAttribute[0]);
                        Path path = this.$downloadedFile;
                        Intrinsics.checkNotNull((Object)path);
                        HttpClient.download-Wn2Vu4Y$default(HttpClient.INSTANCE, this.$url, path, 0L, 0L, 12, null);
                        path = this.$downloadedFile;
                        Intrinsics.checkNotNull((Object)path);
                        FileSystem.INSTANCE.unpack(path, this.$installPath);
                        path = this.$downloadedFile;
                        Intrinsics.checkNotNull((Object)path);
                        return Boxing.boxBoolean((boolean)Files.deleteIfExists(path));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Boolean> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)12, null);
    }

    private final EelPlatform getTargetPlatform() {
        EelPlatform eelPlatform;
        if (ApplicationManager.getApplication() == null) {
            return null;
        }
        try {
            eelPlatform = TargetIdentifier.Companion.getCurrent().getEelApi().getPlatform();
        }
        catch (Exception exception) {
            eelPlatform = null;
        }
        return eelPlatform;
    }

    private static final GoSdkPaths goSdk$lambda$0(String $version, PlatformInfo $platformInfo) {
        return INSTANCE.downloadGoSdkItem($version, $platformInfo);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ide/starter/sdk/go/GoSdkDownloaderFacade$PlatformInfo;", "", "os", "", "arch", "extension", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getOs", "()Ljava/lang/String;", "getArch", "getExtension", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.tools.ide.starter"})
    public static final class PlatformInfo {
        @NotNull
        private final String os;
        @NotNull
        private final String arch;
        @NotNull
        private final String extension;

        public PlatformInfo(@NotNull String os, @NotNull String arch, @NotNull String extension) {
            Intrinsics.checkNotNullParameter((Object)os, (String)"os");
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            this.os = os;
            this.arch = arch;
            this.extension = extension;
        }

        @NotNull
        public final String getOs() {
            return this.os;
        }

        @NotNull
        public final String getArch() {
            return this.arch;
        }

        @NotNull
        public final String getExtension() {
            return this.extension;
        }

        @NotNull
        public final String component1() {
            return this.os;
        }

        @NotNull
        public final String component2() {
            return this.arch;
        }

        @NotNull
        public final String component3() {
            return this.extension;
        }

        @NotNull
        public final PlatformInfo copy(@NotNull String os, @NotNull String arch, @NotNull String extension) {
            Intrinsics.checkNotNullParameter((Object)os, (String)"os");
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            return new PlatformInfo(os, arch, extension);
        }

        public static /* synthetic */ PlatformInfo copy$default(PlatformInfo platformInfo, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = platformInfo.os;
            }
            if ((n & 2) != 0) {
                string2 = platformInfo.arch;
            }
            if ((n & 4) != 0) {
                string3 = platformInfo.extension;
            }
            return platformInfo.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "PlatformInfo(os=" + this.os + ", arch=" + this.arch + ", extension=" + this.extension + ")";
        }

        public int hashCode() {
            int result2 = this.os.hashCode();
            result2 = result2 * 31 + this.arch.hashCode();
            result2 = result2 * 31 + this.extension.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlatformInfo)) {
                return false;
            }
            PlatformInfo platformInfo = (PlatformInfo)other;
            if (!Intrinsics.areEqual((Object)this.os, (Object)platformInfo.os)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.arch, (Object)platformInfo.arch)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.extension, (Object)platformInfo.extension);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

