/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.utils;

import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.HttpClient;
import com.intellij.ide.starter.utils.SizeKt;
import com.intellij.tools.ide.util.common.LoggingKt;
import com.intellij.tools.ide.util.common.NoRetryException;
import com.intellij.tools.ide.util.common.RetryKt;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\t0\r\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016J1\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ1\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00182\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001f\u0010\u001cJ\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0018H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ide/starter/utils/HttpClient;", "", "<init>", "()V", "locks", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/locks/ReentrantLock;", "sendRequest", "Y", "request", "Lorg/apache/http/client/methods/HttpUriRequest;", "processor", "Lkotlin/Function1;", "Lorg/apache/http/HttpResponse;", "(Lorg/apache/http/client/methods/HttpUriRequest;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "download", "", "url", "outFile", "Ljava/io/File;", "retries", "", "outPath", "Ljava/nio/file/Path;", "timeout", "Lkotlin/time/Duration;", "download-Wn2Vu4Y", "(Ljava/lang/String;Ljava/nio/file/Path;JJ)V", "downloadIfMissing", "targetFile", "downloadIfMissing-Wn2Vu4Y", "getLock", "path", "HttpNotFound", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClient.kt\ncom/intellij/ide/starter/utils/HttpClient\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n72#2,2:106\n1#3:108\n*S KotlinDebug\n*F\n+ 1 HttpClient.kt\ncom/intellij/ide/starter/utils/HttpClient\n*L\n103#1:106,2\n103#1:108\n*E\n"})
public final class HttpClient {
    @NotNull
    public static final HttpClient INSTANCE = new HttpClient();
    @NotNull
    private static final ConcurrentHashMap<String, ReentrantLock> locks = new ConcurrentHashMap();

    private HttpClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <Y> Y sendRequest(@NotNull HttpUriRequest request, @NotNull Function1<? super HttpResponse, ? extends Y> processor) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Closeable closeable = (Closeable)HttpClientBuilder.create().build();
        Throwable throwable = null;
        try {
            Object object;
            CloseableHttpClient client = (CloseableHttpClient)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)client.execute(request);
            Throwable throwable2 = null;
            try {
                CloseableHttpResponse response = (CloseableHttpResponse)closeable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)response);
                object = processor.invoke((Object)response);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            Object object2 = object;
            return (Y)object2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void download(@NotNull String url, @NotNull File outFile, long retries) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)outFile, (String)"outFile");
        Path path = outFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        HttpClient.download-Wn2Vu4Y$default(this, url, path, retries, 0L, 8, null);
    }

    public static /* synthetic */ void download$default(HttpClient httpClient, String string, File file, long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = 3L;
        }
        httpClient.download(string, file, l);
    }

    public final void download-Wn2Vu4Y(@NotNull String url, @NotNull Path outPath, long retries, long timeout) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)outPath, (String)"outPath");
        String encodeUrl = StringsKt.replace$default((String)url, (String)" ", (String)"%20", (boolean)false, (int)4, null);
        LoggingKt.logOutput((String)("Downloading " + encodeUrl + " to " + outPath));
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(timeout, encodeUrl, outPath, retries, url, null){
            int label;
            final /* synthetic */ long $timeout;
            final /* synthetic */ String $encodeUrl;
            final /* synthetic */ Path $outPath;
            final /* synthetic */ long $retries;
            final /* synthetic */ String $url;
            {
                this.$timeout = $timeout;
                this.$encodeUrl = $encodeUrl;
                this.$outPath = $outPath;
                this.$retries = $retries;
                this.$url = $url;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TimeoutKt.withTimeout-KLykuaI((long)this.$timeout, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(this.$encodeUrl, this.$outPath, this.$retries, this.$url, null){
                            int label;
                            final /* synthetic */ String $encodeUrl;
                            final /* synthetic */ Path $outPath;
                            final /* synthetic */ long $retries;
                            final /* synthetic */ String $url;
                            {
                                this.$encodeUrl = $encodeUrl;
                                this.$outPath = $outPath;
                                this.$retries = $retries;
                                this.$url = $url;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = RetryKt.withRetry-gwCluXo$default((String)("Failure during downloading " + this.$encodeUrl + " to " + this.$outPath), (long)this.$retries, null, (long)0L, (Function1)((Function1)new Function1<Continuation<? super Path>, Object>(this.$encodeUrl, this.$url, this.$outPath, null){
                                            int label;
                                            final /* synthetic */ String $encodeUrl;
                                            final /* synthetic */ String $url;
                                            final /* synthetic */ Path $outPath;
                                            {
                                                this.$encodeUrl = $encodeUrl;
                                                this.$url = $url;
                                                this.$outPath = $outPath;
                                                super(1, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        HttpGet request = new HttpGet(this.$encodeUrl);
                                                        return HttpClient.INSTANCE.sendRequest((HttpUriRequest)request, arg_0 -> download.1.invokeSuspend$lambda$0(this.$encodeUrl, this.$url, this.$outPath, arg_0));
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(Continuation<? super Path> p1) {
                                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            private static final Path invokeSuspend$lambda$0(String $encodeUrl, String $url, Path $outPath, HttpResponse response) {
                                                if (response.getStatusLine().getStatusCode() == 404) {
                                                    throw new HttpNotFound("Server returned 404 Not Found: " + $encodeUrl, null, 2, null);
                                                }
                                                if (response.getStatusLine().getStatusCode() == 403 && StringsKt.startsWith$default((String)$url, (String)"https://cache-redirector.jetbrains.com/", (boolean)false, (int)2, null)) {
                                                    throw new HttpNotFound("Server returned 403 which we interpret as not found for cache-redirector urls: " + $url, null, 2, null);
                                                }
                                                Path path = $outPath.getParent();
                                                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
                                                Path path2 = path;
                                                Object object = new LinkOption[]{};
                                                if (!Files.exists(path2, Arrays.copyOf(object, ((LinkOption[])object).length))) {
                                                    Path path3 = $outPath.getParent();
                                                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getParent(...)");
                                                    path2 = path3;
                                                    object = new FileAttribute[]{};
                                                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, (FileAttribute[])Arrays.copyOf(object, ((Object[])object).length)), (String)"createDirectories(...)");
                                                }
                                                Files.deleteIfExists($outPath);
                                                Path tempFile = Files.createTempFile($outPath.getParent(), PathsKt.getName((Path)$outPath), "-download.tmp", new FileAttribute[0]);
                                                try {
                                                    CopyOption[] copyOptionArray;
                                                    Intrinsics.checkNotNull((Object)tempFile);
                                                    object = tempFile;
                                                    OpenOption[] openOptionArray = new OpenOption[]{};
                                                    OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length));
                                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                                                    object = outputStream;
                                                    int n = 0xA00000;
                                                    object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
                                                    Throwable throwable = null;
                                                    try {
                                                        CopyOption[] copyOptionArray2;
                                                        BufferedOutputStream stream = (BufferedOutputStream)object;
                                                        boolean bl = false;
                                                        HttpEntity httpEntity = response.getEntity();
                                                        if (httpEntity != null) {
                                                            httpEntity.writeTo((OutputStream)stream);
                                                            copyOptionArray2 = Unit.INSTANCE;
                                                        } else {
                                                            copyOptionArray2 = null;
                                                        }
                                                        copyOptionArray = copyOptionArray2;
                                                    }
                                                    catch (Throwable throwable2) {
                                                        throwable = throwable2;
                                                        throw throwable2;
                                                    }
                                                    finally {
                                                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                                                    }
                                                    object = tempFile;
                                                    copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                                                    CopyOption[] copyOptionArray3 = copyOptionArray;
                                                    Path path4 = Files.move((Path)object, $outPath, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length));
                                                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"move(...)");
                                                    object = path4;
                                                }
                                                catch (Throwable throwable) {
                                                    Intrinsics.checkNotNull((Object)tempFile);
                                                    Files.deleteIfExists(tempFile);
                                                    throw throwable;
                                                }
                                                Files.deleteIfExists(tempFile);
                                                return object;
                                            }
                                        }), (Continuation)((Continuation)this), (int)12, null);
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ void download-Wn2Vu4Y$default(HttpClient httpClient, String string, Path path, long l, long l2, int n, Object object) {
        if ((n & 4) != 0) {
            l = 3L;
        }
        if ((n & 8) != 0) {
            l2 = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES);
        }
        httpClient.download-Wn2Vu4Y(string, path, l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void downloadIfMissing-Wn2Vu4Y(@NotNull String url, @NotNull Path targetFile, long retries, long timeout) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Lock lock = this.getLock(targetFile);
        lock.lock();
        try {
            boolean bl = false;
            if (FileSystem.INSTANCE.isFileUpToDate(targetFile)) {
                LoggingKt.logOutput((String)("File " + targetFile + " was already downloaded. Size " + SizeKt.formatSize(Files.size(targetFile))));
                return;
            }
            Files.deleteIfExists(targetFile);
            INSTANCE.download-Wn2Vu4Y(url, targetFile, retries, timeout);
            return;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ void downloadIfMissing-Wn2Vu4Y$default(HttpClient httpClient, String string, Path path, long l, long l2, int n, Object object) {
        if ((n & 4) != 0) {
            l = 3L;
        }
        if ((n & 8) != 0) {
            l2 = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES);
        }
        httpClient.downloadIfMissing-Wn2Vu4Y(string, path, l, l2);
    }

    /*
     * WARNING - void declaration
     */
    private final ReentrantLock getLock(Path path) {
        void $this$getOrPut$iv;
        ConcurrentMap concurrentMap = locks;
        String key$iv = ((Object)path.toAbsolutePath()).toString();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            ReentrantLock default$iv = new ReentrantLock();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (ReentrantLock)object;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/starter/utils/HttpClient$HttpNotFound;", "Lcom/intellij/tools/ide/util/common/NoRetryException;", "message", "", "cause", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "intellij.tools.ide.starter"})
    public static final class HttpNotFound
    extends NoRetryException {
        public HttpNotFound(@NotNull String message, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message, cause);
        }

        public /* synthetic */ HttpNotFound(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable);
        }
    }
}

