/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.utils;

import com.intellij.ide.starter.process.exec.ExecOutputRedirect;
import com.intellij.ide.starter.process.exec.ProcessExecutor;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.tools.ide.util.common.LoggingKt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\nJ0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\b\b\u0002\u0010\u0014\u001a\u00020\u00052\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/starter/utils/JvmUtils;", "", "<init>", "()V", "quoteArg", "", "arg", "execJavaCmd", "", "javaHome", "Ljava/nio/file/Path;", "args", "", "callJavaVersion", "isX64Jdk", "", "resolveInstalledJdk", "writeJvmArgsFile", "", "argFile", "lineSeparator", "charset", "Ljava/nio/charset/Charset;", "getJavaClassCompileVersion", "filePath", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nJvmUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmUtils.kt\ncom/intellij/ide/starter/utils/JvmUtils\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1107#2,2:154\n1#3:156\n1#3:183\n1391#4:157\n1480#4,5:158\n1586#4:163\n1661#4,3:164\n777#4:167\n873#4,2:168\n296#4,2:170\n1642#4,10:172\n1915#4:182\n1916#4:184\n1652#4:185\n832#4:186\n862#4,2:187\n*S KotlinDebug\n*F\n+ 1 JvmUtils.kt\ncom/intellij/ide/starter/utils/JvmUtils\n*L\n18#1:154,2\n94#1:183\n63#1:157\n63#1:158,5\n64#1:163\n64#1:164,3\n65#1:167\n65#1:168,2\n85#1:170,2\n94#1:172,10\n94#1:182\n94#1:184\n94#1:185\n95#1:186\n95#1:187,2\n*E\n"})
public final class JvmUtils {
    @NotNull
    public static final JvmUtils INSTANCE = new JvmUtils();

    private JvmUtils() {
    }

    private final String quoteArg(String arg) {
        boolean bl;
        int n;
        block10: {
            String specials = " #'\"\n\r\t\f";
            CharSequence $this$any$iv = specials;
            boolean $i$f$any = false;
            for (n = 0; n < $this$any$iv.length(); ++n) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(n);
                boolean bl2 = false;
                if (!StringsKt.contains$default((CharSequence)arg, (char)it, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block10;
            }
            bl = false;
        }
        if (!bl) {
            return arg;
        }
        StringBuilder sb = new StringBuilder(arg.length() * 2);
        n = arg.length();
        block8: for (int i = 0; i < n; ++i) {
            char element = arg.charAt(i);
            switch (element) {
                case ' ': 
                case '#': 
                case '\'': {
                    StringBuilder stringBuilder = sb.append('\"').append(element).append('\"');
                    continue block8;
                }
                case '\"': {
                    StringBuilder stringBuilder = sb.append("\"\\\"\"");
                    continue block8;
                }
                case '\n': {
                    StringBuilder stringBuilder = sb.append("\"\\n\"");
                    continue block8;
                }
                case '\r': {
                    StringBuilder stringBuilder = sb.append("\"\\r\"");
                    continue block8;
                }
                case '\t': {
                    StringBuilder stringBuilder = sb.append("\"\\t\"");
                    continue block8;
                }
                default: {
                    StringBuilder stringBuilder = sb.append(element);
                }
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> execJavaCmd(@NotNull Path javaHome, @NotNull Iterable<String> args) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object list$iv$iv;
        Object it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Path path;
        String ext;
        Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        String string = ext = SystemInfo.isWindows ? ".exe" : "";
        if (Files.isSymbolicLink(javaHome)) {
            Path path2 = Files.readSymbolicLink(javaHome);
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"readSymbolicLink(...)");
        } else {
            path = javaHome;
        }
        Path realJavaHomePath = path;
        Path java = realJavaHomePath.toAbsolutePath().resolve("bin/java" + ext);
        Intrinsics.checkNotNull((Object)java);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(java, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean $i$a$-require-JvmUtils$execJavaCmd$22 = false;
            String $i$a$-require-JvmUtils$execJavaCmd$22 = "Java is not found under " + java;
            throw new IllegalArgumentException($i$a$-require-JvmUtils$execJavaCmd$22.toString());
        }
        String prefix = "exec-java-cmd";
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        ExecOutputRedirect.ToString stderr = new ExecOutputRedirect.ToString();
        List processArguments = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((Object)java).toString()), args);
        ProcessExecutor.start$default(new ProcessExecutor(prefix, javaHome, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, processArguments, null, stdout, stderr, null, null, null, false, 0, false, false, 32552, null), false, 1, null);
        Object object = new ExecOutputRedirect.ToString[]{stdout, stderr};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$flatMap = false;
        void var13_14 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ExecOutputRedirect.ToString)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = ((ExecOutputRedirect.ToString)it).read();
            String[] stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue((Object)System.lineSeparator(), (String)"lineSeparator(...)");
            list$iv$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List mergedOutput = (List)destination$iv$iv;
        Iterable iterable = mergedOutput;
        String string2 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator(...)");
        LoggingKt.logOutput((String)("\n    Result of calling " + processArguments + ":\n    " + CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null) + "\n    "));
        return mergedOutput;
    }

    public static /* synthetic */ List execJavaCmd$default(JvmUtils jvmUtils, Path path, Iterable iterable, int n, Object object) {
        if ((n & 2) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        return jvmUtils.execJavaCmd(path, iterable);
    }

    @NotNull
    public final String callJavaVersion(@NotNull Path javaHome) {
        Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
        Iterable iterable = this.execJavaCmd(javaHome, CollectionsKt.listOf((Object)"-version"));
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
    }

    public final boolean isX64Jdk(@NotNull Path javaHome) {
        Object v0;
        Object object;
        block2: {
            Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
            object = new String[]{"-XshowSettings:all", "-version"};
            Iterable $this$firstOrNull$iv = this.execJavaCmd(javaHome, CollectionsKt.listOf((Object[])object));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"sun.arch.data.model", (boolean)false, (int)2, null)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        String archProperty = v0;
        object = archProperty;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            throw new IllegalAccessException("Couldn't get architecture property sun.arch.data.model value from JDK");
        }
        return StringsKt.endsWith$default((String)((Object)StringsKt.trim((CharSequence)archProperty)).toString(), (String)"64", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final Path resolveInstalledJdk() {
        block21: {
            block20: {
                var3_1 /* !! */  = new String[]{"JDK_21_0", "JDK_17_0", "JDK_11_0", "JDK_HOME", "JAVA_HOME"};
                $this$mapNotNull$iv = CollectionsKt.listOf((Object[])var3_1 /* !! */ );
                $i$f$mapNotNull = false;
                var5_9 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var11_21 = $this$forEach$iv$iv$iv.iterator();
                while (var11_21.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var11_21.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (String)element$iv$iv;
                    $i$a$-mapNotNull-JvmUtils$resolveInstalledJdk$jdkEnv$1 = false;
                    if (System.getenv(it) == null) continue;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv;
                $i$f$filterNot = false;
                $this$mapNotNullTo$iv$iv = $this$filterNot$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterNotTo = false;
                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                    it = (String)element$iv$iv;
                    $i$a$-filterNot-JvmUtils$resolveInstalledJdk$jdkEnv$2 = false;
                    if (StringsKt.startsWith$default((String)it, (String)"%", (boolean)false, (int)2, null) != false && StringsKt.endsWith$default((String)it, (String)"%", (boolean)false, (int)2, null) != false) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                v0 = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                if (v0 == null) {
                    v0 = System.getProperty("java.home");
                }
                v1 = jdkEnv = v0;
                if (v1 != null) {
                    it = v1;
                    $i$a$-let-JvmUtils$resolveInstalledJdk$javaHome$1 = false;
                    v2 = Paths.get(it, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"get(...)");
                    path = v2;
                    if (Files.isSymbolicLink(path)) {
                        v3 = Files.readSymbolicLink(path);
                        v4 = v3;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"readSymbolicLink(...)");
                    } else {
                        v4 = path;
                    }
                } else {
                    v4 = javaHome = null;
                }
                if (javaHome == null) break block20;
                v5 = new LinkOption[]{};
                if (Files.exists(javaHome, Arrays.copyOf(v5, v5.length))) break block21;
            }
            throw new IllegalArgumentException("Java Home " + javaHome + " is null, empty or doesn't exist. Specify JAVA_HOME to point to JDK 11 x64");
        }
        v6 = new LinkOption[]{};
        if (!Files.isDirectory(javaHome, Arrays.copyOf(v6, v6.length))) ** GOTO lbl-1000
        var3_1 /* !! */  = Files.walk(javaHome, new FileVisitOption[0]);
        it = null;
        try {
            it = (Stream)var3_1 /* !! */ ;
            $i$a$-use-JvmUtils$resolveInstalledJdk$1 = false;
            var5_12 = it.count();
        }
        catch (Throwable var7_15) {
            it = var7_15;
            throw var7_15;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)var3_1 /* !! */ , (Throwable)it);
        }
        if (var5_12 > 10L) {
            v7 = true;
        } else lbl-1000:
        // 2 sources

        {
            v7 = false;
        }
        if (!v7) {
            $i$a$-require-JvmUtils$resolveInstalledJdk$2 = false;
            $i$a$-require-JvmUtils$resolveInstalledJdk$2 = "Java Home " + javaHome + " is not found or empty!";
            throw new IllegalArgumentException($i$a$-require-JvmUtils$resolveInstalledJdk$2.toString());
        }
        if (!this.isX64Jdk(javaHome)) {
            $i$a$-require-JvmUtils$resolveInstalledJdk$3 = false;
            var4_8 = "JDK at path " + javaHome + " should support x64 architecture";
            throw new IllegalArgumentException(var4_8.toString());
        }
        return javaHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeJvmArgsFile(@NotNull Path argFile, @NotNull List<String> args, @NotNull String lineSeparator, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)argFile, (String)"argFile");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Closeable closeable = Files.newBufferedWriter(argFile, charset, new OpenOption[0]);
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)closeable;
            boolean bl = false;
            for (String arg : args) {
                writer.write(INSTANCE.quoteArg(arg));
                writer.write(lineSeparator);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void writeJvmArgsFile$default(JvmUtils jvmUtils, Path path, List list, String string, Charset charset, int n, Object object) {
        if ((n & 4) != 0) {
            String string2 = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator(...)");
            string = string2;
        }
        if ((n & 8) != 0) {
            charset = Charsets.UTF_8;
        }
        jvmUtils.writeJvmArgsFile(path, list, string, charset);
    }

    @NotNull
    public final String getJavaClassCompileVersion(@NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Regex versionMatcher = new Regex("major version: [0-9]{2,3}");
        Object[] objectArray = new String[]{"javap", "-verbose", ((Object)filePath.getFileName()).toString()};
        ProcessExecutor.start$default(new ProcessExecutor("get java class compile version", filePath.getParent(), DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS), null, CollectionsKt.listOf((Object[])objectArray), null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
        MatchResult matchResult = Regex.find$default((Regex)versionMatcher, (CharSequence)stdout.read(), (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult);
        objectArray = new String[]{": "};
        return String.valueOf(Integer.parseInt((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)matchResult.getValue(), (String[])objectArray, (boolean)false, (int)0, (int)6, null))) - 44);
    }
}

