/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.utils;

import com.intellij.openapi.util.SystemInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"createInMemoryDirectory", "Ljava/nio/file/Path;", "directoryName", "", "intellij.tools.ide.starter"})
public final class MemoryFsKt {
    @NotNull
    public static final Path createInMemoryDirectory(@NotNull String directoryName) {
        Intrinsics.checkNotNullParameter((Object)directoryName, (String)"directoryName");
        if (!SystemInfo.isLinux) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Path shmDirectory = Paths.get("/dev/shm", new String[0]);
        Intrinsics.checkNotNull((Object)shmDirectory);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(shmDirectory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IllegalStateException("Check failed.");
        }
        Path path = shmDirectory.resolve(directoryName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }
}

