/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.utils;

import com.intellij.ide.starter.models.VMOptions;
import com.intellij.openapi.util.SystemInfo;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"getUpdateEnvVarsWithAddedPath", "", "", "path", "Ljava/nio/file/Path;", "getUpdateEnvVarsWithPrependedPath", "updatePathEnvVariable", "", "Lcom/intellij/ide/starter/models/VMOptions;", "intellij.tools.ide.starter"})
public final class PathEnvUtilsKt {
    @NotNull
    public static final Map<String, String> getUpdateEnvVarsWithAddedPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String pathEnv = SystemInfo.isWindows ? "Path" : "PATH";
        String pathSeparator = SystemInfo.isWindows ? ";" : ":";
        String currentPath = System.getenv().getOrDefault(pathEnv, "");
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getenv(...)");
        return MapsKt.plus(map, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)pathEnv, (Object)(currentPath + pathSeparator + path))));
    }

    @NotNull
    public static final Map<String, String> getUpdateEnvVarsWithPrependedPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String pathEnv = SystemInfo.isWindows ? "Path" : "PATH";
        String pathSeparator = SystemInfo.isWindows ? ";" : ":";
        String currentPath = System.getenv().getOrDefault(pathEnv, "");
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getenv(...)");
        return MapsKt.plus(map, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)pathEnv, (Object)(path + pathSeparator + currentPath))));
    }

    public static final void updatePathEnvVariable(@NotNull VMOptions $this$updatePathEnvVariable, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$updatePathEnvVariable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String pathEnv = SystemInfo.isWindows ? "Path" : "PATH";
        String envVars = PathEnvUtilsKt.getUpdateEnvVarsWithAddedPath(path).get(pathEnv);
        if (envVars != null) {
            $this$updatePathEnvVariable.withEnv(pathEnv, envVars);
        }
    }
}

